<!-- received="Fri Jun 25 22:51:44 1999 EET DST" -->
<!-- sent="Fri, 25 Jun 1999 20:43:04 +0200" -->
<!-- name="Oliver Neukum" -->
<!-- email="Oliver.Neukum@lrz.uni-muenchen.de" -->
<!-- subject="[patch] make minix work in 2.3.8" -->
<!-- id="99062520484801.00227@halrloprillalar" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-25,: [patch] make minix work in 2.3.8</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[patch] make minix work in 2.3.8</h1>
<b>Oliver Neukum</b> (<a href="mailto:Oliver.Neukum@lrz.uni-muenchen.de"><i>Oliver.Neukum@lrz.uni-muenchen.de</i></a>)<br>
<i>Fri, 25 Jun 1999 20:43:04 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#1234">[ date ]</a><a href="index.html#1234">[ thread ]</a><a href="subject.html#1234">[ subject ]</a><a href="author.html#1234">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1235.html">Bob Taylor: "Re: Research help needed"</a>
<li> <b>Previous message:</b> <a href="1233.html">Theodore Y. Ts'o: "Re: kernel programming isn't so hard, but even so, reiserfs seems to be getting an "exokernel" implementation (was albods are not a clean set of orthogonal primitives)"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
--Boundary-=_BbmQBhCDarzOwKkYHIDdqSCDXrJm<br>
Content-Type: text/plain<br>
Content-Transfer-Encoding: 8bit<br>
<p>
Hi,<br>
<p>
attached I have a patch against linux-2.3.8. It allows minixfs to compile. The<br>
resulting kernel boots and seems to work. I have UP only, I'd be grateful for<br>
SMP testers.<br>
Please be careful with the patch !<br>
<p>
Regards<br>
	Oliver<br>
<p>
PS: Is there any documentation on locking in the buffer cache ?<br>
--Boundary-=_BbmQBhCDarzOwKkYHIDdqSCDXrJm<br>
Content-Type: text/x-c;<br>
  name="m238.diff"<br>
Content-Transfer-Encoding: 8bit<br>
Content-Disposition: attachment; filename="m238.diff"<br>
<p>
--- linux/fs/minix/file.c.alt	Fri Jun 25 19:24:35 1999<br>
+++ linux/fs/minix/file.c	Fri Jun 25 19:57:11 1999<br>
@@ -15,6 +15,7 @@<br>
 #include &lt;linux/locks.h&gt;<br>
 #include &lt;linux/mm.h&gt;<br>
 #include &lt;linux/pagemap.h&gt;<br>
+#include &lt;linux/smp_lock.h&gt;<br>
 <br>
 #include &lt;asm/uaccess.h&gt;<br>
 #include &lt;asm/system.h&gt;<br>
@@ -36,6 +37,7 @@<br>
 	int i, err, created;<br>
 	struct buffer_head *bh;<br>
 <br>
+	lock_kernel();<br>
 	i = PAGE_SIZE / BLOCK_SIZE;<br>
 	block = page-&gt;offset / BLOCK_SIZE;<br>
 	p = nr;<br>
@@ -56,13 +58,14 @@<br>
 <br>
 	/* IO start */<br>
 	brw_page(WRITE, page, inode-&gt;i_dev, nr, BLOCK_SIZE, 1);<br>
+	unlock_kernel();<br>
 	return 0;<br>
 }<br>
 <br>
 static long minix_write_one_page(struct file *file, struct page *page, unsigned long offset, unsigned long bytes, const char *buf)<br>
 {<br>
-	return block_write_one_page(file, page, offset, bytes, buf, minix_getblk_block);<br>
-}<br>
+	return block_write_partial_page(file, page, offset, bytes, buf,<br>
+minix_getblk_block); }<br>
 <br>
 /*<br>
  * Write to a file (through the page cache).<br>
@@ -104,12 +107,12 @@<br>
 	NULL,			/* rename */<br>
 	NULL,			/* readlink */<br>
 	NULL,			/* follow_link */<br>
-	generic_readpage,	/* readpage */<br>
-	minix_writepage,	/* writepage */<br>
 	minix_bmap,		/* bmap */<br>
+	block_read_full_page,	/* readpage */<br>
+	minix_writepage,	/* writepage */<br>
+	block_flushpage,	/* flushpage */<br>
 	minix_truncate,		/* truncate */<br>
 	NULL,			/* permission */<br>
 	NULL,			/* smap */<br>
 	NULL,			/* revalidate */<br>
-	block_flushpage,	/* flushpage */<br>
-};<br>
+	};<br>
--- linux/fs/minix/inode.c.alt	Fri Jun 25 19:57:45 1999<br>
+++ linux/fs/minix/inode.c	Fri Jun 25 20:00:10 1999<br>
@@ -19,6 +19,7 @@<br>
 #include &lt;linux/stat.h&gt;<br>
 #include &lt;linux/locks.h&gt;<br>
 #include &lt;linux/init.h&gt;<br>
+#include &lt;linux/smp_lock.h&gt;<br>
 <br>
 #include &lt;asm/system.h&gt;<br>
 #include &lt;asm/uaccess.h&gt;<br>
@@ -456,10 +457,15 @@<br>
  */<br>
 int minix_bmap(struct inode * inode, int block)<br>
 {<br>
+	int ret;<br>
+<br>
+	lock_kernel();<br>
 	if (INODE_VERSION(inode) == MINIX_V1)<br>
-		return V1_minix_bmap(inode, block);<br>
+		ret = V1_minix_bmap(inode, block);<br>
 	else<br>
-		return V2_minix_bmap(inode, block);<br>
+		ret = V2_minix_bmap(inode, block);<br>
+	unlock_kernel();<br>
+	return ret;<br>
 }<br>
 <br>
 /*<br>
--- linux/fs/minix/symlink.c.alt	Fri Jun 25 20:00:25 1999<br>
+++ linux/fs/minix/symlink.c	Fri Jun 25 20:07:27 1999<br>
@@ -62,18 +62,16 @@<br>
 {<br>
 	struct buffer_head * bh;<br>
 	int i;<br>
-	char c;<br>
 <br>
 	if (buflen &gt; 1023)<br>
 		buflen = 1023;<br>
 	bh = minix_bread(dentry-&gt;d_inode, 0, 0);<br>
 	if (!bh)<br>
 		return 0;<br>
-	i = 0;<br>
-	while (i&lt;buflen &amp;&amp; (c = bh-&gt;b_data[i])) {<br>
-		i++;<br>
-		put_user(c,buffer++);<br>
-	}<br>
+<br>
+	i = strnlen(bh-&gt;b_data, buflen);<br>
+	copy_to_user(buffer, bh-&gt;b_data, i);<br>
+<br>
 	brelse(bh);<br>
 	return i;<br>
 }<br>
<p>
--Boundary-=_BbmQBhCDarzOwKkYHIDdqSCDXrJm--<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1235.html">Bob Taylor: "Re: Research help needed"</a>
<li> <b>Previous message:</b> <a href="1233.html">Theodore Y. Ts'o: "Re: kernel programming isn't so hard, but even so, reiserfs seems to be getting an "exokernel" implementation (was albods are not a clean set of orthogonal primitives)"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
