<!-- received="Fri Jun 25 23:13:44 1999 EET DST" -->
<!-- sent="Fri, 25 Jun 1999 21:08:04 +0200 (CEST)" -->
<!-- name="Andrea Arcangeli" -->
<!-- email="andrea@suse.de" -->
<!-- subject="Re: [patch] pagecache-2.3.9-E8, fixes against pre3-2.3.9" -->
<!-- id="" -->
<!-- inreplyto="Pine.LNX.4.10.9906251828510.5362-100000@laser.random" -->
<title>Linux-kernel mailing list archive 1999-25,: Re: [patch] pagecache-2.3.9-E8, fixes against pre3-2.3.9</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: [patch] pagecache-2.3.9-E8, fixes against pre3-2.3.9</h1>
<b>Andrea Arcangeli</b> (<a href="mailto:andrea@suse.de"><i>andrea@suse.de</i></a>)<br>
<i>Fri, 25 Jun 1999 21:08:04 +0200 (CEST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#1239">[ date ]</a><a href="index.html#1239">[ thread ]</a><a href="subject.html#1239">[ subject ]</a><a href="author.html#1239">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1240.html">Theodore Y. Ts'o: "Re: [RFC] File flags handling - proposal for API."</a>
<li> <b>Previous message:</b> <a href="1238.html">Ingo Oeser: "strsep() instead of strtok()"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
On Fri, 25 Jun 1999, Andrea Arcangeli wrote:<br>
<p>
<i>&gt;o	fix for an fs corrution bug in all 2.3.[89]: even if we write to a</i><br>
<i>&gt;	partial buffer, this doesn't mean that we have all buffers</i><br>
<i>&gt;	in the page uptodate. The below check was bogus:</i><br>
<i>&gt;</i><br>
<i>&gt;	if (!partial)</i><br>
<i>&gt;                SetPageUptodate(page);</i><br>
<i>&gt;        return bytes;</i><br>
<p>
I have a more efficient fix for the same bug, here it is an incremental<br>
patch (incremental with the previous big buffer patch, it will generate<br>
some offset but it will apply cleanly):<br>
<p>
Index: linux/fs/buffer.c<br>
===================================================================<br>
RCS file: /var/cvs/linux/fs/buffer.c,v<br>
retrieving revision 1.1.2.183<br>
diff -u -r1.1.2.183 buffer.c<br>
--- linux/fs/buffer.c	1999/06/25 17:19:48	1.1.2.183<br>
+++ linux/fs/buffer.c	1999/06/25 19:01:32<br>
@@ -1424,7 +1424,7 @@<br>
 	struct dentry *dentry = file-&gt;f_dentry;<br>
 	struct inode *inode = dentry-&gt;d_inode;<br>
 	unsigned long block;<br>
-	int err, nr_uptodate = 0, uptodate;<br>
+	int err, uptodate, all_uptodate = 1;<br>
 	unsigned long blocksize, start_block, end_block;<br>
 	unsigned long start_offset, start_bytes, end_bytes;<br>
 	unsigned long bbits, blocks, i, len;<br>
@@ -1473,7 +1473,6 @@<br>
 			BUG();<br>
 <br>
 		uptodate = buffer_uptodate(bh);<br>
-		nr_uptodate += uptodate;<br>
 <br>
 		if ((i &lt; start_block) || (i &gt; end_block))<br>
 			goto skip;<br>
@@ -1525,11 +1524,11 @@<br>
 		 * lots of dirty pages.<br>
 		 */<br>
 		mark_buffer_uptodate(bh, 1);<br>
-		if (!uptodate)<br>
-			nr_uptodate++;<br>
+		uptodate = 1;<br>
 		atomic_mark_buffer_dirty(bh, 0);<br>
 <br>
 skip:<br>
+		all_uptodate &amp;= uptodate;<br>
 		i++;<br>
 		block++;<br>
 		bh = bh-&gt;b_this_page;<br>
@@ -1541,7 +1540,7 @@<br>
 	 * the next read(). Here we 'discover' wether the page went<br>
 	 * uptodate as a result of this (potentially partial) write.<br>
 	 */<br>
-	if ((PAGE_SIZE &gt;&gt; bbits) == nr_uptodate)<br>
+	if (all_uptodate)<br>
 		SetPageUptodate(page);<br>
 	return bytes;<br>
 out:<br>
<p>
<p>
<p>
<p>
Andrea Arcangeli<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1240.html">Theodore Y. Ts'o: "Re: [RFC] File flags handling - proposal for API."</a>
<li> <b>Previous message:</b> <a href="1238.html">Ingo Oeser: "strsep() instead of strtok()"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
