<!-- received="Sat Jun 26 00:27:47 1999 EET DST" -->
<!-- sent="Fri, 25 Jun 1999 22:57:33 +0200 (MEST)" -->
<!-- name="Patrick Schaaf" -->
<!-- email="phbof@bof.de" -->
<!-- subject="Re: /proc and chroot, again" -->
<!-- id="199906252057.WAA00440@oknodo.bof.de" -->
<!-- inreplyto="199906251911.VAA01230@oknodo.bof.de" -->
<title>Linux-kernel mailing list archive 1999-25,: Re: /proc and chroot, again</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: /proc and chroot, again</h1>
<b>Patrick Schaaf</b> (<a href="mailto:phbof@bof.de"><i>phbof@bof.de</i></a>)<br>
<i>Fri, 25 Jun 1999 22:57:33 +0200 (MEST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#1251">[ date ]</a><a href="index.html#1251">[ thread ]</a><a href="subject.html#1251">[ subject ]</a><a href="author.html#1251">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1252.html">Casey Schaufler: "Re: [RFC] File flags handling - proposal for API"</a>
<li> <b>Previous message:</b> <a href="1250.html">Pavel Machek: "Re: A few questions....."</a>
<li> <b>In reply to:</b> <a href="1236.html">Patrick Schaaf: "/proc and chroot, again"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
s/works/looks_better/<br>
<p>
<i>&gt; inspired by the recent discussion on chroot and /proc, I made the appended</i><br>
<i>&gt; patch to 2.3.8.</i><br>
<p>
Patch against 2.3.8. As far as I can see, it should also work for 2.2.x.<br>
<p>
--- linux-2.3.8/fs/proc/base.c	Sat Jun 19 20:45:28 1999<br>
+++ linux-2.3.8-bof/fs/proc/base.c	Fri Jun 25 12:18:40 1999<br>
@@ -50,7 +50,7 @@<br>
 	NULL,			/* writepage */<br>
 	NULL,			/* flushpage */<br>
 	NULL,			/* truncate */<br>
-	NULL,			/* permission */<br>
+	proc_permission,	/* permission */<br>
 	NULL,			/* smap */<br>
 	NULL			/* revalidate */<br>
 };<br>
--- linux-2.3.8/fs/proc/root.c	Sat Jun 19 20:45:29 1999<br>
+++ linux-2.3.8-bof/fs/proc/root.c	Fri Jun 25 22:03:45 1999<br>
@@ -945,6 +945,8 @@<br>
 #define PROC_NUMBUF 10<br>
 #define PROC_MAXPIDS 20<br>
 <br>
+extern int proc_down_under(struct task_struct *);<br>
+<br>
 /*<br>
  * Get a few pid's to return for filldir - we need to hold the<br>
  * tasklist lock while doing this, and we must release it before<br>
@@ -960,6 +962,8 @@<br>
 	for_each_task(p) {<br>
 		int pid = p-&gt;pid;<br>
 		if (!pid)<br>
+			continue;<br>
+		if (0 != proc_down_under(p))<br>
 			continue;<br>
 		if (--index &gt;= 0)<br>
 			continue;<br>
--- linux-2.3.8/fs/proc/inode.c	Tue Jun  8 19:47:58 1999<br>
+++ linux-2.3.8-bof/fs/proc/inode.c	Fri Jun 25 22:21:02 1999<br>
@@ -175,65 +175,44 @@<br>
  *<br>
  * Jeremy Fitzhardinge &lt;<a href="mailto:jeremy@zip.com.au">jeremy@zip.com.au</a>&gt;<br>
  */<br>
-int proc_permission(struct inode *inode, int mask)<br>
-{<br>
-	struct task_struct *p;<br>
-	unsigned long ino = inode-&gt;i_ino;<br>
-	unsigned long pid;<br>
-	struct dentry *de, *base;<br>
-<br>
-	if (standard_permission(inode, mask) != 0)<br>
-		return -EACCES;<br>
-<br>
-	/* <br>
-	 * Find the root of the processes being examined (if any).<br>
-	 * XXX Surely there's a better way of doing this?<br>
-	 */<br>
-	if (ino &gt;= PROC_OPENPROM_FIRST &amp;&amp; <br>
-	    ino &lt;  PROC_OPENPROM_FIRST + PROC_NOPENPROM)<br>
-		return 0;		/* already allowed */<br>
-<br>
-	pid = ino &gt;&gt; 16;<br>
-	if (pid == 0)<br>
-		return 0;		/* already allowed */<br>
-	<br>
-	de = NULL;<br>
-	base = current-&gt;fs-&gt;root;<br>
 <br>
-	read_lock(&amp;tasklist_lock);<br>
-	p = find_task_by_pid(pid);<br>
+/* callers do read_lock(&amp;tasklist_lock) - sufficient? */<br>
+int proc_down_under(struct task_struct *p)<br>
+{<br>
+	struct dentry *base = current-&gt;fs ? current-&gt;fs-&gt;root : NULL;<br>
+	struct dentry *de = (p &amp;&amp; p-&gt;fs) ? p-&gt;fs-&gt;root : NULL;<br>
 <br>
-	if (p &amp;&amp; p-&gt;fs)<br>
-		de = p-&gt;fs-&gt;root;<br>
-	read_unlock(&amp;tasklist_lock);	/* FIXME! */<br>
-<br>
-	if (p == NULL)<br>
-		return -EACCES;		/* ENOENT? */<br>
-<br>
-	if (de == NULL)<br>
-	{<br>
-		/* kswapd and bdflush don't have proper root or cwd... */<br>
-		return -EACCES;<br>
-	}<br>
-	<br>
-	/* XXX locking? */<br>
-	for(;;)<br>
-	{<br>
+	if (base &amp;&amp; de) for(;;) {<br>
 		struct dentry *parent;<br>
-<br>
 		if (de == base)<br>
-			return 0;	/* already allowed */<br>
-<br>
+			return 0;<br>
 		de = de-&gt;d_covers;<br>
 		parent = de-&gt;d_parent;<br>
-<br>
 		if (de == parent)<br>
 			break;<br>
-<br>
 		de = parent;<br>
 	}<br>
+	return -ENOENT;<br>
+}<br>
+<br>
+int proc_permission(struct inode *inode, int mask)<br>
+{<br>
+	unsigned long ino = inode-&gt;i_ino;<br>
+	unsigned long pid = ino &gt;&gt; 16;<br>
+	int res;<br>
+<br>
+	if (standard_permission(inode, mask) != 0) return -EACCES;<br>
+<br>
+	/* allow everything except /proc/&lt;pid&gt;/ */<br>
+	if ((ino&gt;=PROC_OPENPROM_FIRST&amp;&amp;ino&lt;PROC_OPENPROM_FIRST+PROC_NOPENPROM)<br>
+	  ||(pid==0))<br>
+		return 0;<br>
+<br>
+	read_lock(&amp;tasklist_lock);<br>
+	res = proc_down_under(find_task_by_pid(pid));<br>
+	read_unlock(&amp;tasklist_lock);	/* FIXME!? */<br>
 <br>
-	return -EACCES;			/* incompatible roots */<br>
+	return res;<br>
 }<br>
 <br>
 struct inode * proc_get_inode(struct super_block * sb, int ino,<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1252.html">Casey Schaufler: "Re: [RFC] File flags handling - proposal for API"</a>
<li> <b>Previous message:</b> <a href="1250.html">Pavel Machek: "Re: A few questions....."</a>
<li> <b>In reply to:</b> <a href="1236.html">Patrick Schaaf: "/proc and chroot, again"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
