<!-- received="Sun Aug  8 02:10:52 1999 EET DST" -->
<!-- sent="Sat, 7 Aug 1999 16:04:13 -0600" -->
<!-- name="yodaiken@chelm.cs.nmt.edu" -->
<!-- email="yodaiken@chelm.cs.nmt.edu" -->
<!-- subject="irq.c changes to test" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-32,: irq.c changes to test</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>irq.c changes to test</h1>
<a href="mailto:yodaiken@chelm.cs.nmt.edu"><i>yodaiken@chelm.cs.nmt.edu</i></a><br>
<i>Sat, 7 Aug 1999 16:04:13 -0600</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#11">[ date ]</a><a href="index.html#11">[ thread ]</a><a href="subject.html#11">[ subject ]</a><a href="author.html#11">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0012.html">Jonathan Masters: "Re: hdd &amp; sound"</a>
<li> <b>Previous message:</b> <a href="0010.html">Andrea Arcangeli: "Re: No kmem_cache_destroy?"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
The following patch to irq.c on x86 <br>
A) separates machine dependent from not.<br>
B) separates 8259 from io_apic<br>
C) makes sure that all elements in the handler structure expect<br>
   to be called with spinlocks set outside, instead of the current mix<br>
   of expectations.<br>
D) removes some mostly duplicated code.<br>
E) makes the RTLinux patch, much simpler. Once this patch is in, or<br>
   some equivalent fix is made, RTLinux can be added to the kernel with<br>
   under 100 lines of code, 0 additional instructions in the non-rtl<br>
   path.<br>
<p>
The big question is whether it works. It works fine on the two smp <br>
machines I've tested, but ... <br>
<p>
       victor <br>
<p>
Patch against 2.3.12<br>
------------------------------------------------------<br>
<p>
diff -u -r -N vanilla12/arch/i386/kernel/Makefile linux.new12/arch/i386/kernel/Makefile<br>
--- vanilla12/arch/i386/kernel/Makefile	Sun Jul 11 10:48:05 1999<br>
+++ linux.new12/arch/i386/kernel/Makefile	Wed Aug  4 16:20:49 1999<br>
@@ -14,7 +14,7 @@<br>
 <br>
 O_TARGET := kernel.o<br>
 O_OBJS   := process.o signal.o entry.o traps.o irq.o vm86.o \<br>
-            ptrace.o ioport.o ldt.o setup.o time.o sys_i386.o<br>
+            ptrace.o i8259.o ioport.o ldt.o setup.o time.o sys_i386.o<br>
 OX_OBJS  := i386_ksyms.o<br>
 MX_OBJS  :=<br>
 <br>
diff -u -r -N vanilla12/arch/i386/kernel/bios32.c linux.new12/arch/i386/kernel/bios32.c<br>
--- vanilla12/arch/i386/kernel/bios32.c	Sat Apr 24 18:49:37 1999<br>
+++ linux.new12/arch/i386/kernel/bios32.c	Wed Aug  4 16:20:49 1999<br>
@@ -93,7 +93,7 @@<br>
 #include &lt;asm/smp.h&gt;<br>
 #include &lt;asm/spinlock.h&gt;<br>
 <br>
-#include "irq.h"<br>
+#include &lt;linux/irq.h&gt;<br>
 <br>
 #undef DEBUG<br>
 <br>
diff -u -r -N vanilla12/arch/i386/kernel/i8259.c linux.new12/arch/i386/kernel/i8259.c<br>
--- vanilla12/arch/i386/kernel/i8259.c	Wed Dec 31 17:00:00 1969<br>
+++ linux.new12/arch/i386/kernel/i8259.c	Wed Aug  4 16:20:49 1999<br>
@@ -0,0 +1,404 @@<br>
+#include &lt;linux/config.h&gt;<br>
+#include &lt;linux/ptrace.h&gt;<br>
+#include &lt;linux/errno.h&gt;<br>
+#include &lt;linux/kernel_stat.h&gt;<br>
+#include &lt;linux/signal.h&gt;<br>
+#include &lt;linux/sched.h&gt;<br>
+#include &lt;linux/ioport.h&gt;<br>
+#include &lt;linux/interrupt.h&gt;<br>
+#include &lt;linux/timex.h&gt;<br>
+#include &lt;linux/malloc.h&gt;<br>
+#include &lt;linux/random.h&gt;<br>
+#include &lt;linux/smp.h&gt;<br>
+#include &lt;linux/tasks.h&gt;<br>
+#include &lt;linux/smp_lock.h&gt;<br>
+#include &lt;linux/init.h&gt;<br>
+<br>
+#include &lt;asm/system.h&gt;<br>
+#include &lt;asm/io.h&gt;<br>
+#include &lt;asm/irq.h&gt;<br>
+#include &lt;asm/bitops.h&gt;<br>
+#include &lt;asm/smp.h&gt;<br>
+#include &lt;asm/pgtable.h&gt;<br>
+#include &lt;asm/delay.h&gt;<br>
+#include &lt;asm/desc.h&gt;<br>
+<br>
+#include &lt;linux/irq.h&gt;<br>
+<br>
+<br>
+/* Intel specific no controller  code<br>
+   odd that no-controller should be architecture dependent<br>
+   but see the ifdef __SMP__ <br>
+ */<br>
+static void enable_none(unsigned int irq) { }<br>
+static unsigned int startup_none(unsigned int irq) {return 0; }<br>
+static void disable_none(unsigned int irq) { }<br>
+static void ack_none(unsigned int irq){<br>
+#ifdef __SMP__<br>
+	/*<br>
+	 * [currently unexpected vectors happen only on SMP and APIC.<br>
+	 *  if we want to have non-APIC and non-8259A controllers<br>
+	 *  in the future with unexpected vectors, this ack should<br>
+	 *  probably be made controller-specific.]<br>
+	 */<br>
+	ack_APIC_irq();<br>
+#endif<br>
+}<br>
+<br>
+/* startup is the same as "enable", shutdown is same as "disable" */<br>
+#define shutdown_none	disable_none<br>
+#define end_none	enable_none<br>
+<br>
+struct hw_interrupt_type no_irq_type = {<br>
+	"none",<br>
+	startup_none,<br>
+	shutdown_none,<br>
+	enable_none,<br>
+	disable_none,<br>
+        ack_none,<br>
+	end_none<br>
+};<br>
+<br>
+<br>
+/*<br>
+ * This is the 'legacy' 8259A Programmable Interrupt Controller,<br>
+ * present in the majority of PC/AT boxes.<br>
+ * plus some generic x86 specific things if generic specifics makes<br>
+ * any sense at all.<br>
+ * this file should become arch/i386/kernel/irq.c when the old irq.c<br>
+ * moves to arch independent land<br>
+ */<br>
+/*<br>
+ * This builds up the IRQ handler stubs using some ugly macros in irq.h<br>
+ *<br>
+ * These macros create the low-level assembly IRQ routines that save<br>
+ * register context and call do_IRQ(). do_IRQ() then does all the<br>
+ * operations that are needed to keep the AT (or SMP IOAPIC)<br>
+ * interrupt-controller happy.<br>
+ */<br>
+<br>
+<br>
+BUILD_COMMON_IRQ()<br>
+<br>
+#define BI(x,y) \<br>
+	BUILD_IRQ(##x##y)<br>
+<br>
+#define BUILD_16_IRQS(x) \<br>
+	BI(x,0) BI(x,1) BI(x,2) BI(x,3) \<br>
+	BI(x,4) BI(x,5) BI(x,6) BI(x,7) \<br>
+	BI(x,8) BI(x,9) BI(x,a) BI(x,b) \<br>
+	BI(x,c) BI(x,d) BI(x,e) BI(x,f)<br>
+<br>
+/*<br>
+ * ISA PIC or low IO-APIC triggered (INTA-cycle or APIC) interrupts:<br>
+ * (these are usually mapped to vectors 0x20-0x30)<br>
+ */<br>
+BUILD_16_IRQS(0x0)<br>
+<br>
+#ifdef CONFIG_X86_IO_APIC<br>
+/*<br>
+ * The IO-APIC gives us many more interrupt sources. Most of these <br>
+ * are unused but an SMP system is supposed to have enough memory ...<br>
+ * sometimes (mostly wrt. hw bugs) we get corrupted vectors all<br>
+ * across the spectrum, so we really want to be prepared to get all<br>
+ * of these. Plus, more powerful systems might have more than 64<br>
+ * IO-APIC registers.<br>
+ *<br>
+ * (these are usually mapped into the 0x30-0xff vector range)<br>
+ */<br>
+                   BUILD_16_IRQS(0x1) BUILD_16_IRQS(0x2) BUILD_16_IRQS(0x3)<br>
+BUILD_16_IRQS(0x4) BUILD_16_IRQS(0x5) BUILD_16_IRQS(0x6) BUILD_16_IRQS(0x7)<br>
+BUILD_16_IRQS(0x8) BUILD_16_IRQS(0x9) BUILD_16_IRQS(0xa) BUILD_16_IRQS(0xb)<br>
+BUILD_16_IRQS(0xc) BUILD_16_IRQS(0xd)<br>
+#endif<br>
+<br>
+#undef BUILD_16_IRQS<br>
+#undef BI<br>
+<br>
+<br>
+#ifdef __SMP__<br>
+/*<br>
+ * The following vectors are part of the Linux architecture, there<br>
+ * is no hardware IRQ pin equivalent for them, they are triggered<br>
+ * through the ICC by us (IPIs)<br>
+ */<br>
+BUILD_SMP_INTERRUPT(reschedule_interrupt)<br>
+BUILD_SMP_INTERRUPT(invalidate_interrupt)<br>
+BUILD_SMP_INTERRUPT(stop_cpu_interrupt)<br>
+BUILD_SMP_INTERRUPT(call_function_interrupt)<br>
+BUILD_SMP_INTERRUPT(spurious_interrupt)<br>
+<br>
+/*<br>
+ * every pentium local APIC has two 'local interrupts', with a<br>
+ * soft-definable vector attached to both interrupts, one of<br>
+ * which is a timer interrupt, the other one is error counter<br>
+ * overflow. Linux uses the local APIC timer interrupt to get<br>
+ * a much simpler SMP time architecture:<br>
+ */<br>
+BUILD_SMP_TIMER_INTERRUPT(apic_timer_interrupt)<br>
+<br>
+#endif<br>
+<br>
+#define IRQ(x,y) \<br>
+	IRQ##x##y##_interrupt<br>
+<br>
+#define IRQLIST_16(x) \<br>
+	IRQ(x,0), IRQ(x,1), IRQ(x,2), IRQ(x,3), \<br>
+	IRQ(x,4), IRQ(x,5), IRQ(x,6), IRQ(x,7), \<br>
+	IRQ(x,8), IRQ(x,9), IRQ(x,a), IRQ(x,b), \<br>
+	IRQ(x,c), IRQ(x,d), IRQ(x,e), IRQ(x,f)<br>
+<br>
+static void (*interrupt[NR_IRQS])(void) = {<br>
+	IRQLIST_16(0x0),<br>
+<br>
+#ifdef CONFIG_X86_IO_APIC<br>
+	                 IRQLIST_16(0x1), IRQLIST_16(0x2), IRQLIST_16(0x3),<br>
+	IRQLIST_16(0x4), IRQLIST_16(0x5), IRQLIST_16(0x6), IRQLIST_16(0x7),<br>
+	IRQLIST_16(0x8), IRQLIST_16(0x9), IRQLIST_16(0xa), IRQLIST_16(0xb),<br>
+	IRQLIST_16(0xc), IRQLIST_16(0xd)<br>
+#endif<br>
+};<br>
+<br>
+#undef IRQ<br>
+#undef IRQLIST_16<br>
+<br>
+<br>
+<br>
+<br>
+static void enable_8259A_irq(unsigned int irq);<br>
+void disable_8259A_irq(unsigned int irq);<br>
+<br>
+/* shutdown is same as "disable" */<br>
+#define end_8259A_irq		enable_8259A_irq<br>
+#define shutdown_8259A_irq	disable_8259A_irq<br>
+static void mask_and_ack_8259A(unsigned int);<br>
+static unsigned int startup_8259A_irq(unsigned int irq){ <br>
+	enable_8259A_irq(irq);<br>
+	return 0; /* never anything pending */<br>
+}<br>
+<br>
+static struct hw_interrupt_type i8259A_irq_type = {<br>
+	"XT-PIC",<br>
+	startup_8259A_irq,<br>
+	shutdown_8259A_irq,<br>
+	enable_8259A_irq,<br>
+	disable_8259A_irq,<br>
+	mask_and_ack_8259A,<br>
+	end_8259A_irq<br>
+};<br>
+<br>
+/*<br>
+ * 8259A PIC functions to handle ISA devices:<br>
+ */<br>
+<br>
+/*<br>
+ * This contains the irq mask for both 8259A irq controllers,<br>
+ */<br>
+static unsigned int cached_irq_mask = 0xffff;<br>
+<br>
+#define __byte(x,y) 	(((unsigned char *)&amp;(y))[x])<br>
+#define cached_21	(__byte(0,cached_irq_mask))<br>
+#define cached_A1	(__byte(1,cached_irq_mask))<br>
+<br>
+/*<br>
+ * Not all IRQs can be routed through the IO-APIC, eg. on certain (older)<br>
+ * boards the timer interrupt is not connected to any IO-APIC pin, it's<br>
+ * fed to the CPU IRQ line directly.<br>
+ *<br>
+ * Any '1' bit in this mask means the IRQ is routed through the IO-APIC.<br>
+ * this 'mixed mode' IRQ handling costs nothing because it's only used<br>
+ * at IRQ setup time.<br>
+ */<br>
+unsigned long io_apic_irqs = 0;<br>
+<br>
+/*<br>
+ * These have to be protected by the irq controller spinlock<br>
+ * before being called.<br>
+ */<br>
+void disable_8259A_irq(unsigned int irq)<br>
+{<br>
+	unsigned int mask = 1 &lt;&lt; irq;<br>
+	cached_irq_mask |= mask;<br>
+	if (irq &amp; 8) {<br>
+		outb(cached_A1,0xA1);<br>
+	} else {<br>
+		outb(cached_21,0x21);<br>
+	}<br>
+}<br>
+<br>
+static void enable_8259A_irq(unsigned int irq)<br>
+{<br>
+	unsigned int mask = ~(1 &lt;&lt; irq);<br>
+	cached_irq_mask &amp;= mask;<br>
+	if (irq &amp; 8) {<br>
+		outb(cached_A1,0xA1);<br>
+	} else {<br>
+		outb(cached_21,0x21);<br>
+	}<br>
+}<br>
+<br>
+int i8259A_irq_pending(unsigned int irq)<br>
+{<br>
+	unsigned int mask = 1&lt;&lt;irq;<br>
+<br>
+	if (irq &lt; 8)<br>
+                return (inb(0x20) &amp; mask);<br>
+        return (inb(0xA0) &amp; (mask &gt;&gt; 8));<br>
+}<br>
+<br>
+void make_8259A_irq(unsigned int irq)<br>
+{<br>
+	disable_irq_nosync(irq);<br>
+	io_apic_irqs &amp;= ~(1&lt;&lt;irq);<br>
+	irq_desc[irq].handler = &amp;i8259A_irq_type;<br>
+	enable_irq(irq);<br>
+}<br>
+<br>
+/*<br>
+ * Careful! The 8259A is a fragile beast, it pretty<br>
+ * much _has_ to be done exactly like this (mask it<br>
+ * first, _then_ send the EOI, and the order of EOI<br>
+ * to the two 8259s is important!<br>
+ */<br>
+static void mask_and_ack_8259A(unsigned int irq)<br>
+{<br>
+	cached_irq_mask |= 1 &lt;&lt; irq;<br>
+	if (irq &amp; 8) {<br>
+		inb(0xA1);	/* DUMMY */<br>
+		outb(cached_A1,0xA1);<br>
+		outb(0x62,0x20);	/* Specific EOI to cascade */<br>
+		outb(0x20,0xA0);<br>
+	} else {<br>
+		inb(0x21);	/* DUMMY */<br>
+		outb(cached_21,0x21);<br>
+		outb(0x20,0x20);<br>
+	}<br>
+}<br>
+#ifndef CONFIG_VISWS<br>
+/*<br>
+ * Note that on a 486, we don't want to do a SIGFPE on an irq13<br>
+ * as the irq is unreliable, and exception 16 works correctly<br>
+ * (ie as explained in the intel literature). On a 386, you<br>
+ * can't use exception 16 due to bad IBM design, so we have to<br>
+ * rely on the less exact irq13.<br>
+ *<br>
+ * Careful.. Not only is IRQ13 unreliable, but it is also<br>
+ * leads to races. IBM designers who came up with it should<br>
+ * be shot.<br>
+ */<br>
+ <br>
+static void math_error_irq(int cpl, void *dev_id, struct pt_regs *regs)<br>
+{<br>
+	outb(0,0xF0);<br>
+	if (ignore_irq13 || !boot_cpu_data.hard_math)<br>
+		return;<br>
+	math_error();<br>
+}<br>
+<br>
+static struct irqaction irq13 = { math_error_irq, 0, 0, "fpu", NULL, NULL };<br>
+<br>
+/*<br>
+ * IRQ2 is cascade interrupt to second interrupt controller<br>
+ */<br>
+<br>
+static struct irqaction irq2  = { no_action, 0, 0, "cascade", NULL, NULL};<br>
+#endif<br>
+<br>
+<br>
+void init_ISA_irqs (void)<br>
+{<br>
+	int i;<br>
+<br>
+	for (i = 0; i &lt; NR_IRQS; i++) {<br>
+		irq_desc[i].status = IRQ_DISABLED;<br>
+		irq_desc[i].action = 0;<br>
+		irq_desc[i].depth = 0;<br>
+<br>
+		if (i &lt; 16) {<br>
+			/*<br>
+			 * 16 old-style INTA-cycle interrupts:<br>
+			 */<br>
+			irq_desc[i].handler = &amp;i8259A_irq_type;<br>
+		} else {<br>
+			/*<br>
+			 * 'high' PCI IRQs filled in on demand<br>
+			 */<br>
+			irq_desc[i].handler = &amp;no_irq_type;<br>
+		}<br>
+	}<br>
+}<br>
+<br>
+__initfunc(void init_IRQ(void))<br>
+{<br>
+	int i;<br>
+<br>
+#ifndef CONFIG_X86_VISWS_APIC<br>
+	init_ISA_irqs();<br>
+#else<br>
+	init_VISWS_APIC_irqs();<br>
+#endif<br>
+	/*<br>
+	 * Cover the whole vector space, no vector can escape<br>
+	 * us. (some of these will be overridden and become<br>
+	 * 'special' SMP interrupts)<br>
+	 */<br>
+	for (i = 0; i &lt; NR_IRQS; i++) {<br>
+		int vector = FIRST_EXTERNAL_VECTOR + i;<br>
+		if (vector != SYSCALL_VECTOR) <br>
+			set_intr_gate(vector, interrupt[i]);<br>
+	}<br>
+<br>
+#ifdef __SMP__	<br>
+<br>
+	/*<br>
+	  IRQ0 must be given a fixed assignment and initialized<br>
+	  before init_IRQ_SMP.<br>
+	*/<br>
+	set_intr_gate(IRQ0_TRAP_VECTOR, interrupt[0]);<br>
+<br>
+	/*<br>
+	 * The reschedule interrupt is a CPU-to-CPU reschedule-helper<br>
+	 * IPI, driven by wakeup.<br>
+	 */<br>
+	set_intr_gate(RESCHEDULE_VECTOR, reschedule_interrupt);<br>
+<br>
+	/* IPI for invalidation */<br>
+	set_intr_gate(INVALIDATE_TLB_VECTOR, invalidate_interrupt);<br>
+<br>
+	/* IPI for CPU halt */<br>
+	set_intr_gate(STOP_CPU_VECTOR, stop_cpu_interrupt);<br>
+<br>
+	/* self generated IPI for local APIC timer */<br>
+	set_intr_gate(LOCAL_TIMER_VECTOR, apic_timer_interrupt);<br>
+<br>
+	/* IPI for generic function call */<br>
+	set_intr_gate(CALL_FUNCTION_VECTOR, call_function_interrupt);<br>
+<br>
+	/* IPI vector for APIC spurious interrupts */<br>
+	set_intr_gate(SPURIOUS_APIC_VECTOR, spurious_interrupt);<br>
+#endif	<br>
+<br>
+	/*<br>
+	 * Set the clock to 100 Hz, we already have a valid<br>
+	 * vector now:<br>
+	 */<br>
+	outb_p(0x34,0x43);		/* binary, mode 2, LSB/MSB, ch 0 */<br>
+	outb_p(LATCH &amp; 0xff , 0x40);	/* LSB */<br>
+	outb(LATCH &gt;&gt; 8 , 0x40);	/* MSB */<br>
+<br>
+#ifndef CONFIG_VISWS<br>
+	setup_irq(2, &amp;irq2);<br>
+	setup_irq(13, &amp;irq13);<br>
+#endif<br>
+}<br>
+<br>
+#ifdef CONFIG_X86_IO_APIC<br>
+__initfunc(void init_IRQ_SMP(void))<br>
+{<br>
+	int i;<br>
+	for (i = 0; i &lt; NR_IRQS ; i++)<br>
+		if (IO_APIC_VECTOR(i) &gt; 0)<br>
+			set_intr_gate(IO_APIC_VECTOR(i), interrupt[i]);<br>
+}<br>
+#endif<br>
+<br>
diff -u -r -N vanilla12/arch/i386/kernel/io_apic.c linux.new12/arch/i386/kernel/io_apic.c<br>
--- vanilla12/arch/i386/kernel/io_apic.c	Sun Jul 25 11:26:01 1999<br>
+++ linux.new12/arch/i386/kernel/io_apic.c	Wed Aug  4 16:20:49 1999<br>
@@ -19,7 +19,7 @@<br>
 #include &lt;linux/delay.h&gt;<br>
 #include &lt;asm/io.h&gt;<br>
 <br>
-#include "irq.h"<br>
+#include &lt;linux/irq.h&gt;<br>
 <br>
 /*<br>
  * volatile is justified in this case, IO-APIC register contents<br>
@@ -954,24 +954,13 @@<br>
  * better to do it this way as thus we do not have to be aware of<br>
  * 'pending' interrupts in the IRQ path, except at this point.<br>
  */<br>
-static inline void self_IPI(unsigned int irq)<br>
-{<br>
-	irq_desc_t *desc = irq_desc + irq;<br>
-	unsigned int status = desc-&gt;status;<br>
-<br>
-	if ((status &amp; (IRQ_PENDING | IRQ_REPLAY)) == IRQ_PENDING) {<br>
-		desc-&gt;status = status | IRQ_REPLAY;<br>
-		send_IPI_self(IO_APIC_VECTOR(irq));<br>
-	}<br>
-}<br>
-<br>
 /*<br>
  * Edge triggered needs to resend any interrupt<br>
- * that was delayed.<br>
+ * that was delayed but this is now handled in the device<br>
+ * independent code.<br>
  */<br>
 static void enable_edge_ioapic_irq(unsigned int irq)<br>
 {<br>
-	self_IPI(irq);<br>
 	enable_IO_APIC_irq(irq);<br>
 }<br>
 <br>
@@ -984,129 +973,49 @@<br>
  * Starting up a edge-triggered IO-APIC interrupt is<br>
  * nasty - we need to make sure that we get the edge.<br>
  * If it is already asserted for some reason, we need<br>
- * to fake an edge by marking it IRQ_PENDING..<br>
+ * return 1 to indicate that is was pending.<br>
  *<br>
  * This is not complete - we should be able to fake<br>
  * an edge even if it isn't on the 8259A...<br>
  */<br>
 <br>
-static void startup_edge_ioapic_irq(unsigned int irq)<br>
+static unsigned int startup_edge_ioapic_irq(unsigned int irq)<br>
 {<br>
+	int was_pending = 0;<br>
 	if (irq &lt; 16) {<br>
 		disable_8259A_irq(irq);<br>
 		if (i8259A_irq_pending(irq))<br>
-			irq_desc[irq].status |= IRQ_PENDING;<br>
+			was_pending = 1;<br>
 	}<br>
 	enable_edge_ioapic_irq(irq);<br>
+	return was_pending;<br>
 }<br>
 <br>
 #define shutdown_edge_ioapic_irq	disable_edge_ioapic_irq<br>
+void static ack_edge_ioapic_irq(unsigned int i){<br>
+ack_APIC_irq();<br>
+}<br>
+void static end_edge_ioapic_irq(unsigned int i){}<br>
+<br>
 <br>
 /*<br>
  * Level triggered interrupts can just be masked,<br>
  * and shutting down and starting up the interrupt<br>
- * is the same as enabling and disabling them.<br>
+ * is the same as enabling and disabling them -- except<br>
+ * with a startup need to return a "was pending" value.<br>
  */<br>
-#define startup_level_ioapic_irq	unmask_IO_APIC_irq<br>
+static unsigned int startup_level_ioapic_irq(unsigned int irq){ <br>
+	unmask_IO_APIC_irq(irq);<br>
+	return 0; /* don't check for pending */<br>
+}<br>
+<br>
 #define shutdown_level_ioapic_irq	mask_IO_APIC_irq<br>
 #define enable_level_ioapic_irq		unmask_IO_APIC_irq<br>
 #define disable_level_ioapic_irq	mask_IO_APIC_irq<br>
-<br>
-static void do_edge_ioapic_IRQ(unsigned int irq, struct pt_regs * regs)<br>
-{<br>
-	irq_desc_t *desc = irq_desc + irq;<br>
-	struct irqaction * action;<br>
-	unsigned int status;<br>
-<br>
-	spin_lock(&amp;irq_controller_lock);<br>
-<br>
-	/*<br>
-	 * Edge triggered IRQs can be acknowledged immediately<br>
-	 * and do not need to be masked.<br>
-	 */<br>
+#define end_level_ioapic_irq		unmask_IO_APIC_irq	<br>
+void static mask_and_ack_level_ioapic_irq(unsigned int i){<br>
+	mask_IO_APIC_irq(i);<br>
 	ack_APIC_irq();<br>
-	status = desc-&gt;status &amp; ~(IRQ_REPLAY | IRQ_WAITING);<br>
-	status |= IRQ_PENDING;<br>
-<br>
-	/*<br>
-	 * If the IRQ is disabled for whatever reason, we cannot<br>
-	 * use the action we have.<br>
-	 */<br>
-	action = NULL;<br>
-	if (!(status &amp; (IRQ_DISABLED | IRQ_INPROGRESS))) {<br>
-		action = desc-&gt;action;<br>
-		status &amp;= ~IRQ_PENDING;<br>
-		status |= IRQ_INPROGRESS;<br>
-	}<br>
-	desc-&gt;status = status;<br>
-	spin_unlock(&amp;irq_controller_lock);<br>
-<br>
-	/*<br>
-	 * If there is no IRQ handler or it was disabled, exit early.<br>
-	 */<br>
-	if (!action)<br>
-		return;<br>
-<br>
-	/*<br>
-	 * Edge triggered interrupts need to remember<br>
-	 * pending events.<br>
-	 */<br>
-	for (;;) {<br>
-		handle_IRQ_event(irq, regs, action);<br>
-<br>
-		spin_lock(&amp;irq_controller_lock);<br>
-		if (!(desc-&gt;status &amp; IRQ_PENDING))<br>
-			break;<br>
-		desc-&gt;status &amp;= ~IRQ_PENDING;<br>
-		spin_unlock(&amp;irq_controller_lock);<br>
-	}<br>
-	desc-&gt;status &amp;= ~IRQ_INPROGRESS;<br>
-	spin_unlock(&amp;irq_controller_lock);<br>
-}<br>
-<br>
-static void do_level_ioapic_IRQ(unsigned int irq, struct pt_regs * regs)<br>
-{<br>
-	irq_desc_t *desc = irq_desc + irq;<br>
-	struct irqaction * action;<br>
-	unsigned int status;<br>
-<br>
-	spin_lock(&amp;irq_controller_lock);<br>
-	/*<br>
-	 * In the level triggered case we first disable the IRQ<br>
-	 * in the IO-APIC, then we 'early ACK' the IRQ, then we<br>
-	 * handle it and enable the IRQ when finished.<br>
-	 *<br>
-	 * disable has to happen before the ACK, to avoid IRQ storms.<br>
-	 * So this all has to be within the spinlock.<br>
-	 */<br>
-	mask_IO_APIC_irq(irq);<br>
-	status = desc-&gt;status &amp; ~(IRQ_REPLAY | IRQ_WAITING);<br>
-<br>
-	/*<br>
-	 * If the IRQ is disabled for whatever reason, we must<br>
-	 * not enter the IRQ action.<br>
-	 */<br>
-	action = NULL;<br>
-	if (!(status &amp; (IRQ_DISABLED | IRQ_INPROGRESS))) {<br>
-		action = desc-&gt;action;<br>
-		status |= IRQ_INPROGRESS;<br>
-	}<br>
-	desc-&gt;status = status;<br>
-<br>
-	ack_APIC_irq();<br>
-	spin_unlock(&amp;irq_controller_lock);<br>
-<br>
-	/* Exit early if we had no action or it was disabled */<br>
-	if (!action)<br>
-		return;<br>
-<br>
-	handle_IRQ_event(irq, regs, action);<br>
-<br>
-	spin_lock(&amp;irq_controller_lock);<br>
-	desc-&gt;status &amp;= ~IRQ_INPROGRESS;<br>
-	if (!(desc-&gt;status &amp; IRQ_DISABLED))<br>
-		unmask_IO_APIC_irq(irq);<br>
-	spin_unlock(&amp;irq_controller_lock);<br>
 }<br>
 <br>
 /*<br>
@@ -1122,18 +1031,20 @@<br>
 	"IO-APIC-edge",<br>
 	startup_edge_ioapic_irq,<br>
 	shutdown_edge_ioapic_irq,<br>
-	do_edge_ioapic_IRQ,<br>
 	enable_edge_ioapic_irq,<br>
-	disable_edge_ioapic_irq<br>
+	disable_edge_ioapic_irq,<br>
+	ack_edge_ioapic_irq,<br>
+	end_edge_ioapic_irq<br>
 };<br>
 <br>
 static struct hw_interrupt_type ioapic_level_irq_type = {<br>
 	"IO-APIC-level",<br>
 	startup_level_ioapic_irq,<br>
 	shutdown_level_ioapic_irq,<br>
-	do_level_ioapic_IRQ,<br>
 	enable_level_ioapic_irq,<br>
-	disable_level_ioapic_irq<br>
+	disable_level_ioapic_irq,<br>
+	mask_and_ack_level_ioapic_irq,<br>
+	end_level_ioapic_irq<br>
 };<br>
 <br>
 static inline void init_IO_APIC_traps(void)<br>
diff -u -r -N vanilla12/arch/i386/kernel/irq.c linux.new12/arch/i386/kernel/irq.c<br>
--- vanilla12/arch/i386/kernel/irq.c	Thu Jul 15 16:50:47 1999<br>
+++ linux.new12/arch/i386/kernel/irq.c	Wed Aug  4 16:20:49 1999<br>
@@ -1,3 +1,8 @@<br>
+/* mostly architecture independent<br>
+   some moved to i8259.c<br>
+   the beautiful visws architecture code needs to be updated too.<br>
+   and, finally, the BUILD_IRQ and SMP_BUILD macros in irq.h need fixed.<br>
+   */<br>
 /*<br>
  *	linux/arch/i386/kernel/irq.c<br>
  *<br>
@@ -32,14 +37,14 @@<br>
 <br>
 #include &lt;asm/system.h&gt;<br>
 #include &lt;asm/io.h&gt;<br>
-#include &lt;asm/irq.h&gt;<br>
 #include &lt;asm/bitops.h&gt;<br>
 #include &lt;asm/smp.h&gt;<br>
 #include &lt;asm/pgtable.h&gt;<br>
 #include &lt;asm/delay.h&gt;<br>
 #include &lt;asm/desc.h&gt;<br>
+#include &lt;asm/irq.h&gt;<br>
+#include &lt;linux/irq.h&gt;<br>
 <br>
-#include "irq.h"<br>
 <br>
 unsigned int local_bh_count[NR_CPUS];<br>
 unsigned int local_irq_count[NR_CPUS];<br>
@@ -67,334 +72,18 @@<br>
  * system. We never hold this lock when we call the actual<br>
  * IRQ handler.<br>
  */<br>
-spinlock_t irq_controller_lock;<br>
-<br>
-/*<br>
- * Dummy controller type for unused interrupts<br>
- */<br>
-static void do_none(unsigned int irq, struct pt_regs * regs)<br>
-{<br>
-	/*<br>
-	 * we are careful. While for ISA irqs it's common to happen<br>
-	 * outside of any driver (think autodetection), this is not<br>
-	 * at all nice for PCI interrupts. So we are stricter and<br>
-	 * print a warning when such spurious interrupts happen.<br>
-	 * Spurious interrupts can confuse other drivers if the PCI<br>
-	 * IRQ line is shared.<br>
-	 *<br>
-	 * Such spurious interrupts are either driver bugs, or<br>
-	 * sometimes hw (chipset) bugs.<br>
-	 */<br>
-	printk("unexpected IRQ vector %d on CPU#%d!\n",irq, smp_processor_id());<br>
-<br>
-#ifdef __SMP__<br>
-	/*<br>
-	 * [currently unexpected vectors happen only on SMP and APIC.<br>
-	 *  if we want to have non-APIC and non-8259A controllers<br>
-	 *  in the future with unexpected vectors, this ack should<br>
-	 *  probably be made controller-specific.]<br>
-	 */<br>
-	ack_APIC_irq();<br>
-#endif<br>
-}<br>
-static void enable_none(unsigned int irq) { }<br>
-static void disable_none(unsigned int irq) { }<br>
-<br>
-/* startup is the same as "enable", shutdown is same as "disable" */<br>
-#define startup_none	enable_none<br>
-#define shutdown_none	disable_none<br>
-<br>
-struct hw_interrupt_type no_irq_type = {<br>
-	"none",<br>
-	startup_none,<br>
-	shutdown_none,<br>
-	do_none,<br>
-	enable_none,<br>
-	disable_none<br>
-};<br>
-<br>
-/*<br>
- * This is the 'legacy' 8259A Programmable Interrupt Controller,<br>
- * present in the majority of PC/AT boxes.<br>
- */<br>
-<br>
-static void do_8259A_IRQ(unsigned int irq, struct pt_regs * regs);<br>
-static void enable_8259A_irq(unsigned int irq);<br>
-void disable_8259A_irq(unsigned int irq);<br>
-<br>
-/* startup is the same as "enable", shutdown is same as "disable" */<br>
-#define startup_8259A_irq	enable_8259A_irq<br>
-#define shutdown_8259A_irq	disable_8259A_irq<br>
-<br>
-static struct hw_interrupt_type i8259A_irq_type = {<br>
-	"XT-PIC",<br>
-	startup_8259A_irq,<br>
-	shutdown_8259A_irq,<br>
-	do_8259A_IRQ,<br>
-	enable_8259A_irq,<br>
-	disable_8259A_irq<br>
-};<br>
-<br>
+spinlock_t irq_controller_lock ={0};<br>
 /*<br>
  * Controller mappings for all interrupt sources:<br>
  */<br>
 irq_desc_t irq_desc[NR_IRQS] = { [0 ... NR_IRQS-1] = { 0, &amp;no_irq_type, }};<br>
 <br>
-<br>
-/*<br>
- * 8259A PIC functions to handle ISA devices:<br>
- */<br>
-<br>
-/*<br>
- * This contains the irq mask for both 8259A irq controllers,<br>
- */<br>
-static unsigned int cached_irq_mask = 0xffff;<br>
-<br>
-#define __byte(x,y) 	(((unsigned char *)&amp;(y))[x])<br>
-#define cached_21	(__byte(0,cached_irq_mask))<br>
-#define cached_A1	(__byte(1,cached_irq_mask))<br>
-<br>
-/*<br>
- * Not all IRQs can be routed through the IO-APIC, eg. on certain (older)<br>
- * boards the timer interrupt is not connected to any IO-APIC pin, it's<br>
- * fed to the CPU IRQ line directly.<br>
- *<br>
- * Any '1' bit in this mask means the IRQ is routed through the IO-APIC.<br>
- * this 'mixed mode' IRQ handling costs nothing because it's only used<br>
- * at IRQ setup time.<br>
- */<br>
-unsigned long io_apic_irqs = 0;<br>
-<br>
-/*<br>
- * These have to be protected by the irq controller spinlock<br>
- * before being called.<br>
- */<br>
-void disable_8259A_irq(unsigned int irq)<br>
-{<br>
-	unsigned int mask = 1 &lt;&lt; irq;<br>
-	cached_irq_mask |= mask;<br>
-	if (irq &amp; 8) {<br>
-		outb(cached_A1,0xA1);<br>
-	} else {<br>
-		outb(cached_21,0x21);<br>
-	}<br>
-}<br>
-<br>
-static void enable_8259A_irq(unsigned int irq)<br>
-{<br>
-	unsigned int mask = ~(1 &lt;&lt; irq);<br>
-	cached_irq_mask &amp;= mask;<br>
-	if (irq &amp; 8) {<br>
-		outb(cached_A1,0xA1);<br>
-	} else {<br>
-		outb(cached_21,0x21);<br>
-	}<br>
-}<br>
-<br>
-int i8259A_irq_pending(unsigned int irq)<br>
-{<br>
-	unsigned int mask = 1&lt;&lt;irq;<br>
-<br>
-	if (irq &lt; 8)<br>
-                return (inb(0x20) &amp; mask);<br>
-        return (inb(0xA0) &amp; (mask &gt;&gt; 8));<br>
-}<br>
-<br>
-void make_8259A_irq(unsigned int irq)<br>
-{<br>
-	disable_irq_nosync(irq);<br>
-	io_apic_irqs &amp;= ~(1&lt;&lt;irq);<br>
-	irq_desc[irq].handler = &amp;i8259A_irq_type;<br>
-	enable_irq(irq);<br>
-}<br>
-<br>
-/*<br>
- * Careful! The 8259A is a fragile beast, it pretty<br>
- * much _has_ to be done exactly like this (mask it<br>
- * first, _then_ send the EOI, and the order of EOI<br>
- * to the two 8259s is important!<br>
- */<br>
-static inline void mask_and_ack_8259A(unsigned int irq)<br>
-{<br>
-	cached_irq_mask |= 1 &lt;&lt; irq;<br>
-	if (irq &amp; 8) {<br>
-		inb(0xA1);	/* DUMMY */<br>
-		outb(cached_A1,0xA1);<br>
-		outb(0x62,0x20);	/* Specific EOI to cascade */<br>
-		outb(0x20,0xA0);<br>
-	} else {<br>
-		inb(0x21);	/* DUMMY */<br>
-		outb(cached_21,0x21);<br>
-		outb(0x20,0x20);<br>
-	}<br>
-}<br>
-<br>
-static void do_8259A_IRQ(unsigned int irq, struct pt_regs * regs)<br>
-{<br>
-	struct irqaction * action;<br>
-	irq_desc_t *desc = irq_desc + irq;<br>
-<br>
-	spin_lock(&amp;irq_controller_lock);<br>
-	{<br>
-		unsigned int status;<br>
-		mask_and_ack_8259A(irq);<br>
-		status = desc-&gt;status &amp; ~(IRQ_REPLAY | IRQ_WAITING);<br>
-		action = NULL;<br>
-		if (!(status &amp; (IRQ_DISABLED | IRQ_INPROGRESS))) {<br>
-			action = desc-&gt;action;<br>
-			status |= IRQ_INPROGRESS;<br>
-		}<br>
-		desc-&gt;status = status;<br>
-	}<br>
-	spin_unlock(&amp;irq_controller_lock);<br>
-<br>
-	/* Exit early if we had no action or it was disabled */<br>
-	if (!action)<br>
-		return;<br>
-<br>
-	handle_IRQ_event(irq, regs, action);<br>
-<br>
-	spin_lock(&amp;irq_controller_lock);<br>
-	{<br>
-		unsigned int status = desc-&gt;status &amp; ~IRQ_INPROGRESS;<br>
-		desc-&gt;status = status;<br>
-		if (!(status &amp; IRQ_DISABLED))<br>
-			enable_8259A_irq(irq);<br>
-	}<br>
-	spin_unlock(&amp;irq_controller_lock);<br>
-}<br>
-<br>
-/*<br>
- * This builds up the IRQ handler stubs using some ugly macros in irq.h<br>
- *<br>
- * These macros create the low-level assembly IRQ routines that save<br>
- * register context and call do_IRQ(). do_IRQ() then does all the<br>
- * operations that are needed to keep the AT (or SMP IOAPIC)<br>
- * interrupt-controller happy.<br>
- */<br>
-<br>
-<br>
-BUILD_COMMON_IRQ()<br>
-<br>
-#define BI(x,y) \<br>
-	BUILD_IRQ(##x##y)<br>
-<br>
-#define BUILD_16_IRQS(x) \<br>
-	BI(x,0) BI(x,1) BI(x,2) BI(x,3) \<br>
-	BI(x,4) BI(x,5) BI(x,6) BI(x,7) \<br>
-	BI(x,8) BI(x,9) BI(x,a) BI(x,b) \<br>
-	BI(x,c) BI(x,d) BI(x,e) BI(x,f)<br>
-<br>
-/*<br>
- * ISA PIC or low IO-APIC triggered (INTA-cycle or APIC) interrupts:<br>
- * (these are usually mapped to vectors 0x20-0x30)<br>
- */<br>
-BUILD_16_IRQS(0x0)<br>
-<br>
-#ifdef CONFIG_X86_IO_APIC<br>
-/*<br>
- * The IO-APIC gives us many more interrupt sources. Most of these <br>
- * are unused but an SMP system is supposed to have enough memory ...<br>
- * sometimes (mostly wrt. hw bugs) we get corrupted vectors all<br>
- * across the spectrum, so we really want to be prepared to get all<br>
- * of these. Plus, more powerful systems might have more than 64<br>
- * IO-APIC registers.<br>
- *<br>
- * (these are usually mapped into the 0x30-0xff vector range)<br>
- */<br>
-                   BUILD_16_IRQS(0x1) BUILD_16_IRQS(0x2) BUILD_16_IRQS(0x3)<br>
-BUILD_16_IRQS(0x4) BUILD_16_IRQS(0x5) BUILD_16_IRQS(0x6) BUILD_16_IRQS(0x7)<br>
-BUILD_16_IRQS(0x8) BUILD_16_IRQS(0x9) BUILD_16_IRQS(0xa) BUILD_16_IRQS(0xb)<br>
-BUILD_16_IRQS(0xc) BUILD_16_IRQS(0xd)<br>
-#endif<br>
-<br>
-#undef BUILD_16_IRQS<br>
-#undef BI<br>
-<br>
-<br>
-#ifdef __SMP__<br>
-/*<br>
- * The following vectors are part of the Linux architecture, there<br>
- * is no hardware IRQ pin equivalent for them, they are triggered<br>
- * through the ICC by us (IPIs)<br>
- */<br>
-BUILD_SMP_INTERRUPT(reschedule_interrupt)<br>
-BUILD_SMP_INTERRUPT(invalidate_interrupt)<br>
-BUILD_SMP_INTERRUPT(stop_cpu_interrupt)<br>
-BUILD_SMP_INTERRUPT(call_function_interrupt)<br>
-BUILD_SMP_INTERRUPT(spurious_interrupt)<br>
-<br>
-/*<br>
- * every pentium local APIC has two 'local interrupts', with a<br>
- * soft-definable vector attached to both interrupts, one of<br>
- * which is a timer interrupt, the other one is error counter<br>
- * overflow. Linux uses the local APIC timer interrupt to get<br>
- * a much simpler SMP time architecture:<br>
- */<br>
-BUILD_SMP_TIMER_INTERRUPT(apic_timer_interrupt)<br>
-<br>
-#endif<br>
-<br>
-#define IRQ(x,y) \<br>
-	IRQ##x##y##_interrupt<br>
-<br>
-#define IRQLIST_16(x) \<br>
-	IRQ(x,0), IRQ(x,1), IRQ(x,2), IRQ(x,3), \<br>
-	IRQ(x,4), IRQ(x,5), IRQ(x,6), IRQ(x,7), \<br>
-	IRQ(x,8), IRQ(x,9), IRQ(x,a), IRQ(x,b), \<br>
-	IRQ(x,c), IRQ(x,d), IRQ(x,e), IRQ(x,f)<br>
-<br>
-static void (*interrupt[NR_IRQS])(void) = {<br>
-	IRQLIST_16(0x0),<br>
-<br>
-#ifdef CONFIG_X86_IO_APIC<br>
-	                 IRQLIST_16(0x1), IRQLIST_16(0x2), IRQLIST_16(0x3),<br>
-	IRQLIST_16(0x4), IRQLIST_16(0x5), IRQLIST_16(0x6), IRQLIST_16(0x7),<br>
-	IRQLIST_16(0x8), IRQLIST_16(0x9), IRQLIST_16(0xa), IRQLIST_16(0xb),<br>
-	IRQLIST_16(0xc), IRQLIST_16(0xd)<br>
-#endif<br>
-};<br>
-<br>
-#undef IRQ<br>
-#undef IRQLIST_16<br>
-<br>
-<br>
 /*<br>
  * Special irq handlers.<br>
  */<br>
 <br>
 void no_action(int cpl, void *dev_id, struct pt_regs *regs) { }<br>
 <br>
-#ifndef CONFIG_VISWS<br>
-/*<br>
- * Note that on a 486, we don't want to do a SIGFPE on an irq13<br>
- * as the irq is unreliable, and exception 16 works correctly<br>
- * (ie as explained in the intel literature). On a 386, you<br>
- * can't use exception 16 due to bad IBM design, so we have to<br>
- * rely on the less exact irq13.<br>
- *<br>
- * Careful.. Not only is IRQ13 unreliable, but it is also<br>
- * leads to races. IBM designers who came up with it should<br>
- * be shot.<br>
- */<br>
- <br>
-static void math_error_irq(int cpl, void *dev_id, struct pt_regs *regs)<br>
-{<br>
-	outb(0,0xF0);<br>
-	if (ignore_irq13 || !boot_cpu_data.hard_math)<br>
-		return;<br>
-	math_error();<br>
-}<br>
-<br>
-static struct irqaction irq13 = { math_error_irq, 0, 0, "fpu", NULL, NULL };<br>
-<br>
-/*<br>
- * IRQ2 is cascade interrupt to second interrupt controller<br>
- */<br>
-<br>
-static struct irqaction irq2  = { no_action, 0, 0, "cascade", NULL, NULL};<br>
-#endif<br>
-<br>
 /*<br>
  * Generic, controller-independent functions:<br>
  */<br>
@@ -782,7 +471,15 @@<br>
 	spin_lock_irqsave(&amp;irq_controller_lock, flags);<br>
 	switch (irq_desc[irq].depth) {<br>
 	case 1:<br>
-		irq_desc[irq].status &amp;= ~IRQ_DISABLED;<br>
+		{<br>
+			unsigned int status;<br>
+			irq_desc[irq].status &amp;= ~IRQ_DISABLED;<br>
+			status = irq_desc[irq].status;<br>
+		if ((status &amp; (IRQ_PENDING | IRQ_REPLAY)) == IRQ_PENDING) {<br>
+			irq_desc[irq].status |= IRQ_REPLAY;<br>
+			hw_resend_irq(irq_desc[irq].handler,irq);<br>
+		}<br>
+		}<br>
 		irq_desc[irq].handler-&gt;enable(irq);<br>
 		/* fall throught */<br>
 	default:<br>
@@ -800,7 +497,7 @@<br>
  * SMP cross-CPU interrupts have their own specific<br>
  * handlers).<br>
  */<br>
-asmlinkage void do_IRQ(struct pt_regs regs)<br>
+asmlinkage unsigned int do_IRQ(struct pt_regs regs)<br>
 {	<br>
 	/* <br>
 	 * We ack quickly, we don't want the irq controller<br>
@@ -812,76 +509,81 @@<br>
 	 * 0 return value means that this irq is already being<br>
 	 * handled by some other CPU. (or is disabled)<br>
 	 */<br>
-	int irq = regs.orig_eax &amp; 0xff; /* subtle, see irq.h */<br>
+	int irq = regs.orig_eax &amp;0xff;/* high bits used in ret_from_ code  */<br>
 	int cpu = smp_processor_id();<br>
+	irq_desc_t *desc;<br>
+	struct irqaction * action;<br>
+	unsigned int status;<br>
 <br>
 	kstat.irqs[cpu][irq]++;<br>
-	irq_desc[irq].handler-&gt;handle(irq, &amp;regs);<br>
+        desc = irq_desc + irq;<br>
+	spin_lock(&amp;irq_controller_lock);<br>
+        irq_desc[irq].handler-&gt;ack(irq);<br>
+	/*<br>
+	   REPLAY is when Linux resends an IRQ that was dropped earlier<br>
+	   WAITING is used by probe to mark irqs that are being tested<br>
+	   */<br>
+	status = desc-&gt;status &amp; ~(IRQ_REPLAY | IRQ_WAITING);<br>
+	status |= IRQ_PENDING; /* we _want_ to handle it */<br>
 <br>
 	/*<br>
-	 * This should be conditional: we should really get<br>
-	 * a return code from the irq handler to tell us<br>
-	 * whether the handler wants us to do software bottom<br>
-	 * half handling or not..<br>
+	 * If the IRQ is disabled for whatever reason, we cannot<br>
+	 * use the action we have.<br>
 	 */<br>
-	if (1) {<br>
-		if (bh_active &amp; bh_mask)<br>
-			do_bottom_half();<br>
+	action = NULL;<br>
+	if (!(status &amp; (IRQ_DISABLED | IRQ_INPROGRESS))) {<br>
+		action = desc-&gt;action;<br>
+		status &amp;= ~IRQ_PENDING; /* we commit to handling */<br>
+		status |= IRQ_INPROGRESS; /* we are handling it */<br>
 	}<br>
-}<br>
-<br>
-int setup_x86_irq(unsigned int irq, struct irqaction * new)<br>
-{<br>
-	int shared = 0;<br>
-	struct irqaction *old, **p;<br>
-	unsigned long flags;<br>
+	desc-&gt;status = status;<br>
+	spin_unlock(&amp;irq_controller_lock);<br>
 <br>
 	/*<br>
-	 * Some drivers like serial.c use request_irq() heavily,<br>
-	 * so we have to be careful not to interfere with a<br>
-	 * running system.<br>
+	 * If there is no IRQ handler or it was disabled, exit early.<br>
+	   Since we set PENDING, if another processor is handling<br>
+	   a different instance of this same irq, the other processor<br>
+	   will take care of it.<br>
 	 */<br>
-	if (new-&gt;flags &amp; SA_SAMPLE_RANDOM) {<br>
-		/*<br>
-		 * This function might sleep, we want to call it first,<br>
-		 * outside of the atomic block.<br>
-		 * Yes, this might clear the entropy pool if the wrong<br>
-		 * driver is attempted to be loaded, without actually<br>
-		 * installing a new handler, but is this really a problem,<br>
-		 * only the sysadmin is able to do this.<br>
-		 */<br>
-		rand_initialize_irq(irq);<br>
-	}<br>
+	if (!action)<br>
+		return 1;<br>
 <br>
 	/*<br>
-	 * The following block of code has to be executed atomically<br>
+	 * Edge triggered interrupts need to remember<br>
+	 * pending events.<br>
+	 * This applies to any hw interrupts that allow a second<br>
+	 * instance of the same irq to arrive while we are in do_IRQ<br>
+	 * or in the handler. But the code here only handles the _second_<br>
+	 * instance of the irq, not the third or fourth. So it is mostly<br>
+	 * useful for irq hardware that does not mask cleanly in an<br>
+	 * SMP environment.<br>
 	 */<br>
-	spin_lock_irqsave(&amp;irq_controller_lock,flags);<br>
-	p = &amp;irq_desc[irq].action;<br>
-	if ((old = *p) != NULL) {<br>
-		/* Can't share interrupts unless both agree to */<br>
-		if (!(old-&gt;flags &amp; new-&gt;flags &amp; SA_SHIRQ)) {<br>
-			spin_unlock_irqrestore(&amp;irq_controller_lock,flags);<br>
-			return -EBUSY;<br>
-		}<br>
-<br>
-		/* add new interrupt at end of irq queue */<br>
-		do {<br>
-			p = &amp;old-&gt;next;<br>
-			old = *p;<br>
-		} while (old);<br>
-		shared = 1;<br>
+	for (;;) {<br>
+		handle_IRQ_event(irq, &amp;regs, action);<br>
+		spin_lock(&amp;irq_controller_lock);<br>
+	        <br>
+		if (!(desc-&gt;status &amp; IRQ_PENDING))<br>
+			break;<br>
+		desc-&gt;status &amp;= ~IRQ_PENDING;<br>
+		spin_unlock(&amp;irq_controller_lock);<br>
+	}<br>
+	desc-&gt;status &amp;= ~IRQ_INPROGRESS;<br>
+	if (!(desc-&gt;status &amp; IRQ_DISABLED)){<br>
+			irq_desc[irq].handler-&gt;end(irq);<br>
 	}<br>
+	spin_unlock(&amp;irq_controller_lock);<br>
 <br>
-	*p = new;<br>
-<br>
-	if (!shared) {<br>
-		irq_desc[irq].depth = 0;<br>
-		irq_desc[irq].status &amp;= ~IRQ_DISABLED;<br>
-		irq_desc[irq].handler-&gt;startup(irq);<br>
+	/*<br>
+	 * This should be conditional: we should really get<br>
+	 * a return code from the irq handler to tell us<br>
+	 * whether the handler wants us to do software bottom<br>
+	 * half handling or not..<br>
+	 */<br>
+	if (1) {<br>
+		if (bh_active &amp; bh_mask)<br>
+			do_bottom_half();<br>
 	}<br>
-	spin_unlock_irqrestore(&amp;irq_controller_lock,flags);<br>
-	return 0;<br>
+	return 1;<br>
 }<br>
 <br>
 int request_irq(unsigned int irq, <br>
@@ -910,8 +612,7 @@<br>
 	action-&gt;next = NULL;<br>
 	action-&gt;dev_id = dev_id;<br>
 <br>
-	retval = setup_x86_irq(irq, action);<br>
-<br>
+	retval = setup_irq(irq, action);<br>
 	if (retval)<br>
 		kfree(action);<br>
 	return retval;<br>
@@ -936,13 +637,6 @@<br>
 			irq_desc[irq].status |= IRQ_DISABLED;<br>
 			irq_desc[irq].handler-&gt;shutdown(irq);<br>
 		}<br>
-		spin_unlock_irqrestore(&amp;irq_controller_lock,flags);<br>
-<br>
-		/* Wait to make sure it's not being used on another CPU */<br>
-		while (irq_desc[irq].status &amp; IRQ_INPROGRESS)<br>
-			barrier();<br>
-		kfree(action);<br>
-		return;<br>
 	}<br>
 	printk("Trying to free free IRQ%d\n",irq);<br>
 	spin_unlock_irqrestore(&amp;irq_controller_lock,flags);<br>
@@ -968,7 +662,8 @@<br>
 	for (i = NR_IRQS-1; i &gt; 0; i--) {<br>
 		if (!irq_desc[i].action) {<br>
 			irq_desc[i].status |= IRQ_AUTODETECT | IRQ_WAITING;<br>
-			irq_desc[i].handler-&gt;startup(i);<br>
+			if(irq_desc[i].handler-&gt;startup(i))<br>
+				irq_desc[i].status |= IRQ_PENDING;<br>
 		}<br>
 	}<br>
 	spin_unlock_irq(&amp;irq_controller_lock);<br>
@@ -1031,100 +726,58 @@<br>
 	return irq_found;<br>
 }<br>
 <br>
-void init_ISA_irqs (void)<br>
+/* this was setup_x86_irq but it seems pretty generic */<br>
+int setup_irq(unsigned int irq, struct irqaction * new)<br>
 {<br>
-	int i;<br>
-<br>
-	for (i = 0; i &lt; NR_IRQS; i++) {<br>
-		irq_desc[i].status = IRQ_DISABLED;<br>
-		irq_desc[i].action = 0;<br>
-		irq_desc[i].depth = 0;<br>
-<br>
-		if (i &lt; 16) {<br>
-			/*<br>
-			 * 16 old-style INTA-cycle interrupts:<br>
-			 */<br>
-			irq_desc[i].handler = &amp;i8259A_irq_type;<br>
-		} else {<br>
-			/*<br>
-			 * 'high' PCI IRQs filled in on demand<br>
-			 */<br>
-			irq_desc[i].handler = &amp;no_irq_type;<br>
-		}<br>
-	}<br>
-}<br>
-<br>
-__initfunc(void init_IRQ(void))<br>
-{<br>
-	int i;<br>
+	int shared = 0;<br>
+	struct irqaction *old, **p;<br>
+	unsigned long flags;<br>
 <br>
-#ifndef CONFIG_X86_VISWS_APIC<br>
-	init_ISA_irqs();<br>
-#else<br>
-	init_VISWS_APIC_irqs();<br>
-#endif<br>
 	/*<br>
-	 * Cover the whole vector space, no vector can escape<br>
-	 * us. (some of these will be overridden and become<br>
-	 * 'special' SMP interrupts)<br>
+	 * Some drivers like serial.c use request_irq() heavily,<br>
+	 * so we have to be careful not to interfere with a<br>
+	 * running system.<br>
 	 */<br>
-	for (i = 0; i &lt; NR_IRQS; i++) {<br>
-		int vector = FIRST_EXTERNAL_VECTOR + i;<br>
-		if (vector != SYSCALL_VECTOR) <br>
-			set_intr_gate(vector, interrupt[i]);<br>
+	if (new-&gt;flags &amp; SA_SAMPLE_RANDOM) {<br>
+		/*<br>
+		 * This function might sleep, we want to call it first,<br>
+		 * outside of the atomic block.<br>
+		 * Yes, this might clear the entropy pool if the wrong<br>
+		 * driver is attempted to be loaded, without actually<br>
+		 * installing a new handler, but is this really a problem,<br>
+		 * only the sysadmin is able to do this.<br>
+		 */<br>
+		rand_initialize_irq(irq);<br>
 	}<br>
 <br>
-#ifdef __SMP__	<br>
-<br>
-	/*<br>
-	  IRQ0 must be given a fixed assignment and initialized<br>
-	  before init_IRQ_SMP.<br>
-	*/<br>
-	set_intr_gate(IRQ0_TRAP_VECTOR, interrupt[0]);<br>
-<br>
 	/*<br>
-	 * The reschedule interrupt is a CPU-to-CPU reschedule-helper<br>
-	 * IPI, driven by wakeup.<br>
+	 * The following block of code has to be executed atomically<br>
 	 */<br>
-	set_intr_gate(RESCHEDULE_VECTOR, reschedule_interrupt);<br>
-<br>
-	/* IPI for invalidation */<br>
-	set_intr_gate(INVALIDATE_TLB_VECTOR, invalidate_interrupt);<br>
-<br>
-	/* IPI for CPU halt */<br>
-	set_intr_gate(STOP_CPU_VECTOR, stop_cpu_interrupt);<br>
-<br>
-	/* self generated IPI for local APIC timer */<br>
-	set_intr_gate(LOCAL_TIMER_VECTOR, apic_timer_interrupt);<br>
-<br>
-	/* IPI for generic function call */<br>
-	set_intr_gate(CALL_FUNCTION_VECTOR, call_function_interrupt);<br>
+	spin_lock_irqsave(&amp;irq_controller_lock,flags);<br>
+	p = &amp;irq_desc[irq].action;<br>
+	if ((old = *p) != NULL) {<br>
+		/* Can't share interrupts unless both agree to */<br>
+		if (!(old-&gt;flags &amp; new-&gt;flags &amp; SA_SHIRQ)) {<br>
+			spin_unlock_irqrestore(&amp;irq_controller_lock,flags);<br>
+			return -EBUSY;<br>
+		}<br>
 <br>
-	/* IPI vector for APIC spurious interrupts */<br>
-	set_intr_gate(SPURIOUS_APIC_VECTOR, spurious_interrupt);<br>
-#endif<br>
+		/* add new interrupt at end of irq queue */<br>
+		do {<br>
+			p = &amp;old-&gt;next;<br>
+			old = *p;<br>
+		} while (old);<br>
+		shared = 1;<br>
+	}<br>
 <br>
-	/*<br>
-	 * Set the clock to 100 Hz, we already have a valid<br>
-	 * vector now:<br>
-	 */<br>
-	outb_p(0x34,0x43);		/* binary, mode 2, LSB/MSB, ch 0 */<br>
-	outb_p(LATCH &amp; 0xff , 0x40);	/* LSB */<br>
-	outb(LATCH &gt;&gt; 8 , 0x40);	/* MSB */<br>
-<br>
-#ifndef CONFIG_VISWS<br>
-	setup_x86_irq(2, &amp;irq2);<br>
-	setup_x86_irq(13, &amp;irq13);<br>
-#endif<br>
-}<br>
+	*p = new;<br>
 <br>
-#ifdef CONFIG_X86_IO_APIC<br>
-__initfunc(void init_IRQ_SMP(void))<br>
-{<br>
-	int i;<br>
-	for (i = 0; i &lt; NR_IRQS ; i++)<br>
-		if (IO_APIC_VECTOR(i) &gt; 0)<br>
-			set_intr_gate(IO_APIC_VECTOR(i), interrupt[i]);<br>
+	if (!shared) {<br>
+		irq_desc[irq].depth = 0;<br>
+		irq_desc[irq].status &amp;= ~IRQ_DISABLED;<br>
+		irq_desc[irq].handler-&gt;startup(irq);<br>
+	}<br>
+	spin_unlock_irqrestore(&amp;irq_controller_lock,flags);<br>
+	return 0;<br>
 }<br>
-#endif<br>
 <br>
diff -u -r -N vanilla12/arch/i386/kernel/irq.h linux.new12/arch/i386/kernel/irq.h<br>
--- vanilla12/arch/i386/kernel/irq.h	Wed Jul 28 14:58:07 1999<br>
+++ linux.new12/arch/i386/kernel/irq.h	Wed Aug  4 16:27:29 1999<br>
@@ -1,253 +1,3 @@<br>
-#ifndef __irq_h<br>
-#define __irq_h<br>
 <br>
-#include &lt;asm/irq.h&gt;<br>
+DO NOT USE THIS FILE<br>
 <br>
-/*<br>
- * Interrupt controller descriptor. This is all we need<br>
- * to describe about the low-level hardware.<br>
- */<br>
-struct hw_interrupt_type {<br>
-	const char * typename;<br>
-	void (*startup)(unsigned int irq);<br>
-	void (*shutdown)(unsigned int irq);<br>
-	void (*handle)(unsigned int irq, struct pt_regs * regs);<br>
-	void (*enable)(unsigned int irq);<br>
-	void (*disable)(unsigned int irq);<br>
-};<br>
-<br>
-extern struct hw_interrupt_type no_irq_type;<br>
-<br>
-/*<br>
- * IRQ line status.<br>
- */<br>
-#define IRQ_INPROGRESS	1	/* IRQ handler active - do not enter! */<br>
-#define IRQ_DISABLED	2	/* IRQ disabled - do not enter! */<br>
-#define IRQ_PENDING	4	/* IRQ pending - replay on enable */<br>
-#define IRQ_REPLAY	8	/* IRQ has been replayed but not acked yet */<br>
-#define IRQ_AUTODETECT	16	/* IRQ is being autodetected */<br>
-#define IRQ_WAITING	32	/* IRQ not yet seen - for autodetection */<br>
-<br>
-/*<br>
- * This is the "IRQ descriptor", which contains various information<br>
- * about the irq, including what kind of hardware handling it has,<br>
- * whether it is disabled etc etc.<br>
- *<br>
- * Pad this out to 32 bytes for cache and indexing reasons.<br>
- */<br>
-typedef struct {<br>
-	unsigned int status;			/* IRQ status - IRQ_INPROGRESS, IRQ_DISABLED */<br>
-	struct hw_interrupt_type *handler;	/* handle/enable/disable functions */<br>
-	struct irqaction *action;		/* IRQ action list */<br>
-	unsigned int depth;			/* Disable depth for nested irq disables */<br>
-} irq_desc_t;<br>
-<br>
-/*<br>
- * IDT vectors usable for external interrupt sources start<br>
- * at 0x20:<br>
- */<br>
-#define FIRST_EXTERNAL_VECTOR	0x20<br>
-<br>
-#define SYSCALL_VECTOR		0x80<br>
-<br>
-/*<br>
- * Vectors 0x20-0x2f are used for ISA interrupts.<br>
- */<br>
-<br>
-/*<br>
- * Special IRQ vectors used by the SMP architecture:<br>
- *<br>
- * (some of the following vectors are 'rare', they are merged<br>
- *  into a single vector (FUNCTION_VECTOR) to save vector space.<br>
- *  TLB, reschedule and local APIC vectors are performance-critical.)<br>
- */<br>
-#define RESCHEDULE_VECTOR	0x30<br>
-#define INVALIDATE_TLB_VECTOR	0x31<br>
-#define STOP_CPU_VECTOR		0x40<br>
-#define LOCAL_TIMER_VECTOR	0x41<br>
-#define CALL_FUNCTION_VECTOR	0x50<br>
-<br>
-/*<br>
- * First APIC vector available to drivers: (vectors 0x51-0xfe)<br>
- */<br>
-#define IRQ0_TRAP_VECTOR	0x51<br>
-<br>
-/*<br>
- * This IRQ should never happen, but we print a message nevertheless.<br>
- */<br>
-#define SPURIOUS_APIC_VECTOR	0xff<br>
-<br>
-extern irq_desc_t irq_desc[NR_IRQS];<br>
-extern int irq_vector[NR_IRQS];<br>
-#define IO_APIC_VECTOR(irq)	irq_vector[irq]<br>
-<br>
-extern void init_IRQ_SMP(void);<br>
-extern int handle_IRQ_event(unsigned int, struct pt_regs *, struct irqaction *);<br>
-extern int setup_x86_irq(unsigned int, struct irqaction *);<br>
-<br>
-/*<br>
- * Various low-level irq details needed by irq.c, process.c,<br>
- * time.c, io_apic.c and smp.c<br>
- *<br>
- * Interrupt entry/exit code at both C and assembly level<br>
- */<br>
-<br>
-extern void no_action(int cpl, void *dev_id, struct pt_regs *regs);<br>
-extern void mask_irq(unsigned int irq);<br>
-extern void unmask_irq(unsigned int irq);<br>
-extern void disable_8259A_irq(unsigned int irq);<br>
-extern int i8259A_irq_pending(unsigned int irq);<br>
-extern void ack_APIC_irq(void);<br>
-extern void FASTCALL(send_IPI_self(int vector));<br>
-extern void init_VISWS_APIC_irqs(void);<br>
-extern void setup_IO_APIC(void);<br>
-extern int IO_APIC_get_PCI_irq_vector(int bus, int slot, int fn);<br>
-extern void make_8259A_irq(unsigned int irq);<br>
-extern void send_IPI(int dest, int vector);<br>
-extern void init_pic_mode(void);<br>
-extern void print_IO_APIC(void);<br>
-<br>
-extern unsigned long io_apic_irqs;<br>
-<br>
-extern char _stext, _etext;<br>
-<br>
-#define MAX_IRQ_SOURCES 128<br>
-#define MAX_MP_BUSSES 32<br>
-enum mp_bustype {<br>
-	MP_BUS_ISA,<br>
-	MP_BUS_EISA,<br>
-	MP_BUS_PCI<br>
-};<br>
-extern int mp_bus_id_to_type [MAX_MP_BUSSES];<br>
-extern int mp_bus_id_to_pci_bus [MAX_MP_BUSSES];<br>
-<br>
-extern spinlock_t irq_controller_lock;<br>
-<br>
-#ifdef __SMP__<br>
-<br>
-#include &lt;asm/atomic.h&gt;<br>
-<br>
-static inline void irq_enter(int cpu, unsigned int irq)<br>
-{<br>
-	hardirq_enter(cpu);<br>
-	while (test_bit(0,&amp;global_irq_lock)) {<br>
-		/* nothing */;<br>
-	}<br>
-}<br>
-<br>
-static inline void irq_exit(int cpu, unsigned int irq)<br>
-{<br>
-	hardirq_exit(cpu);<br>
-}<br>
-<br>
-#define IO_APIC_IRQ(x) (((x) &gt;= 16) || ((1&lt;&lt;(x)) &amp; io_apic_irqs))<br>
-<br>
-#else<br>
-<br>
-#define irq_enter(cpu, irq)	(++local_irq_count[cpu])<br>
-#define irq_exit(cpu, irq)	(--local_irq_count[cpu])<br>
-<br>
-#define IO_APIC_IRQ(x)	(0)<br>
-<br>
-#endif<br>
-<br>
-#define __STR(x) #x<br>
-#define STR(x) __STR(x)<br>
-<br>
-#define SAVE_ALL \<br>
-	"cld\n\t" \<br>
-	"pushl %es\n\t" \<br>
-	"pushl %ds\n\t" \<br>
-	"pushl %eax\n\t" \<br>
-	"pushl %ebp\n\t" \<br>
-	"pushl %edi\n\t" \<br>
-	"pushl %esi\n\t" \<br>
-	"pushl %edx\n\t" \<br>
-	"pushl %ecx\n\t" \<br>
-	"pushl %ebx\n\t" \<br>
-	"movl $" STR(__KERNEL_DS) ",%edx\n\t" \<br>
-	"movl %dx,%ds\n\t" \<br>
-	"movl %dx,%es\n\t"<br>
-<br>
-#define IRQ_NAME2(nr) nr##_interrupt(void)<br>
-#define IRQ_NAME(nr) IRQ_NAME2(IRQ##nr)<br>
-<br>
-#define GET_CURRENT \<br>
-	"movl %esp, %ebx\n\t" \<br>
-	"andl $-8192, %ebx\n\t"<br>
-<br>
-#ifdef __SMP__<br>
-<br>
-/*<br>
- *	SMP has a few special interrupts for IPI messages<br>
- */<br>
-<br>
-#define BUILD_SMP_INTERRUPT(x) \<br>
-asmlinkage void x(void); \<br>
-__asm__( \<br>
-"\n"__ALIGN_STR"\n" \<br>
-SYMBOL_NAME_STR(x) ":\n\t" \<br>
-	"pushl $-1\n\t" \<br>
-	SAVE_ALL \<br>
-	"call "SYMBOL_NAME_STR(smp_##x)"\n\t" \<br>
-	"jmp ret_from_intr\n");<br>
-<br>
-#define BUILD_SMP_TIMER_INTERRUPT(x) \<br>
-asmlinkage void x(struct pt_regs * regs); \<br>
-__asm__( \<br>
-"\n"__ALIGN_STR"\n" \<br>
-SYMBOL_NAME_STR(x) ":\n\t" \<br>
-	"pushl $-1\n\t" \<br>
-	SAVE_ALL \<br>
-	"movl %esp,%eax\n\t" \<br>
-	"pushl %eax\n\t" \<br>
-	"call "SYMBOL_NAME_STR(smp_##x)"\n\t" \<br>
-	"addl $4,%esp\n\t" \<br>
-	"jmp ret_from_intr\n");<br>
-<br>
-#endif /* __SMP__ */<br>
-<br>
-#define BUILD_COMMON_IRQ() \<br>
-__asm__( \<br>
-	"\n" __ALIGN_STR"\n" \<br>
-	"common_interrupt:\n\t" \<br>
-	SAVE_ALL \<br>
-	"pushl $ret_from_intr\n\t" \<br>
-	"jmp "SYMBOL_NAME_STR(do_IRQ));<br>
-<br>
-/*<br>
- * subtle. orig_eax is used by the signal code to distinct between<br>
- * system calls and interrupted 'random user-space'. Thus we have<br>
- * to put a negative value into orig_eax here. (the problem is that<br>
- * both system calls and IRQs want to have small integer numbers in<br>
- * orig_eax, and the syscall code has won the optimization conflict ;)<br>
- */<br>
-#define BUILD_IRQ(nr) \<br>
-asmlinkage void IRQ_NAME(nr); \<br>
-__asm__( \<br>
-"\n"__ALIGN_STR"\n" \<br>
-SYMBOL_NAME_STR(IRQ) #nr "_interrupt:\n\t" \<br>
-	"pushl $"#nr"-256\n\t" \<br>
-	"jmp common_interrupt");<br>
-<br>
-/*<br>
- * x86 profiling function, SMP safe. We might want to do this in<br>
- * assembly totally?<br>
- */<br>
-static inline void x86_do_profile (unsigned long eip)<br>
-{<br>
-	if (prof_buffer) {<br>
-		eip -= (unsigned long) &amp;_stext;<br>
-		eip &gt;&gt;= prof_shift;<br>
-		/*<br>
-		 * Don't ignore out-of-bounds EIP values silently,<br>
-		 * put them into the last histogram slot, so if<br>
-		 * present, they will show up as a sharp peak.<br>
-		 */<br>
-		if (eip &gt; prof_len-1)<br>
-			eip = prof_len-1;<br>
-		atomic_inc((atomic_t *)&amp;prof_buffer[eip]);<br>
-	}<br>
-}<br>
-<br>
-#endif<br>
diff -u -r -N vanilla12/arch/i386/kernel/mtrr.c linux.new12/arch/i386/kernel/mtrr.c<br>
--- vanilla12/arch/i386/kernel/mtrr.c	Sun Jun 27 11:10:41 1999<br>
+++ linux.new12/arch/i386/kernel/mtrr.c	Wed Aug  4 16:20:49 1999<br>
@@ -235,7 +235,7 @@<br>
 #include &lt;asm/msr.h&gt;<br>
 <br>
 #include &lt;asm/hardirq.h&gt;<br>
-#include "irq.h"<br>
+#include &lt;linux/irq.h&gt;<br>
 <br>
 #define MTRR_VERSION            "1.35 (19990512)"<br>
 <br>
diff -u -r -N vanilla12/arch/i386/kernel/process.c linux.new12/arch/i386/kernel/process.c<br>
--- vanilla12/arch/i386/kernel/process.c	Mon Jul 26 00:15:13 1999<br>
+++ linux.new12/arch/i386/kernel/process.c	Wed Aug  4 16:20:49 1999<br>
@@ -45,7 +45,7 @@<br>
 #include &lt;asm/math_emu.h&gt;<br>
 #endif<br>
 <br>
-#include "irq.h"<br>
+#include &lt;linux/irq.h&gt;<br>
 <br>
 spinlock_t semaphore_wake_lock = SPIN_LOCK_UNLOCKED;<br>
 <br>
diff -u -r -N vanilla12/arch/i386/kernel/smp.c linux.new12/arch/i386/kernel/smp.c<br>
--- vanilla12/arch/i386/kernel/smp.c	Wed Jul 28 11:45:39 1999<br>
+++ linux.new12/arch/i386/kernel/smp.c	Wed Aug  4 16:20:49 1999<br>
@@ -42,7 +42,7 @@<br>
 #include &lt;asm/mtrr.h&gt;<br>
 #include &lt;asm/msr.h&gt;<br>
 <br>
-#include "irq.h"<br>
+#include &lt;linux/irq.h&gt;<br>
 <br>
 #define JIFFIE_TIMEOUT 100<br>
 <br>
diff -u -r -N vanilla12/arch/i386/kernel/time.c linux.new12/arch/i386/kernel/time.c<br>
--- vanilla12/arch/i386/kernel/time.c	Thu Apr 29 12:53:41 1999<br>
+++ linux.new12/arch/i386/kernel/time.c	Wed Aug  4 16:20:49 1999<br>
@@ -59,7 +59,7 @@<br>
 /*<br>
  * for x86_do_profile()<br>
  */<br>
-#include "irq.h"<br>
+#include &lt;linux/irq.h&gt;<br>
 <br>
 <br>
 unsigned long cpu_hz;	/* Detected as we calibrate the TSC */<br>
@@ -681,8 +681,8 @@<br>
 	co_cpu_write(CO_CPU_CTRL, co_cpu_read(CO_CPU_CTRL) &amp; ~CO_CTRL_TIMEMASK);<br>
 <br>
 	/* Wire cpu IDT entry to s/w handler (and Cobalt APIC to IDT) */<br>
-	setup_x86_irq(CO_IRQ_TIMER, &amp;irq0);<br>
+	setup_irq(CO_IRQ_TIMER, &amp;irq0);<br>
 #else<br>
-	setup_x86_irq(0, &amp;irq0);<br>
+	setup_irq(0, &amp;irq0);<br>
 #endif<br>
 }<br>
diff -u -r -N vanilla12/arch/i386/kernel/traps.c linux.new12/arch/i386/kernel/traps.c<br>
--- vanilla12/arch/i386/kernel/traps.c	Sun Jul 25 14:45:25 1999<br>
+++ linux.new12/arch/i386/kernel/traps.c	Wed Aug  4 16:20:49 1999<br>
@@ -42,7 +42,7 @@<br>
 #include &lt;asm/lithium.h&gt;<br>
 #endif<br>
 <br>
-#include "irq.h"<br>
+#include &lt;linux/irq.h&gt;<br>
 <br>
 asmlinkage int system_call(void);<br>
 asmlinkage void lcall7(void);<br>
diff -u -r -N vanilla12/i8259.c linux.new12/i8259.c<br>
--- vanilla12/i8259.c	Wed Dec 31 17:00:00 1969<br>
+++ linux.new12/i8259.c	Wed Aug  4 16:20:49 1999<br>
@@ -0,0 +1,406 @@<br>
+#include &lt;linux/config.h&gt;<br>
+#include &lt;linux/ptrace.h&gt;<br>
+#include &lt;linux/errno.h&gt;<br>
+#include &lt;linux/kernel_stat.h&gt;<br>
+#include &lt;linux/signal.h&gt;<br>
+#include &lt;linux/sched.h&gt;<br>
+#include &lt;linux/ioport.h&gt;<br>
+#include &lt;linux/interrupt.h&gt;<br>
+#include &lt;linux/timex.h&gt;<br>
+#include &lt;linux/malloc.h&gt;<br>
+#include &lt;linux/random.h&gt;<br>
+#include &lt;linux/smp.h&gt;<br>
+#include &lt;linux/tasks.h&gt;<br>
+#include &lt;linux/smp_lock.h&gt;<br>
+#include &lt;linux/init.h&gt;<br>
+<br>
+#include &lt;asm/system.h&gt;<br>
+#include &lt;asm/io.h&gt;<br>
+#include &lt;asm/irq.h&gt;<br>
+#include &lt;asm/bitops.h&gt;<br>
+#include &lt;asm/smp.h&gt;<br>
+#include &lt;asm/pgtable.h&gt;<br>
+#include &lt;asm/delay.h&gt;<br>
+#include &lt;asm/desc.h&gt;<br>
+<br>
+#include &lt;linux/irq.h&gt;<br>
+<br>
+<br>
+/* Intel specific no controller  code<br>
+   odd that no-controller should be architecture dependent<br>
+   but see the ifdef __SMP__ <br>
+ */<br>
+static void enable_none(unsigned int irq) { }<br>
+static unsigned int startup_none(unsigned int irq) {return 0; }<br>
+static void disable_none(unsigned int irq) { }<br>
+static void ack_none(unsigned int irq){<br>
+#ifdef __SMP__<br>
+	/*<br>
+	 * [currently unexpected vectors happen only on SMP and APIC.<br>
+	 *  if we want to have non-APIC and non-8259A controllers<br>
+	 *  in the future with unexpected vectors, this ack should<br>
+	 *  probably be made controller-specific.]<br>
+	 */<br>
+	ack_APIC_irq();<br>
+#endif<br>
+}<br>
+<br>
+/* startup is the same as "enable", shutdown is same as "disable" */<br>
+#define shutdown_none	disable_none<br>
+#define end_none	enable_none<br>
+<br>
+struct hw_interrupt_type no_irq_type = {<br>
+	"none",<br>
+	startup_none,<br>
+	shutdown_none,<br>
+	enable_none,<br>
+	disable_none,<br>
+        ack_none,<br>
+	end_none<br>
+};<br>
+<br>
+<br>
+/*<br>
+ * This is the 'legacy' 8259A Programmable Interrupt Controller,<br>
+ * present in the majority of PC/AT boxes.<br>
+ * plus some generic x86 specific things if generic specifics makes<br>
+ * any sense at all.<br>
+ * this file should become arch/i386/kernel/irq.c when the old irq.c<br>
+ * moves to arch independent land<br>
+ */<br>
+/*<br>
+ * This builds up the IRQ handler stubs using some ugly macros in irq.h<br>
+ *<br>
+ * These macros create the low-level assembly IRQ routines that save<br>
+ * register context and call do_IRQ(). do_IRQ() then does all the<br>
+ * operations that are needed to keep the AT (or SMP IOAPIC)<br>
+ * interrupt-controller happy.<br>
+ */<br>
+<br>
+<br>
+BUILD_COMMON_IRQ()<br>
+<br>
+#define BI(x,y) \<br>
+	BUILD_IRQ(##x##y)<br>
+<br>
+#define BUILD_16_IRQS(x) \<br>
+	BI(x,0) BI(x,1) BI(x,2) BI(x,3) \<br>
+	BI(x,4) BI(x,5) BI(x,6) BI(x,7) \<br>
+	BI(x,8) BI(x,9) BI(x,a) BI(x,b) \<br>
+	BI(x,c) BI(x,d) BI(x,e) BI(x,f)<br>
+<br>
+/*<br>
+ * ISA PIC or low IO-APIC triggered (INTA-cycle or APIC) interrupts:<br>
+ * (these are usually mapped to vectors 0x20-0x30)<br>
+ */<br>
+BUILD_16_IRQS(0x0)<br>
+<br>
+#ifdef CONFIG_X86_IO_APIC<br>
+/*<br>
+ * The IO-APIC gives us many more interrupt sources. Most of these <br>
+ * are unused but an SMP system is supposed to have enough memory ...<br>
+ * sometimes (mostly wrt. hw bugs) we get corrupted vectors all<br>
+ * across the spectrum, so we really want to be prepared to get all<br>
+ * of these. Plus, more powerful systems might have more than 64<br>
+ * IO-APIC registers.<br>
+ *<br>
+ * (these are usually mapped into the 0x30-0xff vector range)<br>
+ */<br>
+                   BUILD_16_IRQS(0x1) BUILD_16_IRQS(0x2) BUILD_16_IRQS(0x3)<br>
+BUILD_16_IRQS(0x4) BUILD_16_IRQS(0x5) BUILD_16_IRQS(0x6) BUILD_16_IRQS(0x7)<br>
+BUILD_16_IRQS(0x8) BUILD_16_IRQS(0x9) BUILD_16_IRQS(0xa) BUILD_16_IRQS(0xb)<br>
+BUILD_16_IRQS(0xc) BUILD_16_IRQS(0xd)<br>
+#endif<br>
+<br>
+#undef BUILD_16_IRQS<br>
+#undef BI<br>
+<br>
+<br>
+#ifdef __SMP__<br>
+/*<br>
+ * The following vectors are part of the Linux architecture, there<br>
+ * is no hardware IRQ pin equivalent for them, they are triggered<br>
+ * through the ICC by us (IPIs)<br>
+ */<br>
+BUILD_SMP_INTERRUPT(reschedule_interrupt)<br>
+BUILD_SMP_INTERRUPT(invalidate_interrupt)<br>
+BUILD_SMP_INTERRUPT(stop_cpu_interrupt)<br>
+BUILD_SMP_INTERRUPT(call_function_interrupt)<br>
+BUILD_SMP_INTERRUPT(spurious_interrupt)<br>
+<br>
+/*<br>
+ * every pentium local APIC has two 'local interrupts', with a<br>
+ * soft-definable vector attached to both interrupts, one of<br>
+ * which is a timer interrupt, the other one is error counter<br>
+ * overflow. Linux uses the local APIC timer interrupt to get<br>
+ * a much simpler SMP time architecture:<br>
+ */<br>
+BUILD_SMP_TIMER_INTERRUPT(apic_timer_interrupt)<br>
+<br>
+#endif<br>
+<br>
+#define IRQ(x,y) \<br>
+	IRQ##x##y##_interrupt<br>
+<br>
+#define IRQLIST_16(x) \<br>
+	IRQ(x,0), IRQ(x,1), IRQ(x,2), IRQ(x,3), \<br>
+	IRQ(x,4), IRQ(x,5), IRQ(x,6), IRQ(x,7), \<br>
+	IRQ(x,8), IRQ(x,9), IRQ(x,a), IRQ(x,b), \<br>
+	IRQ(x,c), IRQ(x,d), IRQ(x,e), IRQ(x,f)<br>
+<br>
+static void (*interrupt[NR_IRQS])(void) = {<br>
+	IRQLIST_16(0x0),<br>
+<br>
+#ifdef CONFIG_X86_IO_APIC<br>
+	                 IRQLIST_16(0x1), IRQLIST_16(0x2), IRQLIST_16(0x3),<br>
+	IRQLIST_16(0x4), IRQLIST_16(0x5), IRQLIST_16(0x6), IRQLIST_16(0x7),<br>
+	IRQLIST_16(0x8), IRQLIST_16(0x9), IRQLIST_16(0xa), IRQLIST_16(0xb),<br>
+	IRQLIST_16(0xc), IRQLIST_16(0xd)<br>
+#endif<br>
+};<br>
+<br>
+#undef IRQ<br>
+#undef IRQLIST_16<br>
+<br>
+<br>
+<br>
+<br>
+static void enable_8259A_irq(unsigned int irq);<br>
+void disable_8259A_irq(unsigned int irq);<br>
+<br>
+/* shutdown is same as "disable" */<br>
+#define end_8259A_irq		enable_8259A_irq<br>
+#define shutdown_8259A_irq	disable_8259A_irq<br>
+static void mask_and_ack_8259A(unsigned int);<br>
+static unsigned int startup_8259A_irq(unsigned int irq){ <br>
+	enable_8259A_irq(irq);<br>
+	return 0; /* never anything pending */<br>
+}<br>
+<br>
+static struct hw_interrupt_type i8259A_irq_type = {<br>
+	"XT-PIC",<br>
+	startup_8259A_irq,<br>
+	shutdown_8259A_irq,<br>
+	enable_8259A_irq,<br>
+	disable_8259A_irq,<br>
+	mask_and_ack_8259A,<br>
+	end_8259A_irq<br>
+};<br>
+<br>
+/*<br>
+ * 8259A PIC functions to handle ISA devices:<br>
+ */<br>
+<br>
+/*<br>
+ * This contains the irq mask for both 8259A irq controllers,<br>
+ */<br>
+static unsigned int cached_irq_mask = 0xffff;<br>
+<br>
+#define __byte(x,y) 	(((unsigned char *)&amp;(y))[x])<br>
+#define cached_21	(__byte(0,cached_irq_mask))<br>
+#define cached_A1	(__byte(1,cached_irq_mask))<br>
+<br>
+/*<br>
+ * Not all IRQs can be routed through the IO-APIC, eg. on certain (older)<br>
+ * boards the timer interrupt is not connected to any IO-APIC pin, it's<br>
+ * fed to the CPU IRQ line directly.<br>
+ *<br>
+ * Any '1' bit in this mask means the IRQ is routed through the IO-APIC.<br>
+ * this 'mixed mode' IRQ handling costs nothing because it's only used<br>
+ * at IRQ setup time.<br>
+ */<br>
+unsigned long io_apic_irqs = 0;<br>
+<br>
+/*<br>
+ * These have to be protected by the irq controller spinlock<br>
+ * before being called.<br>
+ */<br>
+void disable_8259A_irq(unsigned int irq)<br>
+{<br>
+	unsigned int mask = 1 &lt;&lt; irq;<br>
+	cached_irq_mask |= mask;<br>
+	if (irq &amp; 8) {<br>
+		outb(cached_A1,0xA1);<br>
+	} else {<br>
+		outb(cached_21,0x21);<br>
+	}<br>
+}<br>
+<br>
+static void enable_8259A_irq(unsigned int irq)<br>
+{<br>
+	unsigned int mask = ~(1 &lt;&lt; irq);<br>
+	cached_irq_mask &amp;= mask;<br>
+	if (irq &amp; 8) {<br>
+		outb(cached_A1,0xA1);<br>
+	} else {<br>
+		outb(cached_21,0x21);<br>
+	}<br>
+}<br>
+<br>
+int i8259A_irq_pending(unsigned int irq)<br>
+{<br>
+	unsigned int mask = 1&lt;&lt;irq;<br>
+<br>
+	if (irq &lt; 8)<br>
+                return (inb(0x20) &amp; mask);<br>
+        return (inb(0xA0) &amp; (mask &gt;&gt; 8));<br>
+}<br>
+<br>
+void make_8259A_irq(unsigned int irq)<br>
+{<br>
+	disable_irq_nosync(irq);<br>
+	io_apic_irqs &amp;= ~(1&lt;&lt;irq);<br>
+	irq_desc[irq].handler = &amp;i8259A_irq_type;<br>
+	enable_irq(irq);<br>
+}<br>
+<br>
+/*<br>
+ * Careful! The 8259A is a fragile beast, it pretty<br>
+ * much _has_ to be done exactly like this (mask it<br>
+ * first, _then_ send the EOI, and the order of EOI<br>
+ * to the two 8259s is important!<br>
+ */<br>
+static void mask_and_ack_8259A(unsigned int irq)<br>
+{<br>
+	cached_irq_mask |= 1 &lt;&lt; irq;<br>
+	if (irq &amp; 8) {<br>
+		inb(0xA1);	/* DUMMY */<br>
+		outb(cached_A1,0xA1);<br>
+		outb(0x62,0x20);	/* Specific EOI to cascade */<br>
+		outb(0x20,0xA0);<br>
+	} else {<br>
+		inb(0x21);	/* DUMMY */<br>
+		outb(cached_21,0x21);<br>
+		outb(0x20,0x20);<br>
+	}<br>
+}<br>
+#ifndef CONFIG_VISWS<br>
+/*<br>
+ * Note that on a 486, we don't want to do a SIGFPE on an irq13<br>
+ * as the irq is unreliable, and exception 16 works correctly<br>
+ * (ie as explained in the intel literature). On a 386, you<br>
+ * can't use exception 16 due to bad IBM design, so we have to<br>
+ * rely on the less exact irq13.<br>
+ *<br>
+ * Careful.. Not only is IRQ13 unreliable, but it is also<br>
+ * leads to races. IBM designers who came up with it should<br>
+ * be shot.<br>
+ */<br>
+ <br>
+static void math_error_irq(int cpl, void *dev_id, struct pt_regs *regs)<br>
+{<br>
+	outb(0,0xF0);<br>
+	if (ignore_irq13 || !boot_cpu_data.hard_math)<br>
+		return;<br>
+	math_error();<br>
+}<br>
+<br>
+static struct irqaction irq13 = { math_error_irq, 0, 0, "fpu", NULL, NULL };<br>
+<br>
+/*<br>
+ * IRQ2 is cascade interrupt to second interrupt controller<br>
+ */<br>
+<br>
+static struct irqaction irq2  = { no_action, 0, 0, "cascade", NULL, NULL};<br>
+#endif<br>
+<br>
+<br>
+void init_ISA_irqs (void)<br>
+{<br>
+	int i;<br>
+<br>
+	for (i = 0; i &lt; NR_IRQS; i++) {<br>
+		irq_desc[i].status = IRQ_DISABLED;<br>
+		irq_desc[i].action = 0;<br>
+		irq_desc[i].depth = 0;<br>
+<br>
+		if (i &lt; 16) {<br>
+			/*<br>
+			 * 16 old-style INTA-cycle interrupts:<br>
+			 */<br>
+			irq_desc[i].handler = &amp;i8259A_irq_type;<br>
+		} else {<br>
+			/*<br>
+			 * 'high' PCI IRQs filled in on demand<br>
+			 */<br>
+			irq_desc[i].handler = &amp;no_irq_type;<br>
+		}<br>
+	}<br>
+}<br>
+<br>
+__initfunc(void init_IRQ(void))<br>
+{<br>
+	int i;<br>
+<br>
+#ifndef CONFIG_X86_VISWS_APIC<br>
+	init_ISA_irqs();<br>
+#else<br>
+	init_VISWS_APIC_irqs();<br>
+#endif<br>
+	/*<br>
+	 * Cover the whole vector space, no vector can escape<br>
+	 * us. (some of these will be overridden and become<br>
+	 * 'special' SMP interrupts)<br>
+	 */<br>
+	for (i = 0; i &lt; NR_IRQS; i++) {<br>
+		int vector = FIRST_EXTERNAL_VECTOR + i;<br>
+		if (vector != SYSCALL_VECTOR) <br>
+			set_intr_gate(vector, interrupt[i]);<br>
+	}<br>
+<br>
+#ifdef __SMP__	<br>
+<br>
+	/*<br>
+	  IRQ0 must be given a fixed assignment and initialized<br>
+	  before init_IRQ_SMP.<br>
+	*/<br>
+	set_intr_gate(IRQ0_TRAP_VECTOR, interrupt[0]);<br>
+<br>
+	/*<br>
+	 * The reschedule interrupt is a CPU-to-CPU reschedule-helper<br>
+	 * IPI, driven by wakeup.<br>
+	 */<br>
+	set_intr_gate(RESCHEDULE_VECTOR, reschedule_interrupt);<br>
+<br>
+	/* IPI for invalidation */<br>
+	set_intr_gate(INVALIDATE_TLB_VECTOR, invalidate_interrupt);<br>
+<br>
+	/* IPI for CPU halt */<br>
+	set_intr_gate(STOP_CPU_VECTOR, stop_cpu_interrupt);<br>
+<br>
+	/* self generated IPI for local APIC timer */<br>
+	set_intr_gate(LOCAL_TIMER_VECTOR, apic_timer_interrupt);<br>
+<br>
+	/* IPI for generic function call */<br>
+	set_intr_gate(CALL_FUNCTION_VECTOR, call_function_interrupt);<br>
+<br>
+	/* IPI vector for APIC spurious interrupts */<br>
+	set_intr_gate(SPURIOUS_APIC_VECTOR, spurious_interrupt);<br>
+#endif	<br>
+	request_region(0x20,0x20,"pic1");<br>
+	request_region(0xa0,0x20,"pic2");<br>
+<br>
+	/*<br>
+	 * Set the clock to 100 Hz, we already have a valid<br>
+	 * vector now:<br>
+	 */<br>
+	outb_p(0x34,0x43);		/* binary, mode 2, LSB/MSB, ch 0 */<br>
+	outb_p(LATCH &amp; 0xff , 0x40);	/* LSB */<br>
+	outb(LATCH &gt;&gt; 8 , 0x40);	/* MSB */<br>
+<br>
+#ifndef CONFIG_VISWS<br>
+	setup_irq(2, &amp;irq2);<br>
+	setup_irq(13, &amp;irq13);<br>
+#endif<br>
+}<br>
+<br>
+#ifdef CONFIG_X86_IO_APIC<br>
+__initfunc(void init_IRQ_SMP(void))<br>
+{<br>
+	int i;<br>
+	for (i = 0; i &lt; NR_IRQS ; i++)<br>
+		if (IO_APIC_VECTOR(i) &gt; 0)<br>
+			set_intr_gate(IO_APIC_VECTOR(i), interrupt[i]);<br>
+}<br>
+#endif<br>
+<br>
diff -u -r -N vanilla12/include/asm-i386/hw_irq.h linux.new12/include/asm-i386/hw_irq.h<br>
--- vanilla12/include/asm-i386/hw_irq.h	Wed Dec 31 17:00:00 1969<br>
+++ linux.new12/include/asm-i386/hw_irq.h	Wed Aug  4 16:36:14 1999<br>
@@ -0,0 +1,213 @@<br>
+#ifndef _ASM_HW_IRQ_H<br>
+#define _ASM_HW_IRQ_H<br>
+<br>
+/*<br>
+ *	linux/include/asm/hw_irq.h<br>
+ *<br>
+ *	(C) 1992, 1993 Linus Torvalds, (C) 1997 Ingo Molnar<br>
+ *<br>
+ *	moved some of the old arch/i386/kernel/irq.h to here. VY<br>
+ *<br>
+ *	IRQ/IPI changes taken from work by Thomas Radke<br>
+ *	&lt;<a href="mailto:tomsoft@informatik.tu-chemnitz.de">tomsoft@informatik.tu-chemnitz.de</a>&gt;<br>
+ */<br>
+<br>
+#include &lt;asm/irq.h&gt;<br>
+<br>
+/*<br>
+ * IDT vectors usable for external interrupt sources start<br>
+ * at 0x20:<br>
+ */<br>
+#define FIRST_EXTERNAL_VECTOR	0x20<br>
+<br>
+#define SYSCALL_VECTOR		0x80<br>
+<br>
+/*<br>
+ * Vectors 0x20-0x2f are used for ISA interrupts.<br>
+ */<br>
+<br>
+/*<br>
+ * Special IRQ vectors used by the SMP architecture:<br>
+ *<br>
+ * (some of the following vectors are 'rare', they are merged<br>
+ *  into a single vector (FUNCTION_VECTOR) to save vector space.<br>
+ *  TLB, reschedule and local APIC vectors are performance-critical.)<br>
+ */<br>
+#define RESCHEDULE_VECTOR	0x30<br>
+#define INVALIDATE_TLB_VECTOR	0x31<br>
+#define STOP_CPU_VECTOR		0x40<br>
+#define LOCAL_TIMER_VECTOR	0x41<br>
+#define CALL_FUNCTION_VECTOR	0x50<br>
+<br>
+/*<br>
+ * First APIC vector available to drivers: (vectors 0x51-0xfe)<br>
+ */<br>
+#define IRQ0_TRAP_VECTOR	0x51<br>
+<br>
+/*<br>
+ * This IRQ should never happen, but we print a message nevertheless.<br>
+ */<br>
+#define SPURIOUS_APIC_VECTOR	0xff<br>
+<br>
+extern int irq_vector[NR_IRQS];<br>
+#define IO_APIC_VECTOR(irq)	irq_vector[irq]<br>
+<br>
+extern void init_IRQ_SMP(void);<br>
+<br>
+/*<br>
+ * Various low-level irq details needed by irq.c, process.c,<br>
+ * time.c, io_apic.c and smp.c<br>
+ *<br>
+ * Interrupt entry/exit code at both C and assembly level<br>
+ */<br>
+<br>
+extern void no_action(int cpl, void *dev_id, struct pt_regs *regs);<br>
+extern void mask_irq(unsigned int irq);<br>
+extern void unmask_irq(unsigned int irq);<br>
+extern void disable_8259A_irq(unsigned int irq);<br>
+extern int i8259A_irq_pending(unsigned int irq);<br>
+extern void ack_APIC_irq(void);<br>
+extern void FASTCALL(send_IPI_self(int vector));<br>
+extern void init_VISWS_APIC_irqs(void);<br>
+extern void setup_IO_APIC(void);<br>
+extern int IO_APIC_get_PCI_irq_vector(int bus, int slot, int fn);<br>
+extern void make_8259A_irq(unsigned int irq);<br>
+extern void send_IPI(int dest, int vector);<br>
+extern void init_pic_mode(void);<br>
+extern void print_IO_APIC(void);<br>
+<br>
+extern unsigned long io_apic_irqs;<br>
+<br>
+extern char _stext, _etext;<br>
+<br>
+#define MAX_IRQ_SOURCES 128<br>
+#define MAX_MP_BUSSES 32<br>
+enum mp_bustype {<br>
+	MP_BUS_ISA,<br>
+	MP_BUS_EISA,<br>
+	MP_BUS_PCI<br>
+};<br>
+extern int mp_bus_id_to_type [MAX_MP_BUSSES];<br>
+extern int mp_bus_id_to_pci_bus [MAX_MP_BUSSES];<br>
+<br>
+<br>
+#ifdef __SMP__<br>
+#define IO_APIC_IRQ(x) (((x) &gt;= 16) || ((1&lt;&lt;(x)) &amp; io_apic_irqs))<br>
+<br>
+#else<br>
+<br>
+#define IO_APIC_IRQ(x)	(0)<br>
+<br>
+#endif<br>
+<br>
+#define __STR(x) #x<br>
+#define STR(x) __STR(x)<br>
+<br>
+#define SAVE_ALL \<br>
+	"cld\n\t" \<br>
+	"pushl %es\n\t" \<br>
+	"pushl %ds\n\t" \<br>
+	"pushl %eax\n\t" \<br>
+	"pushl %ebp\n\t" \<br>
+	"pushl %edi\n\t" \<br>
+	"pushl %esi\n\t" \<br>
+	"pushl %edx\n\t" \<br>
+	"pushl %ecx\n\t" \<br>
+	"pushl %ebx\n\t" \<br>
+	"movl $" STR(__KERNEL_DS) ",%edx\n\t" \<br>
+	"movl %dx,%ds\n\t" \<br>
+	"movl %dx,%es\n\t"<br>
+<br>
+#define IRQ_NAME2(nr) nr##_interrupt(void)<br>
+#define IRQ_NAME(nr) IRQ_NAME2(IRQ##nr)<br>
+<br>
+#define GET_CURRENT \<br>
+	"movl %esp, %ebx\n\t" \<br>
+	"andl $-8192, %ebx\n\t"<br>
+<br>
+#ifdef __SMP__<br>
+<br>
+/*<br>
+ *	SMP has a few special interrupts for IPI messages<br>
+ */<br>
+<br>
+#define BUILD_SMP_INTERRUPT(x) \<br>
+asmlinkage void x(void); \<br>
+__asm__( \<br>
+"\n"__ALIGN_STR"\n" \<br>
+SYMBOL_NAME_STR(x) ":\n\t" \<br>
+	"pushl $-1\n\t" \<br>
+	SAVE_ALL \<br>
+	"call "SYMBOL_NAME_STR(smp_##x)"\n\t" \<br>
+	"jmp ret_from_intr\n");<br>
+<br>
+#define BUILD_SMP_TIMER_INTERRUPT(x) \<br>
+asmlinkage void x(struct pt_regs * regs); \<br>
+__asm__( \<br>
+"\n"__ALIGN_STR"\n" \<br>
+SYMBOL_NAME_STR(x) ":\n\t" \<br>
+	"pushl $-1\n\t" \<br>
+	SAVE_ALL \<br>
+	"movl %esp,%eax\n\t" \<br>
+	"pushl %eax\n\t" \<br>
+	"call "SYMBOL_NAME_STR(smp_##x)"\n\t" \<br>
+	"addl $4,%esp\n\t" \<br>
+	"jmp ret_from_intr\n");<br>
+<br>
+#endif /* __SMP__ */<br>
+<br>
+#define BUILD_COMMON_IRQ() \<br>
+__asm__( \<br>
+	"\n" __ALIGN_STR"\n" \<br>
+	"common_interrupt:\n\t" \<br>
+	SAVE_ALL \<br>
+	"pushl $ret_from_intr\n\t" \<br>
+	"jmp "SYMBOL_NAME_STR(do_IRQ));<br>
+<br>
+/* <br>
+ * subtle. orig_eax is used by the signal code to distinct between<br>
+ * system calls and interrupted 'random user-space'. Thus we have<br>
+ * to put a negative value into orig_eax here. (the problem is that<br>
+ * both system calls and IRQs want to have small integer numbers in<br>
+ * orig_eax, and the syscall code has won the optimization conflict ;)<br>
+ *<br>
+ * Subtle as a pigs ear.  VY<br>
+ */<br>
+<br>
+#define BUILD_IRQ(nr) \<br>
+asmlinkage void IRQ_NAME(nr); \<br>
+__asm__( \<br>
+"\n"__ALIGN_STR"\n" \<br>
+SYMBOL_NAME_STR(IRQ) #nr "_interrupt:\n\t" \<br>
+	"pushl $"#nr"-256\n\t" \<br>
+	"jmp common_interrupt");<br>
+<br>
+/*<br>
+ * x86 profiling function, SMP safe. We might want to do this in<br>
+ * assembly totally?<br>
+ */<br>
+static inline void x86_do_profile (unsigned long eip)<br>
+{<br>
+	if (prof_buffer &amp;&amp; current-&gt;pid) {<br>
+		eip -= (unsigned long) &amp;_stext;<br>
+		eip &gt;&gt;= prof_shift;<br>
+		/*<br>
+		 * Don't ignore out-of-bounds EIP values silently,<br>
+		 * put them into the last histogram slot, so if<br>
+		 * present, they will show up as a sharp peak.<br>
+		 */<br>
+		if (eip &gt; prof_len-1)<br>
+			eip = prof_len-1;<br>
+		atomic_inc((atomic_t *)&amp;prof_buffer[eip]);<br>
+	}<br>
+}<br>
+<br>
+#ifdef __SMP__ /*more of this file should probably be ifdefed SMP */<br>
+static inline void hw_resend_irq(struct hw_interrupt_type *h, unsigned int i) {<br>
+		send_IPI_self(IO_APIC_VECTOR(i));<br>
+}<br>
+#else<br>
+static inline void hw_resend_irq(struct hw_interrupt_type *h, unsigned int i) {}<br>
+#endif<br>
+<br>
+#endif /* _ASM_HW_IRQ_H */<br>
diff -u -r -N vanilla12/include/linux/irq.h linux.new12/include/linux/irq.h<br>
--- vanilla12/include/linux/irq.h	Wed Dec 31 17:00:00 1969<br>
+++ linux.new12/include/linux/irq.h	Wed Aug  4 16:36:15 1999<br>
@@ -0,0 +1,79 @@<br>
+#ifndef __irq_h<br>
+#define __irq_h<br>
+<br>
+#include &lt;asm/irq.h&gt;<br>
+/*<br>
+ * IRQ line status.<br>
+ */<br>
+#define IRQ_INPROGRESS	1	/* IRQ handler active - do not enter! */<br>
+#define IRQ_DISABLED	2	/* IRQ disabled - do not enter! */<br>
+#define IRQ_PENDING	4	/* IRQ pending - replay on enable */<br>
+#define IRQ_REPLAY	8	/* IRQ has been replayed but not acked yet */<br>
+#define IRQ_AUTODETECT	16	/* IRQ is being autodetected */<br>
+#define IRQ_WAITING	32	/* IRQ not yet seen - for autodetection */<br>
+<br>
+/*<br>
+ * Interrupt controller descriptor. This is all we need<br>
+ * to describe about the low-level hardware. <br>
+ */<br>
+struct hw_interrupt_type {<br>
+	const char * typename;<br>
+	unsigned int (*startup)(unsigned int irq);<br>
+	void (*shutdown)(unsigned int irq);<br>
+	void (*enable)(unsigned int irq);<br>
+	void (*disable)(unsigned int irq);<br>
+	void (*ack)(unsigned int irq);<br>
+	void (*end)(unsigned int irq);<br>
+};<br>
+<br>
+typedef struct hw_interrupt_type  hw_irq_controller;<br>
+<br>
+/*<br>
+ * This is the "IRQ descriptor", which contains various information<br>
+ * about the irq, including what kind of hardware handling it has,<br>
+ * whether it is disabled etc etc.<br>
+ *<br>
+ * Pad this out to 32 bytes for cache and indexing reasons.<br>
+ */<br>
+typedef struct {<br>
+	unsigned int status;	/* IRQ status<br>
+				  - IRQ_INPROGRESS, IRQ_DISABLED */<br>
+	hw_irq_controller *handler;	/* never derefed in arch<br>
+					   independent code */<br>
+	struct irqaction *action;		/* IRQ action list */<br>
+	unsigned int depth;			/* Disable depth for nested irq disables */<br>
+} irq_desc_t;<br>
+<br>
+#include &lt;asm/hw_irq.h&gt; /* the arch dependent stuff */<br>
+<br>
+extern irq_desc_t irq_desc[NR_IRQS];<br>
+<br>
+extern int handle_IRQ_event(unsigned int, struct pt_regs *, struct irqaction *);<br>
+extern spinlock_t irq_controller_lock;<br>
+extern int setup_irq(unsigned int , struct irqaction * );<br>
+<br>
+#ifdef __SMP__<br>
+<br>
+#include &lt;asm/atomic.h&gt;<br>
+<br>
+static inline void irq_enter(int cpu, unsigned int irq)<br>
+{<br>
+	hardirq_enter(cpu);<br>
+	while (test_bit(0,&amp;global_irq_lock)) {<br>
+		/* nothing */;<br>
+	}<br>
+}<br>
+<br>
+static inline void irq_exit(int cpu, unsigned int irq)<br>
+{<br>
+	hardirq_exit(cpu);<br>
+}<br>
+#else<br>
+#define irq_enter(cpu, irq)	(++local_irq_count[cpu])<br>
+#define irq_exit(cpu, irq)	(--local_irq_count[cpu])<br>
+#endif<br>
+<br>
+extern hw_irq_controller no_irq_type;  /* needed in every arch ? */<br>
+<br>
+#endif /* __asm_h */<br>
+<br>
   <br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0012.html">Jonathan Masters: "Re: hdd &amp; sound"</a>
<li> <b>Previous message:</b> <a href="0010.html">Andrea Arcangeli: "Re: No kmem_cache_destroy?"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
