<!-- received="Sun Aug  8 03:18:55 1999 EET DST" -->
<!-- sent="Sun, 8 Aug 1999 02:15:13 +0200 (CEST)" -->
<!-- name="don@sabotage.org" -->
<!-- email="don@sabotage.org" -->
<!-- subject="PATCH: prevent FIN/XMAS/NULL stealth portscans" -->
<!-- id="199908080015.CAA14043@mail.replay.com" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-32,: PATCH: prevent FIN/XMAS/NULL stealth portscans</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>PATCH: prevent FIN/XMAS/NULL stealth portscans</h1>
<a href="mailto:don@sabotage.org"><i>don@sabotage.org</i></a><br>
<i>Sun, 8 Aug 1999 02:15:13 +0200 (CEST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#22">[ date ]</a><a href="index.html#22">[ thread ]</a><a href="subject.html#22">[ subject ]</a><a href="author.html#22">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0023.html">Mike A. Harris: "Re: &gt; 1 meg bzImage"</a>
<li> <b>Previous message:</b> <a href="0021.html">Alexandr D. Kanevskiy: "Netfilter and the feature freeze"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
This is a diff to produce a patch sent to bugtraq a while ago. Not sure if<br>
it's functionally equivalent to Joachim Baran's patch sent to linux-kernel.<br>
It prevents several types of stealth portscans - FIN,XMAS and NULL. I've run<br>
it for months in my 2.2.10 kernel without any trouble. YMMV. This diff is<br>
against 2.2.11pre1.<br>
PS sorry I don't have the original post, but anyone who mime attaches a<br>
one line patch (and then sends the wrong one) probably would prefer anonymity.<br>
<p>
diff -u -r linux/Documentation/Configure.help linux-2.2.11pre1mod/Documentation/Configure.help<br>
--- linux/Documentation/Configure.help	Sun Jun 13 19:54:06 1999<br>
+++ linux-2.2.11pre1mod/Documentation/Configure.help	Thu Aug  5 18:54:04 1999<br>
@@ -5252,6 +5252,15 @@<br>
   full bandwidth of your network connection, try saying Y here. If<br>
   unsure, say N.<br>
 <br>
+Prevent response to stealth portscans (EXPERIMENTAL)<br>
+CONFIG_NOSTEALTHSCANS<br>
+  This is the anti-stealth-scan fix as posted to bugtraq. Stealth scans<br>
+  are a method of network-based attackers probing what services are<br>
+  available without going through a full three-way connect protocol, to<br>
+  avoid detection. This option prevents most of that. Although tested<br>
+  only under certain configurations, it should have no effect on normal<br>
+  networking. If problems arise, disable this option.  If unsure, say N.<br>
+<br>
 QoS and/or fair queueing<br>
 CONFIG_NET_SCHED<br>
   When the kernel has several packets to send out over the network<br>
diff -u -r linux/net/Config.in linux-2.2.11pre1mod/net/Config.in<br>
--- linux/net/Config.in	Thu Feb 25 10:46:47 1999<br>
+++ linux-2.2.11pre1mod/net/Config.in	Thu Aug  5 18:17:35 1999<br>
@@ -52,6 +52,7 @@<br>
   bool 'Fast switching (read help!)' CONFIG_NET_FASTROUTE<br>
   bool 'Forwarding between high speed interfaces' CONFIG_NET_HW_FLOWCONTROL<br>
   bool 'CPU is too slow to handle full bandwidth' CONFIG_CPU_IS_SLOW<br>
+  bool 'Prevent response to stealth portscans (EXPERIMENTAL)' CONFIG_NOSTEALTHSCANS<br>
   if [ "$CONFIG_EXPERIMENTAL" = "y" ]; then<br>
   mainmenu_option next_comment<br>
   comment 'QoS and/or fair queueing'<br>
diff -u -r linux/net/ipv4/tcp_input.c linux-2.2.11pre1mod/net/ipv4/tcp_input.c<br>
--- linux/net/ipv4/tcp_input.c	Wed Jun  2 09:55:22 1999<br>
+++ linux-2.2.11pre1mod/net/ipv4/tcp_input.c	Thu Aug  5 18:20:17 1999<br>
@@ -2074,7 +2074,12 @@<br>
 			 */<br>
 			goto discard;<br>
 		}<br>
-		<br>
+	<br>
+/* don't answer stealth scans */<br>
+#ifdef CONFIG_NOSTEALTHSCANS<br>
+		if (!th-&gt;rst) return 1;<br>
+#endif<br>
+	<br>
 		goto discard;<br>
 		break;<br>
 <br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0023.html">Mike A. Harris: "Re: &gt; 1 meg bzImage"</a>
<li> <b>Previous message:</b> <a href="0021.html">Alexandr D. Kanevskiy: "Netfilter and the feature freeze"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
