<!-- received="Sun Aug  8 10:09:33 1999 EET DST" -->
<!-- sent="Sat, 7 Aug 1999 22:38:42 +0200" -->
<!-- name="Pavel Machek" -->
<!-- email="pavel@bug.ucw.cz" -->
<!-- subject="Tiny cleanup for vesafb" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-32,: Tiny cleanup for vesafb</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Tiny cleanup for vesafb</h1>
<b>Pavel Machek</b> (<a href="mailto:pavel@bug.ucw.cz"><i>pavel@bug.ucw.cz</i></a>)<br>
<i>Sat, 7 Aug 1999 22:38:42 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#43">[ date ]</a><a href="index.html#43">[ thread ]</a><a href="subject.html#43">[ subject ]</a><a href="author.html#43">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0044.html">Pavel Machek: "Any known data corruption in 2.3.12"</a>
<li> <b>Previous message:</b> <a href="0042.html">doctor@fruitbat.org: "Re: Where to put new keyboard driver"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hi!<br>
<p>
This patch makes vesafb a tiny bit nicer [having two variables for one<br>
thing is bad idea.]. Please apply.<br>
								Pavel<br>
<p>
<p>
--- clean//drivers/video/vesafb.c	Thu May 13 22:41:35 1999<br>
+++ linux/drivers/video/vesafb.c	Fri Jul  9 12:52:16 1999<br>
@@ -96,8 +96,7 @@<br>
 static int             currcon   = 0;<br>
 <br>
 static int             pmi_setpal = 0;	/* pmi for palette changes ??? */<br>
-static int             ypan       = 0;<br>
-static int             ywrap      = 0;<br>
+static int             ypan       = 0;  /* 0..nothing, 1..ypan, 2..ywrap */<br>
 static unsigned short  *pmi_base  = 0;<br>
 static void            (*pmi_start)(void);<br>
 static void            (*pmi_pal)(void);<br>
@@ -130,13 +129,13 @@<br>
 {<br>
 	int offset;<br>
 <br>
-	if (!ypan &amp;&amp; !ywrap)<br>
+	if (!ypan)<br>
 		return -EINVAL;<br>
 	if (var-&gt;xoffset)<br>
 		return -EINVAL;<br>
-	if (ypan &amp;&amp; var-&gt;yoffset+var-&gt;yres &gt; var-&gt;yres_virtual)<br>
+	if (var-&gt;yoffset &gt; var-&gt;yres_virtual)<br>
 		return -EINVAL;<br>
-	if (ywrap &amp;&amp; var-&gt;yoffset &gt; var-&gt;yres_virtual)<br>
+	if ((ypan==1) &amp;&amp; var-&gt;yoffset+var-&gt;yres &gt; var-&gt;yres_virtual)<br>
 		return -EINVAL;<br>
 <br>
 	offset = (var-&gt;yoffset * video_linelength + var-&gt;xoffset) / 4;<br>
@@ -154,7 +153,7 @@<br>
 <br>
 static int vesafb_update_var(int con, struct fb_info *info)<br>
 {<br>
-	if (con == currcon &amp;&amp; (ywrap || ypan)) {<br>
+	if (con == currcon &amp;&amp; ypan) {<br>
 		struct fb_var_screeninfo *var = &amp;fb_display[currcon].var;<br>
 		return vesafb_pan_display(var,con,info);<br>
 	}<br>
@@ -172,8 +171,8 @@<br>
 	fix-&gt;type = video_type;<br>
 	fix-&gt;visual = video_visual;<br>
 	fix-&gt;xpanstep  = 0;<br>
-	fix-&gt;ypanstep  = (ywrap || ypan)  ? 1 : 0;<br>
-	fix-&gt;ywrapstep =  ywrap           ? 1 : 0;<br>
+	fix-&gt;ypanstep  = ypan     ? 1 : 0;<br>
+	fix-&gt;ywrapstep = (ypan&gt;1) ? 1 : 0;<br>
 	fix-&gt;line_length=video_linelength;<br>
 	return 0;<br>
 }<br>
@@ -245,7 +244,7 @@<br>
 	}<br>
 	memcpy(&amp;vesafb_sw, sw, sizeof(*sw));<br>
 	display-&gt;dispsw = &amp;vesafb_sw;<br>
-	if (!ypan &amp;&amp; !ywrap) {<br>
+	if (!ypan) {<br>
 		display-&gt;scrollmode = SCROLL_YREDRAW;<br>
 		vesafb_sw.bmove = fbcon_redraw_bmove;<br>
 	}<br>
@@ -274,7 +273,7 @@<br>
 	if ((var-&gt;activate &amp; FB_ACTIVATE_MASK) == FB_ACTIVATE_TEST)<br>
 		return 0;<br>
 <br>
-	if (ypan || ywrap) {<br>
+	if (ypan) {<br>
 		if (vesafb_defined.yres_virtual != var-&gt;yres_virtual) {<br>
 			vesafb_defined.yres_virtual = var-&gt;yres_virtual;<br>
 			if (con != -1) {<br>
@@ -486,11 +485,11 @@<br>
 		if (! strcmp(this_opt, "inverse"))<br>
 			inverse=1;<br>
 		else if (! strcmp(this_opt, "redraw"))<br>
-			ywrap=0,ypan=0;<br>
+			ypan=0;<br>
 		else if (! strcmp(this_opt, "ypan"))<br>
-			ywrap=0,ypan=1;<br>
+			ypan=1;<br>
 		else if (! strcmp(this_opt, "ywrap"))<br>
-			ywrap=1,ypan=0;<br>
+			ypan=2;<br>
 		else if (! strcmp(this_opt, "vgapal"))<br>
 			pmi_setpal=0;<br>
 		else if (! strcmp(this_opt, "pmipal"))<br>
@@ -551,9 +550,9 @@<br>
 	}<br>
 <br>
 	if (screen_info.vesapm_seg &lt; 0xc000)<br>
-		ywrap = ypan = pmi_setpal = 0; /* not available or some DOS TSR ... */<br>
+		ypan = pmi_setpal = 0; /* not available or some DOS TSR ... */<br>
 <br>
-	if (ypan || ywrap || pmi_setpal) {<br>
+	if (ypan || pmi_setpal) {<br>
 		pmi_base  = (unsigned short*)(__PAGE_OFFSET+((unsigned long)screen_info.vesapm_seg &lt;&lt; 4) + screen_info.vesapm_off);<br>
 		pmi_start = (void*)((char*)pmi_base + pmi_base[1]);<br>
 		pmi_pal   = (void*)((char*)pmi_base + pmi_base[2]);<br>
@@ -571,7 +570,7 @@<br>
 				 * memory area and pass it in the ES register to the BIOS function.<br>
 				 */<br>
 				printk("vesafb: can't handle memory requests, pmi disabled\n");<br>
-				ywrap = ypan = pmi_setpal = 0;<br>
+				ypan = pmi_setpal = 0;<br>
 			}<br>
 		}<br>
 	}<br>
@@ -582,13 +581,13 @@<br>
 	vesafb_defined.yres_virtual=video_size / video_linelength;<br>
 	vesafb_defined.bits_per_pixel=video_bpp;<br>
 <br>
-	if ((ypan || ywrap) &amp;&amp; vesafb_defined.yres_virtual &gt; video_height) {<br>
+	if (ypan &amp;&amp; vesafb_defined.yres_virtual &gt; video_height) {<br>
 		printk("vesafb: scrolling: %s using protected mode interface, yres_virtual=%d\n",<br>
-		       ywrap ? "ywrap" : "ypan",vesafb_defined.yres_virtual);<br>
+		       (ypan &gt; 1) ? "ywrap" : "ypan",vesafb_defined.yres_virtual);<br>
 	} else {<br>
 		printk("vesafb: scrolling: redraw\n");<br>
 		vesafb_defined.yres_virtual = video_height;<br>
-		ypan = ywrap = 0;<br>
+		ypan = 0;<br>
 	}<br>
 	video_height_virtual = vesafb_defined.yres_virtual;<br>
 <br>
<p>
<pre>
-- 
I'm really <a href="mailto:pavel@ucw.cz">pavel@ucw.cz</a>. Look at <a href="http://195.113.31.123/~pavel">http://195.113.31.123/~pavel</a>.  Pavel
Hi! I'm a .signature virus! Copy me into your ~/.signature, please!
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0044.html">Pavel Machek: "Any known data corruption in 2.3.12"</a>
<li> <b>Previous message:</b> <a href="0042.html">doctor@fruitbat.org: "Re: Where to put new keyboard driver"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
