<!-- received="Sun Aug  8 10:15:31 1999 EET DST" -->
<!-- sent="Sat, 7 Aug 1999 22:41:02 +0200" -->
<!-- name="Pavel Machek" -->
<!-- email="pavel@bug.ucw.cz" -->
<!-- subject="Better scrolling for fbcon" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-32,: Better scrolling for fbcon</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Better scrolling for fbcon</h1>
<b>Pavel Machek</b> (<a href="mailto:pavel@bug.ucw.cz"><i>pavel@bug.ucw.cz</i></a>)<br>
<i>Sat, 7 Aug 1999 22:41:02 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#45">[ date ]</a><a href="index.html#45">[ thread ]</a><a href="subject.html#45">[ subject ]</a><a href="author.html#45">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0046.html">Pavel Machek: "Re: FENRIS Final Release for NwFs 1.4.X"</a>
<li> <b>Previous message:</b> <a href="0044.html">Pavel Machek: "Any known data corruption in 2.3.12"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hi!<br>
<p>
Here's my experimental code. It uses two copies to simulate circular<br>
buffer. It is _much_ better than ypan mode. Unfortunately, I can not<br>
get fbcon_bmove_rec+scrollback right. Please take a look,<br>
<p>
								Pavel<br>
<p>
--- clean//include/linux/fb.h	Fri Apr 30 20:29:10 1999<br>
+++ linux/include/linux/fb.h	Fri Aug  6 00:05:54 1999<br>
@@ -276,7 +276,7 @@<br>
 <br>
     struct vc_data *conp;           /* pointer to console data */<br>
     struct fb_info *fb_info;        /* frame buffer for this console */<br>
-    int vrows;                      /* number of virtual rows */<br>
+    int vrows, total_vrows;         /* number of virtual rows */<br>
     unsigned short cursor_x;	    /* current cursor position */<br>
     unsigned short cursor_y;<br>
     int fgcol;                      /* text colors */<br>
--- clean//drivers/video/fbcon.c	Tue May 18 11:13:13 1999<br>
+++ linux/drivers/video/fbcon.c	Mon Jan  1 05:05:05 1990<br>
@@ -30,7 +30,8 @@<br>
  *                         Jakub Jelinek (<a href="mailto:jj@ultra.linux.cz">jj@ultra.linux.cz</a>)<br>
  *<br>
  *  Random hacking by Martin Mares &lt;<a href="mailto:mj@ucw.cz">mj@ucw.cz</a>&gt;<br>
- *<br>
+ *  YTWICE mode by Pavel Machek &lt;<a href="mailto:pavel@ucw.cz">pavel@ucw.cz</a>&gt;<br>
+ *	(cursor does not work just right + scrollback behaves strange)<br>
  *<br>
  *  The low level operations for the various display memory organizations are<br>
  *  now in separate source files.<br>
@@ -55,6 +56,7 @@<br>
  */<br>
 <br>
 #undef FBCONDEBUG<br>
+#define YTWICE  ((p-&gt;scrollmode &amp; __SCROLL_YMASK) == __SCROLL_YTWICE)<br>
 <br>
 #include &lt;linux/config.h&gt;<br>
 #include &lt;linux/module.h&gt;<br>
@@ -209,7 +211,7 @@<br>
 static __inline__ void ypan_down(int unit, struct vc_data *conp,<br>
 				 struct display *p, int count);<br>
 static void fbcon_bmove_rec(struct display *p, int sy, int sx, int dy, int dx,<br>
-			    int height, int width, u_int y_break);<br>
+			    int height, int width, u_int y_break, int flags);<br>
 <br>
 static int fbcon_show_logo(void);<br>
 <br>
@@ -396,6 +398,9 @@<br>
 	divides(fontheight(p), p-&gt;var.yres_virtual))<br>
 	m = __SCROLL_YWRAP;<br>
     else if (divides(p-&gt;ypanstep, fontheight(p)) &amp;&amp;<br>
+	     p-&gt;var.yres_virtual &gt;= 2*p-&gt;var.yres+fontheight(p))<br>
+	m = __SCROLL_YTWICE;<br>
+    else if (divides(p-&gt;ypanstep, fontheight(p)) &amp;&amp;<br>
 	     p-&gt;var.yres_virtual &gt;= p-&gt;var.yres+fontheight(p))<br>
 	m = __SCROLL_YPAN;<br>
     else if (p-&gt;scrollmode &amp; __SCROLL_YNOMOVE)<br>
@@ -568,6 +573,9 @@<br>
     if ((p-&gt;var.yres % fontheight(p)) &amp;&amp;<br>
 	(p-&gt;var.yres_virtual % fontheight(p) &lt; p-&gt;var.yres % fontheight(p)))<br>
 	p-&gt;vrows--;<br>
+    p-&gt;total_vrows = p-&gt;vrows;<br>
+    if (YTWICE)<br>
+	    p-&gt;vrows -= p-&gt;var.yres/fontheight(p);<br>
     conp-&gt;vc_can_do_color = p-&gt;var.bits_per_pixel != 1;<br>
     conp-&gt;vc_complement_mask = conp-&gt;vc_can_do_color ? 0x7700 : 0x0800;<br>
     if (charcnt == 256) {<br>
@@ -684,6 +692,7 @@<br>
 <br>
     /* Split blits that cross physical y_wrap boundary */<br>
 <br>
+    if (!YTWICE) {<br>
     y_break = p-&gt;vrows-p-&gt;yscroll;<br>
     if (sy &lt; y_break &amp;&amp; sy+height-1 &gt;= y_break) {<br>
 	u_int b = y_break-sy;<br>
@@ -691,6 +700,14 @@<br>
 	p-&gt;dispsw-&gt;clear(conp, p, real_y(p, sy+b), sx, height-b, width);<br>
     } else<br>
 	p-&gt;dispsw-&gt;clear(conp, p, real_y(p, sy), sx, height, width);<br>
+    } else {<br>
+	    int i;<br>
+	    for (i=0; i&lt;height; i++) {<br>
+		    p-&gt;dispsw-&gt;clear(conp, p, real_y(p, sy+i), sx, 1, width);<br>
+		    if (YTWICE &amp;&amp; (real_y(p, sy+i) &lt; conp-&gt;vc_rows))<br>
+			    p-&gt;dispsw-&gt;clear(conp, p, p-&gt;vrows + real_y(p, sy+i), sx, 1, width);<br>
+	    }<br>
+    }<br>
 <br>
     if (redraw_cursor)<br>
 	vbl_cursor_cnt = CURSOR_DRAW_DELAY;<br>
@@ -715,6 +732,8 @@<br>
     }<br>
 <br>
     p-&gt;dispsw-&gt;putc(conp, p, c, real_y(p, ypos), xpos);<br>
+    if (YTWICE &amp;&amp; (real_y(p, ypos) &lt; conp-&gt;vc_rows))<br>
+	    p-&gt;dispsw-&gt;putc(conp, p, c, p-&gt;vrows + real_y(p, ypos), xpos);<br>
 <br>
     if (redraw_cursor)<br>
 	    vbl_cursor_cnt = CURSOR_DRAW_DELAY;<br>
@@ -740,6 +759,9 @@<br>
 	    redraw_cursor = 1;<br>
     }<br>
     p-&gt;dispsw-&gt;putcs(conp, p, s, count, real_y(p, ypos), xpos);<br>
+    if (YTWICE &amp;&amp; (real_y(p, ypos) &lt; conp-&gt;vc_rows))<br>
+	    p-&gt;dispsw-&gt;putcs(conp, p, s, count, p-&gt;vrows + real_y(p, ypos), xpos);<br>
+<br>
     if (redraw_cursor)<br>
 	    vbl_cursor_cnt = CURSOR_DRAW_DELAY;<br>
 }<br>
@@ -776,8 +798,11 @@<br>
 	return;<br>
 <br>
     cursor_on = 0;<br>
-    if (cursor_drawn)<br>
+    if (cursor_drawn) {<br>
         p-&gt;dispsw-&gt;revc(p, p-&gt;cursor_x, real_y(p, p-&gt;cursor_y));<br>
+	if (YTWICE &amp;&amp; (real_y(p, p-&gt;cursor_y) &lt; conp-&gt;vc_rows))<br>
+		p-&gt;dispsw-&gt;revc(p, p-&gt;cursor_x, p-&gt;vrows + real_y(p, p-&gt;cursor_y));<br>
+    }<br>
 <br>
     p-&gt;cursor_x = conp-&gt;vc_x;<br>
     p-&gt;cursor_y = y;<br>
@@ -817,6 +842,21 @@<br>
 static int scrollback_max = 0;<br>
 static int scrollback_current = 0;<br>
 <br>
+/*<br>
+ * Logic behind YTWICE:<br>
+ *<br>
+ * real begining of videoram	+-----------------------+<br>
+ *                              | line 1		|<br>
+ *				| line 2		|<br>
+ *          conp-&gt;vc_rows  ---&gt; +-----------------------+<br>
+ *				| line 3		|<br>
+ *				| line 4		|<br>
+ *		p-&gt;vrows  ---&gt;	+-----------------------+<br>
+ *				| line 1 (copy)		|<br>
+ *				| line 2 (copy)		|<br>
+ *				+-----------------------+<br>
+ */<br>
+<br>
 static __inline__ void ywrap_up(int unit, struct vc_data *conp,<br>
 				struct display *p, int count)<br>
 {<br>
@@ -827,6 +867,8 @@<br>
     p-&gt;var.yoffset = p-&gt;yscroll*fontheight(p);<br>
     p-&gt;var.vmode |= FB_VMODE_YWRAP;<br>
     p-&gt;fb_info-&gt;updatevar(unit, p-&gt;fb_info);<br>
+    if (YTWICE &amp;&amp; p-&gt;dispsw-&gt;clear_margins)<br>
+	p-&gt;dispsw-&gt;clear_margins(conp, p, 1);<br>
     scrollback_max += count;<br>
     if (scrollback_max &gt; scrollback_phys_max)<br>
 	scrollback_max = scrollback_phys_max;<br>
@@ -844,6 +886,8 @@<br>
     p-&gt;var.yoffset = p-&gt;yscroll*fontheight(p);<br>
     p-&gt;var.vmode |= FB_VMODE_YWRAP;<br>
     p-&gt;fb_info-&gt;updatevar(unit, p-&gt;fb_info);<br>
+    if (YTWICE &amp;&amp; p-&gt;dispsw-&gt;clear_margins)<br>
+	p-&gt;dispsw-&gt;clear_margins(conp, p, 1);<br>
     scrollback_max -= count;<br>
     if (scrollback_max &lt; 0)<br>
 	scrollback_max = 0;<br>
@@ -1158,6 +1202,23 @@<br>
 		fbcon_clear(conp, b-count, 0, count, conp-&gt;vc_cols);<br>
 		break;<br>
 <br>
+	    case __SCROLL_YTWICE:<br>
+		if (b-t-count &gt; 3*conp-&gt;vc_rows&gt;&gt;2) {<br>
+		    if (t &gt; 0)<br>
+			fbcon_bmove(conp, 0, 0, count, 0, t,<br>
+				    conp-&gt;vc_cols);<br>
+			ywrap_up(unit, conp, p, count);<br>
+		    if (conp-&gt;vc_rows-b &gt; 0)<br>
+			fbcon_bmove(conp, b-count, 0, b, 0,<br>
+				    conp-&gt;vc_rows-b, conp-&gt;vc_cols);<br>
+		} else if (p-&gt;scrollmode &amp; __SCROLL_YPANREDRAW)<br>
+		    goto redraw_up;<br>
+		else<br>
+		    fbcon_bmove(conp, t+count, 0, t, 0, b-t-count,<br>
+				conp-&gt;vc_cols);<br>
+		fbcon_clear(conp, b-count, 0, count, conp-&gt;vc_cols);<br>
+		break;<br>
+<br>
 	    case __SCROLL_YPAN:<br>
 		if (( p-&gt;yscroll + count &lt;= 2 * (p-&gt;vrows - conp-&gt;vc_rows)) &amp;&amp;<br>
 		    (( !scroll_partial &amp;&amp; (b-t == conp-&gt;vc_rows)) ||<br>
@@ -1218,6 +1279,23 @@<br>
 		fbcon_clear(conp, t, 0, count, conp-&gt;vc_cols);<br>
 		break;<br>
 <br>
+	    case __SCROLL_YTWICE:<br>
+		if (b-t-count &gt; 3*conp-&gt;vc_rows&gt;&gt;2) {<br>
+		    if (conp-&gt;vc_rows-b &gt; 0)<br>
+			fbcon_bmove(conp, b, 0, b-count, 0,<br>
+				    conp-&gt;vc_rows-b, conp-&gt;vc_cols);<br>
+		    ywrap_down(unit, conp, p, count);<br>
+		    if (t &gt; 0)<br>
+			fbcon_bmove(conp, count, 0, 0, 0, t,<br>
+				    conp-&gt;vc_cols);<br>
+		} else if (p-&gt;scrollmode &amp; __SCROLL_YPANREDRAW)<br>
+		    goto redraw_down;<br>
+		else<br>
+		    fbcon_bmove(conp, t, 0, t+count, 0, b-t-count,<br>
+				conp-&gt;vc_cols);<br>
+		fbcon_clear(conp, t, 0, count, conp-&gt;vc_cols);<br>
+		break;<br>
+<br>
 	    case __SCROLL_YPAN:<br>
 		if (( count-p-&gt;yscroll &lt;= p-&gt;vrows-conp-&gt;vc_rows) &amp;&amp;<br>
 		    (( !scroll_partial &amp;&amp; (b-t == conp-&gt;vc_rows)) ||<br>
@@ -1278,22 +1356,24 @@<br>
      *  Recursive invocations don't need to erase the cursor over and<br>
      *  over again, so we use fbcon_bmove_rec()<br>
      */<br>
-    fbcon_bmove_rec(p, sy, sx, dy, dx, height, width, p-&gt;vrows-p-&gt;yscroll);<br>
+    fbcon_bmove_rec(p, sy, sx, dy, dx, height, width, p-&gt;vrows-p-&gt;yscroll, 0);<br>
+    if (YTWICE)<br>
+	    fbcon_bmove_rec(p, p-&gt;vrows+sy, sx, p-&gt;vrows+dy, dx, height, width, p-&gt;total_vrows, 1);<br>
 }<br>
 <br>
 static void fbcon_bmove_rec(struct display *p, int sy, int sx, int dy, int dx,<br>
-			    int height, int width, u_int y_break)<br>
+			    int height, int width, u_int y_break, int flags)<br>
 {<br>
     u_int b;<br>
 <br>
     if (sy &lt; y_break &amp;&amp; sy+height &gt; y_break) {<br>
 	b = y_break-sy;<br>
 	if (dy &lt; sy) {	/* Avoid trashing self */<br>
-	    fbcon_bmove_rec(p, sy, sx, dy, dx, b, width, y_break);<br>
-	    fbcon_bmove_rec(p, sy+b, sx, dy+b, dx, height-b, width, y_break);<br>
+	    fbcon_bmove_rec(p, sy, sx, dy, dx, b, width, y_break, flags);<br>
+	    fbcon_bmove_rec(p, sy+b, sx, dy+b, dx, height-b, width, y_break, flags);<br>
 	} else {<br>
-	    fbcon_bmove_rec(p, sy+b, sx, dy+b, dx, height-b, width, y_break);<br>
-	    fbcon_bmove_rec(p, sy, sx, dy, dx, b, width, y_break);<br>
+	    fbcon_bmove_rec(p, sy+b, sx, dy+b, dx, height-b, width, y_break, flags);<br>
+	    fbcon_bmove_rec(p, sy, sx, dy, dx, b, width, y_break, flags);<br>
 	}<br>
 	return;<br>
     }<br>
@@ -1301,14 +1381,24 @@<br>
     if (dy &lt; y_break &amp;&amp; dy+height &gt; y_break) {<br>
 	b = y_break-dy;<br>
 	if (dy &lt; sy) {	/* Avoid trashing self */<br>
-	    fbcon_bmove_rec(p, sy, sx, dy, dx, b, width, y_break);<br>
-	    fbcon_bmove_rec(p, sy+b, sx, dy+b, dx, height-b, width, y_break);<br>
+	    fbcon_bmove_rec(p, sy, sx, dy, dx, b, width, y_break, flags);<br>
+	    fbcon_bmove_rec(p, sy+b, sx, dy+b, dx, height-b, width, y_break, flags);<br>
 	} else {<br>
-	    fbcon_bmove_rec(p, sy+b, sx, dy+b, dx, height-b, width, y_break);<br>
-	    fbcon_bmove_rec(p, sy, sx, dy, dx, b, width, y_break);<br>
+	    fbcon_bmove_rec(p, sy+b, sx, dy+b, dx, height-b, width, y_break, flags);<br>
+	    fbcon_bmove_rec(p, sy, sx, dy, dx, b, width, y_break, flags);<br>
 	}<br>
 	return;<br>
     }<br>
+    if (YTWICE) {<br>
+	    if (real_y(p, dy) &gt; p-&gt;total_vrows)<br>
+		    return;<br>
+	    if (real_y(p, sy) &gt; p-&gt;total_vrows)<br>
+		    return;<br>
+	    if (flags &amp;&amp; (real_y(p, dy) &lt; p-&gt;vrows))<br>
+		    return;<br>
+	    if (flags &amp;&amp; (real_y(p, sy) &lt; p-&gt;vrows))<br>
+		    return;<br>
+    }<br>
     p-&gt;dispsw-&gt;bmove(p, real_y(p, sy), sx, real_y(p, dy), dx, height, width);<br>
 }<br>
 <br>
@@ -1343,6 +1435,7 @@<br>
     }<br>
     p-&gt;var.yoffset = p-&gt;yscroll = 0;<br>
     switch (p-&gt;scrollmode &amp; __SCROLL_YMASK) {<br>
+        case __SCROLL_YTWICE:<br>
 	case __SCROLL_YWRAP:<br>
 	    scrollback_phys_max = p-&gt;vrows-conp-&gt;vc_rows;<br>
 	    break;<br>
@@ -1583,6 +1676,8 @@<br>
 	/* reset wrap/pan */<br>
 	p-&gt;var.xoffset = p-&gt;var.yoffset = p-&gt;yscroll = 0;<br>
 	p-&gt;vrows = p-&gt;var.yres_virtual/h;<br>
+	if (YTWICE)<br>
+		p-&gt;vrows -= p-&gt;var.yres/h;<br>
 	if ((p-&gt;var.yres % h) &amp;&amp; (p-&gt;var.yres_virtual % h &lt; p-&gt;var.yres % h))<br>
 	    p-&gt;vrows--;<br>
 	updatescrollmode(p);<br>
<p>
<pre>
-- 
I'm really <a href="mailto:pavel@ucw.cz">pavel@ucw.cz</a>. Look at <a href="http://195.113.31.123/~pavel">http://195.113.31.123/~pavel</a>.  Pavel
Hi! I'm a .signature virus! Copy me into your ~/.signature, please!
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0046.html">Pavel Machek: "Re: FENRIS Final Release for NwFs 1.4.X"</a>
<li> <b>Previous message:</b> <a href="0044.html">Pavel Machek: "Any known data corruption in 2.3.12"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
