<!-- received="Mon Aug  9 03:49:30 1999 EET DST" -->
<!-- sent="Mon, 9 Aug 1999 01:22:34 +0200 (CEST)" -->
<!-- name="Andrea Arcangeli" -->
<!-- email="andrea@suse.de" -->
<!-- subject="[patch] preserve fast-path in buffer.c" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-32,: [patch] preserve fast-path in buffer.c</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[patch] preserve fast-path in buffer.c</h1>
<b>Andrea Arcangeli</b> (<a href="mailto:andrea@suse.de"><i>andrea@suse.de</i></a>)<br>
<i>Mon, 9 Aug 1999 01:22:34 +0200 (CEST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#123">[ date ]</a><a href="index.html#123">[ thread ]</a><a href="subject.html#123">[ subject ]</a><a href="author.html#123">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0124.html">Andrea Arcangeli: "[patch] WRITEA and lost dirty flag (fs-corruption)"</a>
<li> <b>Previous message:</b> <a href="0122.html">Craig Armour: "fs corruption 2.2.11-pre4"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
The fast path is the case where create_buffer is succesfully so it worth<br>
to take it inline.<br>
<p>
diff -ur 2.3.13-pre8/fs/buffer.c 2.3.13-pre8-tmp/fs/buffer.c<br>
--- 2.3.13-pre8/fs/buffer.c	Sun Aug  8 17:21:37 1999<br>
+++ 2.3.13-pre8-tmp/fs/buffer.c	Mon Aug  9 01:21:02 1999<br>
@@ -1911,10 +1911,8 @@<br>
 	if (!(page = __get_free_page(GFP_BUFFER)))<br>
 		return 0;<br>
 	bh = create_buffers(page, size, 0);<br>
-	if (!bh) {<br>
-		free_page(page);<br>
-		return 0;<br>
-	}<br>
+	if (!bh)<br>
+		goto no_buffer_head;<br>
 <br>
 	isize = BUFSIZE_INDEX(size);<br>
 <br>
@@ -1944,6 +1942,10 @@<br>
 	mem_map[MAP_NR(page)].buffers = bh;<br>
 	atomic_add(PAGE_SIZE, &amp;buffermem);<br>
 	return 1;<br>
+<br>
+no_buffer_head:<br>
+	free_page(page);<br>
+	return 0;<br>
 }<br>
 <br>
 /*<br>
<p>
Andrea<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0124.html">Andrea Arcangeli: "[patch] WRITEA and lost dirty flag (fs-corruption)"</a>
<li> <b>Previous message:</b> <a href="0122.html">Craig Armour: "fs corruption 2.2.11-pre4"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
