<!-- received="Mon Aug  9 03:55:40 1999 EET DST" -->
<!-- sent="Mon, 9 Aug 1999 01:04:59 +0200 (CEST)" -->
<!-- name="Andrea Arcangeli" -->
<!-- email="andrea@suse.de" -->
<!-- subject="[patch] WRITEA and lost dirty flag (fs-corruption)" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-32,: [patch] WRITEA and lost dirty flag (fs-corruption)</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[patch] WRITEA and lost dirty flag (fs-corruption)</h1>
<b>Andrea Arcangeli</b> (<a href="mailto:andrea@suse.de"><i>andrea@suse.de</i></a>)<br>
<i>Mon, 9 Aug 1999 01:04:59 +0200 (CEST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#124">[ date ]</a><a href="index.html#124">[ thread ]</a><a href="subject.html#124">[ subject ]</a><a href="author.html#124">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0125.html">Andrea Arcangeli: "[patch] too_many_dirty_buffers cleanup"</a>
<li> <b>Previous message:</b> <a href="0123.html">Andrea Arcangeli: "[patch] preserve fast-path in buffer.c"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
As you Linus discovered last month, the WRITEA operations forget to<br>
restore the BH_Dirty bit while giving up due out of request-slots (and<br>
doing that it will almost sure trigger bad fs corruption).<br>
<p>
So here it is the fix against 2.3.13-pre8:<br>
<p>
--- tmp/drivers/block/ll_rw_blk.c.~1~	Mon Aug  9 00:49:51 1999<br>
+++ tmp/drivers/block/ll_rw_blk.c	Mon Aug  9 00:54:30 1999<br>
@@ -565,7 +565,7 @@<br>
 /* if no request available: if rw_ahead, forget it; otherwise try again blocking.. */<br>
 	if (!req) {<br>
 		if (rw_ahead)<br>
-			goto end_io;<br>
+			goto failed_ahead;<br>
 		req = __get_request_wait(max_req, bh-&gt;b_rdev);<br>
 	}<br>
 <br>
@@ -583,6 +583,16 @@<br>
 	add_request(major+blk_dev,req);<br>
 	return;<br>
 <br>
+failed_ahead:<br>
+	switch (rw)<br>
+	{<br>
+	case WRITE:<br>
+		/* nobody can write to a buffer while it's locked */<br>
+		if (test_and_set_bit(BH_Dirty, &amp;bh-&gt;b_state))<br>
+			BUG();<br>
+		refile_buffer(bh);<br>
+		break;<br>
+	}<br>
 end_io:<br>
 	bh-&gt;b_end_io(bh, test_bit(BH_Uptodate, &amp;bh-&gt;b_state));<br>
 }<br>
<p>
<p>
Long ago I also noticed that the pagein/pageout stats (the one in vmstat<br>
bi/bo fields) was accounting a failed (due out of request slots)<br>
operation as a real write/read operation. This looks a bug to me so here<br>
it is the fix incremental with the previous patch:<br>
<p>
--- tmp/drivers/block/ll_rw_blk.c	Mon Aug  9 00:57:05 1999<br>
+++ tmp/drivers/block/ll_rw_blk.c1	Mon Aug  9 00:56:51 1999<br>
@@ -586,11 +586,15 @@<br>
 failed_ahead:<br>
 	switch (rw)<br>
 	{<br>
+	case READ:<br>
+		kstat.pgpgin--;<br>
+		break;<br>
 	case WRITE:<br>
 		/* nobody can write to a buffer while it's locked */<br>
 		if (test_and_set_bit(BH_Dirty, &amp;bh-&gt;b_state))<br>
 			BUG();<br>
 		refile_buffer(bh);<br>
+		kstat.pgpgout--;<br>
 		break;<br>
 	}<br>
 end_io:<br>
<p>
Andrea<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0125.html">Andrea Arcangeli: "[patch] too_many_dirty_buffers cleanup"</a>
<li> <b>Previous message:</b> <a href="0123.html">Andrea Arcangeli: "[patch] preserve fast-path in buffer.c"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
