<!-- received="Mon Aug  9 03:59:57 1999 EET DST" -->
<!-- sent="Mon, 9 Aug 1999 02:13:19 +0200 (CEST)" -->
<!-- name="Andrea Arcangeli" -->
<!-- email="andrea@suse.de" -->
<!-- subject="[patch] ext2/inode.c fixes" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-32,: [patch] ext2/inode.c fixes</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[patch] ext2/inode.c fixes</h1>
<b>Andrea Arcangeli</b> (<a href="mailto:andrea@suse.de"><i>andrea@suse.de</i></a>)<br>
<i>Mon, 9 Aug 1999 02:13:19 +0200 (CEST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#126">[ date ]</a><a href="index.html#126">[ thread ]</a><a href="subject.html#126">[ subject ]</a><a href="author.html#126">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0127.html">Andrea Arcangeli: "[patch] ll_rw_block removed some not necessary check for null"</a>
<li> <b>Previous message:</b> <a href="0125.html">Andrea Arcangeli: "[patch] too_many_dirty_buffers cleanup"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
In 2.3.13-pre8 mark_buffer_dirty can't sleep, but I think that it would be<br>
nice to have the ext2 robust against a possible sleeps of<br>
mark_buffer_dirty (since IMO it's not obvious that mark_buffer_dirty has<br>
not to sleep). IMO mark_buffer_dirty is the natural place where to call<br>
balance_dirty()... Anyway that's outside the scope of this email and I'll<br>
address that leather.<br>
<p>
This patch will make ext2:<br>
<p>
o	robust against possible sleeps of mark_buffer_dirty()<br>
o	will avoid silenty ignoring the allocation of the last block<br>
	under us when BUG() will be #undef. If I understood well<br>
	the reason nobody can race with the allocation of the real data<br>
	block is that we are serialized by the per-page-lock (the buffer<br>
	is always &lt;= PAGE_SIZE).<br>
o	will avoid ignoring somebody racing with us in the block_getblk<br>
	path.<br>
<p>
--- 2.3.13-pre8-tmp/fs/ext2/inode.c.~1~	Tue Jul 13 02:02:09 1999<br>
+++ 2.3.13-pre8-tmp/fs/ext2/inode.c	Mon Aug  9 01:52:28 1999<br>
@@ -259,20 +259,22 @@<br>
 	}<br>
 	if (metadata) {<br>
 		result = getblk (inode-&gt;i_dev, tmp, blocksize);<br>
+		memset(result-&gt;b_data, 0, blocksize);<br>
+		mark_buffer_uptodate(result, 1);<br>
+		mark_buffer_dirty(result, 1);<br>
 		if (*p) {<br>
 			ext2_free_blocks (inode, tmp, 1);<br>
-			brelse (result);<br>
+			bforget (result);<br>
 			goto repeat;<br>
 		}<br>
-		memset(result-&gt;b_data, 0, blocksize);<br>
-		mark_buffer_uptodate(result, 1);<br>
-		mark_buffer_dirty(result, 1);<br>
 	} else {<br>
 		if (*p) {<br>
 			/*<br>
 			 * Nobody is allowed to change block allocation<br>
 			 * state from under us:<br>
 			 */<br>
+			ext2_error (inode-&gt;i_sb, "block_getblk",<br>
+				    "data block filled under us");<br>
 			BUG();<br>
 			ext2_free_blocks (inode, tmp, 1);<br>
 			goto repeat;<br>
@@ -366,22 +368,28 @@<br>
 		goto out;<br>
 	if (metadata) {<br>
 		result = getblk (bh-&gt;b_dev, tmp, blocksize);<br>
+		memset(result-&gt;b_data, 0, inode-&gt;i_sb-&gt;s_blocksize);<br>
+		mark_buffer_uptodate(result, 1);<br>
+		mark_buffer_dirty(result, 1);<br>
 		if (*p) {<br>
 			ext2_free_blocks (inode, tmp, 1);<br>
-			brelse (result);<br>
+			bforget (result);<br>
 			goto repeat;<br>
 		}<br>
-		memset(result-&gt;b_data, 0, inode-&gt;i_sb-&gt;s_blocksize);<br>
-		mark_buffer_uptodate(result, 1);<br>
-		mark_buffer_dirty(result, 1);<br>
 	} else {<br>
+		if (*p) {<br>
+			/*<br>
+			 * Nobody is allowed to change block allocation<br>
+			 * state from under us:<br>
+			 */<br>
+			ext2_error (inode-&gt;i_sb, "block_getblk",<br>
+				    "data block filled under us");<br>
+			BUG();<br>
+			ext2_free_blocks (inode, tmp, 1);<br>
+			goto repeat;<br>
+		}<br>
 		*phys = tmp;<br>
 		*new = 1;<br>
-	}<br>
-	if (*p) {<br>
-		ext2_free_blocks (inode, tmp, 1);<br>
-		brelse (result);<br>
-		goto repeat;<br>
 	}<br>
 	*p = le32_to_cpu(tmp);<br>
 	mark_buffer_dirty(bh, 1);<br>
<p>
Andrea<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0127.html">Andrea Arcangeli: "[patch] ll_rw_block removed some not necessary check for null"</a>
<li> <b>Previous message:</b> <a href="0125.html">Andrea Arcangeli: "[patch] too_many_dirty_buffers cleanup"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
