<!-- received="Mon Aug  9 04:06:19 1999 EET DST" -->
<!-- sent="Mon, 9 Aug 1999 01:17:11 +0200 (CEST)" -->
<!-- name="Andrea Arcangeli" -->
<!-- email="andrea@suse.de" -->
<!-- subject="[patch] ll_rw_block removed some not necessary check for null" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-32,: [patch] ll_rw_block removed some not necessary check for null</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[patch] ll_rw_block removed some not necessary check for null</h1>
<b>Andrea Arcangeli</b> (<a href="mailto:andrea@suse.de"><i>andrea@suse.de</i></a>)<br>
<i>Mon, 9 Aug 1999 01:17:11 +0200 (CEST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#127">[ date ]</a><a href="index.html#127">[ thread ]</a><a href="subject.html#127">[ subject ]</a><a href="author.html#127">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0128.html">Andrea Arcangeli: "Re: [patch] ext2/inode.c fixes"</a>
<li> <b>Previous message:</b> <a href="0126.html">Andrea Arcangeli: "[patch] ext2/inode.c fixes"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
In ll_rw_block() there's some not necessary check for NULL. For the<br>
make_request loop, if such pointers would be NULL they would have Oopsed<br>
in the previous checking-loop. For the "sorry" loop, they may have<br>
previously oopsed in the same checking-loop as well.<br>
<p>
Patch against 2.3.13-pre8:<br>
<p>
--- 2.3.13-pre8/drivers/block/ll_rw_blk.c	Sun Aug  8 17:21:29 1999<br>
+++ /tmp/ll_rw_blk.c	Mon Aug  9 01:11:00 1999<br>
@@ -654,26 +654,22 @@<br>
 	}<br>
 <br>
 	for (i = 0; i &lt; nr; i++) {<br>
-		if (bh[i]) {<br>
-			set_bit(BH_Req, &amp;bh[i]-&gt;b_state);<br>
+		set_bit(BH_Req, &amp;bh[i]-&gt;b_state);<br>
 #ifdef CONFIG_BLK_DEV_MD<br>
-			if (MAJOR(bh[i]-&gt;b_dev) == MD_MAJOR) {<br>
-				md_make_request(MINOR (bh[i]-&gt;b_dev), rw, bh[i]);<br>
-				continue;<br>
-			}<br>
-#endif<br>
-			make_request(MAJOR(bh[i]-&gt;b_rdev), rw, bh[i]);<br>
+		if (MAJOR(bh[i]-&gt;b_dev) == MD_MAJOR) {<br>
+			md_make_request(MINOR (bh[i]-&gt;b_dev), rw, bh[i]);<br>
+			continue;<br>
 		}<br>
+#endif<br>
+		make_request(MAJOR(bh[i]-&gt;b_rdev), rw, bh[i]);<br>
 	}<br>
 	return;<br>
 <br>
       sorry:<br>
 	for (i = 0; i &lt; nr; i++) {<br>
-		if (bh[i]) {<br>
-			clear_bit(BH_Dirty, &amp;bh[i]-&gt;b_state);<br>
-			clear_bit(BH_Uptodate, &amp;bh[i]-&gt;b_state);<br>
-			bh[i]-&gt;b_end_io(bh[i], 0);<br>
-		}<br>
+		clear_bit(BH_Dirty, &amp;bh[i]-&gt;b_state);<br>
+		clear_bit(BH_Uptodate, &amp;bh[i]-&gt;b_state);<br>
+		bh[i]-&gt;b_end_io(bh[i], 0);<br>
 	}<br>
 	return;<br>
 }<br>
<p>
Andrea<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0128.html">Andrea Arcangeli: "Re: [patch] ext2/inode.c fixes"</a>
<li> <b>Previous message:</b> <a href="0126.html">Andrea Arcangeli: "[patch] ext2/inode.c fixes"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
