<!-- received="Mon Aug  9 04:07:06 1999 EET DST" -->
<!-- sent="Mon, 9 Aug 1999 02:22:07 +0200 (CEST)" -->
<!-- name="Andrea Arcangeli" -->
<!-- email="andrea@suse.de" -->
<!-- subject="Re: [patch] ext2/inode.c fixes" -->
<!-- id="" -->
<!-- inreplyto="Pine.LNX.4.10.9908090205240.1425-100000@laser.random" -->
<title>Linux-kernel mailing list archive 1999-32,: Re: [patch] ext2/inode.c fixes</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: [patch] ext2/inode.c fixes</h1>
<b>Andrea Arcangeli</b> (<a href="mailto:andrea@suse.de"><i>andrea@suse.de</i></a>)<br>
<i>Mon, 9 Aug 1999 02:22:07 +0200 (CEST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#128">[ date ]</a><a href="index.html#128">[ thread ]</a><a href="subject.html#128">[ subject ]</a><a href="author.html#128">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0129.html">Andrea Arcangeli: "[patch] swap_free overstimate {lowest,highest}_bit"</a>
<li> <b>Previous message:</b> <a href="0127.html">Andrea Arcangeli: "[patch] ll_rw_block removed some not necessary check for null"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
On Mon, 9 Aug 1999, Andrea Arcangeli wrote:<br>
<p>
<i>&gt;This patch will make ext2:</i><br>
<i>&gt;</i><br>
<i>&gt;o	robust against possible sleeps of mark_buffer_dirty()</i><br>
<i>&gt;o	will avoid silenty ignoring the allocation of the last block</i><br>
<i>&gt;	under us when BUG() will be #undef. If I understood well</i><br>
<i>&gt;	the reason nobody can race with the allocation of the real data</i><br>
<i>&gt;	block is that we are serialized by the per-page-lock (the buffer</i><br>
<i>&gt;	is always &lt;= PAGE_SIZE).</i><br>
<i>&gt;o	will avoid ignoring somebody racing with us in the block_getblk</i><br>
<i>&gt;	path.</i><br>
<p>
This second incremental patch (I posted intentionally two separate patches<br>
since these are different issues) will do:<br>
<p>
o	set -EFBIG only when necessary<br>
o	avoid us to return the pointer of a buffer that we bforgot since<br>
	it's not the interesting one anymore.<br>
o	return -ENOSPC also if we can't alloc a block anymore from<br>
	block_getblk as we do for inode_getblk.<br>
<p>
--- 2.3.13-pre8-tmp/fs/ext2/inode.c.~2~	Mon Aug  9 01:54:19 1999<br>
+++ 2.3.13-pre8-tmp/fs/ext2/inode.c	Mon Aug  9 02:00:36 1999<br>
@@ -202,6 +202,7 @@<br>
 	struct buffer_head * result;<br>
 	int blocksize = inode-&gt;i_sb-&gt;s_blocksize;<br>
 <br>
+	result = NULL;	<br>
 	p = inode-&gt;u.ext2_i.i_data + nr;<br>
 repeat:<br>
 	tmp = le32_to_cpu(*p);<br>
@@ -217,7 +218,6 @@<br>
 			return NULL;<br>
 		}<br>
 	}<br>
-	*err = -EFBIG;<br>
 <br>
 	/* Check file limits.. */<br>
 	{<br>
@@ -253,10 +253,10 @@<br>
 	ext2_debug ("goal = %d.\n", goal);<br>
 <br>
 	tmp = ext2_alloc_block (inode, goal, err);<br>
-	if (!tmp) {<br>
-		*err = -ENOSPC;<br>
+	*err = -ENOSPC;<br>
+	if (!tmp)<br>
 		return NULL;<br>
-	}<br>
+	*err = 0;<br>
 	if (metadata) {<br>
 		result = getblk (inode-&gt;i_dev, tmp, blocksize);<br>
 		memset(result-&gt;b_data, 0, blocksize);<br>
@@ -265,6 +265,7 @@<br>
 		if (*p) {<br>
 			ext2_free_blocks (inode, tmp, 1);<br>
 			bforget (result);<br>
+			result = NULL;<br>
 			goto repeat;<br>
 		}<br>
 	} else {<br>
@@ -280,8 +281,6 @@<br>
 			goto repeat;<br>
 		}<br>
 		*phys = tmp;<br>
-		result = NULL;<br>
-		*err = 0;<br>
 		*new = 1;<br>
 	}<br>
 	*p = cpu_to_le32(tmp);<br>
@@ -340,13 +339,13 @@<br>
 			goto out;<br>
 		}<br>
 	}<br>
-	*err = -EFBIG;<br>
 <br>
 	limit = current-&gt;rlim[RLIMIT_FSIZE].rlim_cur;<br>
 	if (limit &lt; RLIM_INFINITY) {<br>
 		limit &gt;&gt;= EXT2_BLOCK_SIZE_BITS(inode-&gt;i_sb);<br>
 		if (new_block &gt;= limit) {<br>
 			send_sig(SIGXFSZ, current, 0);<br>
+			*err = -EFBIG;<br>
 			goto out;<br>
 		}<br>
 	}<br>
@@ -364,8 +363,10 @@<br>
 			goal = bh-&gt;b_blocknr;<br>
 	}<br>
 	tmp = ext2_alloc_block (inode, goal, err);<br>
+	*err = -ENOSPC;<br>
 	if (!tmp)<br>
 		goto out;<br>
+	*err = 0;<br>
 	if (metadata) {<br>
 		result = getblk (bh-&gt;b_dev, tmp, blocksize);<br>
 		memset(result-&gt;b_data, 0, inode-&gt;i_sb-&gt;s_blocksize);<br>
@@ -374,6 +375,7 @@<br>
 		if (*p) {<br>
 			ext2_free_blocks (inode, tmp, 1);<br>
 			bforget (result);<br>
+			result = NULL;<br>
 			goto repeat;<br>
 		}<br>
 	} else {<br>
<p>
Andrea<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0129.html">Andrea Arcangeli: "[patch] swap_free overstimate {lowest,highest}_bit"</a>
<li> <b>Previous message:</b> <a href="0127.html">Andrea Arcangeli: "[patch] ll_rw_block removed some not necessary check for null"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
