<!-- received="Mon Aug  9 04:07:17 1999 EET DST" -->
<!-- sent="Mon, 9 Aug 1999 02:45:14 +0200 (CEST)" -->
<!-- name="Andrea Arcangeli" -->
<!-- email="andrea@suse.de" -->
<!-- subject="[patch] swap_free overstimate {lowest,highest}_bit" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-32,: [patch] swap_free overstimate {lowest,highest}_bit</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[patch] swap_free overstimate {lowest,highest}_bit</h1>
<b>Andrea Arcangeli</b> (<a href="mailto:andrea@suse.de"><i>andrea@suse.de</i></a>)<br>
<i>Mon, 9 Aug 1999 02:45:14 +0200 (CEST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#129">[ date ]</a><a href="index.html#129">[ thread ]</a><a href="subject.html#129">[ subject ]</a><a href="author.html#129">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0130.html">Andrea Arcangeli: "[patch] last lockmap removal"</a>
<li> <b>Previous message:</b> <a href="0128.html">Andrea Arcangeli: "Re: [patch] ext2/inode.c fixes"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
As Mark pointed out loong ago, swap_free enlarge our free-swap-windows<br>
even if there are still reference to the swap entry. This partially breaks<br>
the get_swap_page() optimization done by the lowest/highest bit. Also SCT<br>
confirmed the bug when Mark pointed it out.<br>
<p>
This is how I fixed the bug in 2.3.13-pre8:<br>
<p>
--- 2.3.13-pre8-tmp/mm/swapfile.c.~1~	Thu Jul 22 01:07:28 1999<br>
+++ 2.3.13-pre8-tmp/mm/swapfile.c	Mon Aug  9 02:39:38 1999<br>
@@ -126,15 +126,17 @@<br>
 	offset = SWP_OFFSET(entry);<br>
 	if (offset &gt;= p-&gt;max)<br>
 		goto bad_offset;<br>
-	if (offset &lt; p-&gt;lowest_bit)<br>
-		p-&gt;lowest_bit = offset;<br>
-	if (offset &gt; p-&gt;highest_bit)<br>
-		p-&gt;highest_bit = offset;<br>
 	if (!p-&gt;swap_map[offset])<br>
 		goto bad_free;<br>
 	if (p-&gt;swap_map[offset] &lt; SWAP_MAP_MAX) {<br>
 		if (!--p-&gt;swap_map[offset])<br>
+		{<br>
+			if (offset &lt; p-&gt;lowest_bit)<br>
+				p-&gt;lowest_bit = offset;<br>
+			if (offset &gt; p-&gt;highest_bit)<br>
+				p-&gt;highest_bit = offset;<br>
 			nr_swap_pages++;<br>
+		}<br>
 	}<br>
 #ifdef DEBUG_SWAP<br>
 	printk("DebugVM: swap_free(entry %08lx, count now %d)\n",<br>
<p>
Andrea<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0130.html">Andrea Arcangeli: "[patch] last lockmap removal"</a>
<li> <b>Previous message:</b> <a href="0128.html">Andrea Arcangeli: "Re: [patch] ext2/inode.c fixes"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
