<!-- received="Mon Aug  9 04:17:50 1999 EET DST" -->
<!-- sent="Mon, 9 Aug 1999 02:38:49 +0200 (CEST)" -->
<!-- name="Andrea Arcangeli" -->
<!-- email="andrea@suse.de" -->
<!-- subject="[patch] swap clustering (search for an empty cluster)" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-32,: [patch] swap clustering (search for an empty cluster)</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[patch] swap clustering (search for an empty cluster)</h1>
<b>Andrea Arcangeli</b> (<a href="mailto:andrea@suse.de"><i>andrea@suse.de</i></a>)<br>
<i>Mon, 9 Aug 1999 02:38:49 +0200 (CEST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#131">[ date ]</a><a href="index.html#131">[ thread ]</a><a href="subject.html#131">[ subject ]</a><a href="author.html#131">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0132.html">David S. Miller: "Re: No kmem_cache_destroy?"</a>
<li> <b>Previous message:</b> <a href="0130.html">Andrea Arcangeli: "[patch] last lockmap removal"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
This patch will improve swapout performances if lots of swap is free<br>
(mainly with my other swap-persistence patch applyed at the same time)<br>
since it will avoid us to start swapping new pages in the middle of a<br>
fragmented area.<br>
<p>
The algorithm is the same as before with the difference that now we first<br>
search for a completly empty cluster. If there aren't empty cluster then<br>
the algorithm will revert to the current behaviour (to start the cluster<br>
from the first free block in the swap area).<br>
<p>
In the testing I did some time ago on 2.2.x it even doubled swapout<br>
performances.<br>
<p>
The patch also fixes a little error: in got_page si-&gt;cluster_next must be<br>
set to `offset + 1' and to to `offset'.<br>
<p>
Patch against 2.3.13-pre8:<br>
<p>
--- 2.3.13-pre8-tmp/mm/swapfile.c.~1~	Thu Jul 22 01:07:28 1999<br>
+++ 2.3.13-pre8-tmp/mm/swapfile.c	Mon Aug  9 02:30:21 1999<br>
@@ -46,16 +46,36 @@<br>
 		}<br>
 	}<br>
 	si-&gt;cluster_nr = SWAPFILE_CLUSTER;<br>
+<br>
+	/* try to find an empty (even not aligned) cluster. */<br>
+	offset = si-&gt;lowest_bit;<br>
+ check_next_cluster:<br>
+	if (offset+SWAPFILE_CLUSTER-1 &lt;= si-&gt;highest_bit)<br>
+	{<br>
+		int nr;<br>
+		for (nr = offset; nr &lt; offset+SWAPFILE_CLUSTER; nr++)<br>
+			if (si-&gt;swap_map[nr])<br>
+			{<br>
+				offset = nr+1;<br>
+				goto check_next_cluster;<br>
+			}<br>
+		/* We found a completly empty cluster, so start<br>
+		 * using it.<br>
+		 */<br>
+		goto got_page;<br>
+	}<br>
+	/* No luck, so now go finegrined as usual. -Andrea */<br>
 	for (offset = si-&gt;lowest_bit; offset &lt;= si-&gt;highest_bit ; offset++) {<br>
 		if (si-&gt;swap_map[offset])<br>
 			continue;<br>
-		si-&gt;lowest_bit = offset;<br>
-got_page:<br>
-		si-&gt;swap_map[offset] = 1;<br>
-		nr_swap_pages--;<br>
+	got_page:<br>
+		if (offset == si-&gt;lowest_bit)<br>
+			si-&gt;lowest_bit++;<br>
 		if (offset == si-&gt;highest_bit)<br>
 			si-&gt;highest_bit--;<br>
-		si-&gt;cluster_next = offset;<br>
+		si-&gt;swap_map[offset] = 1;<br>
+		nr_swap_pages--;<br>
+		si-&gt;cluster_next = offset+1;<br>
 		return offset;<br>
 	}<br>
 	return 0;<br>
<p>
Andrea<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0132.html">David S. Miller: "Re: No kmem_cache_destroy?"</a>
<li> <b>Previous message:</b> <a href="0130.html">Andrea Arcangeli: "[patch] last lockmap removal"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
