<!-- received="Mon Aug  9 06:50:54 1999 EET DST" -->
<!-- sent="Mon, 09 Aug 1999 00:01:31 -0400" -->
<!-- name="Horst von Brand" -->
<!-- email="vonbrand@sleipnir.valparaiso.cl" -->
<!-- subject="linux-2.2.11-pre7: i386 asm cleanup" -->
<!-- id="199908090401.AAA00855@sleipnir.valparaiso.cl" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-32,: linux-2.2.11-pre7: i386 asm cleanup</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>linux-2.2.11-pre7: i386 asm cleanup</h1>
<b>Horst von Brand</b> (<a href="mailto:vonbrand@sleipnir.valparaiso.cl"><i>vonbrand@sleipnir.valparaiso.cl</i></a>)<br>
<i>Mon, 09 Aug 1999 00:01:31 -0400</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#145">[ date ]</a><a href="index.html#145">[ thread ]</a><a href="subject.html#145">[ subject ]</a><a href="author.html#145">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0146.html">Alan Curry: "Re: info format (was Re: Linux 2.2.11pre4)"</a>
<li> <b>Previous message:</b> <a href="0144.html">Peter Waltenberg: "Re: SMP Scheduling"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0162.html">Alan Cox: "Re: linux-2.2.11-pre7: i386 asm cleanup"</a>
<li> <b>Reply:</b> <a href="0162.html">Alan Cox: "Re: linux-2.2.11-pre7: i386 asm cleanup"</a>
<li> <b>Reply:</b> <a href="0443.html">Horst von Brand: "Re: linux-2.2.11-pre7: i386 asm cleanup"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
I've got a i586 UP, gcc-2.95, binutils-2.9.5.0.5. The following patch<br>
cleans up the assembler warnings I've encountered. The resulting kernel is<br>
what I'm running right now, booted from lilo.<br>
<p>
- The compiler uses %kX to refer to the 32-bit version of argument X to an<br>
  asm(). Several places say "movl %w0,...", which means "move the 32 bit<br>
  long from the 16-bit version of the register argument", this makes no<br>
  sense.  Either use "movw %w0,..." to move the lower half or use the full<br>
  register, "movl %k0,...".  This is what I do below. Looks somewhat fishy<br>
  to me anyway, if gcc just fills in the lower half and we use the full<br>
  register, we get a random upper half... perhaps the best course of action<br>
  would be just to omit the [wl] here? Or force a 32-bit register in the<br>
  constraints? <br>
<p>
- AFAIU, there is no point in using just the lower half of a register to<br>
  fill in a segment register, with a movl to boot.<br>
<p>
In all cases the assembler warnings imply that the full register is being<br>
used regardless, because of the "l" suffix to the instruction, so this<br>
should be safe.<br>
<p>
--- linux/include/asm-i386/processor.h.dist-2.2.11-pre7	Tue Jul 20 22:28:52 1999<br>
+++ linux/include/asm-i386/processor.h	Sun Aug  8 21:55:11 1999<br>
@@ -268,7 +268,7 @@<br>
 }<br>
 <br>
 #define start_thread(regs, new_eip, new_esp) do {		\<br>
-	__asm__("movl %w0,%%fs ; movl %w0,%%gs": :"r" (0));	\<br>
+	__asm__("movl %k0,%%fs ; movl %k0,%%gs": :"r" (0));	\<br>
 	set_fs(USER_DS);					\<br>
 	regs-&gt;xds = __USER_DS;					\<br>
 	regs-&gt;xes = __USER_DS;					\<br>
--- linux/arch/i386/boot/compressed/head.S.dist-2.2.11-pre7	Sun Mar 29 15:31:16 1998<br>
+++ linux/arch/i386/boot/compressed/head.S	Sun Aug  8 22:48:05 1999<br>
@@ -37,10 +37,10 @@<br>
 	cld<br>
 	cli<br>
 	movl $(__KERNEL_DS),%eax<br>
-	movl %ax,%ds<br>
-	movl %ax,%es<br>
-	movl %ax,%fs<br>
-	movl %ax,%gs<br>
+	movl %eax,%ds<br>
+	movl %eax,%es<br>
+	movl %eax,%fs<br>
+	movl %eax,%gs<br>
 #ifdef __SMP__<br>
 	orw %bx,%bx			# What state are we in BX=1 for SMP<br>
 					# 0 for boot<br>
--- linux/arch/i386/kernel/head.S.dist-2.2.11-pre7	Fri Jan 15 03:57:25 1999<br>
+++ linux/arch/i386/kernel/head.S	Sun Aug  8 22:42:43 1999<br>
@@ -45,10 +45,10 @@<br>
  */<br>
 	cld<br>
 	movl $(__KERNEL_DS),%eax<br>
-	movl %ax,%ds<br>
-	movl %ax,%es<br>
-	movl %ax,%fs<br>
-	movl %ax,%gs<br>
+	movl %eax,%ds<br>
+	movl %eax,%es<br>
+	movl %eax,%fs<br>
+	movl %eax,%gs<br>
 #ifdef __SMP__<br>
 	orw %bx,%bx<br>
 	jz 1f<br>
@@ -229,10 +229,10 @@<br>
 	lidt idt_descr<br>
 	ljmp $(__KERNEL_CS),$1f<br>
 1:	movl $(__KERNEL_DS),%eax	# reload all the segment registers<br>
-	movl %ax,%ds		# after changing gdt.<br>
-	movl %ax,%es<br>
-	movl %ax,%fs<br>
-	movl %ax,%gs<br>
+	movl %eax,%ds		# after changing gdt.<br>
+	movl %eax,%es<br>
+	movl %eax,%fs<br>
+	movl %eax,%gs<br>
 #ifdef __SMP__<br>
 	movl $(__KERNEL_DS), %eax<br>
 	mov  %ax,%ss		# Reload the stack pointer (segment only)<br>
@@ -312,8 +312,8 @@<br>
 	pushl %es<br>
 	pushl %ds<br>
 	movl $(__KERNEL_DS),%eax<br>
-	movl %ax,%ds<br>
-	movl %ax,%es<br>
+	movl %eax,%ds<br>
+	movl %eax,%es<br>
 	pushl $int_msg<br>
 	call SYMBOL_NAME(printk)<br>
 	popl %eax<br>
--- linux/arch/i386/kernel/signal.c.dist-2.2.11-pre7	Sun Jul 11 10:33:14 1999<br>
+++ linux/arch/i386/kernel/signal.c	Sun Aug  8 22:07:18 1999<br>
@@ -339,9 +339,9 @@<br>
 	int tmp, err = 0;<br>
 <br>
 	tmp = 0;<br>
-	__asm__("movl %%gs,%w0" : "=r"(tmp): "0"(tmp));<br>
+	__asm__("movl %%gs,%k0" : "=r"(tmp): "0"(tmp));<br>
 	err |= __put_user(tmp, (unsigned int *)&amp;sc-&gt;gs);<br>
-	__asm__("movl %%fs,%w0" : "=r"(tmp): "0"(tmp));<br>
+	__asm__("movl %%fs,%k0" : "=r"(tmp): "0"(tmp));<br>
 	err |= __put_user(tmp, (unsigned int *)&amp;sc-&gt;fs);<br>
 <br>
 	err |= __put_user(regs-&gt;xes, (unsigned int *)&amp;sc-&gt;es);<br>
--- linux/arch/i386/kernel/entry.S.dist-2.2.11-pre7	Fri Apr 30 11:13:37 1999<br>
+++ linux/arch/i386/kernel/entry.S	Sun Aug  8 22:16:26 1999<br>
@@ -92,8 +92,8 @@<br>
 	pushl %ecx; \<br>
 	pushl %ebx; \<br>
 	movl $(__KERNEL_DS),%edx; \<br>
-	movl %dx,%ds; \<br>
-	movl %dx,%es;<br>
+	movl %edx,%ds; \<br>
+	movl %edx,%es;<br>
 <br>
 #define RESTORE_ALL	\<br>
 	popl %ebx;	\<br>
@@ -264,15 +264,15 @@<br>
 	pushl %ecx<br>
 	pushl %ebx<br>
 	cld<br>
-	movl %es,%cx<br>
+	movl %es,%ecx<br>
 	xchgl %eax, ORIG_EAX(%esp)	# orig_eax (get the error code. )<br>
 	movl %esp,%edx<br>
 	xchgl %ecx, ES(%esp)		# get the address and save es.<br>
 	pushl %eax			# push the error code<br>
 	pushl %edx<br>
 	movl $(__KERNEL_DS),%edx<br>
-	movl %dx,%ds<br>
-	movl %dx,%es<br>
+	movl %edx,%ds<br>
+	movl %edx,%es<br>
 	GET_CURRENT(%ebx)<br>
 	call *%ecx<br>
 	addl $8,%esp<br>
--- linux/arch/i386/kernel/process.c.dist-2.2.11-pre7	Tue Jul 20 22:20:25 1999<br>
+++ linux/arch/i386/kernel/process.c	Sun Aug  8 22:03:36 1999<br>
@@ -365,11 +365,11 @@<br>
 	   the values are consistent for real mode operation already. */<br>
 <br>
 	__asm__ __volatile__ ("movl $0x0010,%%eax\n"<br>
-				"\tmovl %%ax,%%ds\n"<br>
-				"\tmovl %%ax,%%es\n"<br>
-				"\tmovl %%ax,%%fs\n"<br>
-				"\tmovl %%ax,%%gs\n"<br>
-				"\tmovl %%ax,%%ss" : : : "eax");<br>
+				"\tmovl %%eax,%%ds\n"<br>
+				"\tmovl %%eax,%%es\n"<br>
+				"\tmovl %%eax,%%fs\n"<br>
+				"\tmovl %%eax,%%gs\n"<br>
+				"\tmovl %%eax,%%ss" : : : "eax");<br>
 <br>
 	/* Jump to the 16-bit code that we copied earlier.  It disables paging<br>
 	   and the cache, switches to real mode, and jumps to the BIOS reset<br>
@@ -489,7 +489,7 @@<br>
 void forget_segments(void)<br>
 {<br>
 	/* forget local segments */<br>
-	__asm__ __volatile__("movl %w0,%%fs ; movl %w0,%%gs"<br>
+	__asm__ __volatile__("movl %k0,%%fs ; movl %k0,%%gs"<br>
 		: /* no outputs */<br>
 		: "r" (0));<br>
 <br>
--- linux/arch/i386/kernel/traps.c.dist-2.2.11-pre7	Tue Feb 16 19:20:05 1999<br>
+++ linux/arch/i386/kernel/traps.c	Sun Aug  8 22:23:33 1999<br>
@@ -558,7 +558,7 @@<br>
 		((limit) &amp; 0x0ffff); }<br>
 <br>
 #define _set_tssldt_desc(n,addr,limit,type) \<br>
-__asm__ __volatile__ ("movw %3,0(%2)\n\t" \<br>
+__asm__ __volatile__ ("movw %w3,0(%2)\n\t" \<br>
 	"movw %%ax,2(%2)\n\t" \<br>
 	"rorl $16,%%eax\n\t" \<br>
 	"movb %%al,4(%2)\n\t" \<br>
--- linux/arch/i386/kernel/irq.h.dist-2.2.11-pre7	Tue Jul 20 22:50:31 1999<br>
+++ linux/arch/i386/kernel/irq.h	Sun Aug  8 22:30:40 1999<br>
@@ -169,8 +169,8 @@<br>
 	"pushl %ecx\n\t" \<br>
 	"pushl %ebx\n\t" \<br>
 	"movl $" STR(__KERNEL_DS) ",%edx\n\t" \<br>
-	"movl %dx,%ds\n\t" \<br>
-	"movl %dx,%es\n\t"<br>
+	"movl %edx,%ds\n\t" \<br>
+	"movl %edx,%es\n\t"<br>
 <br>
 #define IRQ_NAME2(nr) nr##_interrupt(void)<br>
 #define IRQ_NAME(nr) IRQ_NAME2(IRQ##nr)<br>
--- linux/arch/i386/kernel/vm86.c.dist-2.2.11-pre7	Tue Dec  1 16:28:24 1998<br>
+++ linux/arch/i386/kernel/vm86.c	Sun Aug  8 22:37:38 1999<br>
@@ -256,7 +256,7 @@<br>
 		mark_screen_rdonly(tsk);<br>
 	unlock_kernel();<br>
 	__asm__ __volatile__(<br>
-		"xorl %%eax,%%eax; movl %%ax,%%fs; movl %%ax,%%gs\n\t"<br>
+		"xorl %%eax,%%eax; movl %%eax,%%fs; movl %%eax,%%gs\n\t"<br>
 		"movl %0,%%esp\n\t"<br>
 		"jmp ret_from_sys_call"<br>
 		: /* no outputs */<br>
<pre>
-- 
Horst von Brand                             <a href="mailto:vonbrand@sleipnir.valparaiso.cl">vonbrand@sleipnir.valparaiso.cl</a>
Casilla 9G, Via del Mar, Chile                               +56 32 672616
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0146.html">Alan Curry: "Re: info format (was Re: Linux 2.2.11pre4)"</a>
<li> <b>Previous message:</b> <a href="0144.html">Peter Waltenberg: "Re: SMP Scheduling"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0162.html">Alan Cox: "Re: linux-2.2.11-pre7: i386 asm cleanup"</a>
<li> <b>Reply:</b> <a href="0162.html">Alan Cox: "Re: linux-2.2.11-pre7: i386 asm cleanup"</a>
<li> <b>Reply:</b> <a href="0443.html">Horst von Brand: "Re: linux-2.2.11-pre7: i386 asm cleanup"</a>
<!-- reply="end" -->
</ul>
</font></body>
