<!-- received="Mon Aug  9 09:36:47 1999 EET DST" -->
<!-- sent="Mon, 9 Aug 1999 00:32:17 -0600" -->
<!-- name="Russell Kroll" -->
<!-- email="rkroll@exploits.org" -->
<!-- subject="PATCH: variable number of loopback devices" -->
<!-- id="199908090632.AAA29002@exploits.org" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-32,: PATCH: variable number of loopback devices</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>PATCH: variable number of loopback devices</h1>
<b>Russell Kroll</b> (<a href="mailto:rkroll@exploits.org"><i>rkroll@exploits.org</i></a>)<br>
<i>Mon, 9 Aug 1999 00:32:17 -0600</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#155">[ date ]</a><a href="index.html#155">[ thread ]</a><a href="subject.html#155">[ subject ]</a><a href="author.html#155">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0156.html">Jakub Jelinek: "Re: Problems Compiling 2.2.10-ac12 on SparcStation4 (sun4m)"</a>
<li> <b>Previous message:</b> <a href="0154.html">Sang-yong Suh: "[PATCH] ext2/namei.c lookup performance patch"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
For a project at work involving CD towers that mount iso9660 images via<br>
the /dev/loop* devices, I hit a limit in the kernel of 8.  This was set<br>
with a #define, but changing that line every time the kernel was upgraded<br>
proved to be annoying.  8 makes sense since it keeps the array size down<br>
for most users, but some situations demand much more capacity than that.<br>
<p>
Here's a patch that will allow the use of "max_loop=n" as a parameter when<br>
loading as a module.  If you don't specify a number or compile it into the<br>
kernel monolithically, the limit remains at 8 as before.<br>
<p>
This patch has been tested by nailing it with many mount/umount operations<br>
and reading/writing data on the looped filesystems while they were<br>
mounted.  At the top end of the limit, you actually hit a "too many<br>
filesystems mounted" wall by default, but a sysctl tweak fixes that.<br>
<p>
Max filesystem count aside, having more than 256 loop mounts will require<br>
some interesting changes due to the major/minor situation.  Hopefully my<br>
users won't try to load that many images onto one box in the meantime.<br>
<p>
--- linux/drivers/block/loop-orig.c	Wed Aug  4 11:40:50 1999<br>
+++ linux/drivers/block/loop.c	Wed Aug  4 11:42:18 1999<br>
@@ -21,6 +21,10 @@<br>
  * Make real block number available to downstream transfer functions, enables<br>
  * CBC (and relatives) mode encryption requiring unique IVs per data block. <br>
  * Reed H. Petty, <a href="mailto:rhp@draper.net">rhp@draper.net</a><br>
+ *<br>
+ * Maximum number of loop devices now dynamic via max_loop module parameter.<br>
+ * Still fixed at 8 devices when compiled into the kernel normally.<br>
+ * Russell Kroll &lt;<a href="mailto:rkroll@exploits.org">rkroll@exploits.org</a>&gt; 19990701<br>
  * <br>
  * Still To Fix:<br>
  * - Advisory locking is ignored here. <br>
@@ -61,10 +65,11 @@<br>
 #define TIMEOUT_VALUE (6 * HZ)<br>
 #include &lt;linux/blk.h&gt;<br>
 <br>
-#define MAX_LOOP 8<br>
-static struct loop_device loop_dev[MAX_LOOP];<br>
-static int loop_sizes[MAX_LOOP];<br>
-static int loop_blksizes[MAX_LOOP];<br>
+#include &lt;linux/malloc.h&gt;<br>
+static int max_loop = 8;<br>
+static struct loop_device *loop_dev;<br>
+static int *loop_sizes;<br>
+static int *loop_blksizes;<br>
 <br>
 #define FALSE 0<br>
 #define TRUE (!FALSE)<br>
@@ -169,7 +174,7 @@<br>
 	INIT_REQUEST;<br>
 	current_request=CURRENT;<br>
 	CURRENT=current_request-&gt;next;<br>
-	if (MINOR(current_request-&gt;rq_dev) &gt;= MAX_LOOP)<br>
+	if (MINOR(current_request-&gt;rq_dev) &gt;= max_loop)<br>
 		goto error_out;<br>
 	lo = &amp;loop_dev[MINOR(current_request-&gt;rq_dev)];<br>
 	if (!lo-&gt;lo_dentry || !lo-&gt;transfer)<br>
@@ -578,7 +583,7 @@<br>
 		return -ENODEV;<br>
 	}<br>
 	dev = MINOR(inode-&gt;i_rdev);<br>
-	if (dev &gt;= MAX_LOOP)<br>
+	if (dev &gt;= max_loop)<br>
 		return -ENODEV;<br>
 	lo = &amp;loop_dev[dev];<br>
 	switch (cmd) {<br>
@@ -615,7 +620,7 @@<br>
 		return -ENODEV;<br>
 	}<br>
 	dev = MINOR(inode-&gt;i_rdev);<br>
-	if (dev &gt;= MAX_LOOP) {<br>
+	if (dev &gt;= max_loop) {<br>
 		return -ENODEV;<br>
 	}<br>
 	lo = &amp;loop_dev[dev];<br>
@@ -640,7 +645,7 @@<br>
 		return 0;<br>
 	}<br>
 	dev = MINOR(inode-&gt;i_rdev);<br>
-	if (dev &gt;= MAX_LOOP)<br>
+	if (dev &gt;= max_loop)<br>
 		return 0;<br>
 	err = fsync_dev(inode-&gt;i_rdev);<br>
 	lo = &amp;loop_dev[dev];<br>
@@ -674,6 +679,8 @@<br>
  */<br>
 #ifdef MODULE<br>
 #define loop_init init_module<br>
+MODULE_PARM(max_loop, "i");<br>
+MODULE_PARM_DESC(max_loop, "Maximum number of loop devices (1-255)");<br>
 #endif<br>
 <br>
 int loop_register_transfer(struct loop_func_table *funcs)<br>
@@ -690,7 +697,7 @@<br>
 <br>
 	if ((unsigned)number &gt;= MAX_LO_CRYPT)<br>
 		return -EINVAL; <br>
-	for (lo = &amp;loop_dev[0]; lo &lt; &amp;loop_dev[MAX_LOOP]; lo++) { <br>
+	for (lo = &amp;loop_dev[0]; lo &lt; &amp;loop_dev[max_loop]; lo++) { <br>
 		int type = lo-&gt;lo_encrypt_type;<br>
 		if (type == number) { <br>
 			xfer_funcs[type]-&gt;release(lo);<br>
@@ -714,17 +721,46 @@<br>
 		       MAJOR_NR);<br>
 		return -EIO;<br>
 	}<br>
+<br>
+	if ((max_loop &lt; 1) || (max_loop &gt; 255)) {<br>
+		printk (KERN_WARNING "loop: max_loop must be between 1 and 255\n");<br>
+		return -EINVAL;<br>
+	}<br>
+<br>
 #ifndef MODULE<br>
 	printk(KERN_INFO "loop: registered device at major %d\n", MAJOR_NR);<br>
+#else<br>
+	printk(KERN_INFO "loop: enabling %d loop devices\n", max_loop);<br>
 #endif<br>
 <br>
+	loop_dev = kmalloc (max_loop * sizeof(struct loop_device), GFP_KERNEL);<br>
+	if (!loop_dev) {<br>
+		printk (KERN_ERR "loop: Unable to create loop_dev\n");<br>
+		return -ENOMEM;<br>
+	}<br>
+<br>
+	loop_sizes = kmalloc(max_loop * sizeof(int), GFP_KERNEL);<br>
+	if (!loop_sizes) {<br>
+		printk (KERN_ERR "loop: Unable to create loop_sizes\n");<br>
+		kfree (loop_dev);<br>
+		return -ENOMEM;<br>
+	}<br>
+<br>
+	loop_blksizes = kmalloc (max_loop * sizeof(int), GFP_KERNEL);<br>
+	if (!loop_blksizes) {<br>
+		printk (KERN_ERR "loop: Unable to create loop_blksizes\n");<br>
+		kfree (loop_dev);<br>
+		kfree (loop_sizes);<br>
+		return -ENOMEM;<br>
+	}		<br>
+<br>
 	blk_dev[MAJOR_NR].request_fn = DEVICE_REQUEST;<br>
-	for (i=0; i &lt; MAX_LOOP; i++) {<br>
+	for (i=0; i &lt; max_loop; i++) {<br>
 		memset(&amp;loop_dev[i], 0, sizeof(struct loop_device));<br>
 		loop_dev[i].lo_number = i;<br>
 	}<br>
-	memset(&amp;loop_sizes, 0, sizeof(loop_sizes));<br>
-	memset(&amp;loop_blksizes, 0, sizeof(loop_blksizes));<br>
+	memset(loop_sizes, 0, max_loop * sizeof(int));<br>
+	memset(loop_blksizes, 0, max_loop * sizeof(int));<br>
 	blk_size[MAJOR_NR] = loop_sizes;<br>
 	blksize_size[MAJOR_NR] = loop_blksizes;<br>
 <br>
@@ -736,5 +772,9 @@<br>
 {<br>
 	if (unregister_blkdev(MAJOR_NR, "loop") != 0)<br>
 		printk(KERN_WARNING "loop: cannot unregister blkdev\n");<br>
+<br>
+	kfree (loop_dev);<br>
+	kfree (loop_sizes);<br>
+	kfree (loop_blksizes);<br>
 }<br>
 #endif<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0156.html">Jakub Jelinek: "Re: Problems Compiling 2.2.10-ac12 on SparcStation4 (sun4m)"</a>
<li> <b>Previous message:</b> <a href="0154.html">Sang-yong Suh: "[PATCH] ext2/namei.c lookup performance patch"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
