<!-- received="Mon Aug  9 10:29:08 1999 EET DST" -->
<!-- sent="Mon, 9 Aug 1999 17:26:43 +1000" -->
<!-- name="Herbert Xu" -->
<!-- email="herbert@gondor.apana.org.au" -->
<!-- subject="autofs deadlock" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-32,: autofs deadlock</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>autofs deadlock</h1>
<b>Herbert Xu</b> (<a href="mailto:herbert@gondor.apana.org.au"><i>herbert@gondor.apana.org.au</i></a>)<br>
<i>Mon, 9 Aug 1999 17:26:43 +1000</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#159">[ date ]</a><a href="index.html#159">[ thread ]</a><a href="subject.html#159">[ subject ]</a><a href="author.html#159">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0160.html">Riley Williams: "Re: Wireless ethernet?"</a>
<li> <b>Previous message:</b> <a href="0158.html">Jes Sorensen: "Re: Where to put new keyboard driver"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
--WIyZ46R2i8wDzkSu<br>
Content-Type: text/plain; charset=us-ascii<br>
<p>
Hi:<br>
<p>
I've seen autofs lockup frequently when the nfs server goes down.  This patch<br>
seems to fix the problem to me.<br>
<p>
The problem is that autofs_revalidate will not return until the userspace<br>
automount has finished its job.  But if autofs_revalidate was called with<br>
the semaphore on the parent downed, the userspace automount cannot finish<br>
its job since it needs to call mkdir which will wait on that same semaphore.<br>
<pre>
-- 
Debian GNU/Linux 2.1 is out! ( <a href="http://www.debian.org/">http://www.debian.org/</a> )
Email:  Herbert Xu ~{PmV&gt;HI~} &lt;<a href="mailto:herbert@gondor.apana.org.au">herbert@gondor.apana.org.au</a>&gt;
Home Page: <a href="http://gondor.apana.org.au/~herbert/">http://gondor.apana.org.au/~herbert/</a>
PGP Key: <a href="http://gondor.apana.org.au/~herbert/pubkey.txt">http://gondor.apana.org.au/~herbert/pubkey.txt</a>
<p>
--WIyZ46R2i8wDzkSu
Content-Type: text/x-pascal
Content-Description: autofs patch
Content-Disposition: attachment; filename=p
<p>
Index: root.c
===================================================================
RCS file: /home/gondor/herbert/src/CVS/debian/kernel-source/fs/autofs/root.c,v
retrieving revision 1.1.1.4
retrieving revision 1.2
diff -u -r1.1.1.4 -r1.2
--- root.c	1999/05/14 06:25:58	1.1.1.4
+++ root.c	1999/08/07 09:23:39	1.2
@@ -165,7 +165,7 @@
  * yet completely filled in, and revalidate has to delay such
  * lookups..
  */
-static int autofs_revalidate(struct dentry * dentry, int flags)
+static int autofs_do_revalidate(struct dentry * dentry, int flags)
 {
 	struct inode * dir = dentry-&gt;d_parent-&gt;d_inode;
 	struct autofs_sb_info *sbi = autofs_sbi(dir-&gt;i_sb);
@@ -200,6 +200,13 @@
 	return 1;
 }
 
+static int autofs_revalidate(struct dentry * dentry, int flags)
+{
+	up(&amp;dentry-&gt;d_parent-&gt;d_inode-&gt;i_sem);
+	autofs_do_revalidate(dentry, flags);
+	down(&amp;dentry-&gt;d_parent-&gt;d_inode-&gt;i_sem);
+}
+
 static struct dentry_operations autofs_dentry_operations = {
 	autofs_revalidate,	/* d_revalidate */
 	NULL,			/* d_hash */
@@ -237,9 +244,7 @@
 	dentry-&gt;d_flags |= DCACHE_AUTOFS_PENDING;
 	d_add(dentry, NULL);
 
-	up(&amp;dir-&gt;i_sem);
 	autofs_revalidate(dentry, 0);
-	down(&amp;dir-&gt;i_sem);
 
 	/*
 	 * If we are still pending, check if we had to handle
<p>
--WIyZ46R2i8wDzkSu--
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0160.html">Riley Williams: "Re: Wireless ethernet?"</a>
<li> <b>Previous message:</b> <a href="0158.html">Jes Sorensen: "Re: Where to put new keyboard driver"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
