<!-- received="Mon Aug  9 17:14:49 1999 EET DST" -->
<!-- sent="Mon, 9 Aug 1999 15:57:18 +0200" -->
<!-- name="Jakub Jelinek" -->
<!-- email="jj@sunsite.ms.mff.cuni.cz" -->
<!-- subject="[PATCH] 2.3.13-pre8 init tweaks" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-32,: [PATCH] 2.3.13-pre8 init tweaks</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] 2.3.13-pre8 init tweaks</h1>
<b>Jakub Jelinek</b> (<a href="mailto:jj@sunsite.ms.mff.cuni.cz"><i>jj@sunsite.ms.mff.cuni.cz</i></a>)<br>
<i>Mon, 9 Aug 1999 15:57:18 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#191">[ date ]</a><a href="index.html#191">[ thread ]</a><a href="subject.html#191">[ subject ]</a><a href="author.html#191">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0192.html">Paul Slootman: "Re: no driver change for 2.4?"</a>
<li> <b>Previous message:</b> <a href="0190.html">David S. Miller: "Re: SIOCGIFCONF returns bogus value when ifc_req==NULL"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hi!<br>
<p>
This patch makes __exit and __exitdata attributes work (so that those<br>
functions/data are discarded if not module).<br>
Also, it IMHO simplifies the __initcall stuff.<br>
__initcall is now an attribute like __init is, meaning put this function<br>
into init sections and record it in the table for do_initcalls().<br>
For code which will always be compiled into the kernel, initialization then<br>
looks like this:<br>
<p>
static int __initcall bdflush_init(void)<br>
{<br>
	kernel_thread(bdflush, NULL, CLONE_FS | CLONE_FILES | CLONE_SIGHAND);<br>
	return 0;<br>
}<br>
<p>
and that's it.<br>
For tristate code where you want to put the function into init section and<br>
record it for do_initcalls if it is not a module and want to have it as<br>
initialization function for module, you just do<br>
<p>
static int __initcall init_module (void)<br>
{<br>
	...<br>
}<br>
<p>
static void __exit cleanup_module (void)<br>
{<br>
	...<br>
}<br>
<p>
The static is important, otherwise the non-module could not be linked in.<br>
IMHO it is better to write the attributes like this in the function<br>
definitions than to set them later on using some module_init/exit macros.<br>
FYI modutils don't care about binding of symbols, so even a static<br>
init_module is init_module for them.<br>
<p>
--- linux/arch/alpha/vmlinux.lds~	Fri Aug  6 09:27:53 1999<br>
+++ linux/arch/alpha/vmlinux.lds	Mon Aug  9 15:25:14 1999<br>
@@ -3,6 +3,7 @@ ENTRY(__start)<br>
 SECTIONS<br>
 {<br>
   . = 0xfffffc0000310000;<br>
+  /DISCARD/ : { *(.text.exit) *(.data.exit) }<br>
   _text = .;<br>
   .text : { *(.text) }<br>
   .text2 : { *(.text2) }<br>
@@ -34,7 +35,7 @@ SECTIONS<br>
 <br>
   . = ALIGN(8);<br>
   __initcall_start = .;<br>
-  .initcall.init : { *(.initcall.init) }<br>
+  .initcall.init : { *(.ctors) }<br>
   __initcall_end = .;<br>
 <br>
   . = ALIGN(2*8192);	/* Align double page for init_task_union */<br>
@@ -47,7 +48,7 @@ SECTIONS<br>
   _data = .;<br>
   .data.cacheline_aligned : { *(.data.cacheline_aligned) }<br>
   .rodata : { *(.rodata) }<br>
-  .data : { *(.data) CONSTRUCTORS }<br>
+  .data : { *(.data) }<br>
   .got : { *(.got) }<br>
   .sdata : { *(.sdata) }<br>
   _edata = .;<br>
--- linux/arch/i386/kernel/apm.c~	Mon Aug  9 14:25:46 1999<br>
+++ linux/arch/i386/kernel/apm.c	Mon Aug  9 14:03:44 1999<br>
@@ -1436,7 +1436,7 @@ __setup("apm=", apm_setup);<br>
  * In short, if something bad happens, at least we have a choice<br>
  * of just killing the apm thread..<br>
  */<br>
-static int __init apm_init(void)<br>
+static int __initcall init_module(void)<br>
 {<br>
 	static struct proc_dir_entry *ent;<br>
 <br>
@@ -1541,5 +1541,3 @@ static int __init apm_init(void)<br>
 <br>
 	kernel_thread(apm, NULL, CLONE_FS | CLONE_FILES | CLONE_SIGHAND | SIGCHLD);<br>
 }<br>
-<br>
-module_init(apm_init)<br>
--- linux/arch/i386/kernel/process.c~	Mon Aug  9 14:03:45 1999<br>
+++ linux/arch/i386/kernel/process.c	Mon Aug  9 14:26:39 1999<br>
@@ -84,7 +84,7 @@ void (*idle)(void) = default_idle;<br>
 <br>
 #include &lt;linux/pci.h&gt;<br>
 <br>
-static int __init piix4_idle_init(void)<br>
+static int __initcall piix4_idle_init(void)<br>
 {<br>
 	/* This is the PIIX4 ACPI device */<br>
 	struct pci_dev *dev = pci_find_device(PCI_VENDOR_ID_INTEL, PCI_DEVICE_ID_INTEL_82371AB_3, NULL);<br>
@@ -106,8 +106,6 @@ static int __init piix4_idle_init(void)<br>
 	}<br>
 	return 0;<br>
 }<br>
-<br>
-__initcall(piix4_idle_init);<br>
 <br>
 #endif<br>
 <br>
--- linux/arch/i386/vmlinux.lds.S~	Wed Aug  4 13:41:30 1999<br>
+++ linux/arch/i386/vmlinux.lds.S	Mon Aug  9 15:22:22 1999<br>
@@ -7,6 +7,7 @@ ENTRY(_start)<br>
 SECTIONS<br>
 {<br>
   . = PAGE_OFFSET_RAW + 0x100000;<br>
+  /DISCARD/ : { *(.text.exit) *(.data.exit) }<br>
   _text = .;			/* Text and read-only data */<br>
   .text : {<br>
 	*(.text)<br>
@@ -28,10 +29,7 @@ SECTIONS<br>
 <br>
   _etext = .;			/* End of text section */<br>
 <br>
-  .data : {			/* Data */<br>
-	*(.data)<br>
-	CONSTRUCTORS<br>
-	}<br>
+  .data : { *(.data) }		/* Data */<br>
 <br>
   _edata = .;			/* End of data section */<br>
 <br>
@@ -46,8 +44,9 @@ SECTIONS<br>
   __setup_start = .;<br>
   .setup.init : { *(.setup.init) }<br>
   __setup_end = .;<br>
+  . = ALIGN(4);<br>
   __initcall_start = .;<br>
-  .initcall.init : { *(.initcall.init) }<br>
+  .initcall.init : { *(.ctors) }<br>
   __initcall_end = .;<br>
   . = ALIGN(4096);<br>
   __init_end = .;<br>
--- linux/arch/i386/vmlinux.lds~	Wed Aug  4 13:41:28 1999<br>
+++ linux/arch/i386/vmlinux.lds	Mon Aug  9 15:22:31 1999<br>
@@ -7,6 +7,7 @@ ENTRY(_start)<br>
 SECTIONS<br>
 {<br>
   . = 0xC0000000  + 0x100000;<br>
+  /DISCARD/ : { *(.text.exit) *(.data.exit) }<br>
   _text = .;			/* Text and read-only data */<br>
   .text : {<br>
 	*(.text)<br>
@@ -28,10 +29,7 @@ SECTIONS<br>
 <br>
   _etext = .;			/* End of text section */<br>
 <br>
-  .data : {			/* Data */<br>
-	*(.data)<br>
-	CONSTRUCTORS<br>
-	}<br>
+  .data : { *(.data) }		/* Data */<br>
 <br>
   _edata = .;			/* End of data section */<br>
 <br>
@@ -46,8 +44,9 @@ SECTIONS<br>
   __setup_start = .;<br>
   .setup.init : { *(.setup.init) }<br>
   __setup_end = .;<br>
+  . = ALIGN(4);<br>
   __initcall_start = .;<br>
-  .initcall.init : { *(.initcall.init) }<br>
+  .initcall.init : { *(.ctors) }<br>
   __initcall_end = .;<br>
   . = ALIGN(4096);<br>
   __init_end = .;<br>
--- linux/arch/ppc/vmlinux.lds~	Fri Aug  6 09:28:20 1999<br>
+++ linux/arch/ppc/vmlinux.lds	Mon Aug  9 15:25:02 1999<br>
@@ -6,6 +6,7 @@ SECTIONS<br>
 {<br>
   /* Read-only sections, merged into text segment: */<br>
   . = + SIZEOF_HEADERS;<br>
+  /DISCARD/ : { *(.text.exit) *(.data.exit) }<br>
   .interp : { *(.interp) }<br>
   .hash          : { *(.hash)		}<br>
   .dynsym        : { *(.dynsym)		}<br>
@@ -54,7 +55,6 @@ SECTIONS<br>
     *(.sdata2)<br>
     *(.got.plt) *(.got)<br>
     *(.dynamic)<br>
-    CONSTRUCTORS<br>
   }<br>
   _edata  =  .;<br>
   PROVIDE (edata = .);<br>
@@ -75,8 +75,9 @@ SECTIONS<br>
   __setup_start = .;<br>
   .setup.init : { *(.setup.init) }<br>
   __setup_end = .;<br>
+  . = ALIGN(8);<br>
   __initcall_start = .;<br>
-  .initcall.init : { *(.initcall.init) }<br>
+  .initcall.init : { *(.ctors) }<br>
   __initcall_end = .;<br>
   . = ALIGN(4096);<br>
   __init_end = .;<br>
--- linux/arch/sparc/mm/asyncd.c~	Wed Aug  4 13:41:58 1999<br>
+++ linux/arch/sparc/mm/asyncd.c	Mon Aug  9 13:39:59 1999<br>
@@ -273,12 +273,10 @@ int asyncd(void *unused)<br>
 <br>
 #if CONFIG_AP1000<br>
 <br>
-static int __init init_ap1000(void)<br>
+static int __initcall init_ap1000(void)<br>
 {<br>
 	kernel_thread(asyncd, NULL, CLONE_FS | CLONE_FILES | CLONE_SIGHAND);<br>
 	return 0;<br>
 }<br>
-<br>
-module_init(init_ap1000)<br>
 <br>
 #endif<br>
--- linux/arch/sparc64/kernel/binfmt_aout32.c~	Fri Jul 30 13:32:53 1999<br>
+++ linux/arch/sparc64/kernel/binfmt_aout32.c	Mon Aug  9 15:27:04 1999<br>
@@ -39,7 +39,7 @@ static int aout32_core_dump(long signr, <br>
 extern void dump_thread(struct pt_regs *, struct user *);<br>
 <br>
 static struct linux_binfmt aout32_format = {<br>
-	NULL, NULL, load_aout32_binary, load_aout32_library, aout32_core_dump,<br>
+	NULL, THIS_MODULE, load_aout32_binary, load_aout32_library, aout32_core_dump,<br>
 	PAGE_SIZE<br>
 };<br>
 <br>
@@ -453,7 +453,12 @@ load_aout32_library(int fd)<br>
 }<br>
 <br>
 <br>
-__initfunc(int init_aout32_binfmt(void))<br>
+static int __initcall init_module(void)<br>
 {<br>
 	return register_binfmt(&amp;aout32_format);<br>
+}<br>
+<br>
+static void __exit cleanup_module(void)<br>
+{<br>
+	unregister_binfmt(&amp;aout_format);<br>
 }<br>
--- linux/arch/sparc64/vmlinux.lds~	Fri Aug  6 10:18:30 1999<br>
+++ linux/arch/sparc64/vmlinux.lds	Mon Aug  9 15:22:11 1999<br>
@@ -8,6 +8,7 @@ SECTIONS<br>
   empty_zero_page = 0x0000000000400000;<br>
   swapper_pmd_dir = 0x0000000000402000;<br>
   empty_pg_dir = 0x0000000000403000;<br>
+  /DISCARD/ : { *(.text.exit) *(.data.exit) }<br>
   . = 0x4000;<br>
   .text 0x0000000000404000 :<br>
   {<br>
@@ -18,11 +19,7 @@ SECTIONS<br>
   PROVIDE (etext = .);<br>
   .rodata    : { *(.rodata)  }<br>
   .rodata1   : { *(.rodata1) }<br>
-  .data    :<br>
-  {<br>
-    *(.data)<br>
-    CONSTRUCTORS<br>
-  }<br>
+  .data    : { *(.data) }<br>
   .data1   : { *(.data1) }<br>
   _edata  =  .;<br>
   PROVIDE (edata = .);<br>
@@ -43,8 +40,9 @@ SECTIONS<br>
   __setup_start = .;<br>
   .setup_init : { *(.setup.init) }<br>
   __setup_end = .;<br>
+  . = ALIGN(8);<br>
   __initcall_start = .;<br>
-  .initcall.init : { *(.initcall.init) }<br>
+  .initcall.init : { *(.ctors) }<br>
   __initcall_end = .;<br>
   . = ALIGN(8192);<br>
   __init_end = .;<br>
--- linux/drivers/block/genhd.c~	Mon Aug  9 14:05:00 1999<br>
+++ linux/drivers/block/genhd.c	Mon Aug  9 14:27:28 1999<br>
@@ -1387,7 +1387,7 @@ static inline void setup_dev(struct gend<br>
 		resetup_one_dev(dev, drive);<br>
 }<br>
 <br>
-static int __init device_setup(void)<br>
+static int __initcall device_setup(void)<br>
 {<br>
 	extern void console_map_init(void);<br>
 	extern void cpqarray_init(void);<br>
@@ -1447,8 +1447,6 @@ static int __init device_setup(void)<br>
 #endif<br>
 	return 0;<br>
 }<br>
-<br>
-__initcall(device_setup);<br>
 <br>
 #ifdef CONFIG_PROC_FS<br>
 int get_partition_list(char * page)<br>
--- linux/drivers/char/msbusmouse.c~	Wed Aug  4 13:42:30 1999<br>
+++ linux/drivers/char/msbusmouse.c	Mon Aug  9 13:41:38 1999<br>
@@ -117,7 +117,7 @@ static struct busmouse msbusmouse = {<br>
 	MICROSOFT_BUSMOUSE, "msbusmouse", open_mouse, release_mouse, 0<br>
 };<br>
 <br>
-__initfunc(int ms_bus_mouse_init(void))<br>
+static int __initcall init_module(void)<br>
 {<br>
 	int present = 0;<br>
 	int mse_byte, i;<br>
@@ -151,11 +151,8 @@ __initfunc(int ms_bus_mouse_init(void))<br>
 	return msedev &lt; 0 ? msedev : 0;<br>
 }<br>
 <br>
-void ms_bus_mouse_exit(void)<br>
+static void __exit cleanup_module(void)<br>
 {<br>
 	unregister_busmouse(msedev);<br>
 	release_region(MS_MSE_CONTROL_PORT, 0x04);<br>
 }<br>
-<br>
-module_init(ms_bus_mouse_init)<br>
-module_exit(ms_bus_mouse_exit)<br>
--- linux/drivers/net/hamradio/soundmodem/sm.c~	Fri Aug  6 09:29:46 1999<br>
+++ linux/drivers/net/hamradio/soundmodem/sm.c	Mon Aug  9 14:34:36 1999<br>
@@ -611,10 +611,7 @@ static int midiio[NR_PORTS] = { [0 ... N<br>
 <br>
 /* --------------------------------------------------------------------- */<br>
 <br>
-#ifndef MODULE<br>
-static<br>
-#endif<br>
-int __init init_module(void)<br>
+static int __initcall init_module(void)<br>
 {<br>
 	int i, j, found = 0;<br>
 	char set_hw = 1;<br>
@@ -671,8 +668,6 @@ int __init init_module(void)<br>
 <br>
 /* --------------------------------------------------------------------- */<br>
 <br>
-#ifdef MODULE<br>
-<br>
 MODULE_PARM(mode, "1-" __MODULE_STRING(NR_PORTS) "s");<br>
 MODULE_PARM_DESC(mode, "soundmodem operating mode; eg. sbc:afsk1200 or wss:fsk9600");<br>
 MODULE_PARM(iobase, "1-" __MODULE_STRING(NR_PORTS) "i");<br>
@@ -693,7 +688,7 @@ MODULE_PARM_DESC(midiio, "soundmodem PTT<br>
 MODULE_AUTHOR("Thomas M. Sailer, <a href="mailto:sailer@ife.ee.ethz.ch">sailer@ife.ee.ethz.ch</a>, hb9jnx@hb9w.che.eu");<br>
 MODULE_DESCRIPTION("Soundcard amateur radio modem driver");<br>
 <br>
-void cleanup_module(void)<br>
+static void __exit cleanup_module(void)<br>
 {<br>
 	int i;<br>
 <br>
@@ -713,7 +708,7 @@ void cleanup_module(void)<br>
 	}<br>
 }<br>
 <br>
-#else /* MODULE */<br>
+#ifndef MODULE<br>
 <br>
 /*<br>
  * format: soundmodem=io,irq,dma[,dma2[,serio[,pario]]],mode<br>
@@ -750,7 +745,6 @@ static int __init sm_setup(char *str)<br>
 }<br>
 <br>
 __setup("soundmodem=", sm_setup);<br>
-__initcall(init_module);<br>
 <br>
 #endif /* MODULE */<br>
 /* --------------------------------------------------------------------- */<br>
--- linux/drivers/net/hamradio/baycom_epp.c~	Fri Aug  6 09:29:43 1999<br>
+++ linux/drivers/net/hamradio/baycom_epp.c	Mon Aug  9 14:29:27 1999<br>
@@ -1420,10 +1420,7 @@ static int iobase[NR_PORTS] = { 0x378, }<br>
 <br>
 /* --------------------------------------------------------------------- */<br>
 <br>
-#ifndef MODULE<br>
-static<br>
-#endif<br>
-int __init init_module(void)<br>
+static int __initcall init_module(void)<br>
 {<br>
 	struct device *dev;<br>
 	int i, found = 0;<br>
@@ -1478,8 +1475,6 @@ int __init init_module(void)<br>
 <br>
 /* --------------------------------------------------------------------- */<br>
 <br>
-#ifdef MODULE<br>
-<br>
 MODULE_PARM(mode, "1-" __MODULE_STRING(NR_PORTS) "s");<br>
 MODULE_PARM_DESC(mode, "baycom operating mode");<br>
 MODULE_PARM(iobase, "1-" __MODULE_STRING(NR_PORTS) "i");<br>
@@ -1488,7 +1483,7 @@ MODULE_PARM_DESC(iobase, "baycom io base<br>
 MODULE_AUTHOR("Thomas M. Sailer, <a href="mailto:sailer@ife.ee.ethz.ch">sailer@ife.ee.ethz.ch</a>, hb9jnx@hb9w.che.eu");<br>
 MODULE_DESCRIPTION("Baycom epp amateur radio modem driver");<br>
 <br>
-void cleanup_module(void)<br>
+static void __exit cleanup_module(void)<br>
 {<br>
 	struct device *dev;<br>
 	struct baycom_state *bc;<br>
@@ -1507,7 +1502,7 @@ void cleanup_module(void)<br>
 	}<br>
 }<br>
 <br>
-#else /* MODULE */<br>
+#ifndef MODULE<br>
 <br>
 /*<br>
  * format: baycom_epp=io,mode<br>
@@ -1531,7 +1526,6 @@ static int __init baycom_epp_setup(char <br>
 }<br>
 <br>
 __setup("baycom_epp=", baycom_epp_setup);<br>
-__initcall(init_module);<br>
 <br>
 #endif /* MODULE */<br>
 /* --------------------------------------------------------------------- */<br>
--- linux/drivers/net/hamradio/baycom_par.c~	Mon Aug  9 14:06:37 1999<br>
+++ linux/drivers/net/hamradio/baycom_par.c	Mon Aug  9 14:31:47 1999<br>
@@ -491,10 +491,7 @@ static int iobase[NR_PORTS] = { 0x378, }<br>
 <br>
 /* --------------------------------------------------------------------- */<br>
 <br>
-#ifndef MODULE<br>
-static<br>
-#endif<br>
-int __init init_module(void)<br>
+static int __initcall init_module(void)<br>
 {<br>
 	int i, j, found = 0;<br>
 	char set_hw = 1;<br>
@@ -532,8 +529,6 @@ int __init init_module(void)<br>
 <br>
 /* --------------------------------------------------------------------- */<br>
 <br>
-#ifdef MODULE<br>
-<br>
 MODULE_PARM(mode, "1-" __MODULE_STRING(NR_PORTS) "s");<br>
 MODULE_PARM_DESC(mode, "baycom operating mode; eg. par96 or picpar");<br>
 MODULE_PARM(iobase, "1-" __MODULE_STRING(NR_PORTS) "i");<br>
@@ -542,7 +537,7 @@ MODULE_PARM_DESC(iobase, "baycom io base<br>
 MODULE_AUTHOR("Thomas M. Sailer, <a href="mailto:sailer@ife.ee.ethz.ch">sailer@ife.ee.ethz.ch</a>, hb9jnx@hb9w.che.eu");<br>
 MODULE_DESCRIPTION("Baycom par96 and picpar amateur radio modem driver");<br>
 <br>
-void cleanup_module(void)<br>
+static void __exit cleanup_module(void)<br>
 {<br>
 	int i;<br>
 <br>
@@ -560,7 +555,7 @@ void cleanup_module(void)<br>
 	}<br>
 }<br>
 <br>
-#else /* MODULE */<br>
+#ifndef MODULE<br>
 <br>
 /*<br>
  * format: baycom_par=io,mode<br>
@@ -584,7 +579,6 @@ static int __init baycom_par_setup(char <br>
 }<br>
 <br>
 __setup("baycom_par=", baycom_par_setup);<br>
-__initcall(init_module);<br>
 <br>
 #endif /* MODULE */<br>
 /* --------------------------------------------------------------------- */<br>
--- linux/drivers/net/hamradio/baycom_ser_fdx.c~	Mon Aug  9 14:06:39 1999<br>
+++ linux/drivers/net/hamradio/baycom_ser_fdx.c	Mon Aug  9 14:31:34 1999<br>
@@ -600,10 +600,7 @@ static int baud[NR_PORTS] = { [0 ... NR_<br>
 <br>
 /* --------------------------------------------------------------------- */<br>
 <br>
-#ifndef MODULE<br>
-static<br>
-#endif<br>
-int __init init_module(void)<br>
+static int __initcall init_module(void)<br>
 {<br>
 	int i, j, found = 0;<br>
 	char set_hw = 1;<br>
@@ -643,8 +640,6 @@ int __init init_module(void)<br>
 <br>
 /* --------------------------------------------------------------------- */<br>
 <br>
-#ifdef MODULE<br>
-<br>
 MODULE_PARM(mode, "1-" __MODULE_STRING(NR_PORTS) "s");<br>
 MODULE_PARM_DESC(mode, "baycom operating mode; * for software DCD");<br>
 MODULE_PARM(iobase, "1-" __MODULE_STRING(NR_PORTS) "i");<br>
@@ -657,7 +652,7 @@ MODULE_PARM_DESC(baud, "baycom baud rate<br>
 MODULE_AUTHOR("Thomas M. Sailer, <a href="mailto:sailer@ife.ee.ethz.ch">sailer@ife.ee.ethz.ch</a>, hb9jnx@hb9w.che.eu");<br>
 MODULE_DESCRIPTION("Baycom ser12 full duplex amateur radio modem driver");<br>
 <br>
-void cleanup_module(void)<br>
+static void __exit cleanup_module(void)<br>
 {<br>
 	int i;<br>
 <br>
@@ -675,7 +670,7 @@ void cleanup_module(void)<br>
 	}<br>
 }<br>
 <br>
-#else /* MODULE */<br>
+#ifndef MODULE<br>
 <br>
 /*<br>
  * format: baycom_ser_fdx=io,irq,mode<br>
@@ -703,7 +698,6 @@ static int __init baycom_ser_fdx_setup(c<br>
 }<br>
 <br>
 __setup("baycom_ser_fdx=", baycom_ser_fdx_setup);<br>
-__initcall(init_module);<br>
 <br>
 #endif /* MODULE */<br>
 /* --------------------------------------------------------------------- */<br>
--- linux/drivers/net/hamradio/baycom_ser_hdx.c~	Mon Aug  9 14:06:39 1999<br>
+++ linux/drivers/net/hamradio/baycom_ser_hdx.c	Mon Aug  9 14:32:29 1999<br>
@@ -637,10 +637,7 @@ static int irq[NR_PORTS] = { 4, };<br>
 <br>
 /* --------------------------------------------------------------------- */<br>
 <br>
-#ifndef MODULE<br>
-static<br>
-#endif<br>
-int __init init_module(void)<br>
+static int __initcall init_module(void)<br>
 {<br>
 	int i, j, found = 0;<br>
 	char set_hw = 1;<br>
@@ -679,8 +676,6 @@ int __init init_module(void)<br>
 <br>
 /* --------------------------------------------------------------------- */<br>
 <br>
-#ifdef MODULE<br>
-<br>
 MODULE_PARM(mode, "1-" __MODULE_STRING(NR_PORTS) "s");<br>
 MODULE_PARM_DESC(mode, "baycom operating mode; * for software DCD");<br>
 MODULE_PARM(iobase, "1-" __MODULE_STRING(NR_PORTS) "i");<br>
@@ -691,7 +686,7 @@ MODULE_PARM_DESC(irq, "baycom irq number<br>
 MODULE_AUTHOR("Thomas M. Sailer, <a href="mailto:sailer@ife.ee.ethz.ch">sailer@ife.ee.ethz.ch</a>, hb9jnx@hb9w.che.eu");<br>
 MODULE_DESCRIPTION("Baycom ser12 half duplex amateur radio modem driver");<br>
 <br>
-void cleanup_module(void)<br>
+static void __exit cleanup_module(void)<br>
 {<br>
 	int i;<br>
 <br>
@@ -709,7 +704,7 @@ void cleanup_module(void)<br>
 	}<br>
 }<br>
 <br>
-#else /* MODULE */<br>
+#ifndef MODULE<br>
 <br>
 /*<br>
  * format: baycom_ser_hdx=io,irq,mode<br>
@@ -735,7 +730,6 @@ static int __init baycom_ser_hdx_setup(c<br>
 }<br>
 <br>
 __setup("baycom_ser_hdx=", baycom_ser_hdx_setup);<br>
-__initcall(init_module);<br>
 <br>
 #endif /* MODULE */<br>
 /* --------------------------------------------------------------------- */<br>
--- linux/drivers/pci/proc.c~	Mon Aug  9 14:06:47 1999<br>
+++ linux/drivers/pci/proc.c	Mon Aug  9 14:36:32 1999<br>
@@ -586,7 +586,7 @@ static struct proc_dir_entry proc_old_pc<br>
 	0, &amp;proc_array_inode_operations<br>
 };<br>
 <br>
-static int __init pci_proc_init(void)<br>
+static int __initcall pci_proc_init(void)<br>
 {<br>
 	if (pci_present()) {<br>
 		proc_bus_pci_dir = create_proc_entry("pci", S_IFDIR, proc_bus);<br>
@@ -596,5 +596,3 @@ static int __init pci_proc_init(void)<br>
 	}<br>
 	return 0;<br>
 }<br>
-<br>
-__initcall(pci_proc_init);<br>
--- linux/drivers/sound/es1370.c~	Mon Aug  9 14:07:21 1999<br>
+++ linux/drivers/sound/es1370.c	Mon Aug  9 14:37:28 1999<br>
@@ -2318,10 +2318,7 @@ static struct initvol {<br>
 	{ SOUND_MIXER_WRITE_OGAIN, 0x4040 }<br>
 };<br>
 <br>
-#ifndef MODULE<br>
-static<br>
-#endif<br>
-int __init init_module(void)<br>
+static int __initcall init_module(void)<br>
 {<br>
 	struct es1370_state *s;<br>
 	struct pci_dev *pcidev = NULL;<br>
@@ -2440,8 +2437,6 @@ int __init init_module(void)<br>
 <br>
 /* --------------------------------------------------------------------- */<br>
 <br>
-#ifdef MODULE<br>
-<br>
 MODULE_PARM(joystick, "1-" __MODULE_STRING(NR_DEVICE) "i");<br>
 MODULE_PARM_DESC(joystick, "if 1 enables joystick interface (still need separate driver)");<br>
 MODULE_PARM(lineout, "1-" __MODULE_STRING(NR_DEVICE) "i");<br>
@@ -2452,7 +2447,7 @@ MODULE_PARM_DESC(micbias, "sets the +5V <br>
 MODULE_AUTHOR("Thomas M. Sailer, <a href="mailto:sailer@ife.ee.ethz.ch">sailer@ife.ee.ethz.ch</a>, hb9jnx@hb9w.che.eu");<br>
 MODULE_DESCRIPTION("ES1370 AudioPCI Driver");<br>
 <br>
-void cleanup_module(void)<br>
+static void __exit cleanup_module(void)<br>
 {<br>
 	struct es1370_state *s;<br>
 <br>
@@ -2472,7 +2467,7 @@ void cleanup_module(void)<br>
 	printk(KERN_INFO "es1370: unloading\n");<br>
 }<br>
 <br>
-#else /* MODULE */<br>
+#ifndef MODULE<br>
 <br>
 /* format is: es1370=[joystick[,lineout[,micbias]]] */<br>
 <br>
@@ -2493,6 +2488,5 @@ static int __init es1370_setup(char *str<br>
 }<br>
 <br>
 __setup("es1370=", es1370_setup);<br>
-__initcall(init_module);<br>
 <br>
 #endif /* MODULE */<br>
--- linux/drivers/sound/es1371.c~	Mon Aug  9 14:07:21 1999<br>
+++ linux/drivers/sound/es1371.c	Mon Aug  9 14:38:34 1999<br>
@@ -2719,10 +2719,7 @@ static struct initvol {<br>
 	{ SOUND_MIXER_WRITE_IGAIN, 0x4040 }<br>
 };<br>
 <br>
-#ifndef MODULE<br>
-static<br>
-#endif<br>
-int __init init_module(void)<br>
+static int __initcall init_module(void)<br>
 {<br>
 	struct es1371_state *s;<br>
 	struct pci_dev *pcidev = NULL;<br>
@@ -2885,15 +2882,13 @@ int __init init_module(void)<br>
 <br>
 /* --------------------------------------------------------------------- */<br>
 <br>
-#ifdef MODULE<br>
-<br>
 MODULE_PARM(joystick, "1-" __MODULE_STRING(NR_DEVICE) "i");<br>
 MODULE_PARM_DESC(joystick, "sets address and enables joystick interface (still need separate driver)");<br>
 <br>
 MODULE_AUTHOR("Thomas M. Sailer, <a href="mailto:sailer@ife.ee.ethz.ch">sailer@ife.ee.ethz.ch</a>, hb9jnx@hb9w.che.eu");<br>
 MODULE_DESCRIPTION("ES1371 AudioPCI97 Driver");<br>
 <br>
-void cleanup_module(void)<br>
+static void __exit cleanup_module(void)<br>
 {<br>
 	struct es1371_state *s;<br>
 <br>
@@ -2913,7 +2908,7 @@ void cleanup_module(void)<br>
 	printk(KERN_INFO "es1371: unloading\n");<br>
 }<br>
 <br>
-#else /* MODULE */<br>
+#ifndef MODULE<br>
 <br>
 /* format is: es1371=[joystick] */<br>
 <br>
@@ -2930,6 +2925,5 @@ static int __init es1371_setup(char *str<br>
 }<br>
 <br>
 __setup("es1371=", es1371_setup);<br>
-__initcall(init_module);<br>
 <br>
 #endif /* MODULE */<br>
--- linux/drivers/sound/sonicvibes.c~	Mon Aug  9 14:07:24 1999<br>
+++ linux/drivers/sound/sonicvibes.c	Mon Aug  9 14:39:30 1999<br>
@@ -2314,10 +2314,7 @@ static struct initvol {<br>
 	{ SOUND_MIXER_WRITE_PCM, 0x4040 }<br>
 };<br>
 <br>
-#ifndef MODULE<br>
-static<br>
-#endif<br>
-int __init init_module(void)<br>
+static int __initcall init_module(void)<br>
 {<br>
 	struct sv_state *s;<br>
 	struct pci_dev *pcidev = NULL;<br>
@@ -2501,8 +2498,6 @@ int __init init_module(void)<br>
 <br>
 /* --------------------------------------------------------------------- */<br>
 <br>
-#ifdef MODULE<br>
-<br>
 MODULE_PARM(reverb, "1-" __MODULE_STRING(NR_DEVICE) "i");<br>
 MODULE_PARM_DESC(reverb, "if 1 enables the reverb circuitry. NOTE: your card must have the reverb RAM");<br>
 #if 0<br>
@@ -2516,7 +2511,7 @@ MODULE_PARM_DESC(dmaio, "if the motherbo<br>
 MODULE_AUTHOR("Thomas M. Sailer, <a href="mailto:sailer@ife.ee.ethz.ch">sailer@ife.ee.ethz.ch</a>, hb9jnx@hb9w.che.eu");<br>
 MODULE_DESCRIPTION("S3 SonicVibes Driver");<br>
 <br>
-void cleanup_module(void)<br>
+static void __exit cleanup_module(void)<br>
 {<br>
 	struct sv_state *s;<br>
 <br>
@@ -2545,7 +2540,7 @@ void cleanup_module(void)<br>
 	printk(KERN_INFO "sv: unloading\n");<br>
 }<br>
 <br>
-#else /* MODULE */<br>
+#ifndef MODULE<br>
 <br>
 /* format is: sonicvibes=[reverb] sonicvibesdmaio=dmaioaddr */<br>
 <br>
@@ -2578,6 +2573,5 @@ static int __init sonicvibesdmaio_setup(<br>
 <br>
 __setup("sonicvibes=", sonicvibes_setup);<br>
 __setup("sonicvibesdmaio=", sonicvibesdmaio_setup);<br>
-__initcall(init_module);<br>
 <br>
 #endif /* MODULE */<br>
--- linux/drivers/parport/init.c~	Fri Aug  6 09:29:49 1999<br>
+++ linux/drivers/parport/init.c	Mon Aug  9 14:35:48 1999<br>
@@ -128,7 +128,7 @@ void cleanup_module(void)<br>
 <br>
 #else<br>
 <br>
-int __init parport_init (void)<br>
+int __initcall parport_init (void)<br>
 {<br>
 	if (io[0] == PARPORT_DISABLE) <br>
 		return 1;<br>
@@ -154,8 +154,6 @@ int __init parport_init (void)<br>
 #endif<br>
 	return 0;<br>
 }<br>
-<br>
-__initcall (parport_init);<br>
 <br>
 #endif<br>
 <br>
--- linux/fs/buffer.c~	Fri Aug  6 09:30:52 1999<br>
+++ linux/fs/buffer.c	Mon Aug  9 13:49:05 1999<br>
@@ -2314,11 +2314,8 @@ int bdflush(void * unused) <br>
 	}<br>
 }<br>
 <br>
-static int __init bdflush_init(void)<br>
+static int __initcall bdflush_init(void)<br>
 {<br>
 	kernel_thread(bdflush, NULL, CLONE_FS | CLONE_FILES | CLONE_SIGHAND);<br>
 	return 0;<br>
 }<br>
-<br>
-module_init(bdflush_init)<br>
-<br>
--- linux/fs/binfmt_aout.c~	Wed Aug  4 13:43:29 1999<br>
+++ linux/fs/binfmt_aout.c	Mon Aug  9 13:45:39 1999<br>
@@ -553,15 +553,12 @@ load_aout_library(int fd)<br>
 }<br>
 <br>
 <br>
-static int __init init_aout_binfmt(void)<br>
+static int __initcall init_module(void)<br>
 {<br>
 	return register_binfmt(&amp;aout_format);<br>
 }<br>
 <br>
-static void __exit exit_aout_binfmt(void)<br>
+static void __exit cleanup_module(void)<br>
 {<br>
 	unregister_binfmt(&amp;aout_format);<br>
 }<br>
-<br>
-module_init(init_aout_binfmt)<br>
-module_exit(exit_aout_binfmt)<br>
--- linux/fs/binfmt_elf.c~	Wed Aug  4 13:43:32 1999<br>
+++ linux/fs/binfmt_elf.c	Mon Aug  9 13:46:09 1999<br>
@@ -1290,16 +1290,13 @@ static int elf_core_dump(long signr, str<br>
 }<br>
 #endif		/* USE_ELF_CORE_DUMP */<br>
 <br>
-static int __init init_elf_binfmt(void)<br>
+static int __initcall init_module(void)<br>
 {<br>
 	return register_binfmt(&amp;elf_format);<br>
 }<br>
 <br>
-static void __exit exit_elf_binfmt(void)<br>
+static void __exit cleanup_module(void)<br>
 {<br>
 	/* Remove the COFF and ELF loaders. */<br>
 	unregister_binfmt(&amp;elf_format);<br>
 }<br>
-<br>
-module_init(init_elf_binfmt)<br>
-module_exit(exit_elf_binfmt)<br>
--- linux/fs/binfmt_em86.c~	Wed Aug  4 13:43:34 1999<br>
+++ linux/fs/binfmt_em86.c	Mon Aug  9 13:46:55 1999<br>
@@ -108,15 +108,12 @@ struct linux_binfmt em86_format = {<br>
 	NULL, THIS_MODULE, load_em86, NULL, NULL, 0<br>
 };<br>
 <br>
-static int __init init_em86_binfmt(void)<br>
+static int __initcall init_module(void)<br>
 {<br>
 	return register_binfmt(&amp;em86_format);<br>
 }<br>
 <br>
-static void __exit exit_em86_binfmt(void)<br>
+static void __exit cleanup_module(void)<br>
 {<br>
 	unregister_binfmt(&amp;em86_format);<br>
 }<br>
-<br>
-module_init(init_em86_binfmt)<br>
-module_exit(exit_em86_binfmt)<br>
--- linux/fs/binfmt_misc.c~	Wed Aug  4 13:43:34 1999<br>
+++ linux/fs/binfmt_misc.c	Mon Aug  9 13:47:36 1999<br>
@@ -489,7 +489,7 @@ static void bm_modcount(struct inode *in<br>
 }<br>
 #endif<br>
 <br>
-static int __init init_misc_binfmt(void)<br>
+static int __initcall init_module(void)<br>
 {<br>
 	int error = -ENOENT;<br>
 	struct proc_dir_entry *status = NULL, *reg;<br>
@@ -524,7 +524,7 @@ cleanup_bm:<br>
 	goto out;<br>
 }<br>
 <br>
-static void __exit exit_misc_binfmt(void)<br>
+static void __exit cleanup_module(void)<br>
 {<br>
 	unregister_binfmt(&amp;misc_format);<br>
 	remove_proc_entry("register", bm_dir);<br>
@@ -534,6 +534,3 @@ static void __exit exit_misc_binfmt(void<br>
 }<br>
 <br>
 EXPORT_NO_SYMBOLS;<br>
-<br>
-module_init(init_misc_binfmt)<br>
-module_exit(exit_misc_binfmt)<br>
--- linux/fs/binfmt_script.c~	Wed Aug  4 13:43:35 1999<br>
+++ linux/fs/binfmt_script.c	Mon Aug  9 13:48:06 1999<br>
@@ -104,15 +104,12 @@ struct linux_binfmt script_format = {<br>
 	NULL, THIS_MODULE, load_script, NULL, NULL, 0<br>
 };<br>
 <br>
-static int __init init_script_binfmt(void)<br>
+static int __initcall init_module(void)<br>
 {<br>
 	return register_binfmt(&amp;script_format);<br>
 }<br>
 <br>
-static void __exit exit_script_binfmt(void)<br>
+static void __exit cleanup_module(void)<br>
 {<br>
 	unregister_binfmt(&amp;script_format);<br>
 }<br>
-<br>
-module_init(init_script_binfmt)<br>
-module_exit(exit_script_binfmt)<br>
--- linux/include/asm-alpha/init.h~	Fri Aug  6 09:31:08 1999<br>
+++ linux/include/asm-alpha/init.h	Mon Aug  9 13:30:33 1999<br>
@@ -1 +1,11 @@<br>
-#error "&lt;asm/init.h&gt; should never be used - use &lt;linux/init.h&gt; instead"<br>
+#ifndef _ASM_INIT_H<br>
+#define _ASM_INIT_H<br>
+<br>
+#ifndef _LINUX_INIT_H<br>
+#error "&lt;asm/init.h&gt; should never be used directly - use &lt;linux/init.h&gt; instead"<br>
+#endif<br>
+<br>
+#ifndef __ASSEMBLY__<br>
+typedef unsigned long initcall_t;<br>
+#endif<br>
+#endif<br>
--- linux/include/asm-arm/init.h~	Wed Jul 28 13:30:56 1999<br>
+++ linux/include/asm-arm/init.h	Mon Aug  9 13:30:33 1999<br>
@@ -1,32 +1,11 @@<br>
-#ifndef _ASMARM_INIT_H<br>
-#define _ASMARM_INIT_H<br>
-<br>
-#include &lt;linux/config.h&gt;<br>
-<br>
-/* C routines */<br>
-<br>
-#ifdef CONFIG_TEXT_SECTIONS<br>
-<br>
-#define __init __attribute__ ((__section__ (".text.init")))<br>
-#define __initfunc(__arginit) \<br>
-	__arginit __init; \<br>
-	__arginit<br>
-<br>
-#else<br>
-<br>
-#define __init<br>
-#define __initfunc(__arginit) __arginit<br>
+#ifndef _ASM_INIT_H<br>
+#define _ASM_INIT_H<br>
 <br>
+#ifndef _LINUX_INIT_H<br>
+#error "&lt;asm/init.h&gt; should never be used directly - use &lt;linux/init.h&gt; instead"<br>
 #endif<br>
 <br>
-#define __initdata __attribute__ ((__section__ (".data.init")))<br>
-<br>
-/* Assembly routines */<br>
-#define __INIT		.section	".text.init",@alloc,@execinstr<br>
-#define __INITDATA	.section	".data.init",@alloc,@write<br>
-#define __FINIT	.previous<br>
-<br>
-#define __cacheline_aligned __attribute__ \<br>
-			 ((__aligned__ (L1_CACHE_BYTES)))<br>
-<br>
+#ifndef __ASSEMBLY__<br>
+typedef unsigned long initcall_t;<br>
+#endif<br>
 #endif<br>
--- linux/include/asm-i386/init.h~	Wed Aug  4 13:44:20 1999<br>
+++ linux/include/asm-i386/init.h	Mon Aug  9 13:30:33 1999<br>
@@ -1 +1,11 @@<br>
-#error "&lt;asm/init.h&gt; should never be used - use &lt;linux/init.h&gt; instead"<br>
+#ifndef _ASM_INIT_H<br>
+#define _ASM_INIT_H<br>
+<br>
+#ifndef _LINUX_INIT_H<br>
+#error "&lt;asm/init.h&gt; should never be used directly - use &lt;linux/init.h&gt; instead"<br>
+#endif<br>
+<br>
+#ifndef __ASSEMBLY__<br>
+typedef unsigned long initcall_t;<br>
+#endif<br>
+#endif<br>
--- linux/include/asm-m68k/init.h~	Wed Jul 28 13:31:23 1999<br>
+++ linux/include/asm-m68k/init.h	Mon Aug  9 13:30:33 1999<br>
@@ -1,37 +1,11 @@<br>
-#ifndef _M68K_INIT_H<br>
-#define _M68K_INIT_H<br>
-<br>
-#include &lt;linux/config.h&gt;<br>
-<br>
-#ifndef CONFIG_KGDB<br>
-<br>
-#define __init __attribute__ ((__section__ (".text.init")))<br>
-#define __initdata __attribute__ ((__section__ (".data.init")))<br>
-#define __initfunc(__arginit) \<br>
-	__arginit __init; \<br>
-	__arginit<br>
-/* For assembly routines */<br>
-#define __INIT		.section	".text.init",#alloc,#execinstr<br>
-#define __FINIT		.previous<br>
-#define __INITDATA	.section	".data.init",#alloc,#write<br>
-<br>
-#define __cacheline_aligned __attribute__ \<br>
-		((__aligned__(16), __section__ (".data.cacheline_aligned")))<br>
-<br>
-#else<br>
-<br>
-/* gdb doesn't like it all if the code for one source file isn't together in<br>
- * the executable, so we must avoid the .init sections :-( */<br>
-	<br>
-#define __init<br>
-#define __initdata<br>
-#define __initfunc(__arginit) __arginit<br>
-/* For assembly routines */<br>
-#define __INIT<br>
-#define __FINIT<br>
-#define __INITDATA<br>
-#define __cacheline_aligned __attribute__ ((__aligned__(16)))<br>
-<br>
-#endif /* CONFIG_KGDB */<br>
+#ifndef _ASM_INIT_H<br>
+#define _ASM_INIT_H<br>
 <br>
+#ifndef _LINUX_INIT_H<br>
+#error "&lt;asm/init.h&gt; should never be used directly - use &lt;linux/init.h&gt; instead"<br>
+#endif<br>
+<br>
+#ifndef __ASSEMBLY__<br>
+typedef unsigned long initcall_t;<br>
+#endif<br>
 #endif<br>
--- linux/include/asm-mips/init.h~	Wed Jul 28 13:31:31 1999<br>
+++ linux/include/asm-mips/init.h	Mon Aug  9 13:30:33 1999<br>
@@ -1,30 +1,11 @@<br>
-/* $Id: init.h,v 1.3 1999/02/15 02:22:10 ralf Exp $<br>
- *<br>
- * This file is subject to the terms and conditions of the GNU General Public<br>
- * License.  See the file "COPYING" in the main directory of this archive<br>
- * for more details.<br>
- *<br>
- * Copyright 1998, 1999 Ralf Baechle<br>
- */<br>
-#ifndef __MIPS_INIT_H<br>
-#define __MIPS_INIT_H<br>
+#ifndef _ASM_INIT_H<br>
+#define _ASM_INIT_H<br>
 <br>
-#define __init __attribute__ ((__section__ (".text.init")))<br>
-#define __initdata __attribute__ ((__section__ (".data.init")))<br>
-#define __initfunc(__arginit) \<br>
-	__arginit __init; \<br>
-	__arginit<br>
-<br>
-#if __GNUC__ &gt;= 2 &amp;&amp; __GNUC_MINOR__ &gt;= 8<br>
-#define __initlocaldata  __initdata<br>
-#else<br>
-#define __initlocaldata<br>
+#ifndef _LINUX_INIT_H<br>
+#error "&lt;asm/init.h&gt; should never be used directly - use &lt;linux/init.h&gt; instead"<br>
 #endif<br>
 <br>
-/* For assembly routines */<br>
-#define __INIT		.section	.text.init,"ax"<br>
-#define __FINIT		.previous<br>
-#define __INITDATA	.section	.data.init,"a"<br>
-#define __cacheline_aligned __attribute__((__aligned__(L1_CACHE_BYTES)))<br>
-<br>
-#endif /* __MIPS_INIT_H */<br>
+#ifndef __ASSEMBLY__<br>
+typedef unsigned long initcall_t;<br>
+#endif<br>
+#endif<br>
--- linux/include/asm-ppc/init.h~	Fri Aug  6 09:31:30 1999<br>
+++ linux/include/asm-ppc/init.h	Mon Aug  9 15:38:49 1999<br>
@@ -1,7 +1,13 @@<br>
 #ifndef _PPC_INIT_H<br>
 #define _PPC_INIT_H<br>
 <br>
-#include &lt;linux/init.h&gt;<br>
+#ifndef _LINUX_INIT_H<br>
+#error "&lt;asm/init.h&gt; should never be used directly - use &lt;linux/init.h&gt; instead"<br>
+#endif<br>
+<br>
+#ifndef __ASSEMBLY__<br>
+typedef unsigned long initcall_t;<br>
+#endif<br>
 <br>
 #if 0/*__GNUC__ &gt; 2 || __GNUC_MINOR__ &gt;= 90*/ /* egcs */<br>
 #define __pmacdata __attribute__ ((__section__ (".data.pmac")))<br>
--- linux/include/asm-sparc64/init.h~	Wed Aug  4 13:44:59 1999<br>
+++ linux/include/asm-sparc64/init.h	Mon Aug  9 13:35:52 1999<br>
@@ -1 +1,18 @@<br>
-#error "&lt;asm/init.h&gt; should never be used - use &lt;linux/init.h&gt; instead"<br>
+#ifndef _ASM_INIT_H<br>
+#define _ASM_INIT_H<br>
+<br>
+#ifndef _LINUX_INIT_H<br>
+#error "&lt;asm/init.h&gt; should never be used directly - use &lt;linux/init.h&gt; instead"<br>
+#endif<br>
+<br>
+#ifndef __ASSEMBLY__<br>
+<br>
+#if (__GNUC__ &gt; 2) || (__GNUC__ == 2 &amp;&amp; __GNUC_MINOR__ &gt;= 96)<br>
+typedef unsigned long initcall_t;<br>
+#else<br>
+/* gcc up to 2.95 generates wrong sized constructors for 64bit SPARC code */<br>
+typedef unsigned int initcall_t;<br>
+#endif<br>
+<br>
+#endif<br>
+#endif<br>
--- linux/include/linux/init.h~	Fri Aug  6 09:31:50 1999<br>
+++ linux/include/linux/init.h	Mon Aug  9 14:44:23 1999<br>
@@ -39,8 +39,29 @@<br>
  *<br>
  * For initialized data not at file scope, i.e. within a function,<br>
  * you should use __initlocaldata instead, due to a bug in GCC 2.7.<br>
+ *<br>
+ * For initialization functions to be run automaticaly on startup:<br>
+ *<br>
+ * static void __initcall initme(int x, int y)<br>
+ * {<br>
+ *    extern int z; z = x * y;<br>
+ * }<br>
+ *<br>
+ * or, if the init code is the same for modules and non-modules:<br>
+ *<br>
+ * static int __initcall init_module (void)<br>
+ * {<br>
+ * }<br>
+ *<br>
+ * For cleanup functions:<br>
+ *<br>
+ * static void __exit cleanup_module (void)<br>
+ * {<br>
+ * }<br>
  */<br>
 <br>
+#include &lt;asm/init.h&gt;<br>
+<br>
 /*<br>
  * Disable the __initfunc macros if a file that is a part of a<br>
  * module attempts to use them. We do not want to interfere<br>
@@ -49,16 +70,14 @@<br>
 <br>
 #ifndef MODULE<br>
 <br>
+#ifndef __ASSEMBLY__<br>
+<br>
 /*<br>
  * Used for initialization calls..<br>
  */<br>
-typedef int (*initcall_t)(void);<br>
 <br>
 extern initcall_t __initcall_start, __initcall_end;<br>
 <br>
-#define __initcall(fn)								\<br>
-	static initcall_t __initcall_##fn __init_call = fn<br>
-<br>
 /*<br>
  * Used for kernel command line parameter setup<br>
  */<br>
@@ -73,16 +92,18 @@ extern struct kernel_param __setup_start<br>
 	static char __setup_str_##fn[] __initdata = str;				\<br>
 	static struct kernel_param __setup_##fn __initsetup = { __setup_str_##fn, fn }<br>
 <br>
+#endif /* __ASSEMBLY__ */<br>
+<br>
 /*<br>
  * Mark functions and data as being only used at initialization<br>
  * or exit time.<br>
  */<br>
 #define __init		__attribute__ ((__section__ (".text.init")))<br>
-#define __exit		__attribute__ ((unused, __section__(".text.init")))<br>
+#define __exit		__attribute__ ((unused, __section__(".text.exit")))<br>
 #define __initdata	__attribute__ ((__section__ (".data.init")))<br>
-#define __exitdata	__attribute__ ((unused, __section__ (".data.init")))<br>
+#define __exitdata	__attribute__ ((unused, __section__ (".data.exit")))<br>
 #define __initsetup	__attribute__ ((unused,__section__ (".setup.init")))<br>
-#define __init_call	__attribute__ ((unused,__section__ (".initcall.init")))<br>
+#define __initcall	__attribute__ ((__section__ (".text.init"), __constructor__))<br>
 <br>
 #define __initfunc(__arginit) \<br>
 	__arginit __init; \<br>
@@ -93,9 +114,6 @@ extern struct kernel_param __setup_start<br>
 #define __FINIT		.previous<br>
 #define __INITDATA	.section	".data.init","aw"<br>
 <br>
-#define module_init(x)	__initcall(x);<br>
-#define module_exit(x)	/* nothing */<br>
-<br>
 #else<br>
 <br>
 #define __init<br>
@@ -108,15 +126,6 @@ extern struct kernel_param __setup_start<br>
 #define __INIT<br>
 #define __FINIT<br>
 #define __INITDATA<br>
-<br>
-/* Not sure what version aliases were introduced in, but certainly in 2.95.  */<br>
-#if __GNUC__ &gt; 2 || (__GNUC__ == 2 &amp;&amp; __GNUC_MINOR__ &gt;= 95)<br>
-#define module_init(x)	int init_module(void) __attribute__((alias(#x)));<br>
-#define module_exit(x)	void cleanup_module(void) __attribute__((alias(#x)));<br>
-#else<br>
-#define module_init(x)	int init_module(void) { return x(); }<br>
-#define module_exit(x)	void cleanup_module(void) { x(); }<br>
-#endif<br>
 <br>
 #endif<br>
 <br>
--- linux/init/main.c~	Mon Aug  9 14:09:39 1999<br>
+++ linux/init/main.c	Mon Aug  9 14:47:50 1999<br>
@@ -563,8 +563,7 @@ static void __init do_initcalls(void)<br>
 <br>
 	call = &amp;__initcall_start;<br>
 	do {<br>
-		(*call)();<br>
-		call++;<br>
+		((void (*)(void))(unsigned long)*call++)();<br>
 	} while (call &lt; &amp;__initcall_end);<br>
 }<br>
 <br>
--- linux/mm/vmscan.c~	Wed Aug  4 13:46:39 1999<br>
+++ linux/mm/vmscan.c	Mon Aug  9 13:51:00 1999<br>
@@ -524,12 +524,10 @@ int try_to_free_pages(unsigned int gfp_m<br>
 	return retval;<br>
 }<br>
 <br>
-static int __init kswapd_init(void)<br>
+static int __initcall kswapd_init(void)<br>
 {<br>
 	printk("Starting kswapd v1.6\n");<br>
 	swap_setup();<br>
 	kernel_thread(kswapd, NULL, CLONE_FS | CLONE_FILES | CLONE_SIGHAND);<br>
 	return 0;<br>
 }<br>
-<br>
-module_init(kswapd_init)<br>
<p>
Cheers,<br>
    Jakub<br>
___________________________________________________________________<br>
Jakub Jelinek | <a href="mailto:jj@sunsite.mff.cuni.cz">jj@sunsite.mff.cuni.cz</a> | <a href="http://sunsite.mff.cuni.cz">http://sunsite.mff.cuni.cz</a><br>
Administrator of SunSITE Czech Republic, MFF, Charles University<br>
___________________________________________________________________<br>
UltraLinux  |  <a href="http://ultra.linux.cz/">http://ultra.linux.cz/</a>  |  http://ultra.penguin.cz/<br>
Linux version 2.3.13 on a sparc64 machine (1343.49 BogoMips)<br>
___________________________________________________________________<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0192.html">Paul Slootman: "Re: no driver change for 2.4?"</a>
<li> <b>Previous message:</b> <a href="0190.html">David S. Miller: "Re: SIOCGIFCONF returns bogus value when ifc_req==NULL"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
