<!-- received="Mon Aug  9 23:25:49 1999 EET DST" -->
<!-- sent="Mon, 09 Aug 1999 22:04:26 +0200" -->
<!-- name="Manfred Spraul" -->
<!-- email="manfreds@colorfullife.com" -->
<!-- subject="[PATCH] remove superflous global variables" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-32,: [PATCH] remove superflous global variables</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] remove superflous global variables</h1>
<b>Manfred Spraul</b> (<a href="mailto:manfreds@colorfullife.com"><i>manfreds@colorfullife.com</i></a>)<br>
<i>Mon, 09 Aug 1999 22:04:26 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#263">[ date ]</a><a href="index.html#263">[ thread ]</a><a href="subject.html#263">[ subject ]</a><a href="author.html#263">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0264.html">Stephen Frost: "Re: Linux 2.2.11pre7 (final ?)"</a>
<li> <b>Previous message:</b> <a href="0262.html">Alan Cox: "Re: fdisk partition table keeps missing."</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
I noticed that <br>
* initialize_secondary() is only required for i386, all other arch's<br>
complain about the "broken Intel".<br>
* kstack_ptr is not used.<br>
* kernel_counter is not used.<br>
* syscall_counter<br>
* apic_retval<br>
* lk_lockmsg<br>
<p>
the patch was tested on i386, SMP.<br>
<p>
<pre>
--
	Manfred
&gt;&gt;&gt;&gt;&gt;&gt;&gt;&gt;&gt;&gt;&gt;&gt;&gt;&gt;&gt;&gt;&gt;&gt;&gt;&gt;&gt;&gt;
// Kernel Version:
//  VERSION = 2
//  PATCHLEVEL = 3
//  SUBLEVEL = 12
//  EXTRAVERSION =
diff -r -u -P -x CVS -x *,v 2.3/arch/alpha/kernel/smp.c
build-2.3/arch/alpha/kernel/smp.c
--- 2.3/arch/alpha/kernel/smp.c Thu Jul 22 22:25:36 1999
+++ build-2.3/arch/alpha/kernel/smp.c   Mon Aug  9 21:33:38 1999
@@ -563,17 +563,6 @@
        mb();
 }
 
-/*
- * Only broken Intel needs this, thus it should not even be
- * referenced globally.
- */
-
-void __init
-initialize_secondary(void)
-{
-}
-
-
 extern void update_one_process(struct task_struct *p, unsigned long
ticks,
                               unsigned long user, unsigned long system,
                               int cpu);
diff -r -u -P -x CVS -x *,v 2.3/arch/i386/kernel/head.S
build-2.3/arch/i386/kernel/head.S
--- 2.3/arch/i386/kernel/head.S Thu Jul 22 22:25:37 1999
+++ build-2.3/arch/i386/kernel/head.S   Mon Aug  9 21:50:25 1999
@@ -243,6 +243,15 @@
        xorl %eax,%eax
        lldt %ax
        cld                     # gcc2 wants the direction flag cleared
at all times
+#ifdef __SMP__
+       movb ready, %cl 
+       cmpb $1,%cl
+       je 1f                   # the first CPU calls start_kernel
+                               # all other CPUs call
initialize_secondary
+       call SYMBOL_NAME(initialize_secondary)
+       jmp L6
+1:
+#endif
        call SYMBOL_NAME(start_kernel)
 L6:
        jmp L6                  # main should never return here, but
diff -r -u -P -x CVS -x *,v 2.3/arch/i386/kernel/smp.c
build-2.3/arch/i386/kernel/smp.c
--- 2.3/arch/i386/kernel/smp.c  Thu Jul 29 15:23:06 1999
+++ build-2.3/arch/i386/kernel/smp.c    Mon Aug  9 21:37:27 1999
@@ -111,21 +111,14 @@
 static volatile unsigned long cpu_callin_map[NR_CPUS] = {0,};  /* We
always use 0 the rest is ready for parallel delivery */
 static volatile unsigned long cpu_callout_map[NR_CPUS] = {0,}; /* We
always use 0 the rest is ready for parallel delivery */
 volatile unsigned long smp_invalidate_needed;          /* Used for the
invalidate map that's also checked in the spinlock */
-volatile unsigned long kstack_ptr;                     /* Stack vector
for booting CPUs                        */
 struct cpuinfo_x86 cpu_data[NR_CPUS];                  /* Per CPU
bogomips and other parameters                */
 static unsigned int num_processors = 1;                        /*
Internal processor count                             */
 unsigned long mp_ioapic_addr = 0xFEC00000;             /* Address of
the I/O apic (not yet used)               */
 unsigned char boot_cpu_id = 0;                         /* Processor
that is doing the boot up                  */
 static int smp_activated = 0;                          /* Tripped once
we need to start cross invalidating     */
 int apic_version[NR_CPUS];                             /* APIC version
number                                  */
-unsigned long apic_retval;                             /* Just
debugging the assembler..                       */
-
-volatile unsigned long kernel_counter=0;               /* Number of
times the processor holds the lock         */
-volatile unsigned long syscall_count=0;                        /*
Number of times the processor holds the syscall lock */
 
 volatile unsigned long ipi_count;                      /* Number of
IPIs delivered                             */
-
-const char lk_lockmsg[] = "lock from interrupt context at %p\n"; 
 
 int mp_bus_id_to_type [MAX_MP_BUSSES] = { -1, };
 extern int nr_ioapics;
diff -r -u -P -x CVS -x *,v 2.3/arch/ppc/kernel/smp.c
build-2.3/arch/ppc/kernel/smp.c
--- 2.3/arch/ppc/kernel/smp.c   Thu Jul 29 15:23:08 1999
+++ build-2.3/arch/ppc/kernel/smp.c     Mon Aug  9 21:33:38 1999
@@ -383,11 +383,6 @@
        smp_commenced = 1;
 }
 
-/* intel needs this */
-void __init initialize_secondary(void)
-{
-}
-
 /* Activate a secondary processor. */
 asmlinkage int __init start_secondary(void *unused)
 {
diff -r -u -P -x CVS -x *,v 2.3/arch/sparc/kernel/smp.c
build-2.3/arch/sparc/kernel/smp.c
--- 2.3/arch/sparc/kernel/smp.c Wed Jun  2 18:19:20 1999
+++ build-2.3/arch/sparc/kernel/smp.c   Mon Aug  9 21:33:38 1999
@@ -100,13 +100,6 @@
        local_flush_tlb_all();
 }
 
-/* Only broken Intel needs this, thus it should not even be referenced
- * globally...
- */
-__initfunc(void initialize_secondary(void))
-{
-}
-
 extern int cpu_idle(void *unused);
 
 /* Activate a secondary processor. */
diff -r -u -P -x CVS -x *,v 2.3/arch/sparc64/kernel/smp.c
build-2.3/arch/sparc64/kernel/smp.c
--- 2.3/arch/sparc64/kernel/smp.c       Sat Jul 10 20:45:58 1999
+++ build-2.3/arch/sparc64/kernel/smp.c Mon Aug  9 21:33:38 1999
@@ -160,10 +160,6 @@
 extern int cpu_idle(void *unused);
 extern void init_IRQ(void);
 
-void initialize_secondary(void)
-{
-}
-
 int start_secondary(void *unused)
 {
        trap_init();
diff -r -u -P -x CVS -x *,v 2.3/init/main.c build-2.3/init/main.c
--- 2.3/init/main.c     Thu Jul 29 15:23:11 1999
+++ build-2.3/init/main.c       Mon Aug  9 21:33:38 1999
@@ -1123,8 +1123,6 @@
 
 #endif
 
-extern void initialize_secondary(void);
-
 /*
  *     Activate the first processor.
  */
@@ -1132,14 +1130,6 @@
 asmlinkage void __init start_kernel(void)
 {
        char * command_line;
-
-#ifdef __SMP__
-       static int boot_cpu = 1;
-       /* "current" has been set up, we need to load it now */
-       if (!boot_cpu)
-               initialize_secondary();
-       boot_cpu = 0;
-#endif
 
 /*
  * Interrupts are still disabled. Do necessary setups, then
&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;
<p>
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0264.html">Stephen Frost: "Re: Linux 2.2.11pre7 (final ?)"</a>
<li> <b>Previous message:</b> <a href="0262.html">Alan Cox: "Re: fdisk partition table keeps missing."</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
