<!-- received="Tue Aug 10 10:30:30 1999 EET DST" -->
<!-- sent="Tue, 10 Aug 1999 01:53:42 -0500 (CDT)" -->
<!-- name="Tim Hockin" -->
<!-- email="thockin@isunix.it.ilstu.edu" -->
<!-- subject="(again..) PATCH: CLONE_PPID and friends - comments&gt;?" -->
<!-- id="199908100653.BAA12955@isunix.it.ilstu.edu" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-32,: (again..) PATCH: CLONE_PPID and friends - comments&gt;?</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>(again..) PATCH: CLONE_PPID and friends - comments&gt;?</h1>
<b>Tim Hockin</b> (<a href="mailto:thockin@isunix.it.ilstu.edu"><i>thockin@isunix.it.ilstu.edu</i></a>)<br>
<i>Tue, 10 Aug 1999 01:53:42 -0500 (CDT)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#324">[ date ]</a><a href="index.html#324">[ thread ]</a><a href="subject.html#324">[ subject ]</a><a href="author.html#324">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0325.html">mcrites@primenet.com: "SB1000 cable modem and /proc"</a>
<li> <b>Previous message:</b> <a href="0323.html">Matt Hallacy: "Oops"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Here is the (latest edition of the) final CLONE_PPID patch.  I reworked<br>
sys_wait4, and few other comments I received.<br>
<p>
Anyone see anything wrong with this?  Else I will make a 2.3.x diff and<br>
pass it on to Linus before the 2.4 freeze..<br>
<p>
<p>
Tim<br>
<p>
<p>
<p>
diff -ru clean-linux-2.2.10/fs/exec.c clone-linux-2.2.10/fs/exec.c<br>
--- clean-linux-2.2.10/fs/exec.c	Sun Jun 13 10:50:04 1999<br>
+++ clone-linux-2.2.10/fs/exec.c	Thu Jul 22 03:17:00 1999<br>
@@ -846,9 +846,12 @@<br>
 <br>
 	if (retval &gt;= 0)<br>
 		retval = search_binary_handler(&amp;bprm,regs);<br>
-	if (retval &gt;= 0)<br>
+	if (retval &gt;= 0) {<br>
+		/* clear any thread-special bits - JIC */<br>
+		current-&gt;flags &amp;= ~(PF_PPIDOK | PF_CLWAIT);<br>
 		/* execve success */<br>
 		return retval;<br>
+	}<br>
 <br>
 	/* Something went wrong, return the inode and free the argument pages*/<br>
 	if (bprm.dentry)<br>
diff -ru clean-linux-2.2.10/include/linux/sched.h clone-linux-2.2.10/include/linux/sched.h<br>
--- clean-linux-2.2.10/include/linux/sched.h	Tue May 11 10:35:45 1999<br>
+++ clone-linux-2.2.10/include/linux/sched.h	Thu Jul 22 02:51:17 1999<br>
@@ -34,6 +34,10 @@<br>
 #define CLONE_PID	0x00001000	/* set if pid shared */<br>
 #define CLONE_PTRACE	0x00002000	/* set if we want to let tracing continue on the child too */<br>
 #define CLONE_VFORK	0x00004000	/* set if the parent wants the child to wake it up on mm_release */<br>
+#define CLONE_PPIDOK	0x00008000	/* set if the child should be able to create siblings */<br>
+#define CLONE_PPID	0x00010000	/* set if we want to create a sibling, not a child */<br>
+#define CLONE_WAIT 	0x00020000	/* set if child is allowed to wait() for siblings */<br>
+#define CLONE_SUSPENDED	0x00040000	/* create a process in the stopped state */<br>
 <br>
 /*<br>
  * These are the constant used to fake the fixed-point load-average<br>
@@ -332,6 +336,8 @@<br>
 <br>
 #define PF_USEDFPU	0x00100000	/* task used FPU this quantum (SMP) */<br>
 #define PF_DTRACE	0x00200000	/* delayed trace (used on m68k, i386) */<br>
+#define PF_PPIDOK	0x00400000	/* task is allowed to use CLONE_PPID */<br>
+#define PF_CLWAIT	0x00800000	/* allowed to wait for siblings */<br>
 <br>
 /*<br>
  * Limit the stack by to some sane default: root can always<br>
diff -ru clean-linux-2.2.10/kernel/exit.c clone-linux-2.2.10/kernel/exit.c<br>
--- clean-linux-2.2.10/kernel/exit.c	Fri Apr 30 08:13:37 1999<br>
+++ clone-linux-2.2.10/kernel/exit.c	Sun Aug  8 16:28:33 1999<br>
@@ -145,6 +145,7 @@<br>
 	read_lock(&amp;tasklist_lock);<br>
 	for_each_task(p) {<br>
 		if (p-&gt;p_opptr == father) {<br>
+			p-&gt;flags &amp;= ~(PF_PPIDOK | PF_CLWAIT);<br>
 			p-&gt;exit_signal = SIGCHLD;<br>
 			p-&gt;p_opptr = child_reaper; /* init */<br>
 			if (p-&gt;pdeath_signal) send_sig(p-&gt;pdeath_signal, p, 0);<br>
@@ -407,16 +408,22 @@<br>
 {<br>
 	int flag, retval;<br>
 	struct wait_queue wait = { current, NULL };<br>
+	struct wait_queue wait_sib = { current, NULL };<br>
 	struct task_struct *p;<br>
+	struct task_struct *start;<br>
 <br>
 	if (options &amp; ~(WNOHANG|WUNTRACED|__WCLONE))<br>
 		return -EINVAL;<br>
 <br>
 	add_wait_queue(&amp;current-&gt;wait_chldexit,&amp;wait);<br>
+	if (current-&gt;flags &amp; PF_CLWAIT)<br>
+		add_wait_queue(&amp;current-&gt;p_pptr-&gt;wait_chldexit,&amp;wait_sib);<br>
+<br>
+	start = current-&gt;p_cptr;<br>
 repeat:<br>
 	flag = 0;<br>
 	read_lock(&amp;tasklist_lock);<br>
- 	for (p = current-&gt;p_cptr ; p ; p = p-&gt;p_osptr) {<br>
+ 	for (p = start ; p ; p = p-&gt;p_osptr) {<br>
 		if (pid&gt;0) {<br>
 			if (p-&gt;pid != pid)<br>
 				continue;<br>
@@ -484,10 +491,19 @@<br>
 		current-&gt;state=TASK_INTERRUPTIBLE;<br>
 		schedule();<br>
 		goto repeat;<br>
+	} else {<br>
+		/* try the siblings ? */<br>
+		if ((current-&gt;flags &amp; PF_CLWAIT) &amp;&amp; (start != current-&gt;p_pptr-&gt;p_cptr)) {<br>
+			start = current-&gt;p_pptr-&gt;p_cptr;<br>
+			goto repeat;<br>
+		}<br>
 	}<br>
 	retval = -ECHILD;<br>
 end_wait4:<br>
 	remove_wait_queue(&amp;current-&gt;wait_chldexit,&amp;wait);<br>
+	if (current-&gt;flags &amp; PF_CLWAIT)<br>
+		remove_wait_queue(&amp;current-&gt;p_pptr-&gt;wait_chldexit,&amp;wait_sib);<br>
+<br>
 	return retval;<br>
 }<br>
 <br>
diff -ru clean-linux-2.2.10/kernel/fork.c clone-linux-2.2.10/kernel/fork.c<br>
--- clean-linux-2.2.10/kernel/fork.c	Mon Apr 12 12:44:26 1999<br>
+++ clone-linux-2.2.10/kernel/fork.c	Thu Jul 29 10:08:13 1999<br>
@@ -517,12 +517,18 @@<br>
 {<br>
 	unsigned long new_flags = p-&gt;flags;<br>
 <br>
-	new_flags &amp;= ~(PF_SUPERPRIV | PF_USEDFPU | PF_VFORK);<br>
+	new_flags &amp;= ~(PF_SUPERPRIV | PF_USEDFPU | PF_VFORK <br>
+		       | PF_PPIDOK | PF_CLWAIT);<br>
 	new_flags |= PF_FORKNOEXEC;<br>
 	if (!(clone_flags &amp; CLONE_PTRACE))<br>
 		new_flags &amp;= ~(PF_PTRACED|PF_TRACESYS);<br>
 	if (clone_flags &amp; CLONE_VFORK)<br>
 		new_flags |= PF_VFORK;<br>
+	if (clone_flags &amp; CLONE_PPIDOK)<br>
+		new_flags |= PF_PPIDOK;<br>
+	if (clone_flags &amp; CLONE_WAIT)<br>
+		new_flags |= PF_CLWAIT;<br>
+<br>
 	p-&gt;flags = new_flags;<br>
 }<br>
 <br>
@@ -587,7 +593,14 @@<br>
 	p-&gt;next_run = p;<br>
 	p-&gt;prev_run = p;<br>
 <br>
-	p-&gt;p_pptr = p-&gt;p_opptr = current;<br>
+	if (!(clone_flags &amp; CLONE_PPID)) {<br>
+		p-&gt;p_pptr = p-&gt;p_opptr = current;<br>
+	} else if (current-&gt;flags &amp; PF_PPIDOK) {<br>
+		p-&gt;p_pptr = p-&gt;p_opptr = current-&gt;p_opptr;<br>
+	} else {<br>
+		retval = -EPERM;<br>
+		goto bad_fork_cleanup;<br>
+	}<br>
 	p-&gt;p_cptr = NULL;<br>
 	init_waitqueue(&amp;p-&gt;wait_chldexit);<br>
 	p-&gt;vfork_sem = NULL;<br>
@@ -668,7 +681,10 @@<br>
 <br>
 		p-&gt;next_run = NULL;<br>
 		p-&gt;prev_run = NULL;<br>
-		wake_up_process(p);		/* do this last */<br>
+		if (!(clone_flags &amp; CLONE_SUSPENDED))<br>
+			wake_up_process(p);	/* do this last */<br>
+		else<br>
+			p-&gt;state = TASK_STOPPED;<br>
 	}<br>
 	++total_forks;<br>
 bad_fork:<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0325.html">mcrites@primenet.com: "SB1000 cable modem and /proc"</a>
<li> <b>Previous message:</b> <a href="0323.html">Matt Hallacy: "Oops"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
