<!-- received="Tue Aug 10 12:46:34 1999 EET DST" -->
<!-- sent="Tue, 10 Aug 1999 11:41:29 +0200" -->
<!-- name="Manfred Spraul" -->
<!-- email="manfreds@colorfullife.com" -->
<!-- subject="Re: 2.3.12 - klogd 100%CPU" -->
<!-- id="" -->
<!-- inreplyto="2.3.12 - klogd 100%CPU" -->
<title>Linux-kernel mailing list archive 1999-32,: Re: 2.3.12 - klogd 100%CPU</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: 2.3.12 - klogd 100%CPU</h1>
<b>Manfred Spraul</b> (<a href="mailto:manfreds@colorfullife.com"><i>manfreds@colorfullife.com</i></a>)<br>
<i>Tue, 10 Aug 1999 11:41:29 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#343">[ date ]</a><a href="index.html#343">[ thread ]</a><a href="subject.html#343">[ subject ]</a><a href="author.html#343">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0344.html">Mailing lists: "Re: [PATCH] tty improvement for Unicode/UTF-8 mode"</a>
<li> <b>Previous message:</b> <a href="0342.html">Mailing lists: "Re: [PATCH] keyboard driver improvement for Unicode mode"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
This is a multi-part message in MIME format.<br>
--------------C71C00CDCAA9D8557D6AC32E<br>
Content-Type: text/plain; charset=us-ascii<br>
Content-Transfer-Encoding: 7bit<br>
<p>
I noticed that the synchronization in do_syslog() is completely broken<br>
on both SMP &amp; UP.<br>
Perhaps this explains why klogd stays at 100%: the CD drivers contains a<br>
bug, this causes unusual printk()'s, and this corrupted the kernel ring<br>
buffer.<br>
<p>
I've attached the patch I posted a few days ago.<br>
<p>
<pre>
--
	Manfred
--------------C71C00CDCAA9D8557D6AC32E
Content-Type: text/plain; charset=us-ascii;
 name="patch-console_lock"
Content-Transfer-Encoding: 7bit
Content-Disposition: inline;
 filename="patch-console_lock"
<p>
// $Header: /pub/cvs/ms/patches/patch-console_lock,v 1.1 1999/08/08 20:59:16 manfreds Exp $
// kernel: 2.3.12
--- 2.3/kernel/printk.c	Wed May 19 14:20:03 1999
+++ build-2.3/kernel/printk.c	Sun Aug  8 22:51:03 1999
@@ -10,6 +10,8 @@
  * elsewhere, in preparation for a serial line console (someday).
  * Ted Ts'o, 2/11/93.
  * Modified for sysctl support, 1/8/97, Chris Horn.
+ * Fixed SMP synchronization, 08/08/99, Manfred Spraul 
+ *     <a href="mailto:manfreds@colorfullife.com">manfreds@colorfullife.com</a>
  */
 
 #include &lt;linux/mm.h&gt;
@@ -40,6 +42,8 @@
 int minimum_console_loglevel = MINIMUM_CONSOLE_LOGLEVEL;
 int default_console_loglevel = DEFAULT_CONSOLE_LOGLEVEL;
 
+spinlock_t console_lock;
+
 struct console *console_drivers = NULL;
 static char log_buf[LOG_BUF_LEN];
 static unsigned long log_start = 0;
@@ -115,7 +119,7 @@
  */
 int do_syslog(int type, char * buf, int len)
 {
-	unsigned long i, j, count, flags;
+	unsigned long i, j, limit, count;
 	int do_clear = 0;
 	char c;
 	int error = -EPERM;
@@ -141,18 +145,18 @@
 		if (error)
 			goto out;
 		i = 0;
+		spin_lock_irq(&amp;console_lock);
 		while (log_size &amp;&amp; i &lt; len) {
-			c = *((char *) log_buf+log_start);
+			c = *((char *) log_buf+(log_start &amp; LOG_BUF_LEN-1));
 			log_start++;
 			log_size--;
-			log_start &amp;= LOG_BUF_LEN-1;
-			sti();
+			spin_unlock_irq(&amp;console_lock);
 			__put_user(c,buf);
 			buf++;
 			i++;
-			cli();
+			spin_lock_irq(&amp;console_lock);
 		}
-		sti();
+		spin_unlock_irq(&amp;console_lock);
 		error = i;
 		break;
 	case 4:		/* Read/clear last kernel messages */
@@ -168,26 +172,37 @@
 		error = verify_area(VERIFY_WRITE,buf,len);
 		if (error)
 			goto out;
-		/*
-		 * The logged_chars, log_start, and log_size values may
-		 * change from an interrupt, so we disable interrupts.
-		 */
-		__save_flags(flags);
-		__cli();
+		spin_lock_irq(&amp;console_lock);
 		count = len;
 		if (count &gt; LOG_BUF_LEN)
 			count = LOG_BUF_LEN;
 		if (count &gt; logged_chars)
 			count = logged_chars;
-		j = log_start + log_size - count;
-		__restore_flags(flags);
-		for (i = 0; i &lt; count; i++) {
-			c = *((char *) log_buf+(j++ &amp; (LOG_BUF_LEN-1)));
-			__put_user(c, buf++);
+		limit = log_start + log_size;
+		/*
+		 * __put_user() could sleep, and while we sleep
+		 * the printk() could overwrite the data
+		 * we try to copy to user space. Therefore
+		 * I must copy the data in reverse. &lt;manfreds&gt;
+		 */
+		for(i=0;i &lt; count;i++) {
+			j = limit-1-i;
+			if(j+LOG_BUF_LEN &lt; log_start+log_size)
+				break;
+			c = *((char*) log_buf+( j  &amp; (LOG_BUF_LEN-1)));
+			spin_unlock_irq(&amp;console_lock);
+			__put_user(c,&amp;buf[count-1-i]);
+			spin_lock_irq(&amp;console_lock);
+		}
+		spin_unlock_irq(&amp;console_lock);
+		if(i != count) {
+			/* buffer overflow during copy, correct user buffer. */
+			memmove(buf,&amp;buf[count-i],i);
 		}
+		error = i;
+
 		if (do_clear)
 			logged_chars = 0;
-		error = i;
 		break;
 	case 5:		/* Clear ring buffer */
 		logged_chars = 0;
@@ -223,9 +238,6 @@
 	return do_syslog(type, buf, len);
 }
 
-
-spinlock_t console_lock;
-
 asmlinkage int printk(const char *fmt, ...)
 {
 	va_list args;
@@ -262,10 +274,9 @@
 			log_buf[(log_start+log_size) &amp; (LOG_BUF_LEN-1)] = *p;
 			if (log_size &lt; LOG_BUF_LEN)
 				log_size++;
-			else {
+			else
 				log_start++;
-				log_start &amp;= LOG_BUF_LEN-1;
-			}
+
 			logged_chars++;
 			if (*p == '\n') {
 				line_feed = 1;
@@ -319,7 +330,7 @@
 void register_console(struct console * console)
 {
 	int	i,j,len;
-	int	p = log_start;
+	int	p = (log_start&amp; LOG_BUF_LEN-1);
 	char	buf[16];
 	signed char msg_level = -1;
 	char	*q;
<p>
<p>
<p>
<p>
<p>
--------------C71C00CDCAA9D8557D6AC32E--
<p>
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0344.html">Mailing lists: "Re: [PATCH] tty improvement for Unicode/UTF-8 mode"</a>
<li> <b>Previous message:</b> <a href="0342.html">Mailing lists: "Re: [PATCH] keyboard driver improvement for Unicode mode"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
