<!-- received="Tue Aug 10 16:47:11 1999 EET DST" -->
<!-- sent="Tue, 10 Aug 1999 14:33:34 +0100 (BST)" -->
<!-- name="Alan Cox" -->
<!-- email="alan@lxorguk.ukuu.org.uk" -->
<!-- subject="Re: Buslogic problem in 2.3.13" -->
<!-- id="E11EC26-00037J-00@the-village.bc.nu" -->
<!-- inreplyto="Pine.LNX.4.10.9908100209250.932-100000@Dragon.zathras.net" -->
<title>Linux-kernel mailing list archive 1999-32,: Re: Buslogic problem in 2.3.13</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: Buslogic problem in 2.3.13</h1>
<b>Alan Cox</b> (<a href="mailto:alan@lxorguk.ukuu.org.uk"><i>alan@lxorguk.ukuu.org.uk</i></a>)<br>
<i>Tue, 10 Aug 1999 14:33:34 +0100 (BST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#361">[ date ]</a><a href="index.html#361">[ thread ]</a><a href="subject.html#361">[ subject ]</a><a href="author.html#361">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0362.html">Alan Cox: "Re: SB1000 cable modem and /proc"</a>
<li> <b>Previous message:</b> <a href="0360.html">Jim Nance: "Loop device corruption"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
<i>&gt; In kernels 2.3.13-pre8 and 2.3.13 (possibly earlier) a bug was introduced</i><br>
<i>&gt; in the Buslogic.c module. The variable PCI_Device-&gt;resource[0] is 1 less</i><br>
<i>&gt; than it should be, and thus the check of (BaseAddress0 &amp;</i><br>
<i>&gt; PCI_BASE_ADDRESS_SPACE) fails. I've worked around it by adding 1 to the</i><br>
<i>&gt; variable PCI_Device-&gt;resource[0], but that is not the best way.</i><br>
<p>
The changes to buslogic.c are incorrect. You want these instead I think:<br>
<p>
<p>
diff -u --new-file --recursive --exclude-from ../exclude linux.13p8/drivers/scsi/BusLogic.c linux.ac/drivers/scsi/BusLogic.c<br>
--- linux.13p8/drivers/scsi/BusLogic.c	Sat Aug  7 17:56:30 1999<br>
+++ linux.ac/drivers/scsi/BusLogic.c	Sat Aug  7 18:16:58 1999<br>
@@ -783,12 +783,10 @@<br>
       unsigned int IRQ_Channel = PCI_Device-&gt;irq;<br>
       unsigned long BaseAddress0 = PCI_Device-&gt;resource[0].start;<br>
       unsigned long BaseAddress1 = PCI_Device-&gt;resource[1].start;<br>
-      BusLogic_IO_Address_T IO_Address =<br>
-	BaseAddress0 &amp; PCI_BASE_ADDRESS_IO_MASK;<br>
-      BusLogic_PCI_Address_T PCI_Address =<br>
-	BaseAddress1 &amp; PCI_BASE_ADDRESS_MEM_MASK;<br>
-      if ((BaseAddress0 &amp; PCI_BASE_ADDRESS_SPACE)<br>
-	  != PCI_BASE_ADDRESS_SPACE_IO)<br>
+      BusLogic_IO_Address_T IO_Address = BaseAddress0;<br>
+      BusLogic_PCI_Address_T PCI_Address = BaseAddress1;<br>
+      <br>
+      if (!(PCI_Device-&gt;resource[0].flags &amp; PCI_BASE_ADDRESS_SPACE_IO))<br>
 	{<br>
 	  BusLogic_Error("BusLogic: Base Address0 0x%X not I/O for "<br>
 			 "MultiMaster Host Adapter\n", NULL, BaseAddress0);<br>
@@ -796,8 +794,7 @@<br>
 			 NULL, Bus, Device, IO_Address);<br>
 	  continue;<br>
 	}<br>
-      if ((BaseAddress1 &amp; PCI_BASE_ADDRESS_SPACE)<br>
-	  != PCI_BASE_ADDRESS_SPACE_MEMORY)<br>
+      if (PCI_Device-&gt;resource[1].flags &amp; PCI_BASE_ADDRESS_SPACE_IO)<br>
 	{<br>
 	  BusLogic_Error("BusLogic: Base Address1 0x%X not Memory for "<br>
 			 "MultiMaster Host Adapter\n", NULL, BaseAddress1);<br>
@@ -986,8 +983,8 @@<br>
       unsigned char Bus = PCI_Device-&gt;bus-&gt;number;<br>
       unsigned char Device = PCI_Device-&gt;devfn &gt;&gt; 3;<br>
       unsigned int IRQ_Channel = PCI_Device-&gt;irq;<br>
-      BusLogic_IO_Address_T IO_Address =<br>
-	PCI_Device-&gt;resource[0].start &amp; PCI_BASE_ADDRESS_IO_MASK;<br>
+      BusLogic_IO_Address_T IO_Address = PCI_Device-&gt;resource[0].start;<br>
+<br>
       if (IO_Address == 0 || IRQ_Channel == 0) continue;<br>
       for (i = 0; i &lt; BusLogic_ProbeInfoCount; i++)<br>
 	{<br>
@@ -1032,13 +1029,10 @@<br>
       unsigned int IRQ_Channel = PCI_Device-&gt;irq;<br>
       unsigned long BaseAddress0 = PCI_Device-&gt;resource[0].start;<br>
       unsigned long BaseAddress1 = PCI_Device-&gt;resource[1].start;<br>
-      BusLogic_IO_Address_T IO_Address =<br>
-	BaseAddress0 &amp; PCI_BASE_ADDRESS_IO_MASK;<br>
-      BusLogic_PCI_Address_T PCI_Address =<br>
-	BaseAddress1 &amp; PCI_BASE_ADDRESS_MEM_MASK;<br>
+      BusLogic_IO_Address_T IO_Address = BaseAddress0;<br>
+      BusLogic_PCI_Address_T PCI_Address = BaseAddress1;<br>
 #ifndef CONFIG_SCSI_OMIT_FLASHPOINT<br>
-      if ((BaseAddress0 &amp; PCI_BASE_ADDRESS_SPACE)<br>
-	  != PCI_BASE_ADDRESS_SPACE_IO)<br>
+      if (!(PCI_Device-&gt;resource[0].flags &amp; PCI_BASE_ADDRESS_SPACE_IO))<br>
 	{<br>
 	  BusLogic_Error("BusLogic: Base Address0 0x%X not I/O for "<br>
 			 "FlashPoint Host Adapter\n", NULL, BaseAddress0);<br>
@@ -1046,8 +1040,7 @@<br>
 			 NULL, Bus, Device, IO_Address);<br>
 	  continue;<br>
 	}<br>
-      if ((BaseAddress1 &amp; PCI_BASE_ADDRESS_SPACE)<br>
-	  != PCI_BASE_ADDRESS_SPACE_MEMORY)<br>
+      if (PCI_Device-&gt;resource[1].flags &amp; PCI_BASE_ADDRESS_SPACE_IO)<br>
 	{<br>
 	  BusLogic_Error("BusLogic: Base Address1 0x%X not Memory for "<br>
 			 "FlashPoint Host Adapter\n", NULL, BaseAddress1);<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0362.html">Alan Cox: "Re: SB1000 cable modem and /proc"</a>
<li> <b>Previous message:</b> <a href="0360.html">Jim Nance: "Loop device corruption"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
