<!-- received="Wed Aug 11 10:19:05 1999 EET DST" -->
<!-- sent="Tue, 10 Aug 1999 19:23:50 -0500 (CDT)" -->
<!-- name="Bob_Tracy" -->
<!-- email="rct@gherkin.sa.wlk.com" -->
<!-- subject="pas16 SCSI module enhancement" -->
<!-- id="m11EMBK-000132C@gherkin.sa.wlk.com" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-32,: pas16 SCSI module enhancement</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>pas16 SCSI module enhancement</h1>
<b>Bob_Tracy</b> (<a href="mailto:rct@gherkin.sa.wlk.com"><i>rct@gherkin.sa.wlk.com</i></a>)<br>
<i>Tue, 10 Aug 1999 19:23:50 -0500 (CDT)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#421">[ date ]</a><a href="index.html#421">[ thread ]</a><a href="subject.html#421">[ subject ]</a><a href="author.html#421">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0422.html">Mofeed Shahin: "Re: 2.3.12 - klogd 100% CPU &amp;&amp; Bogus Buffer memory count"</a>
<li> <b>Previous message:</b> <a href="0420.html">Luca Montecchiani: "[2.3.13] ppp version"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
--ELM934331030-225-0_<br>
Content-Type: text/plain; charset=US-ASCII<br>
Content-Transfer-Encoding: 7bit<br>
<p>
It has been possible to build the PAS16 SCSI driver as a module for<br>
some time.  What has been missing is a way to specify the I/O address<br>
and IRQ (other than by defining PAS16_OVERRIDE at compile time) if<br>
autoprobing couldn't find the card.  The attached patches (one for<br>
2.2.11, the other for 2.3.13) correct this deficiency so that things<br>
like "modprobe pas16 pas16_addr=0x388 pas16_irq=5" will work.<br>
<p>
John Weidman and Drew Eckhardt are the last known maintainers of this<br>
driver.  I am *not* assuming ownership by submitting these patches :-).<br>
<p>
Standard disclaimers apply, including "it works for me".  The patches<br>
should apply cleanly modulo minor line number differences due to a few<br>
comments I added to the original driver code.  Thank you for your<br>
consideration.<br>
<p>
<pre>
-- 
Bob Tracy               |  "They couldn't hit an elephant at this dist- "
Firewall Security Corp. |   - Last words of Union General John Sedgwick,
<a href="mailto:rct@frus.com">rct@frus.com</a>            |  Battle of Spotsylvania Court House, U.S. Civil War
<p>
--ELM934331030-225-0_
Content-Type: text/plain; charset=US-ASCII
Content-Disposition: attachment; filename=patch11_pas16
Content-Description: /usr/src/linux-2.2/.patch/patch11_pas16
Content-Transfer-Encoding: 7bit
<p>
--- linux/drivers/scsi/pas16.c.orig	Wed Apr 15 06:45:55 1998
+++ linux/drivers/scsi/pas16.c	Tue Aug 10 19:03:32 1999
@@ -74,7 +74,6 @@
  *     software after reset using the default_irq for the
  *     current board number.
  *
- *
  * 2.  With command line overrides - pas16=port,irq may be 
  *     used on the LILO command line to override the defaults.
  *
@@ -84,6 +83,11 @@
  *     -DPAS16_OVERRIDE={{0x388, 10}}
  *     NOTE:  Untested.
  *	
+ * 4.  When included as a module, with arguments passed on the command line:
+ *         pas16_irq=xx		the interrupt
+ *         pas16_addr=xx	the port
+ *     e.g. "modprobe pas16 pas16_addr=0x388 pas16_irq=5"
+ *
  *     Note that if the override methods are used, place holders must
  *     be specified for other boards in the system.
  *
@@ -100,7 +104,11 @@
  *   interrupts.  Ie, for a board at the default 0x388 base port,
  *   boot: linux pas16=0x388,255
  *
- *     (255 is the IRQ_NONE constant in NCR5380.h)
+ *   IRQ_NONE (255) should be specified for no interrupt,
+ *   IRQ_AUTO (254) to autoprobe for an IRQ line if overridden
+ *   on the command line.
+ *
+ *   (IRQ_AUTO == 254, IRQ_NONE == 255 in NCR5380.h)
  */
  
 #ifdef MODULE
@@ -130,6 +138,8 @@
 };
 static int pas_maxi = 0;
 static int pas_wmaxi = 0;
+static unsigned short pas16_addr = 0;
+static int pas16_irq = 0;
  
 
 int scsi_irq_translate[] =
@@ -384,6 +394,22 @@
     tpnt-&gt;proc_dir = &amp;proc_scsi_pas16;
     tpnt-&gt;proc_info = &amp;pas16_proc_info;
 
+    if (pas16_addr != 0) {
+	overrides[0].io_port = pas16_addr;
+	/*
+	*  This is how we avoid seeing more than
+	*  one host adapter at the same I/O port.
+	*  Cribbed shamelessly from pas16_setup().
+	*/
+	for (count = 0; count &lt; NO_BASES; ++count)
+	    if (bases[count].io_port == pas16_addr) {
+ 		    bases[count].noauto = 1;
+		    break;
+	}
+    }
+    if (pas16_irq != 0)
+	overrides[0].irq = pas16_irq;
+
     for (count = 0; current_override &lt; NO_OVERRIDES; ++current_override) {
 	io_port = 0;
 
@@ -579,5 +605,8 @@
 Scsi_Host_Template driver_template = MV_PAS16;
 
 #include &lt;linux/module.h&gt;
+
+MODULE_PARM(pas16_addr, "h");
+MODULE_PARM(pas16_irq, "i");
 #include "scsi_module.c"
 #endif
<p>
--ELM934331030-225-0_
Content-Type: text/plain; charset=US-ASCII
Content-Disposition: attachment; filename=patch13_pas16
Content-Description: /usr/src/linux-2.3/.patch/patch13_pas16
Content-Transfer-Encoding: 7bit
<p>
--- linux/drivers/scsi/pas16.c.orig	Tue Aug 10 18:26:03 1999
+++ linux/drivers/scsi/pas16.c	Tue Aug 10 18:51:59 1999
@@ -74,7 +74,6 @@
  *     software after reset using the default_irq for the
  *     current board number.
  *
- *
  * 2.  With command line overrides - pas16=port,irq may be 
  *     used on the LILO command line to override the defaults.
  *
@@ -84,6 +83,11 @@
  *     -DPAS16_OVERRIDE={{0x388, 10}}
  *     NOTE:  Untested.
  *	
+ * 4.  When included as a module, with arguments passed on the command line:
+ *         pas16_irq=xx		the interrupt
+ *         pas16_addr=xx	the port
+ *     e.g. "modprobe pas16 pas16_addr=0x388 pas16_irq=5"
+ *
  *     Note that if the override methods are used, place holders must
  *     be specified for other boards in the system.
  *
@@ -100,7 +104,11 @@
  *   interrupts.  Ie, for a board at the default 0x388 base port,
  *   boot: linux pas16=0x388,255
  *
- *     (255 is the IRQ_NONE constant in NCR5380.h)
+ *   IRQ_NONE (255) should be specified for no interrupt,
+ *   IRQ_AUTO (254) to autoprobe for an IRQ line if overridden
+ *   on the command line.
+ *
+ *   (IRQ_AUTO == 254, IRQ_NONE == 255 in NCR5380.h)
  */
  
 #ifdef MODULE
@@ -130,6 +138,8 @@
 };
 static int pas_maxi = 0;
 static int pas_wmaxi = 0;
+static unsigned short pas16_addr = 0;
+static int pas16_irq = 0;
  
 
 int scsi_irq_translate[] =
@@ -386,6 +396,22 @@
     tpnt-&gt;proc_dir = &amp;proc_scsi_pas16;
     tpnt-&gt;proc_info = &amp;pas16_proc_info;
 
+    if (pas16_addr != 0) {
+	overrides[0].io_port = pas16_addr;
+	/*
+	*  This is how we avoid seeing more than
+	*  one host adapter at the same I/O port.
+	*  Cribbed shamelessly from pas16_setup().
+	*/
+	for (count = 0; count &lt; NO_BASES; ++count)
+	    if (bases[count].io_port == pas16_addr) {
+ 		    bases[count].noauto = 1;
+		    break;
+	}
+    }
+    if (pas16_irq != 0)
+	overrides[0].irq = pas16_irq;
+
     for (count = 0; current_override &lt; NO_OVERRIDES; ++current_override) {
 	io_port = 0;
 
@@ -581,4 +607,7 @@
 Scsi_Host_Template driver_template = MV_PAS16;
 
 #include "scsi_module.c"
+
+MODULE_PARM(pas16_addr, "h");
+MODULE_PARM(pas16_irq, "i");
 #endif
<p>
--ELM934331030-225-0_--
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0422.html">Mofeed Shahin: "Re: 2.3.12 - klogd 100% CPU &amp;&amp; Bogus Buffer memory count"</a>
<li> <b>Previous message:</b> <a href="0420.html">Luca Montecchiani: "[2.3.13] ppp version"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
