<!-- received="Wed Aug 11 20:07:44 1999 EET DST" -->
<!-- sent="Wed, 11 Aug 1999 14:48:28 +0200 (MET DST)" -->
<!-- name="Mikael Pettersson" -->
<!-- email="mikpe@csd.uu.se" -->
<!-- subject="PATCH: misc fixes for 2.3.13" -->
<!-- id="199908111248.OAA00410@harpo.csd.uu.se" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-32,: PATCH: misc fixes for 2.3.13</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>PATCH: misc fixes for 2.3.13</h1>
<b>Mikael Pettersson</b> (<a href="mailto:mikpe@csd.uu.se"><i>mikpe@csd.uu.se</i></a>)<br>
<i>Wed, 11 Aug 1999 14:48:28 +0200 (MET DST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#488">[ date ]</a><a href="index.html#488">[ thread ]</a><a href="subject.html#488">[ subject ]</a><a href="author.html#488">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0489.html">Steffen Zahn: "2.3.13: compile error in ncr53c8xx.c"</a>
<li> <b>Previous message:</b> <a href="0487.html">Jonathan Masters: "Unmounting"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Here is a set of small patches which fix a couple<br>
of problems and ugly spots in kernel 2.3.13:<br>
<p>
- fs/exec.c: missing "goto fail;" in do_coredump().<br>
  [Reported by Benjamin Redelings and Jeff Garzik several<br>
   weeks ago, but the fix never made it into 2.3.12 or 2.3.13.]<br>
<p>
- drivers/block/floppy.c: unused variable "ints[]".<br>
<p>
- drivers/char/ftape/lowlevel/ftape-setup.c: updated to use<br>
  the new __setup() mechanism.<br>
<p>
- drivers/pci/{pci.c,Makefile}: fix to make pci link properly<br>
  when building a non-modular kernel.<br>
<p>
- drivers/parport/parport_pc.c: fix typo introduced in 2.3.10.<br>
  [Reported by Vladimir Chernyshov.]<br>
<p>
- arch/i386/kernel/apm.c: remove bogus "asmlinkage" in struct decl.<br>
  This triggers a warning from gcc versions newer than 2.7.x.<br>
<p>
- arch/i386/Makefile: vmlinux.lds is a temporary file generated from<br>
  vmlinux.lds.S, so archmrproper should remove it.<br>
<p>
<p>
/Mikael<br>
<p>
<p>
--- linux-2.3.13/fs/exec.c.orig	Tue Aug 10 23:49:09 1999<br>
+++ linux-2.3.13/fs/exec.c	Wed Aug 11 14:10:56 1999<br>
@@ -811,6 +811,7 @@<br>
 	if (!binfmt || !binfmt-&gt;core_dump)<br>
 		goto fail;<br>
 	if (!current-&gt;dumpable || atomic_read(&amp;current-&gt;mm-&gt;mm_users) != 1)<br>
+		goto fail;<br>
 	current-&gt;dumpable = 0;<br>
 	if (current-&gt;rlim[RLIMIT_CORE].rlim_cur &lt; binfmt-&gt;min_coredump)<br>
 		goto fail;<br>
--- linux-2.3.13/drivers/block/floppy.c.orig	Tue Aug 10 23:48:57 1999<br>
+++ linux-2.3.13/drivers/block/floppy.c	Wed Aug 11 14:10:56 1999<br>
@@ -4365,7 +4365,6 @@<br>
 static void __init parse_floppy_cfg_string(char *cfg)<br>
 {<br>
 	char *ptr;<br>
-	int ints[11];<br>
 <br>
 	while(*cfg) {<br>
 		for(ptr = cfg;*cfg &amp;&amp; *cfg != ' ' &amp;&amp; *cfg != '\t'; cfg++);<br>
--- linux-2.3.13/drivers/char/ftape/lowlevel/ftape-setup.c.orig	Fri Jul  9 14:27:58 1999<br>
+++ linux-2.3.13/drivers/char/ftape/lowlevel/ftape-setup.c	Wed Aug 11 14:10:56 1999<br>
@@ -60,12 +60,15 @@<br>
 	{ "mach2",     &amp;ft_mach2,          CONFIG_FT_MACH2,          0,     1}<br>
 };<br>
 <br>
-void __init ftape_setup(char *str, int *ints)<br>
+static int __init ftape_setup(char *str)<br>
 {<br>
 	int i;<br>
 	int param;<br>
+	int ints[2];<br>
+<br>
 	TRACE_FUN(ft_t_flow);<br>
 <br>
+	str = get_options(str, ARRAY_SIZE(ints), ints);<br>
 	if (str) {<br>
 		for (i=0; i &lt; NR_ITEMS(config_params); i++) {<br>
 			if (strcmp(str,config_params[i].name) == 0){<br>
@@ -81,13 +84,13 @@<br>
 					      config_params[i].name,<br>
 					      config_params[i].min,<br>
 					      config_params[i].max);<br>
-					TRACE_EXIT;<br>
+					goto out;<br>
 				}<br>
 				if(config_params[i].var) {<br>
 					TRACE(ft_t_info, "%s=%d", str, param);<br>
 					*config_params[i].var = param;<br>
 				}<br>
-				TRACE_EXIT;<br>
+				goto out;<br>
 			}<br>
 		}<br>
 	}<br>
@@ -101,5 +104,8 @@<br>
 	} else {<br>
 		TRACE(ft_t_err, "botched ftape option");<br>
 	}<br>
-	TRACE_EXIT;<br>
+ out:<br>
+	TRACE_EXIT 1;<br>
 }<br>
+<br>
+__setup("ftape=", ftape_setup);<br>
--- linux-2.3.13/drivers/pci/pci.c.orig	Tue Aug 10 23:49:03 1999<br>
+++ linux-2.3.13/drivers/pci/pci.c	Wed Aug 11 14:10:56 1999<br>
@@ -197,6 +197,7 @@<br>
 	}<br>
 }<br>
 <br>
+extern void pci_namedevice(struct pci_dev *);<br>
 <br>
 unsigned int __init pci_scan_bus(struct pci_bus *bus)<br>
 {<br>
--- linux-2.3.13/drivers/pci/Makefile.orig	Tue Aug 10 23:49:03 1999<br>
+++ linux-2.3.13/drivers/pci/Makefile	Wed Aug 11 14:10:56 1999<br>
@@ -18,7 +18,7 @@<br>
 O_OBJS   = pci.o names.o<br>
 L_OBJS   := pci_syms.o<br>
 else<br>
-L_OBJS   := pci.o<br>
+L_OBJS   := pci.o names.o<br>
 endif<br>
 <br>
 ifdef CONFIG_PROC_FS<br>
--- linux-2.3.13/drivers/parport/parport_pc.c.orig	Tue Aug 10 23:49:03 1999<br>
+++ linux-2.3.13/drivers/parport/parport_pc.c	Wed Aug 11 14:10:56 1999<br>
@@ -1879,7 +1879,7 @@<br>
 			if (p-&gt;irq != PARPORT_IRQ_NONE)<br>
 				free_irq(p-&gt;irq, p);<br>
 			release_region(p-&gt;base, 3);<br>
-			if (p-&gt;size &gt; 3);<br>
+			if (p-&gt;size &gt; 3)<br>
 				release_region(p-&gt;base + 3, p-&gt;size - 3);<br>
 			if (p-&gt;modes &amp; PARPORT_MODE_ECP)<br>
 				release_region(p-&gt;base_hi, 3);<br>
--- linux-2.3.13/arch/i386/kernel/apm.c.orig	Tue Aug 10 23:48:36 1999<br>
+++ linux-2.3.13/arch/i386/kernel/apm.c	Wed Aug 11 14:10:56 1999<br>
@@ -288,7 +288,7 @@<br>
 /*<br>
  * Local variables<br>
  */<br>
-static asmlinkage struct {<br>
+static struct {<br>
 	unsigned long	offset;<br>
 	unsigned short	segment;<br>
 }				apm_bios_entry;<br>
--- linux-2.3.13/arch/i386/Makefile.orig	Thu Jul 22 12:46:44 1999<br>
+++ linux-2.3.13/arch/i386/Makefile	Wed Aug 11 14:10:56 1999<br>
@@ -111,6 +111,7 @@<br>
 	@$(MAKEBOOT) clean<br>
 <br>
 archmrproper:<br>
+	rm -f arch/i386/vmlinux.lds<br>
 <br>
 archdep:<br>
 	@$(MAKEBOOT) dep<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0489.html">Steffen Zahn: "2.3.13: compile error in ncr53c8xx.c"</a>
<li> <b>Previous message:</b> <a href="0487.html">Jonathan Masters: "Unmounting"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
