<!-- received="Thu Aug 12 07:09:11 1999 EET DST" -->
<!-- sent="12 Aug 1999 00:07:33 -0400" -->
<!-- name="Shenghuo ZHU" -->
<!-- email="zsh@cs.rochester.edu" -->
<!-- subject="Re: Symlink on VFAT" -->
<!-- id="" -->
<!-- inreplyto="Tue, 1 Jun 1999 23:56:18 -0700 (PDT)"" -->
<title>Linux-kernel mailing list archive 1999-32,: Re: Symlink on VFAT</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: Symlink on VFAT</h1>
<b>Shenghuo ZHU</b> (<a href="mailto:zsh@cs.rochester.edu"><i>zsh@cs.rochester.edu</i></a>)<br>
<i>12 Aug 1999 00:07:33 -0400</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#608">[ date ]</a><a href="index.html#608">[ thread ]</a><a href="subject.html#608">[ subject ]</a><a href="author.html#608">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0609.html">Jonathan Masters: "Re: hdd &amp; sound"</a>
<li> <b>Previous message:</b> <a href="0607.html">Jonathan Masters: "Re: [Fwd: hdd &amp; sound]"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
--=-=-=<br>
<p>
<i>&gt;&gt;&gt;&gt;&gt; "Gordon" == Gordon Chaffee &lt;<a href="mailto:chaffee@bmrc.berkeley.edu">chaffee@bmrc.berkeley.edu</a>&gt; writes:</i><br>
<p>
Gordon&gt; Thanks, I had been meaning to do this myself.  I'll try to get<br>
Gordon&gt; it incorporated.<br>
<p>
Hi, <br>
<p>
There is a big change in FAT codes of 2.2.11, so the previous patch<br>
will not work. Here is a new patch for 2.2.11. In this patch, I moved<br>
the codes to FAT. Now both MSDOS and VFAT file systems can support<br>
symlink.<br>
<p>
If anyone want to test this patch, <br>
1. apply the patch to 2.2.11<br>
2. check Filesystem/FAT symlink support<br>
3. compile and install the kernel<br>
4. mount MSDOS or VFAT file system with option symlink, i.e.<br>
        mount -t vfat -o symlink /dev/hda1 /c<br>
<p>
ChangeLog:<br>
<p>
1999-08-11  Shenghuo ZHU  &lt;<a href="mailto:zsh@cs.rochester.edu">zsh@cs.rochester.edu</a>&gt;<br>
<p>
	* fat/inode.c (fat_fill_inode): Symlink extension.<br>
	* fat/symlink.c: New file.<br>
<p>
<p>
--=-=-=<br>
Content-Type: text/x-patch<br>
Content-Disposition: attachment; filename=patch-fat-symlink-2.2.11.diff<br>
<p>
--- linux/include/linux/msdos_fs.h.orig	Wed Aug 11 17:33:32 1999<br>
+++ linux/include/linux/msdos_fs.h	Wed Aug 11 18:30:21 1999<br>
@@ -274,6 +274,13 @@<br>
 extern int fat_mmap(struct file *, struct vm_area_struct *);<br>
 extern int fat_readpage(struct file *, struct page *);<br>
 <br>
+/* symlink.c */<br>
+extern int fat_readlink (struct dentry *, char *, int);<br>
+extern struct dentry *fat_follow_link(struct dentry *, struct dentry *,<br>
+                                      unsigned int);<br>
+extern int fat_symlink (struct inode * dir, struct dentry *dentry,<br>
+                        const char * symname);<br>
+extern int fat_is_symlink(struct inode *inode);<br>
 <br>
 /* vfat.c */<br>
 extern int init_vfat_fs(void);<br>
--- linux/include/linux/msdos_fs_sb.h.orig	Wed Aug 11 16:07:00 1999<br>
+++ linux/include/linux/msdos_fs_sb.h	Wed Aug 11 18:23:31 1999<br>
@@ -24,7 +24,8 @@<br>
 		 posixfs:1,       /* Allow names like makefile and Makefile to coexist */<br>
 		 numtail:1,       /* Does first alias have a numeric '~1' type tail? */<br>
 		 atari:1,         /* Use Atari GEMDOS variation of MS-DOS fs */<br>
-		 fat32:1;	  /* Is this a FAT32 partition? */<br>
+		 fat32:1,	  /* Is this a FAT32 partition? */<br>
+                 symlink:1;	  /* support symlink */<br>
 };<br>
 <br>
 struct vfat_unicode {<br>
--- linux/fs/Config.in.orig	Wed Aug 11 16:06:50 1999<br>
+++ linux/fs/Config.in	Wed Aug 11 17:42:13 1999<br>
@@ -18,6 +18,9 @@<br>
 dep_tristate '  MSDOS fs support' CONFIG_MSDOS_FS $CONFIG_FAT_FS<br>
 dep_tristate '  UMSDOS: Unix-like filesystem on top of standard MSDOS filesystem' CONFIG_UMSDOS_FS $CONFIG_MSDOS_FS<br>
 dep_tristate '  VFAT (Windows-95) fs support' CONFIG_VFAT_FS $CONFIG_FAT_FS<br>
+if [ "$CONFIG_EXPERIMENTAL" = "y" -a "$CONFIG_FAT_FS" != "n" ]; then<br>
+  bool '  FAT symlink support (experimental)' CONFIG_FAT_SYMLINK <br>
+fi<br>
 <br>
 tristate 'ISO 9660 CDROM filesystem support' CONFIG_ISO9660_FS<br>
 if [ "$CONFIG_ISO9660_FS" != "n" ]; then<br>
--- linux/fs/fat/Makefile.orig	Wed Aug 11 17:22:43 1999<br>
+++ linux/fs/fat/Makefile	Wed Aug 11 17:23:48 1999<br>
@@ -12,4 +12,8 @@<br>
 OX_OBJS  := fatfs_syms.o<br>
 M_OBJS   := $(O_TARGET)<br>
 <br>
+ifeq ($(CONFIG_FAT_SYMLINK),y)<br>
+O_OBJS += symlink.o<br>
+endif<br>
+<br>
 include $(TOPDIR)/Rules.make<br>
--- linux/fs/fat/fatfs_syms.c.orig	Wed Aug 11 17:10:58 1999<br>
+++ linux/fs/fat/fatfs_syms.c	Wed Aug 11 19:04:13 1999<br>
@@ -59,6 +59,11 @@<br>
 EXPORT_SYMBOL(fat_readpage);<br>
 EXPORT_SYMBOL(fat_add_entries);<br>
 EXPORT_SYMBOL(fat_dir_empty);<br>
+#ifdef CONFIG_FAT_SYMLINK<br>
+EXPORT_SYMBOL(fat_symlink);<br>
+EXPORT_SYMBOL(fat_follow_link);<br>
+EXPORT_SYMBOL(fat_readlink);<br>
+#endif<br>
 <br>
 int init_fat_fs(void)<br>
 {<br>
--- linux/fs/fat/symlink.c.orig	Wed Aug 11 16:08:05 1999<br>
+++ linux/fs/fat/symlink.c	Wed Aug 11 18:25:43 1999<br>
@@ -0,0 +1,170 @@<br>
+/*<br>
+ *  linux/fs/fat/symlink.c<br>
+ *<br>
+ *  Written 1999 by Shenghuo Zhu<br>
+ *<br>
+ *  FAT symlink support. Cygwin b20 compatible.<br>
+ */<br>
+<br>
+#define __NO_VERSION__<br>
+#include &lt;linux/module.h&gt;<br>
+<br>
+#include &lt;asm/uaccess.h&gt;<br>
+#include &lt;linux/msdos_fs.h&gt;<br>
+#include "msbuffer.h"<br>
+<br>
+struct inode_operations fat_symlink_inode_operations = {<br>
+        NULL,			/* no file-operations */<br>
+        NULL,			/* create */<br>
+        NULL,			/* lookup */<br>
+        NULL,			/* link */<br>
+        NULL,			/* unlink */<br>
+        NULL,			/* symlink */<br>
+        NULL,			/* mkdir */<br>
+        NULL,			/* rmdir */<br>
+        NULL,			/* mknod */<br>
+        NULL,			/* rename */<br>
+        fat_readlink,		/* readlink */<br>
+        fat_follow_link,	/* follow_link */<br>
+        NULL,			/* readpage */<br>
+        NULL,			/* writepage */<br>
+        NULL,			/* bmap */<br>
+        NULL,			/* truncate */<br>
+        NULL,			/* permission */<br>
+        NULL			/* smap */<br>
+};<br>
+<br>
+struct dentry * fat_follow_link(struct dentry * dentry,<br>
+                                struct dentry *base,<br>
+                                unsigned int follow)<br>
+{<br>
+        struct inode *inode = dentry-&gt;d_inode;<br>
+        struct super_block *sb = inode-&gt;i_sb;<br>
+        struct buffer_head * bh = NULL;<br>
+        char * link;<br>
+        int sector=(MSDOS_I(inode)-&gt;i_start-2)*<br>
+                MSDOS_SB(sb)-&gt;cluster_size+MSDOS_SB(sb)-&gt;data_start;<br>
+        <br>
+        if (!(bh = fat_bread(sb, sector))) {<br>
+                printk("dev = %s, sector = %d\n",<br>
+                       kdevname(inode-&gt;i_dev), sector);<br>
+                dput(base);<br>
+                return ERR_PTR(-EIO);<br>
+        }<br>
+        link=bh-&gt;b_data+10;<br>
+        UPDATE_ATIME(inode);<br>
+        base = lookup_dentry(link, base, follow);<br>
+        if (bh)<br>
+                brelse(bh);<br>
+        return base;<br>
+}<br>
+<br>
+int fat_readlink (struct dentry * dentry, char * buffer, int buflen)<br>
+{<br>
+        struct inode *inode = dentry-&gt;d_inode;<br>
+        struct super_block *sb = inode-&gt;i_sb;<br>
+        struct buffer_head * bh = NULL;<br>
+        char * link;<br>
+        int i;<br>
+        int sector=(MSDOS_I(inode)-&gt;i_start-2)*<br>
+                MSDOS_SB(sb)-&gt;cluster_size+MSDOS_SB(sb)-&gt;data_start;<br>
+        <br>
+        if (buflen &gt; sb-&gt;s_blocksize - 1)<br>
+                buflen = sb-&gt;s_blocksize - 1;<br>
+        <br>
+        if (!(bh = fat_bread(sb, sector))) {<br>
+                printk("dev = %s, sector = %d\n",<br>
+                       kdevname(inode-&gt;i_dev), sector);<br>
+                fat_fs_panic(sb, "fat_readlink");<br>
+                return 0;<br>
+        }<br>
+        link=bh-&gt;b_data+10;<br>
+        i = 0;<br>
+        while (i &lt; buflen &amp;&amp; link[i])<br>
+                i++;<br>
+        if (copy_to_user(buffer, link, i))<br>
+                i = -EFAULT;<br>
+        UPDATE_ATIME(inode);<br>
+        if (bh)<br>
+                brelse (bh);<br>
+        return i;<br>
+}<br>
+<br>
+static const char fat_symlink_magic[]="!&lt;symlink&gt;";<br>
+<br>
+int fat_is_symlink(struct inode *inode)<br>
+{<br>
+        struct super_block *sb = inode-&gt;i_sb;<br>
+        int sector=(MSDOS_I(inode)-&gt;i_start-2)*<br>
+                MSDOS_SB(sb)-&gt;cluster_size+MSDOS_SB(sb)-&gt;data_start;<br>
+        struct buffer_head *bh;<br>
+        int ret;<br>
+        if (!(bh = fat_bread(sb, sector))) {<br>
+                printk("dev = %s, sector = %d\n",<br>
+                       kdevname(inode-&gt;i_dev), sector);<br>
+                fat_fs_panic(sb, "is_symlink");<br>
+                return 0;<br>
+        }<br>
+        ret =   *(unsigned long *)(bh-&gt;b_data) ==<br>
+                *(const unsigned long *)fat_symlink_magic &amp;&amp;<br>
+                *(unsigned long *)(bh-&gt;b_data+4) ==<br>
+                *(const unsigned long *)(fat_symlink_magic+4) &amp;&amp;<br>
+                *(unsigned short *)(bh-&gt;b_data+8) ==<br>
+                *(const unsigned short *)(fat_symlink_magic+8);<br>
+        fat_brelse(sb, bh);<br>
+        return ret;<br>
+}<br>
+<br>
+int fat_symlink (struct inode * dir, struct dentry *dentry,<br>
+                 const char * symname)<br>
+{<br>
+        struct inode * inode =NULL;<br>
+        struct buffer_head * bh = NULL;<br>
+        char * link;<br>
+        int i, err = -EIO;<br>
+        char c;<br>
+        const char *magic=fat_symlink_magic;<br>
+        struct super_block *sb=dir-&gt;i_sb;<br>
+        int sector;<br>
+        if (! MSDOS_SB(sb)-&gt;options.symlink) return -EPERM;<br>
+        if (! dir-&gt;i_op || ! dir-&gt;i_op-&gt;create) return -EPERM;<br>
+        if ((err=dir-&gt;i_op-&gt;create(dir, dentry, 0)) &lt; 0)<br>
+                goto out_no_entry;<br>
+        inode=dentry-&gt;d_inode;<br>
+        if ((err=fat_add_cluster(inode))&lt;0)<br>
+                goto out_no_entry;<br>
+        inode-&gt;i_mode = S_IFLNK | S_IRWXUGO;<br>
+        inode-&gt;i_op = &amp;fat_symlink_inode_operations;<br>
+        MSDOS_I(inode)-&gt;i_attrs = ATTR_SYS | ATTR_ARCH;<br>
+        sector=(MSDOS_I(inode)-&gt;i_start-2)*<br>
+                MSDOS_SB(sb)-&gt;cluster_size+MSDOS_SB(sb)-&gt;data_start;<br>
+        if (!(bh = fat_bread(sb, sector))) {<br>
+                printk("dev = %s, sector = %d\n",<br>
+                       kdevname(inode-&gt;i_dev), sector);<br>
+                fat_fs_panic(sb, "fat_symlink");<br>
+                return 0;<br>
+        }<br>
+        link = bh-&gt;b_data;<br>
+        i = 0;<br>
+        while (i &lt; inode-&gt;i_sb-&gt;s_blocksize - 1 &amp;&amp; (c = *(magic++)))<br>
+                link[i++] = c;<br>
+        while (i &lt; inode-&gt;i_sb-&gt;s_blocksize - 1 &amp;&amp; (c = *(symname++)))<br>
+                link[i++] = c;<br>
+        link[i++] = 0;<br>
+        inode-&gt;i_size = i;<br>
+        mark_inode_dirty(inode);<br>
+   <br>
+        dir-&gt;i_version = ++event;<br>
+   <br>
+        fat_mark_buffer_dirty(sb,bh, 1);<br>
+        brelse (bh);<br>
+        err = 0;<br>
+ out:<br>
+        return err;<br>
+   <br>
+ out_no_entry:<br>
+        inode-&gt;i_nlink--;<br>
+        mark_inode_dirty(inode);<br>
+        iput (inode);<br>
+        goto out;<br>
+}<br>
--- linux/fs/fat/inode.c.orig	Wed Aug 11 16:39:08 1999<br>
+++ linux/fs/fat/inode.c	Wed Aug 11 19:11:16 1999<br>
@@ -217,6 +217,9 @@<br>
 	opts-&gt;codepage = 0;<br>
 	opts-&gt;utf8 = 0;<br>
 	opts-&gt;iocharset = NULL;<br>
+#ifdef CONFIG_FAT_SYMLINK<br>
+	opts-&gt;symlink=0;<br>
+#endif<br>
 	*debug = *fat = 0;<br>
 <br>
 	if (!options)<br>
@@ -348,6 +351,10 @@<br>
 			if (!value)<br>
 				return 0;<br>
 			strncpy(cvf_options,value,100);<br>
+#ifdef CONFIG_FAT_SYMLINK<br>
+		} else if (!strcmp(this_char,"symlink")) {<br>
+                        opts-&gt;symlink = 1;<br>
+#endif<br>
 		}<br>
 <br>
 		if (this_char != options) *(this_char-1) = ',';<br>
@@ -747,6 +754,10 @@<br>
 	return 0;<br>
 }<br>
 <br>
+#ifdef CONFIG_FAT_SYMLINK<br>
+extern struct inode_operations fat_symlink_inode_operations;<br>
+#endif<br>
+<br>
 /* doesn't deal with root inode */<br>
 static void fat_fill_inode(struct inode *inode, struct msdos_dir_entry *de)<br>
 {<br>
@@ -832,6 +843,16 @@<br>
 		? date_dos2unix(CF_LE_W(de-&gt;ctime),CF_LE_W(de-&gt;cdate))<br>
 		: inode-&gt;i_mtime;<br>
 	MSDOS_I(inode)-&gt;i_ctime_ms = de-&gt;ctime_ms;<br>
+#ifdef CONFIG_FAT_SYMLINK<br>
+        if ( MSDOS_SB(sb)-&gt;options.symlink &amp;&amp;<br>
+             !S_ISDIR(inode-&gt;i_mode) &amp;&amp;<br>
+             de-&gt;attr == (ATTR_SYS | ATTR_ARCH) &amp;&amp;<br>
+             fat_is_symlink(inode)) {<br>
+                inode-&gt;i_mode = S_IRWXUGO | S_IFLNK;<br>
+                inode-&gt;i_op = &amp;fat_symlink_inode_operations;<br>
+                inode-&gt;i_flags &amp;= ~S_IMMUTABLE;<br>
+        }<br>
+#endif<br>
 }<br>
 <br>
 void fat_write_inode(struct inode *inode)<br>
--- linux/fs/vfat/namei.c.orig	Wed Aug 11 16:46:54 1999<br>
+++ linux/fs/vfat/namei.c	Wed Aug 11 18:22:11 1999<br>
@@ -1229,7 +1229,11 @@<br>
 	vfat_lookup,		/* lookup */<br>
 	NULL,			/* link */<br>
 	vfat_unlink,		/* unlink */<br>
+#ifdef CONFIG_FAT_SYMLINK<br>
+        fat_symlink,            /* symlink */<br>
+#else<br>
 	NULL,			/* symlink */<br>
+#endif<br>
 	vfat_mkdir,		/* mkdir */<br>
 	vfat_rmdir,		/* rmdir */<br>
 	NULL,			/* mknod */<br>
--- linux/fs/msdos/namei.c.orig	Wed Aug 11 16:06:51 1999<br>
+++ linux/fs/msdos/namei.c	Wed Aug 11 17:22:01 1999<br>
@@ -620,7 +620,11 @@<br>
 	msdos_lookup,		/* lookup */<br>
 	NULL,			/* link */<br>
 	msdos_unlink,		/* unlink */<br>
+#ifdef CONFIG_FAT_SYMLINK<br>
+	fat_symlink,            /* symlink */<br>
+#else<br>
 	NULL,			/* symlink */<br>
+#endif<br>
 	msdos_mkdir,		/* mkdir */<br>
 	msdos_rmdir,		/* rmdir */<br>
 	NULL,			/* mknod */<br>
<p>
--=-=-=<br>
<p>
<p>
<pre>
-- 
Shenghuo
<p>
<p>
--=-=-=--
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0609.html">Jonathan Masters: "Re: hdd &amp; sound"</a>
<li> <b>Previous message:</b> <a href="0607.html">Jonathan Masters: "Re: [Fwd: hdd &amp; sound]"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
