<!-- received="Thu Aug 12 08:22:55 1999 EET DST" -->
<!-- sent="Thu, 12 Aug 1999 07:04:03 +0200 (CEST)" -->
<!-- name="Mike Galbraith" -->
<!-- email="mikeg@weiden.de" -->
<!-- subject="Re: 2.2.11: Complicated memory leak..." -->
<!-- id="" -->
<!-- inreplyto="v04210101b3d7e4ad4a17@[130.116.145.101]" -->
<title>Linux-kernel mailing list archive 1999-32,: Re: 2.2.11: Complicated memory leak...</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: 2.2.11: Complicated memory leak...</h1>
<b>Mike Galbraith</b> (<a href="mailto:mikeg@weiden.de"><i>mikeg@weiden.de</i></a>)<br>
<i>Thu, 12 Aug 1999 07:04:03 +0200 (CEST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#619">[ date ]</a><a href="index.html#619">[ thread ]</a><a href="subject.html#619">[ subject ]</a><a href="author.html#619">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0620.html">CaT: "Re: 2.2.11: Complicated memory leak..."</a>
<li> <b>Previous message:</b> <a href="0618.html">David Rees: "Re: 2.2.11 and tulip.c issues"</a>
<li> <b>In reply to:</b> <a href="0611.html">Frank Horowitz: "Re: 2.2.11: Complicated memory leak..."</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0666.html">Alan Cox: "Re: 2.2.11: Complicated memory leak..."</a>
<li> <b>Next in thread:</b> <a href="0613.html">Marques Johansson: "Re: 2.2.11: Complicated memory leak..."</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
On Thu, 12 Aug 1999, Frank Horowitz wrote:<br>
<p>
<i>&gt; I'm now deciding between trying to compile under different versions </i><br>
<i>&gt; of gcc, or (following Mike Galbraith's suggestion) using ikd and </i><br>
<i>&gt; enabling memleak.  I'm open to advice regarding the pain/benefit </i><br>
<i>&gt; ratio of either course.</i><br>
<p>
If you do decide to try ikd, and use gcc-2.95 (or ~recent snapshot),<br>
you will need the below incremental patch.<br>
<p>
I've just build a memleak enabled ac3 kernel with gcc-2.95, and memleak<br>
appears to be working.  Tips concerning what to beat upon are welcome.<br>
<p>
	-Mike<br>
<p>
--- linux-2.2.11.ac3.ikd/arch/i386/kernel/process.c.org	Thu Aug 12 05:36:06 1999<br>
+++ linux-2.2.11.ac3.ikd/arch/i386/kernel/process.c	Thu Aug 12 05:36:48 1999<br>
@@ -707,7 +707,7 @@<br>
  * More important, however, is the fact that this allows us much<br>
  * more flexibility.<br>
  */<br>
-void __switch_to(struct task_struct *prev, struct task_struct *next)<br>
+void STDCALL(__switch_to(struct task_struct *prev, struct task_struct *next))<br>
 {<br>
 	/* Do the FPU save and set TS if it wasn't set before.. */<br>
 	unlazy_fpu(prev);<br>
--- linux-2.2.11.ac3.ikd/include/asm-i386/system.h.org	Thu Aug 12 05:32:21 1999<br>
+++ linux-2.2.11.ac3.ikd/include/asm-i386/system.h	Thu Aug 12 05:33:55 1999<br>
@@ -11,8 +11,7 @@<br>
 #ifndef CONFIG_KERNEL_DEBUGGING /* Fix the FASTCALL thing -Andrea */<br>
 extern void FASTCALL(__switch_to(struct task_struct *prev, struct task_struct *next));<br>
 #else<br>
-extern void __switch_to(struct task_struct *prev, struct task_struct *next)<br>
-			__attribute__((stdcall));<br>
+extern void STDCALL(__switch_to(struct task_struct *prev, struct task_struct *next));<br>
 #endif<br>
 <br>
 #ifdef CONFIG_KERNEL_DEBUGGING /* we can' t use FASTCALL -Andrea */<br>
--- linux-2.2.11.ac3.ikd/include/linux/kernel.h.org	Thu Aug 12 05:34:47 1999<br>
+++ linux-2.2.11.ac3.ikd/include/linux/kernel.h	Thu Aug 12 05:35:36 1999<br>
@@ -41,8 +41,10 @@<br>
 <br>
 #if defined(__i386__) &amp;&amp; !defined(CONFIG_KERNEL_DEBUGGING)<br>
 #define FASTCALL(x)	x __attribute__((regparm(3)))<br>
+#define STDCALL(x)   x<br>
 #else<br>
 #define FASTCALL(x)	x<br>
+#define STDCALL(x)   __attribute__((stdcall)) x<br>
 #endif<br>
 <br>
 extern void math_error(void);<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0620.html">CaT: "Re: 2.2.11: Complicated memory leak..."</a>
<li> <b>Previous message:</b> <a href="0618.html">David Rees: "Re: 2.2.11 and tulip.c issues"</a>
<li> <b>In reply to:</b> <a href="0611.html">Frank Horowitz: "Re: 2.2.11: Complicated memory leak..."</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0666.html">Alan Cox: "Re: 2.2.11: Complicated memory leak..."</a>
<li> <b>Next in thread:</b> <a href="0613.html">Marques Johansson: "Re: 2.2.11: Complicated memory leak..."</a>
<!-- reply="end" -->
</ul>
</font></body>
