<!-- received="Thu Aug 12 16:36:36 1999 EET DST" -->
<!-- sent="Thu, 12 Aug 1999 14:17:58 +0100 (BST)" -->
<!-- name="Alan Cox" -->
<!-- email="alan@lxorguk.ukuu.org.uk" -->
<!-- subject="Re: PATCH: was Re: 2.3.13 pci_namedevice compile error" -->
<!-- id="E11Euk5-0005KO-00@the-village.bc.nu" -->
<!-- inreplyto="37B273E3.FA9A3A08@darmstadt.gmd.de" -->
<title>Linux-kernel mailing list archive 1999-32,: Re: PATCH: was Re: 2.3.13 pci_namedevice compile error</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: PATCH: was Re: 2.3.13 pci_namedevice compile error</h1>
<b>Alan Cox</b> (<a href="mailto:alan@lxorguk.ukuu.org.uk"><i>alan@lxorguk.ukuu.org.uk</i></a>)<br>
<i>Thu, 12 Aug 1999 14:17:58 +0100 (BST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#672">[ date ]</a><a href="index.html#672">[ thread ]</a><a href="subject.html#672">[ subject ]</a><a href="author.html#672">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0673.html">Keith Duthie: "matroxfb &amp; G400"</a>
<li> <b>Previous message:</b> <a href="0671.html">Steve Dodd: "Re: msync problem in 2.3.x"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
<i>&gt; With this patch applied I could compile the kernel, but the result </i><br>
<i>&gt; fails to initialize my 53c810 adapter.</i><br>
<i>&gt; </i><br>
<i>&gt; With 2.3.13 + Alans patch I get:</i><br>
<i>&gt; </i><br>
<i>&gt; ncr53c8xx: at PCI bus 0, device 18, function 0</i><br>
<i>&gt; ncr53c8xx: disabling I/O mapping since base address 0 (0xe1000000)</i><br>
<i>&gt;            bits 0..1 indicate a non-IO mapping</i><br>
<i>&gt; ncr53c8xx: not initializing, both I/O and memory mappings disabled</i><br>
<p>
Try adding this patch on top of the other one (I dont have an NCR controller<br>
to try this so you can try it 8))<br>
<p>
--- drivers/scsi/ncr53c8xx.c~	Fri Aug  6 01:23:13 1999<br>
+++ drivers/scsi/ncr53c8xx.c	Thu Aug 12 20:26:01 1999<br>
@@ -9576,10 +9576,12 @@<br>
 */<br>
 <br>
 static int __init <br>
-pci_get_base_address(struct pci_dev *pdev, int index, u_long *base)<br>
+pci_get_base_address(struct pci_dev *pdev, int index, u_long *base, u_long *flags)<br>
 {<br>
-	*base = pdev-&gt;resource[++index].start;<br>
-	return index;<br>
+	*base = pdev-&gt;resource[index].start;<br>
+	if(flags)<br>
+		*flags = pdev-&gt;resource[index].flags;<br>
+	return ++index;<br>
 }<br>
 <br>
 /*<br>
@@ -9601,7 +9603,7 @@<br>
 #else<br>
 	uchar irq;<br>
 #endif<br>
-	ulong base, base_2, io_port; <br>
+	ulong base, base_2, io_port, io_flag, base_flag;<br>
 	int i;<br>
 #ifdef SCSI_NCR_NVRAM_SUPPORT<br>
 	ncr_nvram *nvram = device-&gt;nvram;<br>
@@ -9619,9 +9621,9 @@<br>
 	device_id = pdev-&gt;device;<br>
 	irq = pdev-&gt;irq;<br>
 	i =	0;<br>
-	i =	pci_get_base_address(pdev, i, &amp;io_port);<br>
-	i =	pci_get_base_address(pdev, i, &amp;base);<br>
-	(void)	pci_get_base_address(pdev, i, &amp;base_2);<br>
+	i =	pci_get_base_address(pdev, i, &amp;io_port, &amp;io_flag);<br>
+	i =	pci_get_base_address(pdev, i, &amp;base, &amp;base_flag);<br>
+	(void)	pci_get_base_address(pdev, i, &amp;base_2, NULL);<br>
 #else<br>
 	pcibios_read_config_word(bus, device_fn, PCI_VENDOR_ID, &amp;vendor_id);<br>
 	pcibios_read_config_word(bus, device_fn, PCI_DEVICE_ID, &amp;device_id);<br>
@@ -9809,19 +9811,17 @@<br>
 	 * Check availability of IO space, memory space and master capability.<br>
 	 */<br>
 	if (command &amp; PCI_COMMAND_IO) { <br>
-		if ((io_port &amp; 3) != 1) {<br>
+		if ((io_flag &amp; 3) != 1) {<br>
 			printk("ncr53c8xx: disabling I/O mapping since base address 0 (0x%x)\n"<br>
 				"           bits 0..1 indicate a non-IO mapping\n", (int) io_port);<br>
 			io_port = 0;<br>
 		}<br>
-		else<br>
-			io_port &amp;= PCI_BASE_ADDRESS_IO_MASK;<br>
 	}<br>
 	else<br>
 		io_port = 0;<br>
 <br>
 	if (command &amp; PCI_COMMAND_MEMORY) {<br>
-		if ((base &amp; PCI_BASE_ADDRESS_SPACE) != PCI_BASE_ADDRESS_SPACE_MEMORY) {<br>
+		if ((base_flag &amp; PCI_BASE_ADDRESS_SPACE) != PCI_BASE_ADDRESS_SPACE_MEMORY) {<br>
 			printk("ncr53c8xx: disabling memory mapping since base address 1\n"<br>
 				"            contains a non-memory mapping\n");<br>
 			base = 0;<br>
@@ -9836,8 +9836,6 @@<br>
 		printk("ncr53c8xx: not initializing, both I/O and memory mappings disabled\n");<br>
 		return -1;<br>
 	}<br>
-<br>
-	base_2 &amp;= PCI_BASE_ADDRESS_MEM_MASK;<br>
 <br>
 	if (io_port &amp;&amp; check_region (io_port, 128)) {<br>
 #ifdef __sparc__<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0673.html">Keith Duthie: "matroxfb &amp; G400"</a>
<li> <b>Previous message:</b> <a href="0671.html">Steve Dodd: "Re: msync problem in 2.3.x"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
