<!-- received="Thu Aug 12 22:38:26 1999 EET DST" -->
<!-- sent="Thu, 12 Aug 1999 21:27:51 +0200" -->
<!-- name="Petr Vandrovec" -->
<!-- email="vandrove@vc.cvut.cz" -->
<!-- subject="Re: New resources - pls, explain :-(" -->
<!-- id="" -->
<!-- inreplyto="Pine.LNX.4.10.9908121154450.5704-100000@penguin.transmeta.com" -->
<title>Linux-kernel mailing list archive 1999-32,: Re: New resources - pls, explain :-(</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: New resources - pls, explain :-(</h1>
<b>Petr Vandrovec</b> (<a href="mailto:vandrove@vc.cvut.cz"><i>vandrove@vc.cvut.cz</i></a>)<br>
<i>Thu, 12 Aug 1999 21:27:51 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#746">[ date ]</a><a href="index.html#746">[ thread ]</a><a href="subject.html#746">[ subject ]</a><a href="author.html#746">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0747.html">Micahel Zappe: "Question about hard links..."</a>
<li> <b>Previous message:</b> <a href="0745.html">Robert J. Hale III: "Want address for EXT3 development group"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hi Linus,<br>
<i>&gt; 	inline unsigned int readl(unsigned int address)</i><br>
<i>&gt; 	{</i><br>
<i>&gt; 		if (address &lt; xxx)</i><br>
<i>&gt; 			return pci_readl(address);</i><br>
<i>&gt; 		if (address &lt; yyy)</i><br>
<i>&gt; 			return vme_readl(address);</i><br>
<i>&gt; 		if (address &lt; zzz)</i><br>
<i>&gt; 			return zorro_readl(address);</i><br>
<i>&gt; 	}</i><br>
No one wants this, I think... It does not cover i2c and if something<br>
other can use ioremap/xxx_readl, it can use little-endian readl<br>
too. Maybe we could push gcc team to optimize (some pseudoasm)<br>
   loadle  xx,%0<br>
   bswap   %0<br>
into<br>
   loadbe  xx,%0<br>
and vice versa? Networking could benefit from this too. And it<br>
should be trivial comparing to alias analysis :-)<br>
<i>&gt; I think we'll just define "readl()" to to be little-endian, and then that</i><br>
<i>&gt; problem is gone. That takes care of 99% of the market right now, so it</i><br>
Can I asume that you (we?) just defined it? Now there is only two<br>
outstanding issue: Is it defined whether readl()/writel() does rmb/wmb/mb <br>
before/after memory access (remove what does not apply) or is it<br>
architecture dependent (as it is currently)? And second issue,<br>
what type should be parameter to readl/writel? unsigned long or void*?<br>
Driver uses both, void* is more frequent than unsigned long.<br>
  And if we are talking about readl/writel, isn't time to fix i386<br>
drivers for removing (xxx | PAGE_OFFSET) from readx/writex? I'm<br>
using following patch for about year and only warning message I'm<br>
getting is from 'EISA' check during bootup (which can be fixed<br>
by using bus_to_virt(0xFFFD9)...).<br>
					Best regards,<br>
						Petr Vandrovec<br>
						<a href="mailto:vandrove@vc.cvut.cz">vandrove@vc.cvut.cz</a><br>
<p>
(of course, this patch is not intended for inclusion into 2.3.x,<br>
but ISA devices maintainers should try this if they are not sure...)<br>
<p>
diff -urdN linux/include/asm-i386/io.h linux/include/asm-i386/io.h<br>
--- linux/include/asm-i386/io.h	Thu May 13 23:42:31 1999<br>
+++ linux/include/asm-i386/io.h	Sat Aug  7 22:21:44 1999<br>
@@ -101,8 +101,8 @@<br>
 #include &lt;linux/vmalloc.h&gt;<br>
 #include &lt;asm/page.h&gt;<br>
 <br>
-#define __io_virt(x)		((void *)(PAGE_OFFSET | (unsigned long)(x)))<br>
-#define __io_phys(x)		((unsigned long)(x) &amp; ~PAGE_OFFSET)<br>
+#define __io_virt(x)		((void *)(PAGE_OFFSET + (unsigned long)(x)))<br>
+#define __io_phys(x)		((unsigned long)(x) - PAGE_OFFSET)<br>
 /*<br>
  * Change virtual addresses to physical addresses and vv.<br>
  * These are pretty trivial<br>
@@ -149,30 +149,38 @@<br>
  * memory location directly.<br>
  */<br>
 <br>
+extern inline unsigned long __io_virt2(void* addr) {<br>
+	if ((unsigned long)addr &lt; PAGE_OFFSET) {<br>
+		printk("Sorry, access to %lX at %p\n", (unsigned long)addr, __builtin_return_address(0));<br>
+		(unsigned long)addr += PAGE_OFFSET;<br>
+	}<br>
+	return (unsigned long)addr;<br>
+}<br>
-#define readb(addr) (*(volatile unsigned char *) __io_virt(addr))<br>
-#define readw(addr) (*(volatile unsigned short *) __io_virt(addr))<br>
-#define readl(addr) (*(volatile unsigned int *) __io_virt(addr))<br>
 <br>
+#define readb(addr) (*(volatile unsigned char *) __io_virt2(addr))<br>
+#define readw(addr) (*(volatile unsigned short *) __io_virt2(addr))<br>
+#define readl(addr) (*(volatile unsigned int *) __io_virt2(addr))<br>
-#define writeb(b,addr) (*(volatile unsigned char *) __io_virt(addr) = (b))<br>
-#define writew(b,addr) (*(volatile unsigned short *) __io_virt(addr) = (b))<br>
-#define writel(b,addr) (*(volatile unsigned int *) __io_virt(addr) = (b))<br>
 <br>
+#define writeb(b,addr) (*(volatile unsigned char *) __io_virt2(addr) = (b))<br>
+#define writew(b,addr) (*(volatile unsigned short *) __io_virt2(addr) = (b))<br>
+#define writel(b,addr) (*(volatile unsigned int *) __io_virt2(addr) = (b))<br>
+<br>
-#define memset_io(a,b,c)	memset(__io_virt(a),(b),(c))<br>
-#define memcpy_fromio(a,b,c)	memcpy((a),__io_virt(b),(c))<br>
-#define memcpy_toio(a,b,c)	memcpy(__io_virt(a),(b),(c))<br>
+#define memset_io(a,b,c)	memset(__io_virt2(a),(b),(c))<br>
+#define memcpy_fromio(a,b,c)	memcpy((a),__io_virt2(b),(c))<br>
+#define memcpy_toio(a,b,c)	memcpy(__io_virt2(a),(b),(c))<br>
 <br>
 /*<br>
  * Again, i386 does not require mem IO specific function.<br>
  */<br>
 <br>
-#define eth_io_copy_and_sum(a,b,c,d)	eth_copy_and_sum((a),__io_virt(b),(c),(d))<br>
+#define eth_io_copy_and_sum(a,b,c,d)	eth_copy_and_sum((a),__io_virt2(b),(c),(d))<br>
 <br>
 static inline int check_signature(unsigned long io_addr,<br>
 	const unsigned char *signature, int length)<br>
 {<br>
 	int retval = 0;<br>
 	do {<br>
-		if (readb(io_addr) != *signature)<br>
+		if (readb((void*)io_addr) != *signature)<br>
 			goto out;<br>
 		io_addr++;<br>
 		signature++;<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0747.html">Micahel Zappe: "Question about hard links..."</a>
<li> <b>Previous message:</b> <a href="0745.html">Robert J. Hale III: "Want address for EXT3 development group"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
