<!-- received="Fri Aug 13 01:51:34 1999 EET DST" -->
<!-- sent="Thu, 12 Aug 1999 21:37:18 +0200 (CEST)" -->
<!-- name="Andrea Arcangeli" -->
<!-- email="andrea@suse.de" -->
<!-- subject="Re: 2.3.12 - klogd 100%CPU" -->
<!-- id="" -->
<!-- inreplyto="37B30447.9AC48100@colorfullife.com" -->
<title>Linux-kernel mailing list archive 1999-32,: Re: 2.3.12 - klogd 100%CPU</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: 2.3.12 - klogd 100%CPU</h1>
<b>Andrea Arcangeli</b> (<a href="mailto:andrea@suse.de"><i>andrea@suse.de</i></a>)<br>
<i>Thu, 12 Aug 1999 21:37:18 +0200 (CEST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#750">[ date ]</a><a href="index.html#750">[ thread ]</a><a href="subject.html#750">[ subject ]</a><a href="author.html#750">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0751.html">Joerg Pommnitz: "Re: PATCH: was Re: 2.3.13 pci_namedevice compile error"</a>
<li> <b>Previous message:</b> <a href="0749.html">B.W. McAdams: "Re: RealMagic DVD-cards"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
On Thu, 12 Aug 1999, Manfred Spraul wrote:<br>
<p>
<i>&gt;* my patch guarantees that syslog(3) will only return valid data, i.e.</i><br>
<i>&gt;it will refuse to return data which was already overwritten.</i><br>
<p>
There's no one difference in returning random data or writing nothing to<br>
the buffer. If you really want to fix this minor issue at the expense of<br>
allocing a tmp-kernel buffer see the below patch.<br>
<p>
<i>&gt;* register_console(CON_PRINTBUFFER) could use the wrong msg_level for</i><br>
<i>&gt;the first line.</i><br>
<p>
I think you are wrong. The current code seems fine.<br>
<p>
<i>&gt;* console_print() must not use spin_lock_irq(), it needs</i><br>
<i>&gt;spin_lock_irqsave().</i><br>
<p>
Also all other functions (except do_syslog) needs the irqsave version.<br>
Thanks for pointing this out.<br>
<p>
Here it is my updated patch where I address the two points you raised<br>
above.<br>
<p>
Against 2.3.13 (but applyes cleanly also against 2.2.11):<br>
<p>
--- 2.3.13/kernel/printk.c	Thu Aug 12 02:53:25 1999<br>
+++ 2.3.13-printk/kernel/printk.c	Thu Aug 12 21:30:05 1999<br>
@@ -17,6 +17,7 @@<br>
 #include &lt;linux/smp_lock.h&gt;<br>
 #include &lt;linux/console.h&gt;<br>
 #include &lt;linux/init.h&gt;<br>
+#include &lt;linux/slab.h&gt;<br>
 <br>
 #include &lt;asm/uaccess.h&gt;<br>
 <br>
@@ -46,6 +47,7 @@<br>
 static unsigned long logged_chars = 0;<br>
 struct console_cmdline console_cmdline[MAX_CMDLINECONSOLES];<br>
 static int preferred_console = -1;<br>
+spinlock_t console_lock = SPIN_LOCK_UNLOCKED;<br>
 <br>
 /*<br>
  *	Setup a list of consoles. Called from init/main.c<br>
@@ -117,12 +119,12 @@<br>
  */<br>
 int do_syslog(int type, char * buf, int len)<br>
 {<br>
-	unsigned long i, j, count, flags;<br>
+	unsigned long i, j, count;<br>
 	int do_clear = 0;<br>
 	char c;<br>
 	int error = -EPERM;<br>
+	char * tmp_buf;<br>
 <br>
-	lock_kernel();<br>
 	error = 0;<br>
 	switch (type) {<br>
 	case 0:		/* Close log */<br>
@@ -143,18 +145,19 @@<br>
 		if (error)<br>
 			goto out;<br>
 		i = 0;<br>
+		spin_lock_irq(&amp;console_lock);<br>
 		while (log_size &amp;&amp; i &lt; len) {<br>
 			c = *((char *) log_buf+log_start);<br>
 			log_start++;<br>
 			log_size--;<br>
 			log_start &amp;= LOG_BUF_LEN-1;<br>
-			sti();<br>
+			spin_unlock_irq(&amp;console_lock);<br>
 			__put_user(c,buf);<br>
 			buf++;<br>
 			i++;<br>
-			cli();<br>
+			spin_lock_irq(&amp;console_lock);<br>
 		}<br>
-		sti();<br>
+		spin_unlock_irq(&amp;console_lock);<br>
 		error = i;<br>
 		break;<br>
 	case 4:		/* Read/clear last kernel messages */<br>
@@ -170,43 +173,65 @@<br>
 		error = verify_area(VERIFY_WRITE,buf,len);<br>
 		if (error)<br>
 			goto out;<br>
-		/*<br>
-		 * The logged_chars, log_start, and log_size values may<br>
-		 * change from an interrupt, so we disable interrupts.<br>
-		 */<br>
-		__save_flags(flags);<br>
-		__cli();<br>
+	realloc_buf:<br>
 		count = len;<br>
 		if (count &gt; LOG_BUF_LEN)<br>
 			count = LOG_BUF_LEN;<br>
+		spin_lock_irq(&amp;console_lock);<br>
 		if (count &gt; logged_chars)<br>
 			count = logged_chars;<br>
+		spin_unlock_irq(&amp;console_lock);<br>
+		tmp_buf = kmalloc(count, GFP_KERNEL);<br>
+		if (!tmp_buf)<br>
+			goto out;<br>
+		/* The logged_chars, log_start, and log_size are serialized<br>
+		   by the console_lock (the console_lock can be acquired also<br>
+		   from irqs by printk). */<br>
+		spin_lock_irq(&amp;console_lock);<br>
+		if (count &gt; logged_chars)<br>
+		{<br>
+			spin_unlock_irq(&amp;console_lock);<br>
+			kfree(tmp_buf);<br>
+			goto realloc_buf;<br>
+		}<br>
 		j = log_start + log_size - count;<br>
-		__restore_flags(flags);<br>
 		for (i = 0; i &lt; count; i++) {<br>
 			c = *((char *) log_buf+(j++ &amp; (LOG_BUF_LEN-1)));<br>
-			__put_user(c, buf++);<br>
+			*(tmp_buf+i) = c;<br>
 		}<br>
 		if (do_clear)<br>
+			/* the increment done in printk may undo our<br>
+			   not atomic assigment if we do it without the<br>
+			   console lock held. */<br>
 			logged_chars = 0;<br>
+		spin_unlock_irq(&amp;console_lock);<br>
+		copy_to_user(buf, tmp_buf, count);<br>
 		error = i;<br>
 		break;<br>
 	case 5:		/* Clear ring buffer */<br>
+		spin_lock_irq(&amp;console_lock);<br>
 		logged_chars = 0;<br>
+		spin_unlock_irq(&amp;console_lock);<br>
 		break;<br>
 	case 6:		/* Disable logging to console */<br>
+		spin_lock_irq(&amp;console_lock);<br>
 		console_loglevel = minimum_console_loglevel;<br>
+		spin_unlock_irq(&amp;console_lock);<br>
 		break;<br>
 	case 7:		/* Enable logging to console */<br>
+		spin_lock_irq(&amp;console_lock);<br>
 		console_loglevel = default_console_loglevel;<br>
+		spin_unlock_irq(&amp;console_lock);<br>
 		break;<br>
 	case 8:<br>
 		error = -EINVAL;<br>
 		if (len &lt; 1 || len &gt; 8)<br>
 			goto out;<br>
+		spin_lock_irq(&amp;console_lock);<br>
 		if (len &lt; minimum_console_loglevel)<br>
 			len = minimum_console_loglevel;<br>
 		console_loglevel = len;<br>
+		spin_unlock_irq(&amp;console_lock);<br>
 		error = 0;<br>
 		break;<br>
 	default:<br>
@@ -214,7 +239,6 @@<br>
 		break;<br>
 	}<br>
 out:<br>
-	unlock_kernel();<br>
 	return error;<br>
 }<br>
 <br>
@@ -226,8 +250,6 @@<br>
 }<br>
 <br>
 <br>
-spinlock_t console_lock;<br>
-<br>
 asmlinkage int printk(const char *fmt, ...)<br>
 {<br>
 	va_list args;<br>
@@ -292,24 +314,33 @@<br>
 <br>
 void console_print(const char *s)<br>
 {<br>
-	struct console *c = console_drivers;<br>
+	struct console *c;<br>
 	int len = strlen(s);<br>
+	unsigned long flags;<br>
 <br>
+	spin_lock_irqsave(&amp;console_lock, flags);<br>
+	c = console_drivers;<br>
 	while(c) {<br>
 		if ((c-&gt;flags &amp; CON_ENABLED) &amp;&amp; c-&gt;write)<br>
 			c-&gt;write(c, s, len);<br>
 		c = c-&gt;next;<br>
 	}<br>
+	spin_unlock_irqrestore(&amp;console_lock, flags);<br>
 }<br>
 <br>
 void unblank_console(void)<br>
 {<br>
-	struct console *c = console_drivers;<br>
+	struct console *c;<br>
+	unsigned long flags;<br>
+<br>
+	spin_lock_irqsave(&amp;console_lock, flags);<br>
+	c = console_drivers;<br>
 	while(c) {<br>
 		if ((c-&gt;flags &amp; CON_ENABLED) &amp;&amp; c-&gt;unblank)<br>
 			c-&gt;unblank();<br>
 		c = c-&gt;next;<br>
 	}<br>
+	spin_unlock_irqrestore(&amp;console_lock, flags);<br>
 }<br>
 <br>
 /*<br>
@@ -321,10 +352,11 @@<br>
 void register_console(struct console * console)<br>
 {<br>
 	int	i,j,len;<br>
-	int	p = log_start;<br>
+	int	p;<br>
 	char	buf[16];<br>
 	signed char msg_level = -1;<br>
 	char	*q;<br>
+	unsigned long flags;<br>
 <br>
 	/*<br>
 	 *	See if we want to use this console driver. If we<br>
@@ -370,6 +402,7 @@<br>
 	 *	Put this console in the list - keep the<br>
 	 *	preferred driver at the head of the list.<br>
 	 */<br>
+	spin_lock_irqsave(&amp;console_lock, flags);<br>
 	if ((console-&gt;flags &amp; CON_CONSDEV) || console_drivers == NULL) {<br>
 		console-&gt;next = console_drivers;<br>
 		console_drivers = console;<br>
@@ -377,12 +410,15 @@<br>
 		console-&gt;next = console_drivers-&gt;next;<br>
 		console_drivers-&gt;next = console;<br>
 	}<br>
+	spin_unlock_irqrestore(&amp;console_lock, flags);<br>
+<br>
 	if ((console-&gt;flags &amp; CON_PRINTBUFFER) == 0) return;<br>
 <br>
 	/*<br>
 	 *	Print out buffered log messages.<br>
 	 */<br>
-	for (i=0,j=0; i &lt; log_size; i++) {<br>
+	spin_lock_irqsave(&amp;console_lock, flags);<br>
+	for (p=log_start,i=0,j=0; i &lt; log_size; i++) {<br>
 		buf[j++] = log_buf[p];<br>
 		p++; p &amp;= LOG_BUF_LEN-1;<br>
 		if (buf[j-1] != '\n' &amp;&amp; i &lt; log_size - 1 &amp;&amp; j &lt; sizeof(buf)-1)<br>
@@ -401,26 +437,32 @@<br>
 			msg_level = -1;<br>
 		j = 0;<br>
 	}<br>
+	spin_unlock_irqrestore(&amp;console_lock, flags);<br>
 }<br>
 <br>
 <br>
 int unregister_console(struct console * console)<br>
 {<br>
         struct console *a,*b;<br>
+	int ret = 0;<br>
+	unsigned long flags;<br>
 	<br>
+	spin_lock_irqsave(&amp;console_lock, flags);<br>
 	if (console_drivers == console) {<br>
 		console_drivers=console-&gt;next;<br>
-		return (0);<br>
+		goto out;<br>
 	}<br>
 	for (a=console_drivers-&gt;next, b=console_drivers ;<br>
 	     a; b=a, a=b-&gt;next) {<br>
 		if (a == console) {<br>
 			b-&gt;next = a-&gt;next;<br>
-			return 0;<br>
+			goto out;<br>
 		}  <br>
 	}<br>
-	<br>
-	return (1);<br>
+	ret = 1;<br>
+ out:<br>
+	spin_unlock_irqrestore(&amp;console_lock, flags);<br>
+	return ret;<br>
 }<br>
 	<br>
 /*<br>
<p>
<p>
Andrea<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0751.html">Joerg Pommnitz: "Re: PATCH: was Re: 2.3.13 pci_namedevice compile error"</a>
<li> <b>Previous message:</b> <a href="0749.html">B.W. McAdams: "Re: RealMagic DVD-cards"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
