<!-- received="Fri Aug 13 08:42:08 1999 EET DST" -->
<!-- sent="Thu, 12 Aug 1999 22:19:14 +0200" -->
<!-- name="Manfred Spraul" -->
<!-- email="manfreds@colorfullife.com" -->
<!-- subject="Re: 2.3.12 - klogd 100%CPU" -->
<!-- id="" -->
<!-- inreplyto="2.3.12 - klogd 100%CPU" -->
<title>Linux-kernel mailing list archive 1999-32,: Re: 2.3.12 - klogd 100%CPU</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: 2.3.12 - klogd 100%CPU</h1>
<b>Manfred Spraul</b> (<a href="mailto:manfreds@colorfullife.com"><i>manfreds@colorfullife.com</i></a>)<br>
<i>Thu, 12 Aug 1999 22:19:14 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#775">[ date ]</a><a href="index.html#775">[ thread ]</a><a href="subject.html#775">[ subject ]</a><a href="author.html#775">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0776.html">Richard B. Johnson: "Kernel-dependent utmp??"</a>
<li> <b>Previous message:</b> <a href="0774.html">Nat Lanza: "Re: More file flags"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Andrea Arcangeli wrote:<br>
<i>&gt; </i><br>
<i>&gt; There's no one difference in returning random data or writing nothing to</i><br>
<i>&gt; the buffer. If you really want to fix this minor issue at the expense of</i><br>
<i>&gt; allocing a tmp-kernel buffer see the below patch.</i><br>
But now my solution is far better. Alloc memory, check that you have<br>
enough mem, realloc otherwise, ...<br>
All I have to do is copy the data from the end to the beginning, then I<br>
stop automagically as soon as I collide with parallel printk()'s.<br>
<p>
<i>&gt; &gt;* register_console(CON_PRINTBUFFER) could use the wrong msg_level for</i><br>
<i>&gt; &gt;the first line.</i><br>
<i>&gt; I think you are wrong. The current code seems fine.</i><br>
<p>
After a wrap-around, the first line could be incomplete. This means that<br>
the first line does not start with a "&lt;?&gt;", and thus the line "msg_level<br>
= buf[1] - '0';" is not perfect. [I use default_message_loglevel for a<br>
incomplete first line]. It's not important.<br>
<p>
Btw, what about adding something like this to your IKD kernel?<br>
<i>&gt;&gt;&gt;&gt;&gt;&gt;&gt;&gt;&gt;</i><br>
--- 2.3/include/asm-i386/spinlock.h     Sat Jun 26 11:52:55 1999<br>
+++ build-2.3/include/asm-i386/spinlock.h       Thu Aug 12 19:27:00 1999<br>
@@ -7,7 +7,7 @@<br>
  * &lt;linux/spinlock.h&gt; with all of this. Oh, well.<br>
  */<br>
 #define spin_lock_irqsave(lock, flags)         do {<br>
local_irq_save(flags);       spin_lock(lock); } while (0)<br>
-#define spin_lock_irq(lock)                    do {<br>
local_irq_disable();         spin_lock(lock); } while (0)<br>
+#define spin_lock_irq(lock)                    do { unsigned long<br>
flags; local_irq_save(flags); if( (flags&amp;(1&lt;&lt;9)) ==0) printk("spinlock<br>
bad: %lxh\n",lock);         spin_lock(lock); } while (0)<br>
 #define spin_lock_bh(lock)                     do {<br>
local_bh_disable();          spin_lock(lock); } while (0)<br>
 <br>
 #define read_lock_irqsave(lock, flags)         do {<br>
local_irq_save(flags);       read_lock(lock); } while (0)<br>
&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;&lt;<br>
I tried this, and I only found the spin_lock_irq(&amp;runqueue_lock) -call<br>
in sched.c, line 679.<br>
[This is not a bug. do_bottom_half always returns with interrupts<br>
disabled even if it was<br>
called with interrupts enabled.]<br>
<p>
<pre>
--
	Manfred
<p>
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0776.html">Richard B. Johnson: "Kernel-dependent utmp??"</a>
<li> <b>Previous message:</b> <a href="0774.html">Nat Lanza: "Re: More file flags"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
