<!-- received="Fri Aug 13 09:45:19 1999 EET DST" -->
<!-- sent="Thu, 12 Aug 1999 21:12:59 -0400 (EDT)" -->
<!-- name="Chuck Lever" -->
<!-- email="cel@monkey.org" -->
<!-- subject="Re: filemap_nopage() tries to copy to page 0, eek." -->
<!-- id="" -->
<!-- inreplyto="00a701bee4c5$c61afbe0$b041dec2@frodo" -->
<title>Linux-kernel mailing list archive 1999-32,: Re: filemap_nopage() tries to copy to page 0, eek.</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: filemap_nopage() tries to copy to page 0, eek.</h1>
<b>Chuck Lever</b> (<a href="mailto:cel@monkey.org"><i>cel@monkey.org</i></a>)<br>
<i>Thu, 12 Aug 1999 21:12:59 -0400 (EDT)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#782">[ date ]</a><a href="index.html#782">[ thread ]</a><a href="subject.html#782">[ subject ]</a><a href="author.html#782">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0783.html">thomas.putnam@natinst.com: "Re: Problems writting a CHAR Driver with interruptible_sleep"</a>
<li> <b>Previous message:</b> <a href="0781.html">Arthur: "Re: 2.3.13"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
On Thu, 12 Aug 1999, Steve Dodd wrote:<br>
<i>&gt; Err, yes, 2.3.12 and 2.3.13 (I think). I'm away from my machine at the</i><br>
<i>&gt; moment so I can't check, but I was using whatever was current when I posted</i><br>
<i>&gt; the message. The simplest option seemed to be to stick a</i><br>
<i>&gt; </i><br>
<i>&gt; if (!new_page)</i><br>
<i>&gt;     new_page = page_cache_alloc();</i><br>
<i>&gt; </i><br>
<i>&gt; just before we attempt to copy to new_page, but I was wondering if we could</i><br>
<i>&gt; overlap the page allocation for new_page and the previous -&gt;readpage()..</i><br>
<p>
here's a cleaner patch i came up with flying back from san jose.  it's<br>
against 2.3.10, but should apply to 2.3.1[23] without much fiddling.<br>
essentially it's the same as what i described yesterday, but there's some<br>
additional clean-up and extra comments that go along with the deletion of<br>
redundant code.  i've been testing a more complicated variant of this for<br>
a few weeks, and haven't seen any trouble with it.<br>
<p>
Steve, can you try this out and let me know if it helps?<br>
<p>
--- linux-2.3.10-ref/mm/filemap.c	Sat Jul 10 12:27:06 1999<br>
+++ linux/mm/filemap.c	Thu Aug 12 16:03:00 1999<br>
@@ -1302,7 +1302,6 @@<br>
 	if (!page)<br>
 		goto no_cached_page;<br>
 <br>
-found_page:<br>
 	/*<br>
 	 * Ok, found a page in the page cache, now we need to check<br>
 	 * that it's up-to-date.  First check whether we'll need an<br>
@@ -1314,12 +1313,8 @@<br>
 			goto failure;<br>
 	}<br>
 <br>
-	if (!Page_Uptodate(page)) {<br>
-		lock_page(page);<br>
-		if (!Page_Uptodate(page))<br>
-			goto page_not_uptodate;<br>
-		UnlockPage(page);<br>
-	}<br>
+	if (!Page_Uptodate(page))<br>
+		goto page_not_uptodate;<br>
 <br>
 success:<br>
 	/*<br>
@@ -1358,44 +1353,28 @@<br>
 	for (i = 1 &lt;&lt; page_cluster; i &gt; 0; --i, reada += PAGE_CACHE_SIZE)<br>
 		new_page = try_to_read_ahead(file, reada, new_page);<br>
 <br>
-	if (!new_page)<br>
-		new_page = page_cache_alloc();<br>
-	if (!new_page)<br>
-		goto no_page;<br>
-<br>
 	/*<br>
-	 * During getting the above page we might have slept,<br>
-	 * so we need to re-check the situation with the page<br>
-	 * cache.. The page we just got may be useful if we<br>
-	 * can't share, so don't get rid of it here.<br>
+	 * The page we want has now been added to the page cache.<br>
+	 * In the unlikely event that someone removed it in the<br>
+	 * meantime, we'll just come back here and read it again.<br>
 	 */<br>
-	page = __find_get_page(inode, offset, hash);<br>
-	if (page)<br>
-		goto found_page;<br>
-<br>
-	/*<br>
-	 * Now, create a new page-cache page from the page we got<br>
-	 */<br>
-	page = page_cache_entry(new_page);<br>
-	if (add_to_page_cache_unique(page, inode, offset, hash))<br>
-		goto retry_find;<br>
-<br>
-	/*<br>
-	 * Now it's ours and locked, we can do initial IO to it:<br>
-	 */<br>
-	new_page = 0;<br>
+	goto retry_find;<br>
 <br>
 page_not_uptodate:<br>
+	lock_page(page);<br>
+	if (Page_Uptodate(page)) {<br>
+		UnlockPage(page);<br>
+		goto success;<br>
+	}<br>
+<br>
 	error = inode-&gt;i_op-&gt;readpage(file, page);<br>
 <br>
 	if (!error) {<br>
 		wait_on_page(page);<br>
-		if (PageError(page))<br>
-			goto page_read_error;<br>
-		goto success;<br>
+		if (Page_Uptodate(page))<br>
+			goto success;<br>
 	}<br>
 <br>
-page_read_error:<br>
 	/*<br>
 	 * Umm, take care of errors if the page isn't up-to-date.<br>
 	 * Try to re-read it _once_. We do this synchronously,<br>
<p>
	- Chuck Lever<br>
<pre>
--
corporate:	&lt;<a href="mailto:chuckl@netscape.com">chuckl@netscape.com</a>&gt;
personal:	&lt;<a href="mailto:chucklever@netscape.net">chucklever@netscape.net</a>&gt; or &lt;cel@monkey.org&gt;
<p>
The Linux Scalability project:
	<a href="http://www.citi.umich.edu/projects/linux-scalability/">http://www.citi.umich.edu/projects/linux-scalability/</a>
<p>
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0783.html">thomas.putnam@natinst.com: "Re: Problems writting a CHAR Driver with interruptible_sleep"</a>
<li> <b>Previous message:</b> <a href="0781.html">Arthur: "Re: 2.3.13"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
