<!-- received="Fri Aug 13 17:09:54 1999 EET DST" -->
<!-- sent="Fri, 13 Aug 1999 04:59:38 -0700" -->
<!-- name="David S. Miller" -->
<!-- email="davem@redhat.com" -->
<!-- subject="PATCH (was Possible Linux/Solaris 7 TCP bug)" -->
<!-- id="199908131159.EAA00930@pizda.davem.net" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-32,: PATCH (was Possible Linux/Solaris 7 TCP bug)</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>PATCH (was Possible Linux/Solaris 7 TCP bug)</h1>
<b>David S. Miller</b> (<a href="mailto:davem@redhat.com"><i>davem@redhat.com</i></a>)<br>
<i>Fri, 13 Aug 1999 04:59:38 -0700</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#843">[ date ]</a><a href="index.html#843">[ thread ]</a><a href="subject.html#843">[ subject ]</a><a href="author.html#843">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0844.html">Jes Sorensen: "Re: New resources - pls, explain :-("</a>
<li> <b>Previous message:</b> <a href="0842.html">Juan J. Quintela: "General Protection Fault in forget_segments"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0852.html">Ilpo Ruotsalainen: "Re: PATCH (was Possible Linux/Solaris 7 TCP bug)"</a>
<li> <b>Reply:</b> <a href="0852.html">Ilpo Ruotsalainen: "Re: PATCH (was Possible Linux/Solaris 7 TCP bug)"</a>
<li> <b>Reply:</b> <a href="0859.html">David S. Miller: "Re: PATCH (was Possible Linux/Solaris 7 TCP bug)"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
	This is hindering my work quite badly so I'd be very grateful<br>
	if some TCP guru could take a look at the trace and tell me<br>
	which OS is the one in fault (for which one I'll need to wait<br>
	for a patch, that is).<br>
<p>
Please try this patch, it should fix the stuck connections.<br>
<p>
--- ./include/net/tcp.h.~1~	Wed Aug 11 04:48:56 1999<br>
+++ ./include/net/tcp.h	Fri Aug 13 04:29:02 1999<br>
@@ -142,7 +139,8 @@<br>
 				nonagle;<br>
 <br>
 	/* And these are ours. */<br>
-	__u32			rcv_nxt,snd_nxt;<br>
+	__u32			rcv_nxt, snd_nxt;<br>
+	__u16			window;<br>
 	struct tcp_func		*af_specific;<br>
 	struct tcp_bind_bucket	*tb;<br>
 	struct tcp_tw_bucket	*next_death;<br>
--- ./net/ipv4/tcp_input.c.~1~	Sun Aug  8 01:44:24 1999<br>
+++ ./net/ipv4/tcp_input.c	Fri Aug 13 04:40:55 1999<br>
@@ -1006,7 +1006,8 @@<br>
 			tcp_tw_reschedule(tw);<br>
 	}<br>
 	/* Ack old packets if necessary */ <br>
-	if (!after(TCP_SKB_CB(skb)-&gt;end_seq, tw-&gt;rcv_nxt)) <br>
+	if (!after(TCP_SKB_CB(skb)-&gt;end_seq, tw-&gt;rcv_nxt) &amp;&amp;<br>
+	    (th-&gt;doff * 4) &gt; len)<br>
 		return TCP_TW_ACK; <br>
 	return 0; <br>
 }<br>
@@ -1067,7 +1068,8 @@<br>
 		tw-&gt;family	= sk-&gt;family;<br>
 		tw-&gt;reuse	= sk-&gt;reuse;<br>
 		tw-&gt;rcv_nxt	= sk-&gt;tp_pinfo.af_tcp.rcv_nxt;<br>
-		tw-&gt;snd_nxt = sk-&gt;tp_pinfo.af_tcp.snd_nxt;<br>
+		tw-&gt;snd_nxt     = sk-&gt;tp_pinfo.af_tcp.snd_nxt;<br>
+		tw-&gt;window	= tcp_select_window(sk);<br>
 		tw-&gt;af_specific	= sk-&gt;tp_pinfo.af_tcp.af_specific;<br>
 <br>
 #if defined(CONFIG_IPV6) || defined(CONFIG_IPV6_MODULE)<br>
--- ./net/ipv4/tcp_ipv4.c.~1~	Thu Aug 12 08:35:18 1999<br>
+++ ./net/ipv4/tcp_ipv4.c	Fri Aug 13 04:31:33 1999<br>
@@ -1026,7 +1028,7 @@<br>
  *<br>
  *  Assumes that the caller did basic address and flag checks.<br>
  */<br>
-static void tcp_v4_send_ack(struct sk_buff *skb, __u32 seq, __u32 ack)<br>
+static void tcp_v4_send_ack(struct sk_buff *skb, __u32 seq, __u32 ack, __u16 window)<br>
 {<br>
 	struct tcphdr *th = skb-&gt;h.th;<br>
 	struct tcphdr rth;<br>
@@ -1042,6 +1044,8 @@<br>
 	rth.ack_seq = ack; <br>
 	rth.ack = 1;<br>
 <br>
+	rth.window = htons(window);<br>
+<br>
 	memset(&amp;arg, 0, sizeof arg); <br>
 	arg.iov[0].iov_base = (unsigned char *)&amp;rth; <br>
 	arg.iov[0].iov_len  = sizeof rth;<br>
@@ -1774,10 +1778,12 @@<br>
 do_time_wait:<br>
 	/* Sorry for the ugly switch. 2.3 will have a better solution. */ <br>
 	switch (tcp_timewait_state_process((struct tcp_tw_bucket *)sk,<br>
-							   skb, th, skb-&gt;len)) {<br>
+					   skb, th, skb-&gt;len)) {<br>
 	case TCP_TW_ACK:<br>
-		tcp_v4_send_ack(skb, ((struct tcp_tw_bucket *)sk)-&gt;snd_nxt,<br>
-						((struct tcp_tw_bucket *)sk)-&gt;rcv_nxt); <br>
+		tcp_v4_send_ack(skb,<br>
+				((struct tcp_tw_bucket *)sk)-&gt;snd_nxt,<br>
+				((struct tcp_tw_bucket *)sk)-&gt;rcv_nxt,<br>
+				((struct tcp_tw_bucket *)sk)-&gt;window);<br>
 		goto discard_it; <br>
 	case TCP_TW_RST:<br>
 		goto no_tcp_socket; <br>
--- ./net/ipv6/tcp_ipv6.c.~1~	Thu Aug 12 08:35:24 1999<br>
+++ ./net/ipv6/tcp_ipv6.c	Fri Aug 13 04:31:29 1999<br>
@@ -1121,7 +1121,7 @@<br>
 	kfree_skb(buff);<br>
 }<br>
 <br>
-static void tcp_v6_send_ack(struct sk_buff *skb, __u32 seq, __u32 ack)<br>
+static void tcp_v6_send_ack(struct sk_buff *skb, __u32 seq, __u32 ack, __u16 window)<br>
 {<br>
 	struct tcphdr *th = skb-&gt;h.th, *t1; <br>
 	struct sk_buff *buff;<br>
@@ -1144,6 +1144,8 @@<br>
 	t1-&gt;seq = seq;<br>
 	t1-&gt;ack_seq = ack; <br>
 <br>
+	t1-&gt;window = htons(window);<br>
+<br>
 	buff-&gt;csum = csum_partial((char *)t1, sizeof(*t1), 0);<br>
 <br>
 	fl.nl_u.ip6_u.daddr = &amp;skb-&gt;nh.ipv6h-&gt;saddr;<br>
@@ -1461,10 +1463,12 @@<br>
 <br>
 do_time_wait:<br>
 	switch (tcp_timewait_state_process((struct tcp_tw_bucket *)sk,<br>
-									   skb, th, skb-&gt;len)) {<br>
+					   skb, th, skb-&gt;len)) {<br>
 	case TCP_TW_ACK:<br>
-		tcp_v6_send_ack(skb, ((struct tcp_tw_bucket *)sk)-&gt;snd_nxt,<br>
-						((struct tcp_tw_bucket *)sk)-&gt;rcv_nxt); <br>
+		tcp_v6_send_ack(skb,<br>
+				((struct tcp_tw_bucket *)sk)-&gt;snd_nxt,<br>
+				((struct tcp_tw_bucket *)sk)-&gt;rcv_nxt,<br>
+				((struct tcp_tw_bucket *)sk)-&gt;window);<br>
 		goto discard_it; <br>
 	case TCP_TW_RST:<br>
 		goto no_tcp_socket;<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0844.html">Jes Sorensen: "Re: New resources - pls, explain :-("</a>
<li> <b>Previous message:</b> <a href="0842.html">Juan J. Quintela: "General Protection Fault in forget_segments"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0852.html">Ilpo Ruotsalainen: "Re: PATCH (was Possible Linux/Solaris 7 TCP bug)"</a>
<li> <b>Reply:</b> <a href="0852.html">Ilpo Ruotsalainen: "Re: PATCH (was Possible Linux/Solaris 7 TCP bug)"</a>
<li> <b>Reply:</b> <a href="0859.html">David S. Miller: "Re: PATCH (was Possible Linux/Solaris 7 TCP bug)"</a>
<!-- reply="end" -->
</ul>
</font></body>
