<!-- received="Sat Aug 14 01:09:53 1999 EET DST" -->
<!-- sent="Fri, 13 Aug 1999 21:03:39 +0200 (CEST)" -->
<!-- name="Andrea Arcangeli" -->
<!-- email="andrea@suse.de" -->
<!-- subject="[patch] vt_console_print bug" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-32,: [patch] vt_console_print bug</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[patch] vt_console_print bug</h1>
<b>Andrea Arcangeli</b> (<a href="mailto:andrea@suse.de"><i>andrea@suse.de</i></a>)<br>
<i>Fri, 13 Aug 1999 21:03:39 +0200 (CEST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#922">[ date ]</a><a href="index.html#922">[ thread ]</a><a href="subject.html#922">[ subject ]</a><a href="author.html#922">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0923.html">gokhan sozmen: "Bug report: 2.2.11 Makefile"</a>
<li> <b>Previous message:</b> <a href="0921.html">Marc Mutz: "Re: [2.3.13] some bench on a 486"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Redirecting all kernel messages to a fixed terminal (not the foreground<br>
one) caused the kernel messages to be screwed up on such fixed vt.<br>
<p>
Here it is my fix against both 2.2.x and 2.3.x:<br>
<p>
--- 2.2.11/drivers/char/console.c	Wed Mar 24 01:44:52 1999<br>
+++ 2.2.11-cons/drivers/char/console.c	Fri Aug 13 20:45:13 1999<br>
@@ -1984,7 +1984,7 @@<br>
 	static unsigned long printing = 0;<br>
 	const ushort *start;<br>
 	ushort cnt = 0;<br>
-	ushort myx = x;<br>
+	ushort myx;<br>
 <br>
 	/* console busy or not yet initialized */<br>
 	if (!printable || test_and_set_bit(0, &amp;printing))<br>
@@ -1992,6 +1992,10 @@<br>
 <br>
 	if (kmsg_redirect &amp;&amp; vc_cons_allocated(kmsg_redirect - 1))<br>
 		currcons = kmsg_redirect - 1;<br>
+<br>
+	/* read `x' only after setting currecons properly (otherwise<br>
+	   the `x' macro will read the x of the foreground console). */<br>
+	myx = x;<br>
 <br>
 	if (!vc_cons_allocated(currcons)) {<br>
 		/* impossible */<br>
<p>
<p>
The problem was that `x' is a macro that expands to something like<br>
`vc_cons[currcons].d-&gt;vc_x' and so we must read x only _after_ setting<br>
currcons to the kmsg_redirect_console.<br>
<p>
Andrea<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0923.html">gokhan sozmen: "Bug report: 2.2.11 Makefile"</a>
<li> <b>Previous message:</b> <a href="0921.html">Marc Mutz: "Re: [2.3.13] some bench on a 486"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
