<!-- received="Sat Aug 14 03:14:15 1999 EET DST" -->
<!-- sent="Sat, 14 Aug 1999 01:02:26 +0100 (BST)" -->
<!-- name="Alan Cox" -->
<!-- email="alan@lxorguk.ukuu.org.uk" -->
<!-- subject="Re: 2.2.12pre[13] network problem" -->
<!-- id="E11FRHI-0001hZ-00@the-village.bc.nu" -->
<!-- inreplyto="Pine.LNX.4.10.9908131725070.585-100000@athame.dynamicro.internal" -->
<title>Linux-kernel mailing list archive 1999-32,: Re: 2.2.12pre[13] network problem</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: 2.2.12pre[13] network problem</h1>
<b>Alan Cox</b> (<a href="mailto:alan@lxorguk.ukuu.org.uk"><i>alan@lxorguk.ukuu.org.uk</i></a>)<br>
<i>Sat, 14 Aug 1999 01:02:26 +0100 (BST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#947">[ date ]</a><a href="index.html#947">[ thread ]</a><a href="subject.html#947">[ subject ]</a><a href="author.html#947">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0948.html">Samuli Karkkainen: "Re: Repeatable GPF reading /proc/interrupts on a 2.0.37ac12"</a>
<li> <b>Previous message:</b> <a href="0946.html">Andreas Bombe: "Re: Repeatable GPF reading /proc/interrupts on a 2.0.37ac12"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0976.html">Dominik Kubla: "Re: 2.2.12pre[13] network problem"</a>
<li> <b>Reply:</b> <a href="0976.html">Dominik Kubla: "Re: 2.2.12pre[13] network problem"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
<i>&gt; I've tried 2.2.12pre1 and 2.2.12pre3 today.  Output from ifconfig looks</i><br>
<i>&gt; normal.  Interface eth0 works fine.  Interface eth1 doesn't: if pinged</i><br>
<i>&gt; from another box, it may or may not (mostly not) wake up and ping back,</i><br>
<i>&gt; and if it does, and I ping from the local host, that may work for a bit;</i><br>
<i>&gt; but very soon (under 20 seconds) the interface seems to revert to</i><br>
<i>&gt; inactivity.  All this time eth0 is quite normal.  Taking eth1 down and</i><br>
<i>&gt; bringing it back up manually with ifconfig doesn't help.  Rebooting</i><br>
<i>&gt; 2.2.11 causes the problem to go away.</i><br>
<p>
Do you have any of the IP virtual server stuff built in ?<br>
<p>
Can you see if backing out this helps<br>
<p>
<p>
diff -u --new-file --recursive --exclude-from ../exclude linux.vanilla/net/ipv4/arp.c linux.12p2/net/ipv4/arp.c<br>
--- linux.vanilla/net/ipv4/arp.c	Tue Aug 10 21:45:41 1999<br>
+++ linux.12p2/net/ipv4/arp.c	Wed Aug 11 22:54:16 1999<br>
@@ -65,6 +65,8 @@<br>
  *					clean up the APFDDI &amp; gen. FDDI bits.<br>
  *		Alexey Kuznetsov:	new arp state machine;<br>
  *					now it is in net/core/neighbour.c.<br>
+ *              Wensong Zhang   :       NOARP device (such as tunl) arp fix.<br>
+ *		Peter Kese	:	arp_solicit: saddr opt disabled for vs.<br>
  */<br>
 <br>
 /* RFC1122 Status:<br>
@@ -306,9 +308,15 @@<br>
 	u32 target = *(u32*)neigh-&gt;primary_key;<br>
 	int probes = neigh-&gt;probes;<br>
 <br>
+#if !defined(CONFIG_IP_MASQUERADE_VS)	/* Virtual server */ <br>
+	/* use default interface address as source address in virtual<br>
+	 * server environment. Otherways the saddr might be the virtual<br>
+	 * address and gateway's arp cache might start routing packets<br>
+	 * to the real server */<br>
 	if (skb &amp;&amp; inet_addr_type(skb-&gt;nh.iph-&gt;saddr) == RTN_LOCAL)<br>
 		saddr = skb-&gt;nh.iph-&gt;saddr;<br>
 	else<br>
+#endif<br>
 		saddr = inet_select_addr(dev, target, RT_SCOPE_LINK);<br>
 <br>
 	if ((probes -= neigh-&gt;parms-&gt;ucast_probes) &lt; 0) {<br>
@@ -534,6 +542,7 @@<br>
 	struct rtable *rt;<br>
 	unsigned char *sha, *tha;<br>
 	u32 sip, tip;<br>
+	struct device *tdev;<br>
 	u16 dev_type = dev-&gt;type;<br>
 	int addr_type;<br>
 	struct in_device *in_dev = dev-&gt;ip_ptr;<br>
@@ -627,6 +636,13 @@<br>
  *	addresses.  If this is one such, delete it.<br>
  */<br>
 	if (LOOPBACK(tip) || MULTICAST(tip))<br>
+		goto out;<br>
+<br>
+/* <br>
+ *      Check for the device flags for the target IP. If the IFF_NOARP<br>
+ *      is set, just delete it. No arp reply is sent.    -- WZ<br>
+ */ <br>
+	if ((tdev = ip_dev_find(tip)) &amp;&amp; (tdev-&gt;flags &amp; IFF_NOARP))<br>
 		goto out;<br>
 <br>
 /*<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0948.html">Samuli Karkkainen: "Re: Repeatable GPF reading /proc/interrupts on a 2.0.37ac12"</a>
<li> <b>Previous message:</b> <a href="0946.html">Andreas Bombe: "Re: Repeatable GPF reading /proc/interrupts on a 2.0.37ac12"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0976.html">Dominik Kubla: "Re: 2.2.12pre[13] network problem"</a>
<li> <b>Reply:</b> <a href="0976.html">Dominik Kubla: "Re: 2.2.12pre[13] network problem"</a>
<!-- reply="end" -->
</ul>
</font></body>
