<!-- received="Sat Aug 14 16:39:01 1999 EET DST" -->
<!-- sent="Sat, 14 Aug 1999 15:35:25 +0200 (CEST)" -->
<!-- name="Andrea Arcangeli" -->
<!-- email="andrea@suse.de" -->
<!-- subject="Re: kupdate &amp; laptop's" -->
<!-- id="" -->
<!-- inreplyto="Pine.LNX.4.10.9908141416270.557-100000@laser.random" -->
<title>Linux-kernel mailing list archive 1999-32,: Re: kupdate &amp; laptop's</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: kupdate &amp; laptop's</h1>
<b>Andrea Arcangeli</b> (<a href="mailto:andrea@suse.de"><i>andrea@suse.de</i></a>)<br>
<i>Sat, 14 Aug 1999 15:35:25 +0200 (CEST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#997">[ date ]</a><a href="index.html#997">[ thread ]</a><a href="subject.html#997">[ subject ]</a><a href="author.html#997">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0998.html">Benjamin LaHaise: "Re: Problems writting a CHAR Driver with interruptible_sleep (wait_queu e)"</a>
<li> <b>Previous message:</b> <a href="0996.html">CaT: "IDE-UDMA page MIA?"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
On Sat, 14 Aug 1999, Andrea Arcangeli wrote:<br>
<p>
<i>&gt;mistake. If you think it's better to allow kupdate to be stopped simply</i><br>
<i>&gt;via a SIGSTOP I can change the code.</i><br>
<p>
I written the code to allow kupdate to be stopped also via SIGSTOP. Patch<br>
against 2.2.11:<br>
<p>
--- 2.2.11/fs/buffer.c	Thu Aug 12 02:32:33 1999<br>
+++ 2.2.11-kupdate/fs/buffer.c	Sat Aug 14 15:31:24 1999<br>
@@ -1841,13 +1841,18 @@<br>
 	tsk-&gt;session = 1;<br>
 	tsk-&gt;pgrp = 1;<br>
 	strcpy(tsk-&gt;comm, "kupdate");<br>
+<br>
+	/* sigstop and sigcont will stop and wakeup kupdate */<br>
+	spin_lock_irq(&amp;tsk-&gt;sigmask_lock);<br>
 	sigfillset(&amp;tsk-&gt;blocked);<br>
-	/* sigcont will wakeup kupdate after setting interval to 0 */<br>
 	sigdelset(&amp;tsk-&gt;blocked, SIGCONT);<br>
+	sigdelset(&amp;tsk-&gt;blocked, SIGSTOP);<br>
+	spin_unlock_irq(&amp;tsk-&gt;sigmask_lock);<br>
 <br>
 	lock_kernel();<br>
 <br>
 	for (;;) {<br>
+		/* update interval */<br>
 		interval = bdf_prm.b_un.interval;<br>
 		if (interval)<br>
 		{<br>
@@ -1856,8 +1861,24 @@<br>
 		}<br>
 		else<br>
 		{<br>
+		stop_kupdate:<br>
 			tsk-&gt;state = TASK_STOPPED;<br>
 			schedule(); /* wait for SIGCONT */<br>
+		}<br>
+		/* check for sigstop */<br>
+		if (signal_pending(tsk))<br>
+		{<br>
+			int stopped = 0;<br>
+			spin_lock_irq(&amp;tsk-&gt;sigmask_lock);<br>
+			if (sigismember(&amp;tsk-&gt;signal, SIGSTOP))<br>
+			{<br>
+				sigdelset(&amp;tsk-&gt;signal, SIGSTOP);<br>
+				stopped = 1;<br>
+			}<br>
+			recalc_sigpending(tsk);<br>
+			spin_unlock_irq(&amp;tsk-&gt;sigmask_lock);<br>
+			if (stopped)<br>
+				goto stop_kupdate;<br>
 		}<br>
 #ifdef DEBUG<br>
 		printk("kupdate() activated...\n");<br>
<p>
<p>
Andrea<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0998.html">Benjamin LaHaise: "Re: Problems writting a CHAR Driver with interruptible_sleep (wait_queu e)"</a>
<li> <b>Previous message:</b> <a href="0996.html">CaT: "IDE-UDMA page MIA?"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
