<!-- received="Sat Aug 14 22:44:22 1999 EET DST" -->
<!-- sent="Sat, 14 Aug 1999 15:40:05 -0400 (EDT)" -->
<!-- name="Peter Englmaier" -->
<!-- email="ppe@pa.uky.edu" -->
<!-- subject="Re: kupdate &amp; laptop's [patch for integration of mobile-update]" -->
<!-- id="199908141940.PAA03004@pa.uky.edu" -->
<!-- inreplyto="Pine.LNX.4.10.9908141416270.557-100000@laser.random" -->
<title>Linux-kernel mailing list archive 1999-32,: Re: kupdate &amp; laptop's [patch for integration of mobile-update]</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: kupdate &amp; laptop's [patch for integration of mobile-update]</h1>
<b>Peter Englmaier</b> (<a href="mailto:ppe@pa.uky.edu"><i>ppe@pa.uky.edu</i></a>)<br>
<i>Sat, 14 Aug 1999 15:40:05 -0400 (EDT)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#1029">[ date ]</a><a href="index.html#1029">[ thread ]</a><a href="subject.html#1029">[ subject ]</a><a href="author.html#1029">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1030.html">Raul Miller: "Re: Cause of mysterious lock-ups with 2.2.x kernels discovered!"</a>
<li> <b>Previous message:</b> <a href="1028.html">Jonas Jochum: "Problem with ISDN/Response Times"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
<i>&gt; Yes, you need a:</i><br>
<i>&gt; </i><br>
<i>&gt; 	echo 40 500 64 256 0 &gt;/proc/sys/vm/bdflush</i><br>
<i>&gt; </i><br>
<i>&gt; to disable kupdate. Then it will go to sleep.</i><br>
<i>&gt; </i><br>
<i>&gt; To reenable kupdate you need to:</i><br>
<i>&gt; </i><br>
<i>&gt; 	echo 40 500 64 256 500 &gt;/proc/sys/vm/bdflush</i><br>
<i>&gt; </i><br>
<i>&gt; and _then_ send it a SIGCONT. (note on Alpha the second 500 has to be</i><br>
<i>&gt; close to 5000 since HZ is 1024 there)</i><br>
<p>
Maybe a better fix would be to integrate mobile-update in 'kupdate'?<br>
I've attached a possible patch to fs/buffer.c below. The idea is based<br>
on mobile-update, but I simplified it a bit and it checks for activity<br>
on all IDE(?) disks.  I don't know how to make it a compile option,<br>
yet. Maybe it would be even better to activate mobile-update only if<br>
running on battery?  Anyway, the patch seems to work for me.<br>
<p>
Cheers, Peter.<br>
<p>
--- buffer.c.ORIGINAL	Sat Aug 14 14:08:07 1999<br>
+++ buffer.c	Sat Aug 14 15:21:35 1999<br>
@@ -1,3 +1,4 @@<br>
+#define MOBILE_UPDATE<br>
 /*<br>
  *  linux/fs/buffer.c<br>
  *<br>
@@ -37,6 +38,10 @@<br>
 #include &lt;linux/init.h&gt;<br>
 #include &lt;linux/quotaops.h&gt;<br>
 <br>
+#ifdef MOBILE_UPDATE<br>
+#include &lt;linux/kernel_stat.h&gt;<br>
+#endif<br>
+<br>
 #include &lt;asm/uaccess.h&gt;<br>
 #include &lt;asm/io.h&gt;<br>
 #include &lt;asm/bitops.h&gt;<br>
@@ -1837,6 +1842,10 @@<br>
 {<br>
 	struct task_struct * tsk = current;<br>
 	int interval;<br>
+#ifdef MOBILE_UPDATE<br>
+	int dsk, activity;<br>
+	static unsigned int disk_activity[DK_NDRIVE];<br>
+#endif<br>
 <br>
 	tsk-&gt;session = 1;<br>
 	tsk-&gt;pgrp = 1;<br>
@@ -1862,6 +1871,32 @@<br>
 #ifdef DEBUG<br>
 		printk("kupdate() activated...\n");<br>
 #endif<br>
+#ifdef MOBILE_UPDATE<br>
+		/* Find out if there was any disk activity */<br>
+		activity=0;<br>
+		for (dsk=0; dsk&lt;DK_NDRIVE; dsk++)<br>
+		  activity |= kstat.dk_drive[dsk] != disk_activity[dsk];<br>
+<br>
+		/* If there was activity, or if it is the first call,<br>
+		 * call sync_old_buffers()<br>
+		 */<br>
+		if (activity || disk_activity[0] == 0)<br>
+	        {<br>
+#ifdef DEBUG<br>
+		        printk("kmobile-update calls sync\n");<br>
+#endif<br>
+		        sync_old_buffers();<br>
+<br>
+			/* remember disk status for next call */<br>
+			for (dsk=0; dsk&lt;DK_NDRIVE; dsk++)<br>
+			  disk_activity[dsk] = kstat.dk_drive[dsk];<br>
+		}<br>
+#ifdef DEBUG<br>
+		else<br>
+		        printk("kmobile-update ignores sync()\n");<br>
+#endif<br>
+#else<br>
 		sync_old_buffers();<br>
+#endif<br>
 	}<br>
 }<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1030.html">Raul Miller: "Re: Cause of mysterious lock-ups with 2.2.x kernels discovered!"</a>
<li> <b>Previous message:</b> <a href="1028.html">Jonas Jochum: "Problem with ISDN/Response Times"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
