<!-- received="Sun Sep  5 01:17:13 1999 EET DST" -->
<!-- sent="Sun, 05 Sep 1999 00:12:39 +0200" -->
<!-- name="Martin Schenk" -->
<!-- email="schenkm@eunet.at" -->
<!-- subject="Slow fsync on large files (with a patch against 2.2.12)" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-36,: Slow fsync on large files (with a patch against 2.2.12)</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Slow fsync on large files (with a patch against 2.2.12)</h1>
<b>Martin Schenk</b> (<a href="mailto:schenkm@eunet.at"><i>schenkm@eunet.at</i></a>)<br>
<i>Sun, 05 Sep 1999 00:12:39 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#5">[ date ]</a><a href="index.html#5">[ thread ]</a><a href="subject.html#5">[ subject ]</a><a href="author.html#5">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0006.html">Riley Williams: "Re: SMP linux help"</a>
<li> <b>Previous message:</b> <a href="0004.html">dmitryv: "2.3.16 - messages on the console: semaphore in use..."</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
This is a multi-part message in MIME format.<br>
--------------C6E30A06B74B143DB15A5F0E<br>
Content-Type: text/plain; charset=us-ascii<br>
Content-Transfer-Encoding: 7bit<br>
<p>
problem:<br>
<p>
fsyncing a large file takes a lot of time, because ext2_sync_file<br>
goes through the headers of all buffered blocks of the file in order<br>
to determine whether the block has to be written to disk.<br>
On a 100 Mb file (100000 blocks), this can lead to more than<br>
200000 calls to sync_block (sync_block is called twice for each block) -<br>
on my K6-200 this takes about 1/2 second of CPU time.<br>
(So fsyncing a large file with few changes in LINUX is CPU and not I/O<br>
bound - at least when most of the file is in the buffer cache)<br>
<p>
further details:<br>
ext2_sync_file finds all these blocks by going through a hierarchy of<br>
indirect blocks, which store block numbers.<br>
<p>
idea for the solution:<br>
Moving the check for changes from the bottom of the "block hierarchy"<br>
to the upper levels, so only a small part of the blocks has to be<br>
checked.<br>
Every time data is written to a file, the concerned block is searched<br>
by going through the inode of the file and the "block hierarchy".<br>
This makes it possible to set flags, so that on fsyncing a file, only a<br>
part of the "hierarchy" has to be searched.<br>
<p>
implementation:<br>
I added a flag "sync_depend" to the "buffer_head" structure which<br>
already contains the meta data of the buffered blocks.<br>
I changed block_getblk in /usr/src/linux/fs/ext2/inode.c to set<br>
sync_depend<br>
on the searched block when it is called with the flag create!=0.<br>
I changed the functions scanning the "block hierarchy" in<br>
/usr/src/linux/fs/ext2/fsync.c to abort the scan on branches with<br>
sync_depend==0,<br>
and to reset sync_depend to 0 after syncing.<br>
<p>
caveats:<br>
My code assumes the following:<br>
- the struct buffer_head is an acceptable place to put a flag like<br>
sync_depend<br>
- all writes to a block somehow end up going through block_getblk with<br>
create==1<br>
- I have not overlooked other things (as I know very little about ext2<br>
this does<br>
  not seem likely)<br>
<p>
results:<br>
On the above mentioned problem, the application of my patch reduces the<br>
number<br>
of calls to sync_block to below 1000.<br>
<p>
<pre>
-- 
Martin Schenk &lt;<a href="mailto:schenkm@eunet.at">schenkm@eunet.at</a>&gt;
Richard-Wagnergasse 46, A-8010 Graz, Austria
--------------C6E30A06B74B143DB15A5F0E
Content-Type: text/plain; charset=us-ascii; name="syncdiff"
Content-Transfer-Encoding: 7bit
Content-Disposition: inline; filename="syncdiff"
<p>
--- linuxelf-2.2/include/linux/fs.h	Sat Sep  4 21:40:25 1999
+++ linux.orig/include/linux/fs.h	Thu Aug 26 02:29:52 1999
@@ -226,14 +226,6 @@
 	 */
 	void (*b_end_io)(struct buffer_head *bh, int uptodate);
 	void *b_dev_id;
-
-#ifdef CONFIG_FASTSYNC			/* faster fsync for large files on EXT2 */
-	int	sync_depend:1;		/* (Double/Triple)Indirect-Buffer:
-					   true -&gt; points to a possibly changed buffer,
-					   false -&gt;no changes done, sync does not need to
-						   check dependents
-					*/ 
-#endif
 };
 
 typedef void (bh_end_io_t)(struct buffer_head *bh, int uptodate);
--- linuxelf-2.2/fs/ext2/inode.c	Sat Sep  4 22:07:14 1999
+++ linux.orig/fs/ext2/inode.c	Mon Aug  9 21:04:57 1999
@@ -283,9 +283,6 @@
 			return NULL;
 		}
 	}
-#ifdef CONFIG_FASTSYNC
-	if (create) bh-&gt;sync_depend=1;	/* changes to dependents possible */
-#endif
 	p = (u32 *) bh-&gt;b_data + nr;
 repeat:
 	tmp = le32_to_cpu(*p);
--- linuxelf-2.2/fs/ext2/fsync.c	Sat Sep  4 22:48:59 1999
+++ linux.orig/fs/ext2/fsync.c	Wed May 20 22:09:12 1998
@@ -155,11 +146,6 @@
 	rc = sync_iblock (inode, iblock, &amp;ind_bh, wait);
 	if (rc || !ind_bh)
 		return rc;
-
-#ifdef CONFIG_FASTSYNC
-	if (!ind_bh-&gt;sync_depend) 
-	{	brelse(ind_bh); return 0; } /* no changes to dependents */
-#endif
 	
 	for (i = 0; i &lt; addr_per_block; i++) {
 		rc = sync_block_swab32 (inode, 
@@ -168,10 +154,6 @@
 		if (rc)
 			err = rc;
 	}
-
-#ifdef CONFIG_FASTSYNC
-	if (wait) ind_bh-&gt;sync_depend=0;
-#endif
 	brelse (ind_bh);
 	return err;
 }
@@ -186,11 +168,6 @@
 	rc = sync_iblock_swab32 (inode, iblock, &amp;ind_bh, wait);
 	if (rc || !ind_bh)
 		return rc;
-
-#ifdef CONFIG_FASTSYNC
-	if (!ind_bh-&gt;sync_depend) 
-	{	brelse(ind_bh); return 0; } /* no changes to dependents */
-#endif
 	
 	for (i = 0; i &lt; addr_per_block; i++) {
 		rc = sync_block_swab32 (inode, 
@@ -199,10 +176,6 @@
 		if (rc)
 			err = rc;
 	}
-
-#ifdef CONFIG_FASTSYNC
-	if (wait) ind_bh-&gt;sync_depend=0;
-#endif
 	brelse (ind_bh);
 	return err;
 }
@@ -219,11 +192,6 @@
 	rc = sync_iblock (inode, diblock, &amp;dind_bh, wait);
 	if (rc || !dind_bh)
 		return rc;
-
-#ifdef CONFIG_FASTSYNC
-	if (!dind_bh-&gt;sync_depend) 
-	{	brelse(dind_bh); return 0; } /* no changes to dependents */
-#endif
 	
 	for (i = 0; i &lt; addr_per_block; i++) {
 		rc = sync_indirect_swab32 (inode,
@@ -232,11 +200,6 @@
 		if (rc)
 			err = rc;
 	}
-
-#ifdef CONFIG_FASTSYNC
-	if (wait) dind_bh-&gt;sync_depend=0;
-#endif
-
 	brelse (dind_bh);
 	return err;
 }
@@ -251,11 +214,6 @@
 	rc = sync_iblock_swab32 (inode, diblock, &amp;dind_bh, wait);
 	if (rc || !dind_bh)
 		return rc;
-
-#ifdef CONFIG_FASTSYNC
-	if (!dind_bh-&gt;sync_depend) 
-	{	brelse(dind_bh); return 0; } /* no changes to dependents */
-#endif
 	
 	for (i = 0; i &lt; addr_per_block; i++) {
 		rc = sync_indirect_swab32 (inode,
@@ -264,10 +222,6 @@
 		if (rc)
 			err = rc;
 	}
-
-#ifdef CONFIG_FASTSYNC
-	if (wait) dind_bh-&gt;sync_depend=0;
-#endif
 	brelse (dind_bh);
 	return err;
 }
@@ -284,12 +238,6 @@
 	rc = sync_iblock (inode, tiblock, &amp;tind_bh, wait);
 	if (rc || !tind_bh)
 		return rc;
-
-#ifdef CONFIG_FASTSYNC
-	if (!tind_bh-&gt;sync_depend) /* no changes to dependents */
-	{	brelse(tind_bh); return 0; 
-	}
-#endif
 	
 	for (i = 0; i &lt; addr_per_block; i++) {
 		rc = sync_dindirect_swab32 (inode,
@@ -298,10 +246,6 @@
 		if (rc)
 			err = rc;
 	}
-
-#ifdef CONFIG_FASTSYNC
-	if (wait) tind_bh-&gt;sync_depend=0;
-#endif
 	brelse (tind_bh);
 	return err;
 }
<p>
--------------C6E30A06B74B143DB15A5F0E--
<p>
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0006.html">Riley Williams: "Re: SMP linux help"</a>
<li> <b>Previous message:</b> <a href="0004.html">dmitryv: "2.3.16 - messages on the console: semaphore in use..."</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
