<!-- received="Sun Sep  5 11:23:49 1999 EET DST" -->
<!-- sent="Sun,  5 Sep 1999 01:01:07 -0700 (PDT)" -->
<!-- name="Raymond Nijssen" -->
<!-- email="raymond@woensel.ics.ele.tue.nl" -->
<!-- subject="resource limits bug" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-36,: resource limits bug</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>resource limits bug</h1>
<b>Raymond Nijssen</b> (<a href="mailto:raymond@woensel.ics.ele.tue.nl"><i>raymond@woensel.ics.ele.tue.nl</i></a>)<br>
<i>Sun,  5 Sep 1999 01:01:07 -0700 (PDT)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#39">[ date ]</a><a href="index.html#39">[ thread ]</a><a href="subject.html#39">[ subject ]</a><a href="author.html#39">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0040.html">Thomas Bierweiler: "OOPS with 2.0.38 + SMP"</a>
<li> <b>Previous message:</b> <a href="0038.html">Mike Galbraith: "Re: 2.2.12 Memory Leak?"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0117.html">list.kernel@iahastie.clara.net: "Re: resource limits bug"</a>
<li> <b>Reply:</b> <a href="0117.html">list.kernel@iahastie.clara.net: "Re: resource limits bug"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
The 2.2.5 kernel lets non-privileged users increase resource limits beyond<br>
maximum value and even beyond kernel maximum values as shown in the code<br>
snippet below.<br>
<p>
On 2.0.35 kernels resource limits seem to be totally broken.<br>
<p>
BTW, why are most "unlimited" kernel limits set to 2G (that is, LONG_MAX in<br>
include/asm-*/resource.h) while 3G or so would be more correct?<br>
<p>
Thanks,<br>
-Raymond<br>
<p>
<p>
<p>
102[linux1:]~/src/test&gt;uname -a <br>
Linux linux1 2.2.5-15smp #1 SMP Mon Apr 19 22:43:28 EDT 1999 i686 unknown <br>
<p>
102[linux1:]~/src/test&gt;id <br>
uid=114(raymond) gid=101(utmp) groups=101(utmp),100(users)<br>
<p>
103[linux1:]~/src/test&gt;cat rlim.c <br>
#include &lt;sys/resource.h&gt;  <br>
#include &lt;stdio.h&gt; <br>
 <br>
#define linux22 <br>
 <br>
int main() { <br>
    struct rlimit rlim;  <br>
    int rv; <br>
 <br>
    printf("Default:  (max,cur)\n"); <br>
    rv = getrlimit(RLIMIT_DATA,&amp;rlim);  <br>
    if ( rv == -1 ) <br>
        perror("getrlimit");  <br>
    else <br>
      printf("rlimit_data:%lu,%lu\n", rlim.rlim_max, rlim.rlim_cur);  <br>
 <br>
#ifdef linux22 <br>
    rv = getrlimit(RLIMIT_AS,&amp;rlim);  <br>
    if ( rv == -1 ) <br>
        perror("getrlimit");  <br>
  else <br>
      printf("rlimit_as:%lu,%lu\n", rlim.rlim_max, rlim.rlim_cur);  <br>
#endif <br>
 <br>
    printf("Setting rlimits\n"); <br>
    rlim.rlim_cur=rlim.rlim_max=(unsigned)(2.75*1024*1024*1024);  <br>
#ifdef linux22 <br>
    rv = setrlimit( RLIMIT_AS, &amp;rlim );  <br>
    if ( rv == -1 )  <br>
        perror("setrlimit");  <br>
#endif <br>
    rv = setrlimit( RLIMIT_DATA, &amp;rlim );  <br>
    if ( rv == -1 ) <br>
        perror("setrlimit");  <br>
 <br>
 <br>
    printf("After:  (max,cur)\n"); <br>
    rv = getrlimit(RLIMIT_DATA,&amp;rlim);  <br>
    if ( rv == -1 ) <br>
        perror("getrlimit");  <br>
    else <br>
      printf("rlimit_data:%lu,%lu\n", rlim.rlim_max, rlim.rlim_cur);  <br>
 <br>
#ifdef linux22 <br>
    rv = getrlimit(RLIMIT_AS,&amp;rlim);  <br>
    if ( rv == -1 ) <br>
        perror("getrlimit");  <br>
  else <br>
      printf("rlimit_as:%lu,%lu\n", rlim.rlim_max, rlim.rlim_cur);  <br>
#endif <br>
    return 0; <br>
} <br>
<p>
<p>
104[linux1:]~/src/test&gt;gcc -Wall rlim.c <br>
105[linux1:]~/src/test&gt;./a.out <br>
Default:  (max,cur) <br>
rlimit_data:2147483647,2896167424 <br>
rlimit_as:2147483647,2147483647 <br>
Setting rlimits <br>
After:  (max,cur) <br>
rlimit_data:2952790016,2952790016 <br>
rlimit_as:2952790016,2952790016 <br>
<p>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0040.html">Thomas Bierweiler: "OOPS with 2.0.38 + SMP"</a>
<li> <b>Previous message:</b> <a href="0038.html">Mike Galbraith: "Re: 2.2.12 Memory Leak?"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0117.html">list.kernel@iahastie.clara.net: "Re: resource limits bug"</a>
<li> <b>Reply:</b> <a href="0117.html">list.kernel@iahastie.clara.net: "Re: resource limits bug"</a>
<!-- reply="end" -->
</ul>
</font></body>
