<!-- received="Sun Sep  5 15:53:00 1999 EET DST" -->
<!-- sent="Sun, 05 Sep 1999 14:53:08 +0200" -->
<!-- name="Manfred Spraul" -->
<!-- email="manfreds@colorfullife.com" -->
<!-- subject="Re: Race conditions in file creation in 2.3." -->
<!-- id="" -->
<!-- inreplyto="Race conditions in file creation in 2.3." -->
<title>Linux-kernel mailing list archive 1999-36,: Re: Race conditions in file creation in 2.3.</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: Race conditions in file creation in 2.3.</h1>
<b>Manfred Spraul</b> (<a href="mailto:manfreds@colorfullife.com"><i>manfreds@colorfullife.com</i></a>)<br>
<i>Sun, 05 Sep 1999 14:53:08 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#59">[ date ]</a><a href="index.html#59">[ thread ]</a><a href="subject.html#59">[ subject ]</a><a href="author.html#59">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0060.html">Catalin Muresan: "2.2.11, pppd 2.3.7 - stalled interfaces"</a>
<li> <b>Previous message:</b> <a href="0058.html">Gabor Lenart: "Re: for a help"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
This is a multi-part message in MIME format.<br>
--------------2F4894000232D3AC1662AC76<br>
Content-Type: text/plain; charset=us-ascii<br>
Content-Transfer-Encoding: 7bit<br>
<p>
Alan wrote:<br>
<i>&gt; I think the error is coming from open() from the error message cp issued.</i><br>
<p>
Yes, but it's open(O_TRUNC).<br>
<p>
I could reproduce a bug with the attached c-program.<br>
Just start ~ 10 processes and wait [amd-K6 200, scsi, ext2 disk]<br>
<p>
The bug could be caused by the missing synchronization of truncate() and<br>
write()	<br>
This is a known problem since ~2.3.7. [neither O_APPEND, nor i_size nor<br>
f_pos are synchronized]<br>
<p>
Unfortunately, it seems difficult to fix it properly:<br>
<p>
1) affected files:<br>
several places outside VFS access i_sem directly: [at least]<br>
+ fs/nfsd/vfs.c<br>
+ arch/*/kernel/sys_*.c<br>
+ drivers/char/tty_io.c<br>
<p>
2) different types of files have completely different synchronzation<br>
requirements, so I think flags should be added to VFS which sync calls<br>
are required.<br>
<p>
+ pipes: nothing, even parallel read()/write() calls to the same filp<br>
must not block in VFS [the pipe could use O_NONBLOCK]<br>
linux-2.2 uses a dirty hack: fs/pipe.c knows that sys_write() called<br>
down(i_sem), and pipe.c calls up(). <br>
<p>
+ e.g. raw-io: everything can run parallel _except_ parallel<br>
sys_read()/sys_write() calls to the same filp [flip-&gt;f_pos!]. No<br>
restrictions on parallel sys_pread()/sys_pwrite(). Note that this cannot<br>
be implemented in raw.c, because raw.c does not know whether sys_read()<br>
or sys_pread() was called.<br>
<p>
+ normal files: parallel, non-overlapping read/write calls are possible[<br>
overlapping writes violate NfsV2]. Truncate can run in parallel with<br>
read()/write() if these calls don't access the area between [old-EOF,<br>
new-EOF].<br>
Even Windows 95 allow this level or parallelity for some files, this<br>
should be possible under Linux as well.<br>
<p>
+ everything else: I'd call down() before calling f_ops-&gt;read()/write(),<br>
I don't know if all character devices can handle parallel read()/write()<br>
calls. If they can handle it, then they should set appopriate flags.<br>
	<br>
<pre>
--
	Manfred
--------------2F4894000232D3AC1662AC76
Content-Type: text/plain; charset=us-ascii;
 name="opentest.cpp"
Content-Transfer-Encoding: 7bit
Content-Disposition: inline;
 filename="opentest.cpp"
<p>
#include &lt;unistd.h&gt;
#include &lt;stdio.h&gt;
#include &lt;stdlib.h&gt;
#include &lt;errno.h&gt;
#include &lt;fcntl.h&gt;
<p>
static char buffer[81930];
<p>
extern "C" int main( int argc, char *argv[] )
{
	printf("opentest &lt;test file&gt;\n");
	if(argc != 2) {
		printf(" Invalid parameters.\n");
		return 1;
	}
	for (;;) {
		int handle;
<p>
		handle = open(argv[1],O_WRONLY|O_CREAT|O_TRUNC, 0600);
		if(handle==-1) {
			printf("open failed: %d.\n",errno);
			return 1;
		}
		write(handle, buffer, 81930);
		write(handle, buffer, 81930);
		write(handle, buffer, 81930);
		write(handle, buffer, 81930);
		write(handle, buffer, 81930);
		write(handle, buffer, 81930);
		close(handle);
		unlink(argv[1]);
	}
	return 0;
}
<p>
<p>
--------------2F4894000232D3AC1662AC76--
<p>
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0060.html">Catalin Muresan: "2.2.11, pppd 2.3.7 - stalled interfaces"</a>
<li> <b>Previous message:</b> <a href="0058.html">Gabor Lenart: "Re: for a help"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
