<!-- received="Mon Sep  6 01:55:47 1999 EET DST" -->
<!-- sent="Sun, 5 Sep 1999 22:38:38 +0200" -->
<!-- name="list.kernel@iahastie.clara.net" -->
<!-- email="list.kernel@iahastie.clara.net" -->
<!-- subject="Re: resource limits bug" -->
<!-- id="" -->
<!-- inreplyto="resource limits bug" -->
<title>Linux-kernel mailing list archive 1999-36,: Re: resource limits bug</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: resource limits bug</h1>
<a href="mailto:list.kernel@iahastie.clara.net"><i>list.kernel@iahastie.clara.net</i></a><br>
<i>Sun, 5 Sep 1999 22:38:38 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#117">[ date ]</a><a href="index.html#117">[ thread ]</a><a href="subject.html#117">[ subject ]</a><a href="author.html#117">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0118.html">list.kernel@iahastie.clara.net: "Even more bizarre 2.3.x(x &gt;=15) behavior"</a>
<li> <b>Previous message:</b> <a href="0116.html">list.kernel@iahastie.clara.net: "Re: 2.3.16, ide-scsi cdrom errors on audio CDs"</a>
<li> <b>Maybe in reply to:</b> <a href="0039.html">Raymond Nijssen: "resource limits bug"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
On Sun, Sep 05, 1999 at 12:21:43PM +0100, Alan Cox wrote:<br>
<i>&gt; &gt; BTW, why are most "unlimited" kernel limits set to 2G (that is, LONG_MAX in</i><br>
<i>&gt; &gt; include/asm-*/resource.h) while 3G or so would be more correct?</i><br>
<i>&gt; </i><br>
<i>&gt; Because the ulimit values are signed. 2.2.12 has most of the checks fixed,</i><br>
<i>&gt; 2.3.x someone need sto shift to using an unsigned rlimit_t.</i><br>
<p>
I posted that patch on Wednesday.  In case you missed it I include<br>
it below.  Incidentally, I spotted this problem by using the -W flag.<br>
It's a shame that some of the warnings this generates can't be worked<br>
around; we can't make the header files clean.  (in particular, the test<br>
against zero always being false is something we don't want warned about in<br>
the signal.h file.  I tried a couple of things to eliminate that warning,<br>
but I can't see a way.)<br>
<p>
diff -u linux-2.2.12/include/linux/resource.h linux-2.2.12-Wclean/include/linux/resource.h<br>
--- linux-2.2.12/include/linux/resource.h	Thu Aug 26 21:41:53 1999<br>
+++ linux-2.2.12-Wclean/include/linux/resource.h	Wed Sep  1 18:10:23 1999<br>
@@ -38,10 +38,14 @@<br>
 };<br>
 <br>
 #define RLIM_INFINITY	((long)(~0UL&gt;&gt;1))<br>
+#define RLIM_SAVED_CUR	RLIM_INFINITY<br>
+#define RLIM_SAVED_MAX	RLIM_INFINITY<br>
+<br>
+typedef unsigned long	rlim_t;<br>
 <br>
 struct rlimit {<br>
-	long	rlim_cur;<br>
-	long	rlim_max;<br>
+	rlim_t	rlim_cur;<br>
+	rlim_t	rlim_max;<br>
 };<br>
 <br>
 #define	PRIO_MIN	(-20)<br>
<p>
<pre>
-- 
Matthew Wilcox &lt;<a href="mailto:willy@bofh.ai">willy@bofh.ai</a>&gt;
"Windows and MacOS are products, contrived by engineers in the service of
specific companies. Unix, by contrast, is not so much a product as it is a
painstakingly compiled oral history of the hacker subculture." - N Stephenson
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
<p>
<p>
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0118.html">list.kernel@iahastie.clara.net: "Even more bizarre 2.3.x(x &gt;=15) behavior"</a>
<li> <b>Previous message:</b> <a href="0116.html">list.kernel@iahastie.clara.net: "Re: 2.3.16, ide-scsi cdrom errors on audio CDs"</a>
<li> <b>Maybe in reply to:</b> <a href="0039.html">Raymond Nijssen: "resource limits bug"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
