<!-- received="Mon Sep  6 02:04:53 1999 EET DST" -->
<!-- sent="5 Sep 1999 11:10:41 -0700" -->
<!-- name="list.kernel@iahastie.clara.net" -->
<!-- email="list.kernel@iahastie.clara.net" -->
<!-- subject="Re: [patch] 2.3.17-pre1 mem_init [Re: [PATCH] 2.3.15 fancy memory" -->
<!-- id="" -->
<!-- inreplyto="[patch] 2.3.17-pre1 mem_init [Re: [PATCH] 2.3.15 fancy memory" -->
<title>Linux-kernel mailing list archive 1999-36,: Re: [patch] 2.3.17-pre1 mem_init [Re: [PATCH] 2.3.15 fancy memory</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: [patch] 2.3.17-pre1 mem_init [Re: [PATCH] 2.3.15 fancy memory</h1>
<a href="mailto:list.kernel@iahastie.clara.net"><i>list.kernel@iahastie.clara.net</i></a><br>
<i>5 Sep 1999 11:10:41 -0700</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#119">[ date ]</a><a href="index.html#119">[ thread ]</a><a href="subject.html#119">[ subject ]</a><a href="author.html#119">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0120.html">list.kernel@iahastie.clara.net: "Re: 2.3.16, ide-scsi cdrom errors on audio CDs"</a>
<li> <b>Previous message:</b> <a href="0118.html">list.kernel@iahastie.clara.net: "Even more bizarre 2.3.x(x &gt;=15) behavior"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
In article &lt;<a href="mailto:linux.kernel.7qt95f$v65$1@alfie.demon.co.uk">linux.kernel.7qt95f$v65$1@alfie.demon.co.uk</a>&gt;,<br>
Nick Holloway &lt;<a href="mailto:Nick.Holloway@alfie.demon.co.uk">Nick.Holloway@alfie.demon.co.uk</a>&gt; wrote:<br>
<i>&gt;<a href="mailto:torvalds@transmeta.com">torvalds@transmeta.com</a> (Linus Torvalds) writes:</i><br>
<i>&gt;&gt; 	unsigned long start = e820.map[i].addr;</i><br>
<i>&gt;&gt; 	unsigned long end = start + e820.map[i].size;</i><br>
<i>&gt;&gt; </i><br>
<i>&gt;&gt; 	start = PAGE_ALIGN(start) + PAGE_OFFSET;</i><br>
<i>&gt;&gt; 	end = (end &amp; PAGE_MASK) + PAGE_OFFSET;</i><br>
<i>&gt;</i><br>
<i>&gt;Doesn't this end up wasting 1 page of memory at the start (as PAGE_ALIGN</i><br>
<i>&gt;already takes you to the next page boundary)?</i><br>
<p>
<p>
   (I'm not Linux, but...)  The entire ia32 universe is shifted PAGE_OFFSET<br>
   up from the start of memory.   If you don't PAGE_OFFSET, you get some<br>
   really hilarious crashes as soon as kswapd needs to swap some pages<br>
   out.<br>
<p>
   Since Linus pointed out that the page whitelisting was, umm, a bit<br>
   confusing, I revisited the patch-on-a-patch again and blatantly<br>
   ripped off his code.   I also got rid of the magic number 1 and<br>
   replaced it with a constant, and, in the grand tradition of putting<br>
   unrelated things into my patches, upped the printk buffer from 16 to<br>
   32k because even with the binfmt_aout spamming turned off my<br>
   2.3.17pre1 kernel would overflow the 16k buffer before klogd could<br>
   harvest any of it.   (Tested on one machine overnight via a 2gb<br>
   bonnie run and a couple of kernel rebuilds)<br>
<p>
--- linux-2.3.16-orig/include/asm-i386/e820.h	Mon Aug 30 10:47:02 1999<br>
+++ linux-2.3.16/include/asm-i386/e820.h	Sun Sep  5 10:55:31 1999<br>
@@ -28,6 +28,7 @@<br>
 	long type;		/* type of memory segment */<br>
     } map[E820MAX];<br>
 };<br>
+#define E820_IS_RAM	1	/* memory region contains usable memory */<br>
 <br>
 extern struct e820map e820;<br>
 #endif/*!__ASSEMBLY__*/<br>
--- linux-2.3.16-orig/arch/i386/kernel/setup.c	Sun Sep  5 04:03:19 1999<br>
+++ linux-2.3.16/arch/i386/kernel/setup.c	Sun Sep  5 10:57:23 1999<br>
@@ -422,8 +422,8 @@<br>
 <br>
 		mem_size = (ALT_MEM_K &lt; EXT_MEM_K) ? EXT_MEM_K : ALT_MEM_K;<br>
 <br>
-		add_memory_region(0, LOWMEMSIZE(), 1);<br>
-		add_memory_region(HIGH_MEMORY, mem_size &lt;&lt; 10, 1);<br>
+		add_memory_region(0, LOWMEMSIZE(), E820_IS_RAM);<br>
+		add_memory_region(HIGH_MEMORY, mem_size &lt;&lt; 10, E820_IS_RAM);<br>
   	}<br>
 } /* setup_memory_region */<br>
 <br>
@@ -503,7 +503,7 @@<br>
 					 */<br>
 					e820.nr_map = 0;<br>
 					usermem = 1;<br>
-					add_memory_region(0, LOWMEMSIZE(), 1);<br>
+					add_memory_region(0, LOWMEMSIZE(), E820_IS_RAM);<br>
 				}<br>
 				mem_size = memparse(from+4, &amp;from);<br>
 				if (*from == '@')<br>
@@ -512,7 +512,7 @@<br>
 					start_at = HIGH_MEMORY;<br>
 					mem_size -= HIGH_MEMORY;<br>
 				}<br>
-				add_memory_region(start_at, mem_size, 1);<br>
+				add_memory_region(start_at, mem_size, E820_IS_RAM);<br>
 			}<br>
 		}<br>
 		c = *(from++);<br>
@@ -530,12 +530,7 @@<br>
 <br>
 	memory_end = 0;<br>
 	for (i=0; i &lt; e820.nr_map; i++) {<br>
-		printk("type=%d, addr=%08x, size=%08x",<br>
-			e820.map[i].type,<br>
-			e820.map[i].addr,<br>
-			e820.map[i].size);<br>
-		/* RAM? */<br>
-		if (e820.map[i].type == 1) {<br>
+		if (e820.map[i].type == E820_IS_RAM) {<br>
 			unsigned long end = e820.map[i].addr + e820.map[i].size;<br>
 <br>
 			if (end &gt; memory_end)<br>
--- linux-2.3.16-orig/arch/i386/mm/init.c	Sun Sep  5 04:01:01 1999<br>
+++ linux-2.3.16/arch/i386/mm/init.c	Sun Sep  5 10:58:22 1999<br>
@@ -415,7 +415,7 @@<br>
 	for (avail = i = 0; i &lt; e820.nr_map; i++) {<br>
 		unsigned long start, end;<br>
 <br>
-		if (e820.map[i].type != 1)	/* not usable memory */<br>
+		if (e820.map[i].type != E820_IS_RAM)	/* not usable memory */<br>
 			continue;<br>
 		printk("memory region: %luk @ %08lx\n",<br>
 				    ((long)(e820.map[i].size)) / 1024,<br>
--- linux-2.3.16-orig/kernel/printk.c	Mon Aug 23 11:15:53 1999<br>
+++ linux-2.3.16/kernel/printk.c	Sun Sep  5 11:00:06 1999<br>
@@ -22,7 +22,7 @@<br>
 <br>
 #include &lt;asm/uaccess.h&gt;<br>
 <br>
-#define LOG_BUF_LEN	(16384)<br>
+#define LOG_BUF_LEN	(32768)<br>
 #define LOG_BUF_MASK	(LOG_BUF_LEN-1)<br>
 <br>
 static char buf[1024];<br>
<p>
<p>
                  ____<br>
    david parsons \bi/ maybe this will satisfy the boundary conditions.<br>
                   \/<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<p>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0120.html">list.kernel@iahastie.clara.net: "Re: 2.3.16, ide-scsi cdrom errors on audio CDs"</a>
<li> <b>Previous message:</b> <a href="0118.html">list.kernel@iahastie.clara.net: "Even more bizarre 2.3.x(x &gt;=15) behavior"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
