<!-- received="Mon Sep  6 04:45:10 1999 EET DST" -->
<!-- sent="Mon, 6 Sep 1999 02:19:52 +0200 (CEST)" -->
<!-- name="Robert de Vries" -->
<!-- email="rhdv@rhdv.cistron.nl" -->
<!-- subject="[PATCH] 2.3.17-pre1: siginfo data available for all signals" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-36,: [PATCH] 2.3.17-pre1: siginfo data available for all signals</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] 2.3.17-pre1: siginfo data available for all signals</h1>
<b>Robert de Vries</b> (<a href="mailto:rhdv@rhdv.cistron.nl"><i>rhdv@rhdv.cistron.nl</i></a>)<br>
<i>Mon, 6 Sep 1999 02:19:52 +0200 (CEST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#161">[ date ]</a><a href="index.html#161">[ thread ]</a><a href="subject.html#161">[ subject ]</a><a href="author.html#161">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0162.html">Peter Clark: "Kernel 2.3.14/15/16 won't boot"</a>
<li> <b>Previous message:</b> <a href="0160.html">Jordan Mendelson: "&gt; 15,000 Simultaneous Connections"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Normally only real-time signals have siginfo data. However it is also<br>
useful for other signals as well. Some of the other signals would like to<br>
carry extra information, but that information is lost currently.<br>
<p>
This patch handles all signals alike. Every signal is put into the signal<br>
queue. Only real-time signals are queued multiple times. Other signals can<br>
have only one siginfo in the queue.<br>
<p>
The patch also fixes some unitialized data being passed to user space<br>
under some circumstances. When sending a signal using kill, the siginfo<br>
structure on the stack was not zeroed.<br>
<p>
For some reason magic values for siginfo were passed to send_sig_info.<br>
These magic values are transformed to normal pointers to a struct siginfo,<br>
so that the rest of the code does not have to handle these special values.<br>
This simplifies the rest of the code somewhat.<br>
<p>
The patch is rather large because of the changes in indentation.<br>
Therefore I have attached two versions of the same patch. The first one is<br>
the real one, the second one is to ease the visual check.<br>
<p>
	Robert<br>
<p>
The real patch:<br>
<p>
diff -ruN linux-2.3.17-pre1-vanilla/kernel/signal.c linux-2.3.17-pre1-devt/kernel/signal.c<br>
--- linux-2.3.17-pre1-vanilla/kernel/signal.c	Mon Aug 23 20:15:53 1999<br>
+++ linux-2.3.17-pre1-devt/kernel/signal.c	Sun Sep  5 23:19:23 1999<br>
@@ -129,64 +129,48 @@<br>
 <br>
 	if (sig) {<br>
 		int reset = 1;<br>
+		struct signal_queue *q, **pp;<br>
 <br>
 		/* Collect the siginfo appropriate to this signal.  */<br>
-		if (sig &lt; SIGRTMIN) {<br>
-			/* XXX: As an extension, support queueing exactly<br>
-			   one non-rt signal if SA_SIGINFO is set, so that<br>
-			   we can get more detailed information about the<br>
-			   cause of the signal.  */<br>
-			/* Deciding not to init these couple of fields is<br>
-			   more expensive that just initializing them.  */<br>
+		pp = &amp;current-&gt;sigqueue;<br>
+		q = current-&gt;sigqueue;<br>
+<br>
+		/* Find the one we're interested in ... */<br>
+		for ( ; q ; pp = &amp;q-&gt;next, q = q-&gt;next)<br>
+			if (q-&gt;info.si_signo == sig)<br>
+				break;<br>
+		if (q) {<br>
+			if ((*pp = q-&gt;next) == NULL)<br>
+				current-&gt;sigqueue_tail = pp;<br>
+			*info = q-&gt;info;<br>
+			kmem_cache_free(signal_queue_cachep,q);<br>
+			atomic_dec(&amp;nr_queued_signals);<br>
+<br>
+			/* then see if this signal is still pending. */<br>
+			q = *pp;<br>
+			while (q) {<br>
+				if (q-&gt;info.si_signo == sig) {<br>
+					reset = 0;<br>
+					break;<br>
+				}<br>
+				q = q-&gt;next;<br>
+			}<br>
+		} else {<br>
+			/* Ok, it wasn't in the queue.  It must have<br>
+			   been sent either by a non-rt mechanism and<br>
+			   we ran out of queue space.  So zero out the<br>
+			   info.  */<br>
 			info-&gt;si_signo = sig;<br>
 			info-&gt;si_errno = 0;<br>
 			info-&gt;si_code = 0;<br>
 			info-&gt;si_pid = 0;<br>
 			info-&gt;si_uid = 0;<br>
-		} else {<br>
-			struct signal_queue *q, **pp;<br>
-			pp = &amp;current-&gt;sigqueue;<br>
-			q = current-&gt;sigqueue;<br>
-<br>
-			/* Find the one we're interested in ... */<br>
-			for ( ; q ; pp = &amp;q-&gt;next, q = q-&gt;next)<br>
-				if (q-&gt;info.si_signo == sig)<br>
-					break;<br>
-			if (q) {<br>
-				if ((*pp = q-&gt;next) == NULL)<br>
-					current-&gt;sigqueue_tail = pp;<br>
-				*info = q-&gt;info;<br>
-				kmem_cache_free(signal_queue_cachep,q);<br>
-				atomic_dec(&amp;nr_queued_signals);<br>
-				<br>
-				/* then see if this signal is still pending. */<br>
-				q = *pp;<br>
-				while (q) {<br>
-					if (q-&gt;info.si_signo == sig) {<br>
-						reset = 0;<br>
-						break;<br>
-					}<br>
-					q = q-&gt;next;<br>
-				}<br>
-			} else {<br>
-				/* Ok, it wasn't in the queue.  It must have<br>
-				   been sent either by a non-rt mechanism and<br>
-				   we ran out of queue space.  So zero out the<br>
-				   info.  */<br>
-				info-&gt;si_signo = sig;<br>
-				info-&gt;si_errno = 0;<br>
-				info-&gt;si_code = 0;<br>
-				info-&gt;si_pid = 0;<br>
-				info-&gt;si_uid = 0;<br>
-			}<br>
 		}<br>
 <br>
 		if (reset)<br>
 			sigdelset(&amp;current-&gt;signal, sig);<br>
 		recalc_sigpending(current);<br>
 <br>
-		/* XXX: Once POSIX.1b timers are in, if si_code == SI_TIMER,<br>
-		   we need to xchg out the timer overrun values.  */<br>
 	} else {<br>
 		/* XXX: Once CLONE_PID is in to join those "threads" that are<br>
 		   part of the same "process", look for signals sent to the<br>
@@ -247,11 +231,33 @@<br>
 	return 1;<br>
 }<br>
 <br>
+static void set_siginfo(siginfo_t *info, int sig, int kernel_signal)<br>
+{<br>
+	memset(info, 0, sizeof(*info));<br>
+<br>
+	if (kernel_signal) {<br>
+		info-&gt;si_signo = sig;<br>
+		info-&gt;si_errno = 0;<br>
+		info-&gt;si_code = SI_KERNEL;<br>
+		info-&gt;si_pid = 0;<br>
+		info-&gt;si_uid = 0;<br>
+	}<br>
+	else {<br>
+		info-&gt;si_signo = sig;<br>
+		info-&gt;si_errno = 0;<br>
+		info-&gt;si_code = SI_USER;<br>
+		info-&gt;si_pid = current-&gt;pid;<br>
+		info-&gt;si_uid = current-&gt;uid;<br>
+	}<br>
+}<br>
+<br>
 int<br>
 send_sig_info(int sig, struct siginfo *info, struct task_struct *t)<br>
 {<br>
 	unsigned long flags;<br>
 	int ret;<br>
+	struct signal_queue *q;<br>
+	siginfo_t info_compat;<br>
 <br>
 #if DEBUG_SIG<br>
 printk("SIG queue (%s:%d): %d ", t-&gt;comm, t-&gt;pid, sig);<br>
@@ -260,9 +266,16 @@<br>
 	ret = -EINVAL;<br>
 	if (sig &lt; 0 || sig &gt; _NSIG)<br>
 		goto out_nolock;<br>
+<br>
+	/* backward compatibility, convert magic info value to real info */<br>
+	if ((info == NULL) || ((unsigned long)info == 1)) {<br>
+		set_siginfo(&amp;info_compat, sig, info != NULL);<br>
+		info = &amp;info_compat;<br>
+	}<br>
+<br>
 	/* The somewhat baroque permissions check... */<br>
 	ret = -EPERM;<br>
-	if ((!info || ((unsigned long)info != 1 &amp;&amp; SI_FROMUSER(info)))<br>
+	if (SI_FROMUSER(info)<br>
 	    &amp;&amp; ((sig != SIGCONT) || (current-&gt;session != t-&gt;session))<br>
 	    &amp;&amp; (current-&gt;euid ^ t-&gt;suid) &amp;&amp; (current-&gt;euid ^ t-&gt;uid)<br>
 	    &amp;&amp; (current-&gt;uid ^ t-&gt;suid) &amp;&amp; (current-&gt;uid ^ t-&gt;uid)<br>
@@ -304,63 +317,42 @@<br>
 	if (ignored_signal(sig, t))<br>
 		goto out;<br>
 <br>
-	if (sig &lt; SIGRTMIN) {<br>
-		/* Non-real-time signals are not queued.  */<br>
-		/* XXX: As an extension, support queueing exactly one<br>
-		   non-rt signal if SA_SIGINFO is set, so that we can<br>
-		   get more detailed information about the cause of<br>
-		   the signal.  */<br>
+	/* If it is a NON RT signal, only one signal gets queued, the later<br>
+	   ones are discarded. */<br>
+	else if (sig &lt; SIGRTMIN) {<br>
+		/* Non-real-time signals are not queued. */<br>
 		if (sigismember(&amp;t-&gt;signal, sig))<br>
 			goto out;<br>
+	}<br>
+<br>
+	/* Real-time signals must be queued if sent by sigqueue, or<br>
+	   some other real-time mechanism.  It is implementation<br>
+	   defined whether kill() does so.  We attempt to do so, on<br>
+	   the principle of least surprise, but since kill is not<br>
+	   allowed to fail with EAGAIN when low on memory we just<br>
+	   make sure at least one signal gets delivered and don't<br>
+	   pass on the info struct.  */<br>
+<br>
+	q = 0;<br>
+	if (atomic_read(&amp;nr_queued_signals) &lt; max_queued_signals) {<br>
+		q = (struct signal_queue *)<br>
+		    kmem_cache_alloc(signal_queue_cachep, GFP_ATOMIC);<br>
+	}<br>
+<br>
+	if (q) {<br>
+		atomic_inc(&amp;nr_queued_signals);<br>
+		q-&gt;next = NULL;<br>
+		*t-&gt;sigqueue_tail = q;<br>
+		t-&gt;sigqueue_tail = &amp;q-&gt;next;<br>
+		q-&gt;info = *info;<br>
 	} else {<br>
-		/* Real-time signals must be queued if sent by sigqueue, or<br>
-		   some other real-time mechanism.  It is implementation<br>
-		   defined whether kill() does so.  We attempt to do so, on<br>
-		   the principle of least surprise, but since kill is not<br>
-		   allowed to fail with EAGAIN when low on memory we just<br>
-		   make sure at least one signal gets delivered and don't<br>
-		   pass on the info struct.  */<br>
-<br>
-		struct signal_queue *q = 0;<br>
-<br>
-		if (atomic_read(&amp;nr_queued_signals) &lt; max_queued_signals) {<br>
-			q = (struct signal_queue *)<br>
-			    kmem_cache_alloc(signal_queue_cachep, GFP_ATOMIC);<br>
-		}<br>
-		<br>
-		if (q) {<br>
-			atomic_inc(&amp;nr_queued_signals);<br>
-			q-&gt;next = NULL;<br>
-			*t-&gt;sigqueue_tail = q;<br>
-			t-&gt;sigqueue_tail = &amp;q-&gt;next;<br>
-			switch ((unsigned long) info) {<br>
-			case 0:<br>
-				q-&gt;info.si_signo = sig;<br>
-				q-&gt;info.si_errno = 0;<br>
-				q-&gt;info.si_code = SI_USER;<br>
-				q-&gt;info.si_pid = current-&gt;pid;<br>
-				q-&gt;info.si_uid = current-&gt;uid;<br>
-				break;<br>
-			case 1:<br>
-				q-&gt;info.si_signo = sig;<br>
-				q-&gt;info.si_errno = 0;<br>
-				q-&gt;info.si_code = SI_KERNEL;<br>
-				q-&gt;info.si_pid = 0;<br>
-				q-&gt;info.si_uid = 0;<br>
-				break;<br>
-			default:<br>
-				q-&gt;info = *info;<br>
-				break;<br>
-			}<br>
-		} else {<br>
-			/* If this was sent by a rt mechanism, try again.  */<br>
-			if (info-&gt;si_code &lt; 0) {<br>
-				ret = -EAGAIN;<br>
-				goto out;<br>
-			}<br>
-			/* Otherwise, mention that the signal is pending,<br>
-			   but don't queue the info.  */<br>
+		/* If this was sent by a rt mechanism, try again.  */<br>
+		if (info-&gt;si_code &lt; 0) {<br>
+			ret = -EAGAIN;<br>
+			goto out;<br>
 		}<br>
+		/* Otherwise, mention that the signal is pending,<br>
+		   but don't queue the info.  */<br>
 	}<br>
 <br>
 	sigaddset(&amp;t-&gt;signal, sig);<br>
@@ -791,6 +783,8 @@<br>
 sys_kill(int pid, int sig)<br>
 {<br>
 	struct siginfo info;<br>
+	<br>
+	memset(&amp;info, 0, sizeof(info));<br>
 <br>
 	info.si_signo = sig;<br>
 	info.si_errno = 0;<br>
<p>
<p>
<p>
The minimal patch:<br>
<p>
--- linux-2.3.17-pre1-vanilla/kernel/signal.c	Mon Aug 23 20:15:53 1999<br>
+++ linux-2.3.17-pre1-devt/kernel/signal.c	Sun Sep  5 23:19:23 1999<br>
@@ -129,22 +129,9 @@<br>
 <br>
 	if (sig) {<br>
 		int reset = 1;<br>
+		struct signal_queue *q, **pp;<br>
 <br>
 		/* Collect the siginfo appropriate to this signal.  */<br>
-		if (sig &lt; SIGRTMIN) {<br>
-			/* XXX: As an extension, support queueing exactly<br>
-			   one non-rt signal if SA_SIGINFO is set, so that<br>
-			   we can get more detailed information about the<br>
-			   cause of the signal.  */<br>
-			/* Deciding not to init these couple of fields is<br>
-			   more expensive that just initializing them.  */<br>
-			info-&gt;si_signo = sig;<br>
-			info-&gt;si_errno = 0;<br>
-			info-&gt;si_code = 0;<br>
-			info-&gt;si_pid = 0;<br>
-			info-&gt;si_uid = 0;<br>
-		} else {<br>
-			struct signal_queue *q, **pp;<br>
 			pp = &amp;current-&gt;sigqueue;<br>
 			q = current-&gt;sigqueue;<br>
 <br>
@@ -179,14 +166,11 @@<br>
 				info-&gt;si_pid = 0;<br>
 				info-&gt;si_uid = 0;<br>
 			}<br>
-		}<br>
 <br>
 		if (reset)<br>
 			sigdelset(&amp;current-&gt;signal, sig);<br>
 		recalc_sigpending(current);<br>
 <br>
-		/* XXX: Once POSIX.1b timers are in, if si_code == SI_TIMER,<br>
-		   we need to xchg out the timer overrun values.  */<br>
 	} else {<br>
 		/* XXX: Once CLONE_PID is in to join those "threads" that are<br>
 		   part of the same "process", look for signals sent to the<br>
@@ -247,11 +231,33 @@<br>
 	return 1;<br>
 }<br>
 <br>
+static void set_siginfo(siginfo_t *info, int sig, int kernel_signal)<br>
+{<br>
+	memset(info, 0, sizeof(*info));<br>
+<br>
+	if (kernel_signal) {<br>
+		info-&gt;si_signo = sig;<br>
+		info-&gt;si_errno = 0;<br>
+		info-&gt;si_code = SI_KERNEL;<br>
+		info-&gt;si_pid = 0;<br>
+		info-&gt;si_uid = 0;<br>
+	}<br>
+	else {<br>
+		info-&gt;si_signo = sig;<br>
+		info-&gt;si_errno = 0;<br>
+		info-&gt;si_code = SI_USER;<br>
+		info-&gt;si_pid = current-&gt;pid;<br>
+		info-&gt;si_uid = current-&gt;uid;<br>
+	}<br>
+}<br>
+<br>
 int<br>
 send_sig_info(int sig, struct siginfo *info, struct task_struct *t)<br>
 {<br>
 	unsigned long flags;<br>
 	int ret;<br>
+	struct signal_queue *q;<br>
+	siginfo_t info_compat;<br>
 <br>
 #if DEBUG_SIG<br>
 printk("SIG queue (%s:%d): %d ", t-&gt;comm, t-&gt;pid, sig);<br>
@@ -260,9 +266,16 @@<br>
 	ret = -EINVAL;<br>
 	if (sig &lt; 0 || sig &gt; _NSIG)<br>
 		goto out_nolock;<br>
+<br>
+	/* backward compatibility, convert magic info value to real info */<br>
+	if ((info == NULL) || ((unsigned long)info == 1)) {<br>
+		set_siginfo(&amp;info_compat, sig, info != NULL);<br>
+		info = &amp;info_compat;<br>
+	}<br>
+<br>
 	/* The somewhat baroque permissions check... */<br>
 	ret = -EPERM;<br>
-	if ((!info || ((unsigned long)info != 1 &amp;&amp; SI_FROMUSER(info)))<br>
+	if (SI_FROMUSER(info)<br>
 	    &amp;&amp; ((sig != SIGCONT) || (current-&gt;session != t-&gt;session))<br>
 	    &amp;&amp; (current-&gt;euid ^ t-&gt;suid) &amp;&amp; (current-&gt;euid ^ t-&gt;uid)<br>
 	    &amp;&amp; (current-&gt;uid ^ t-&gt;suid) &amp;&amp; (current-&gt;uid ^ t-&gt;uid)<br>
@@ -304,15 +317,14 @@<br>
 	if (ignored_signal(sig, t))<br>
 		goto out;<br>
 <br>
-	if (sig &lt; SIGRTMIN) {<br>
+	/* If it is a NON RT signal, only one signal gets queued, the later<br>
+	   ones are discarded. */<br>
+	else if (sig &lt; SIGRTMIN) {<br>
 		/* Non-real-time signals are not queued.  */<br>
-		/* XXX: As an extension, support queueing exactly one<br>
-		   non-rt signal if SA_SIGINFO is set, so that we can<br>
-		   get more detailed information about the cause of<br>
-		   the signal.  */<br>
 		if (sigismember(&amp;t-&gt;signal, sig))<br>
 			goto out;<br>
-	} else {<br>
+	}<br>
+<br>
 		/* Real-time signals must be queued if sent by sigqueue, or<br>
 		   some other real-time mechanism.  It is implementation<br>
 		   defined whether kill() does so.  We attempt to do so, on<br>
@@ -321,8 +333,7 @@<br>
 		   make sure at least one signal gets delivered and don't<br>
 		   pass on the info struct.  */<br>
 <br>
-		struct signal_queue *q = 0;<br>
-<br>
+	q = 0;<br>
 		if (atomic_read(&amp;nr_queued_signals) &lt; max_queued_signals) {<br>
 			q = (struct signal_queue *)<br>
 			    kmem_cache_alloc(signal_queue_cachep, GFP_ATOMIC);<br>
@@ -333,25 +344,7 @@<br>
 			q-&gt;next = NULL;<br>
 			*t-&gt;sigqueue_tail = q;<br>
 			t-&gt;sigqueue_tail = &amp;q-&gt;next;<br>
-			switch ((unsigned long) info) {<br>
-			case 0:<br>
-				q-&gt;info.si_signo = sig;<br>
-				q-&gt;info.si_errno = 0;<br>
-				q-&gt;info.si_code = SI_USER;<br>
-				q-&gt;info.si_pid = current-&gt;pid;<br>
-				q-&gt;info.si_uid = current-&gt;uid;<br>
-				break;<br>
-			case 1:<br>
-				q-&gt;info.si_signo = sig;<br>
-				q-&gt;info.si_errno = 0;<br>
-				q-&gt;info.si_code = SI_KERNEL;<br>
-				q-&gt;info.si_pid = 0;<br>
-				q-&gt;info.si_uid = 0;<br>
-				break;<br>
-			default:<br>
 				q-&gt;info = *info;<br>
-				break;<br>
-			}<br>
 		} else {<br>
 			/* If this was sent by a rt mechanism, try again.  */<br>
 			if (info-&gt;si_code &lt; 0) {<br>
@@ -361,7 +354,6 @@<br>
 			/* Otherwise, mention that the signal is pending,<br>
 			   but don't queue the info.  */<br>
 		}<br>
-	}<br>
 <br>
 	sigaddset(&amp;t-&gt;signal, sig);<br>
 	if (!sigismember(&amp;t-&gt;blocked, sig)) {<br>
@@ -791,6 +783,8 @@<br>
 sys_kill(int pid, int sig)<br>
 {<br>
 	struct siginfo info;<br>
+	<br>
+	memset(&amp;info, 0, sizeof(info));<br>
 <br>
 	info.si_signo = sig;<br>
 	info.si_errno = 0;<br>
<p>
<p>
<pre>
-- 
Robert de Vries
<a href="mailto:rhdv@rhdv.cistron.nl">rhdv@rhdv.cistron.nl</a>
<p>
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0162.html">Peter Clark: "Kernel 2.3.14/15/16 won't boot"</a>
<li> <b>Previous message:</b> <a href="0160.html">Jordan Mendelson: "&gt; 15,000 Simultaneous Connections"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
