<!-- received="Mon Sep  6 06:17:24 1999 EET DST" -->
<!-- sent="Sun, 05 Sep 1999 20:12:51 -0700" -->
<!-- name="G. Allen Morris III" -->
<!-- email="gam3@ixlabs.com" -->
<!-- subject="[PATCH] nfsd generation number patch" -->
<!-- id="199909060312.UAA26275@209-239-200-203.oak.jps.net" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-36,: [PATCH] nfsd generation number patch</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] nfsd generation number patch</h1>
<b>G. Allen Morris III</b> (<a href="mailto:gam3@ixlabs.com"><i>gam3@ixlabs.com</i></a>)<br>
<i>Sun, 05 Sep 1999 20:12:51 -0700</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#166">[ date ]</a><a href="index.html#166">[ thread ]</a><a href="subject.html#166">[ subject ]</a><a href="author.html#166">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0167.html">Rick Hohensee: "libsys for GNU/Linux"</a>
<li> <b>Previous message:</b> <a href="0165.html">tad-m2n@omoikane.co.jp: "Re: Fixing the SCSI layer"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
This patch adds generation numbers to the nfs filehhandle.<br>
While these are still not used, having them in the filehandle<br>
now will make it easier to use them in the future.  Also when<br>
they are set by a filesystem they will solve the problems with<br>
solaris (and other) clients cacheing and using filehandles that<br>
should be stale.<br>
<p>
  Allen &lt;<a href="mailto:gam3@ixlabs.com">gam3@ixlabs.com</a>&gt;<br>
<p>
<p>
Index: fs/nfsd/nfsfh.c<br>
===================================================================<br>
RCS file: /home/cvs/cvsroot/linux-2.2/fs/nfsd/nfsfh.c,v<br>
retrieving revision 1.1<br>
diff -u -u -r1.1 nfsfh.c<br>
--- fs/nfsd/nfsfh.c	1999/09/03 17:20:45	1.1<br>
+++ fs/nfsd/nfsfh.c	1999/09/05 16:03:06<br>
@@ -4,6 +4,7 @@<br>
  * NFS server file handle treatment.<br>
  *<br>
  * Copyright (C) 1995, 1996 Olaf Kirch &lt;<a href="mailto:okir@monad.swb.de">okir@monad.swb.de</a>&gt;<br>
+ * Portions Copyright (C) 1999 G. Allen Morris III &lt;<a href="mailto:gam3@acm.org">gam3@acm.org</a>&gt;<br>
  */<br>
 <br>
 #include &lt;linux/sched.h&gt;<br>
@@ -1192,6 +1193,7 @@<br>
 	fhp-&gt;fh_handle.fh_dcookie = dentry;<br>
 	if (inode) {<br>
 		fhp-&gt;fh_handle.fh_ino = ino_t_to_u32(inode-&gt;i_ino);<br>
+		fhp-&gt;fh_handle.fh_generation = inode-&gt;i_generation;<br>
 	}<br>
 	fhp-&gt;fh_handle.fh_dirino = ino_t_to_u32(parent-&gt;d_inode-&gt;i_ino);<br>
 	fhp-&gt;fh_handle.fh_dev	 = kdev_t_to_u32(parent-&gt;d_inode-&gt;i_dev);<br>
@@ -1223,6 +1225,7 @@<br>
 	if (!inode)<br>
 		goto out_negative;<br>
 	fhp-&gt;fh_handle.fh_ino = ino_t_to_u32(inode-&gt;i_ino);<br>
+	fhp-&gt;fh_handle.fh_generation = inode-&gt;i_generation;<br>
 out:<br>
 	return;<br>
 <br>
Index: include/linux/nfsd/nfsfh.h<br>
===================================================================<br>
RCS file: /home/cvs/cvsroot/linux-2.2/include/linux/nfsd/nfsfh.h,v<br>
retrieving revision 1.1<br>
diff -u -u -r1.1 nfsfh.h<br>
--- include/linux/nfsd/nfsfh.h	1999/09/03 17:20:46	1.1<br>
+++ include/linux/nfsd/nfsfh.h	1999/09/05 18:21:01<br>
@@ -8,7 +8,7 @@<br>
  * or SHA. I've removed this code, because it doesn't give you more<br>
  * security than blocking external access to port 2049 on your firewall.<br>
  *<br>
- * Copyright (C) 1995, 1996, 1997 Olaf Kirch &lt;<a href="mailto:okir@monad.swb.de">okir@monad.swb.de</a>&gt;<br>
+ * Copyright (C) 1995-1999 Olaf Kirch &lt;<a href="mailto:okir@monad.swb.de">okir@monad.swb.de</a>&gt;<br>
  */<br>
 <br>
 #ifndef NFSD_FH_H<br>
@@ -33,6 +33,7 @@<br>
 	__u32		fb_dev;		/* our device */<br>
 	__u32		fb_xdev;<br>
 	__u32		fb_xino;<br>
+	__u32		fb_generation;<br>
 };<br>
 <br>
 #define NFS_FH_PADDING		(NFS_FHSIZE - sizeof(struct nfs_fhbase))<br>
@@ -47,6 +48,7 @@<br>
 #define fh_dev			fh_base.fb_dev<br>
 #define fh_xdev			fh_base.fb_xdev<br>
 #define fh_xino			fh_base.fb_xino<br>
+#define fh_generation		fh_base.fb_generation<br>
 <br>
 #ifdef __KERNEL__<br>
 <br>
@@ -179,34 +181,6 @@<br>
 		up(&amp;inode-&gt;i_sem);<br>
 	}<br>
 }<br>
-<br>
-/*<br>
- * Release an inode<br>
- */<br>
-#if 0<br>
-#define fh_put(fhp)	__fh_put(fhp, __FILE__, __LINE__)<br>
-<br>
-static inline void<br>
-__fh_put(struct svc_fh *fhp, char *file, int line)<br>
-{<br>
-	struct dentry	*dentry;<br>
-<br>
-	if (!fhp-&gt;fh_dverified)<br>
-		return;<br>
-<br>
-	dentry = fhp-&gt;fh_dentry;<br>
-	if (!dentry-&gt;d_count) {<br>
-		printk("nfsd: trying to free free dentry in %s:%d\n"<br>
-		       "      file %s/%s\n",<br>
-		       file, line,<br>
-		       dentry-&gt;d_parent-&gt;d_name.name, dentry-&gt;d_name.name);<br>
-	} else {<br>
-		fh_unlock(fhp);<br>
-		fhp-&gt;fh_dverified = 0;<br>
-		dput(dentry);<br>
-	}<br>
-}<br>
-#endif<br>
 <br>
 #endif /* __KERNEL__ */<br>
 <br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0167.html">Rick Hohensee: "libsys for GNU/Linux"</a>
<li> <b>Previous message:</b> <a href="0165.html">tad-m2n@omoikane.co.jp: "Re: Fixing the SCSI layer"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
