<!-- received="Mon Sep  6 13:30:01 1999 EET DST" -->
<!-- sent="06 Sep 1999 12:18:05 +0200" -->
<!-- name="Trond Myklebust" -->
<!-- email="trond.myklebust@fys.uio.no" -->
<!-- subject="Re: NFSv3 patches break smbfs" -->
<!-- id="" -->
<!-- inreplyto="Sun, 5 Sep 1999 18:36:20 -0400 (EDT)"" -->
<title>Linux-kernel mailing list archive 1999-36,: Re: NFSv3 patches break smbfs</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: NFSv3 patches break smbfs</h1>
<b>Trond Myklebust</b> (<a href="mailto:trond.myklebust@fys.uio.no"><i>trond.myklebust@fys.uio.no</i></a>)<br>
<i>06 Sep 1999 12:18:05 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#213">[ date ]</a><a href="index.html#213">[ thread ]</a><a href="subject.html#213">[ subject ]</a><a href="author.html#213">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0214.html">Michael Elizabeth Chastain: "get_module_symbol and 8390.o"</a>
<li> <b>Previous message:</b> <a href="0212.html">manfreds@colorfullife.com: "Re: set_current_state"</a>
<li> <b>In reply to:</b> <a href="0141.html">Alan Cox: "Re: NFSv3 patches break smbfs"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Alan Cox &lt;<a href="mailto:alan@redhat.com">alan@redhat.com</a>&gt; writes:<br>
<p>
<i>&gt; &gt; applied.  I'm able to copy files to a share mounted from an NT 4.0sp3</i><br>
<i>&gt; &gt; server, but all processes concerned hang hard when attempting to delete</i><br>
<i>&gt; &gt; the same file.  'ps' shows them hung in a 'D' state.</i><br>
<i>&gt; &gt; </i><br>
<i>&gt; &gt; This happened a few months back with one of your earlier patches, but I</i><br>
<i>&gt; &gt; don't remember what the fix consisted of.</i><br>
<i>&gt; &gt; </i><br>
<i>&gt; </i><br>
<i>&gt; Add the smbfs patches from a 2.2.11ac release and it should be fine - its</i><br>
<i>&gt; the page locking changes</i><br>
<p>
Oops. Thanks Alan.<br>
<p>
Please apply the following patch (or alternatively do as Alan suggests<br>
and just copy fs/smbfs/file.c over from the ac release).<br>
<p>
Cheers,<br>
  Trond<br>
<p>
--- fs/smbfs/file.c.orig	Sat Aug 28 22:15:00 1999<br>
+++ fs/smbfs/file.c	Mon Sep  6 12:08:25 1999<br>
@@ -191,6 +191,7 @@<br>
 smb_updatepage(struct file *file, struct page *page, const char *buf, unsigned long offset, unsigned int count, int sync)<br>
 {<br>
 	struct dentry *dentry = file-&gt;f_dentry;<br>
+	int result = -EFAULT;<br>
 <br>
 	set_bit(PG_locked, &amp;page-&gt;flags);<br>
 <br>
@@ -200,11 +201,13 @@<br>
 <br>
 	if (copy_from_user((u8*)page_address(page) + offset, buf, count)) {<br>
 		clear_bit(PG_uptodate, &amp;page-&gt;flags);<br>
-		smb_unlock_page(page);<br>
-		return -EFAULT;<br>
+		goto out;<br>
 	}<br>
 <br>
-	return smb_writepage_sync(dentry, page, offset, count);<br>
+	result = smb_writepage_sync(dentry, page, offset, count);<br>
+ out:<br>
+	smb_unlock_page(page);<br>
+	return result;<br>
 }<br>
 <br>
 static ssize_t<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0214.html">Michael Elizabeth Chastain: "get_module_symbol and 8390.o"</a>
<li> <b>Previous message:</b> <a href="0212.html">manfreds@colorfullife.com: "Re: set_current_state"</a>
<li> <b>In reply to:</b> <a href="0141.html">Alan Cox: "Re: NFSv3 patches break smbfs"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
