<!-- received="Mon Sep  6 19:00:28 1999 EET DST" -->
<!-- sent="Mon, 6 Sep 1999 08:57:02 -0700 (PDT)" -->
<!-- name="H.J. Lu" -->
<!-- email="hjl@lucon.org" -->
<!-- subject="Re: Problem allocating DMA memory" -->
<!-- id="19990906155702.6BC7B1B493@ocean.lucon.org" -->
<!-- inreplyto="Problem allocating DMA memory" -->
<title>Linux-kernel mailing list archive 1999-36,: Re: Problem allocating DMA memory</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: Problem allocating DMA memory</h1>
<b>H.J. Lu</b> (<a href="mailto:hjl@lucon.org"><i>hjl@lucon.org</i></a>)<br>
<i>Mon, 6 Sep 1999 08:57:02 -0700 (PDT)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#257">[ date ]</a><a href="index.html#257">[ thread ]</a><a href="subject.html#257">[ subject ]</a><a href="author.html#257">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0258.html">Krzysztof Halasa: "Frame Relay, HDLC and RISCom/N2 card drivers"</a>
<li> <b>Previous message:</b> <a href="0256.html">Rik van Riel: "Re: Problem allocating DMA memory"</a>
<li> <b>Maybe in reply to:</b> <a href="0164.html">Richard Gooch: "Problem allocating DMA memory"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0260.html">Alan Cox: "Re: Problem allocating DMA memory"</a>
<li> <b>Reply:</b> <a href="0260.html">Alan Cox: "Re: Problem allocating DMA memory"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
<i>&gt; &gt; &gt; 2.2.11/2.2.12 have a zoned allocator which seems to help massively</i><br>
<i>&gt; &gt; </i><br>
<i>&gt; &gt; Nice and simple, I like it (and have overlooked it until now :().</i><br>
<i>&gt; &gt; </i><br>
<i>&gt; &gt; I think we should implement something at least this good in 2.3,</i><br>
<i>&gt; &gt; maybe even with cache colouring...</i><br>
<i>&gt; </i><br>
<i>&gt; Its simple, elegant but does need optimising. If you have little ram left</i><br>
<i>&gt; but DMA ram your page allocation rate is noticably slower. On a 20Mb box</i><br>
<i>&gt; thats not ideal.</i><br>
<i>&gt; </i><br>
<i>&gt; </i><br>
<p>
This patch allows you to turn it off if you have few RAMs or your arch<br>
doesn't care. I turn it off on my alpha. It seems to work ok.<br>
<p>
You can also do something clever to check the ratio of DMA and none DMA<br>
memories. If it is above certain threshold, don't preserve DMA.<br>
<p>
<pre>
-- 
H.J. Lu (<a href="mailto:hjl@gnu.org">hjl@gnu.org</a>)
<pre>
---
Index: linux/mm/page_alloc.c
===================================================================
RCS file: /work/cvs/linux/linux/mm/page_alloc.c,v
retrieving revision 1.1.1.32
retrieving revision 1.5
diff -u -p -r1.1.1.32 -r1.5
--- linux/mm/page_alloc.c	1999/08/12 22:20:51	1.1.1.32
+++ linux/mm/page_alloc.c	1999/08/01 19:06:11	1.5
@@ -210,7 +210,6 @@ do { struct free_area_struct * area = fr
 			EXPAND(ret, map_nr, order, new_order, area); \
 			spin_unlock_irqrestore(&amp;page_alloc_lock, flags); \
 			return ADDRESS(map_nr); \
-		 \
 		} \
 		new_order++; area++; \
 	} while (new_order &lt; NR_MEM_LISTS); \
@@ -278,7 +277,9 @@ ok_to_allocate:
 	if (gfp_mask &amp; __GFP_DMA)
 		RMQUEUE_DMA(order);
 	else {
+#ifdef CONFIG_PRESERVE_DMA_MEMORY
 		RMQUEUE_NODMA(order);
+#endif
 		RMQUEUE_ANY(order);
 	}
 	spin_unlock_irqrestore(&amp;page_alloc_lock, flags);
Index: linux/arch/i386/config.in
===================================================================
RCS file: /work/cvs/linux/linux/arch/i386/config.in,v
retrieving revision 1.6
diff -u -p -r1.6 config.in
--- linux/arch/i386/config.in	1999/07/09 21:23:45	1.6
+++ linux/arch/i386/config.in	1999/07/16 22:46:32
@@ -56,6 +56,8 @@ endmenu
 mainmenu_option next_comment
 comment 'General setup'
 
+bool 'Preserve DMA memory' CONFIG_PRESERVE_DMA_MEMORY
+
 bool 'Networking support' CONFIG_NET
 bool 'PCI support' CONFIG_PCI
 if [ "$CONFIG_PCI" = "y" ]; then
Index: linux/arch/alpha/config.in
===================================================================
RCS file: /work/cvs/linux/linux/arch/alpha/config.in,v
retrieving revision 1.3
diff -u -p -r1.3 config.in
--- linux/arch/alpha/config.in	1999/07/09 21:23:45	1.3
+++ linux/arch/alpha/config.in	1999/07/16 22:46:55
@@ -21,6 +21,8 @@ endmenu
 mainmenu_option next_comment
 comment 'General setup'
 
+bool 'Preserve DMA memory' CONFIG_PRESERVE_DMA_MEMORY
+
 choice 'Alpha system type' \
 	"Generic		CONFIG_ALPHA_GENERIC		\
 	 Alcor/Alpha-XLT	CONFIG_ALPHA_ALCOR		\
Index: linux/Documentation/Configure.help
===================================================================
RCS file: /work/cvs/linux/linux/Documentation/Configure.help,v
retrieving revision 1.9
diff -u -p -r1.9 Configure.help
--- linux/Documentation/Configure.help	1999/07/09 21:23:45	1.9
+++ linux/Documentation/Configure.help	1999/07/16 22:37:03
@@ -187,6 +187,13 @@ CONFIG_MAC_FLOPPY
   If you have a SWIM-3 (Super Woz Integrated Machine 3; from Apple)
   floppy controller, say Y here. Most commonly found in PowerMacs.
 
+Preserve DMA memory
+CONFIG_PRESERVE_DMA_MEMORY
+  Saying Y here will make kernel try to preserve DMA memory. It is very
+  useful for x86 since it has 16M DMA memory limit. If you have large
+  RAM and/or many devices using DMA on your x86 machine, you should say
+  Y. Otherwise, say N.
+
 RAM disk support
 CONFIG_BLK_DEV_RAM
   Saying Y here will allow you to use a portion of your RAM memory as
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0258.html">Krzysztof Halasa: "Frame Relay, HDLC and RISCom/N2 card drivers"</a>
<li> <b>Previous message:</b> <a href="0256.html">Rik van Riel: "Re: Problem allocating DMA memory"</a>
<li> <b>Maybe in reply to:</b> <a href="0164.html">Richard Gooch: "Problem allocating DMA memory"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0260.html">Alan Cox: "Re: Problem allocating DMA memory"</a>
<li> <b>Reply:</b> <a href="0260.html">Alan Cox: "Re: Problem allocating DMA memory"</a>
<!-- reply="end" -->
</ul>
</font></body>
