<!-- received="Mon Sep  6 20:30:58 1999 EET DST" -->
<!-- sent="Mon, 6 Sep 1999 13:18:32 -0400 (EDT)" -->
<!-- name="Benjamin C.R. LaHaise" -->
<!-- email="blah@kvack.org" -->
<!-- subject="Re: Problem allocating DMA memory" -->
<!-- id="" -->
<!-- inreplyto="E11O1Me-000053-00@the-village.bc.nu" -->
<title>Linux-kernel mailing list archive 1999-36,: Re: Problem allocating DMA memory</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: Problem allocating DMA memory</h1>
<b>Benjamin C.R. LaHaise</b> (<a href="mailto:blah@kvack.org"><i>blah@kvack.org</i></a>)<br>
<i>Mon, 6 Sep 1999 13:18:32 -0400 (EDT)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#274">[ date ]</a><a href="index.html#274">[ thread ]</a><a href="subject.html#274">[ subject ]</a><a href="author.html#274">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0275.html">Simon Richter: "[patch] ACPI groundbreaking stuff"</a>
<li> <b>Previous message:</b> <a href="0273.html">=?iso-8859-1?Q?Gr=E9goire?= FAVRE: "2.3.16 problem and P2B-LS"</a>
<li> <b>In reply to:</b> <a href="0260.html">Alan Cox: "Re: Problem allocating DMA memory"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
On Mon, 6 Sep 1999, Alan Cox wrote:<br>
<p>
<i>&gt; &gt; This patch allows you to turn it off if you have few RAMs or your arch</i><br>
<i>&gt; &gt; doesn't care. I turn it off on my alpha. It seems to work ok.</i><br>
<i>&gt; </i><br>
<i>&gt; I saw the patch. It doesnt address the performance issue</i><br>
<p>
However, this one should.  It has run flawlessly for the past couple of<br>
weeks whenever I've run 2.2.12 (about 1/2 the time), and even makes it<br>
possible to see how much free DMA memory there is (plus eliminates the<br>
huge list walk involved when doing shift-scroll lock).<br>
<p>
		-ben<br>
<p>
--- clean/2.2.12/mm/page_alloc.c	Mon Aug  9 15:04:41 1999<br>
+++ lin2.2/mm/page_alloc.c	Mon Aug 16 00:16:42 1999<br>
@@ -35,17 +35,19 @@<br>
 #else<br>
 #define NR_MEM_LISTS 10<br>
 #endif<br>
+#define NR_MEM_TYPES 2		/* GFP_DMA vs not for now. */<br>
 <br>
 /* The start of this MUST match the start of "struct page" */<br>
 struct free_area_struct {<br>
 	struct page *next;<br>
 	struct page *prev;<br>
 	unsigned int * map;<br>
+	unsigned long count;<br>
 };<br>
 <br>
 #define memory_head(x) ((struct page *)(x))<br>
 <br>
-static struct free_area_struct free_area[NR_MEM_LISTS];<br>
+static struct free_area_struct free_area[NR_MEM_TYPES][NR_MEM_LISTS];<br>
 <br>
 static inline void init_mem_queue(struct free_area_struct * head)<br>
 {<br>
@@ -61,6 +63,7 @@<br>
 	entry-&gt;next = next;<br>
 	next-&gt;prev = entry;<br>
 	head-&gt;next = entry;<br>
+	head-&gt;count++;<br>
 }<br>
 <br>
 static inline void remove_mem_queue(struct page * entry)<br>
@@ -90,9 +93,9 @@<br>
  */<br>
 spinlock_t page_alloc_lock = SPIN_LOCK_UNLOCKED;<br>
 <br>
-static inline void free_pages_ok(unsigned long map_nr, unsigned long order)<br>
+static inline void free_pages_ok(unsigned long map_nr, unsigned long order, unsigned type)<br>
 {<br>
-	struct free_area_struct *area = free_area + order;<br>
+	struct free_area_struct *area = free_area[type] + order;<br>
 	unsigned long index = map_nr &gt;&gt; (1 + order);<br>
 	unsigned long mask = (~0UL) &lt;&lt; order;<br>
 	unsigned long flags;<br>
@@ -106,6 +109,7 @@<br>
 	while (mask + (1 &lt;&lt; (NR_MEM_LISTS-1))) {<br>
 		if (!test_and_change_bit(index, area-&gt;map))<br>
 			break;<br>
+		area-&gt;count--;<br>
 		remove_mem_queue(list(map_nr ^ -mask));<br>
 		mask &lt;&lt;= 1;<br>
 		area++;<br>
@@ -119,33 +123,28 @@<br>
 	spin_unlock_irqrestore(&amp;page_alloc_lock, flags);<br>
 }<br>
 <br>
-void __free_page(struct page *page)<br>
+static inline void __free_pages(struct page *page, unsigned long order)<br>
 {<br>
 	if (!PageReserved(page) &amp;&amp; atomic_dec_and_test(&amp;page-&gt;count)) {<br>
 		if (PageSwapCache(page))<br>
 			panic ("Freeing swap cache page");<br>
 		page-&gt;flags &amp;= ~(1 &lt;&lt; PG_referenced);<br>
-		free_pages_ok(page - mem_map, 0);<br>
+		free_pages_ok(page - mem_map, order, PageDMA(page) ? 1 : 0);<br>
 		return;<br>
 	}<br>
 }<br>
 <br>
+void __free_page(struct page *page)<br>
+{<br>
+	__free_pages(page, 0);<br>
+}<br>
+<br>
 void free_pages(unsigned long addr, unsigned long order)<br>
 {<br>
 	unsigned long map_nr = MAP_NR(addr);<br>
 <br>
-	if (map_nr &lt; max_mapnr) {<br>
-		mem_map_t * map = mem_map + map_nr;<br>
-		if (PageReserved(map))<br>
-			return;<br>
-		if (atomic_dec_and_test(&amp;map-&gt;count)) {<br>
-			if (PageSwapCache(map))<br>
-				panic ("Freeing swap cache pages");<br>
-			map-&gt;flags &amp;= ~(1 &lt;&lt; PG_referenced);<br>
-			free_pages_ok(map_nr, order);<br>
-			return;<br>
-		}<br>
-	}<br>
+	if (map_nr &lt; max_mapnr)<br>
+		__free_pages(mem_map + map_nr, order);<br>
 }<br>
 <br>
 /*<br>
@@ -153,52 +152,9 @@<br>
  */<br>
 #define MARK_USED(index, order, area) \<br>
 	change_bit((index) &gt;&gt; (1+(order)), (area)-&gt;map)<br>
-#define CAN_DMA(x) (PageDMA(x))<br>
 #define ADDRESS(x) (PAGE_OFFSET + ((x) &lt;&lt; PAGE_SHIFT))<br>
-#define RMQUEUE_DMA(order) \<br>
-do { struct free_area_struct * area = free_area+order; \<br>
-     unsigned long new_order = order; \<br>
-	do { struct page *prev = memory_head(area), *ret = prev-&gt;next; \<br>
-		while (memory_head(area) != ret) { \<br>
-			if (CAN_DMA(ret)) { \<br>
-				unsigned long map_nr; \<br>
-				(prev-&gt;next = ret-&gt;next)-&gt;prev = prev; \<br>
-				map_nr = ret - mem_map; \<br>
-				MARK_USED(map_nr, new_order, area); \<br>
-				nr_free_pages -= 1 &lt;&lt; order; \<br>
-				EXPAND(ret, map_nr, order, new_order, area); \<br>
-				spin_unlock_irqrestore(&amp;page_alloc_lock, flags); \<br>
-				return ADDRESS(map_nr); \<br>
-			} \<br>
-			prev = ret; \<br>
-			ret = ret-&gt;next; \<br>
-		} \<br>
-		new_order++; area++; \<br>
-	} while (new_order &lt; NR_MEM_LISTS); \<br>
-} while (0)<br>
-#define RMQUEUE_NODMA(order) \<br>
-do { struct free_area_struct * area = free_area+order; \<br>
-     unsigned long new_order = order; \<br>
-	do { struct page *prev = memory_head(area), *ret = prev-&gt;next; \<br>
-		while (memory_head(area) != ret) { \<br>
-			if (!CAN_DMA(ret)) { \<br>
-				unsigned long map_nr; \<br>
-				(prev-&gt;next = ret-&gt;next)-&gt;prev = prev; \<br>
-				map_nr = ret - mem_map; \<br>
-				MARK_USED(map_nr, new_order, area); \<br>
-				nr_free_pages -= 1 &lt;&lt; order; \<br>
-				EXPAND(ret, map_nr, order, new_order, area); \<br>
-				spin_unlock_irqrestore(&amp;page_alloc_lock, flags); \<br>
-				return ADDRESS(map_nr); \<br>
-			} \<br>
-			prev = ret; \<br>
-			ret = ret-&gt;next; \<br>
-		} \<br>
-		new_order++; area++; \<br>
-	} while (new_order &lt; NR_MEM_LISTS); \<br>
-} while (0)<br>
-#define RMQUEUE_ANY(order) \<br>
-do { struct free_area_struct * area = free_area+order; \<br>
+#define RMQUEUE_TYPE(order, type) \<br>
+do { struct free_area_struct * area = free_area[type]+order; \<br>
      unsigned long new_order = order; \<br>
 	do { struct page *prev = memory_head(area), *ret = prev-&gt;next; \<br>
 		if (memory_head(area) != ret) { \<br>
@@ -207,10 +163,10 @@<br>
 			map_nr = ret - mem_map; \<br>
 			MARK_USED(map_nr, new_order, area); \<br>
 			nr_free_pages -= 1 &lt;&lt; order; \<br>
+			area-&gt;count--; \<br>
 			EXPAND(ret, map_nr, order, new_order, area); \<br>
 			spin_unlock_irqrestore(&amp;page_alloc_lock, flags); \<br>
 			return ADDRESS(map_nr); \<br>
-		 \<br>
 		} \<br>
 		new_order++; area++; \<br>
 	} while (new_order &lt; NR_MEM_LISTS); \<br>
@@ -275,12 +231,10 @@<br>
 	}<br>
 ok_to_allocate:<br>
 	spin_lock_irqsave(&amp;page_alloc_lock, flags);<br>
-	if (gfp_mask &amp; __GFP_DMA)<br>
-		RMQUEUE_DMA(order);<br>
-	else {<br>
-		RMQUEUE_NODMA(order);<br>
-		RMQUEUE_ANY(order);<br>
-	}<br>
+	/* if it's not a dma request, try non-dma first */<br>
+	if (!(gfp_mask &amp; __GFP_DMA))<br>
+		RMQUEUE_TYPE(order, 0);<br>
+	RMQUEUE_TYPE(order, 1);<br>
 	spin_unlock_irqrestore(&amp;page_alloc_lock, flags);<br>
 <br>
 	/*<br>
@@ -305,26 +259,27 @@<br>
 void show_free_areas(void)<br>
 {<br>
  	unsigned long order, flags;<br>
- 	unsigned long total = 0;<br>
+	unsigned type;<br>
 <br>
+	spin_lock_irqsave(&amp;page_alloc_lock, flags);<br>
 	printk("Free pages:      %6dkB\n ( ",nr_free_pages&lt;&lt;(PAGE_SHIFT-10));<br>
 	printk("Free: %d (%d %d %d)\n",<br>
 		nr_free_pages,<br>
 		freepages.min,<br>
 		freepages.low,<br>
 		freepages.high);<br>
-	spin_lock_irqsave(&amp;page_alloc_lock, flags);<br>
- 	for (order=0 ; order &lt; NR_MEM_LISTS; order++) {<br>
-		struct page * tmp;<br>
-		unsigned long nr = 0;<br>
-		for (tmp = free_area[order].next ; tmp != memory_head(free_area+order) ; tmp = tmp-&gt;next) {<br>
-			nr ++;<br>
+	for (type = 0; type &lt; NR_MEM_TYPES; type++) {<br>
+ 		unsigned long total = 0;<br>
+		printk("%sDMA: ", type ? "" : "Non");<br>
+ 		for (order=0 ; order &lt; NR_MEM_LISTS; order++) {<br>
+			unsigned long nr = free_area[type][order].count;<br>
+<br>
+			total += nr * ((PAGE_SIZE&gt;&gt;10) &lt;&lt; order);<br>
+			printk("%lu*%lukB ", nr, (unsigned long)((PAGE_SIZE&gt;&gt;10) &lt;&lt; order));<br>
 		}<br>
-		total += nr * ((PAGE_SIZE&gt;&gt;10) &lt;&lt; order);<br>
-		printk("%lu*%lukB ", nr, (unsigned long)((PAGE_SIZE&gt;&gt;10) &lt;&lt; order));<br>
+		printk("= %lukB)\n", total);<br>
 	}<br>
 	spin_unlock_irqrestore(&amp;page_alloc_lock, flags);<br>
-	printk("= %lukB)\n", total);<br>
 #ifdef SWAP_CACHE_INFO<br>
 	show_swap_cache_info();<br>
 #endif	<br>
@@ -341,8 +296,7 @@<br>
 unsigned long __init free_area_init(unsigned long start_mem, unsigned long end_mem)<br>
 {<br>
 	mem_map_t * p;<br>
-	unsigned long mask = PAGE_MASK;<br>
-	unsigned long i;<br>
+	unsigned long i, j;<br>
 <br>
 	/*<br>
 	 * Select nr of pages we try to keep free for important stuff<br>
@@ -369,17 +323,20 @@<br>
 		p-&gt;flags = (1 &lt;&lt; PG_DMA) | (1 &lt;&lt; PG_reserved);<br>
 	} while (p &gt; mem_map);<br>
 <br>
-	for (i = 0 ; i &lt; NR_MEM_LISTS ; i++) {<br>
-		unsigned long bitmap_size;<br>
-		init_mem_queue(free_area+i);<br>
-		mask += mask;<br>
-		end_mem = (end_mem + ~mask) &amp; mask;<br>
-		bitmap_size = (end_mem - PAGE_OFFSET) &gt;&gt; (PAGE_SHIFT + i);<br>
-		bitmap_size = (bitmap_size + 7) &gt;&gt; 3;<br>
-		bitmap_size = LONG_ALIGN(bitmap_size);<br>
-		free_area[i].map = (unsigned int *) start_mem;<br>
-		memset((void *) start_mem, 0, bitmap_size);<br>
-		start_mem += bitmap_size;<br>
+	for (j = 0; j &lt; NR_MEM_TYPES; j++) {<br>
+		unsigned long mask = PAGE_MASK;<br>
+		for (i = 0 ; i &lt; NR_MEM_LISTS ; i++) {<br>
+			unsigned long bitmap_size;<br>
+			init_mem_queue(free_area[j]+i);<br>
+			mask += mask;<br>
+			end_mem = (end_mem + ~mask) &amp; mask;<br>
+			bitmap_size = (end_mem - PAGE_OFFSET) &gt;&gt; (PAGE_SHIFT + i);<br>
+			bitmap_size = (bitmap_size + 7) &gt;&gt; 3;<br>
+			bitmap_size = LONG_ALIGN(bitmap_size);<br>
+			free_area[j][i].map = (unsigned int *) start_mem;<br>
+			memset((void *) start_mem, 0, bitmap_size);<br>
+			start_mem += bitmap_size;<br>
+		}<br>
 	}<br>
 	return start_mem;<br>
 }<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0275.html">Simon Richter: "[patch] ACPI groundbreaking stuff"</a>
<li> <b>Previous message:</b> <a href="0273.html">=?iso-8859-1?Q?Gr=E9goire?= FAVRE: "2.3.16 problem and P2B-LS"</a>
<li> <b>In reply to:</b> <a href="0260.html">Alan Cox: "Re: Problem allocating DMA memory"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
