<!-- received="Mon Sep  6 20:33:48 1999 EET DST" -->
<!-- sent="Mon, 6 Sep 1999 19:18:46 +0200 (CEST)" -->
<!-- name="Simon Richter" -->
<!-- email="geier@phobos.fachschaften.tu-muenchen.de" -->
<!-- subject="[patch] ACPI groundbreaking stuff" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-36,: [patch] ACPI groundbreaking stuff</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[patch] ACPI groundbreaking stuff</h1>
<b>Simon Richter</b> (<a href="mailto:geier@phobos.fachschaften.tu-muenchen.de"><i>geier@phobos.fachschaften.tu-muenchen.de</i></a>)<br>
<i>Mon, 6 Sep 1999 19:18:46 +0200 (CEST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#275">[ date ]</a><a href="index.html#275">[ thread ]</a><a href="subject.html#275">[ subject ]</a><a href="author.html#275">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0276.html">Jamie Lokier: "Re: iput: Aieee, semaphore in use inode 00:00/XXX, count=2"</a>
<li> <b>Previous message:</b> <a href="0274.html">Benjamin C.R. LaHaise: "Re: Problem allocating DMA memory"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hi,<br>
<p>
Since the ACPI4Linux project has restarted their repository (the direction<br>
the code went into was a dead end that made testing basically impossible),<br>
we start from a clean kernel now.<br>
<p>
This very first patch makes memory init more verbose and adds the<br>
configuration options for ACPI (also known as the big red switch), so we<br>
can play. :-)<br>
<p>
Also, it adds the possibility to free ACPI tables that are not required by<br>
the BIOS anymore instantly (for those who do not want ACPI support) and<br>
adds the ACPI4Linux project to the maintainers list. It should apply<br>
cleanly to 2.3.16.<br>
<p>
<p>
<p>
Index: acpi/linux/MAINTAINERS<br>
diff -u acpi/linux/MAINTAINERS:1.1.1.1 acpi/linux/MAINTAINERS:1.2<br>
--- acpi/linux/MAINTAINERS:1.1.1.1	Sun Sep  5 13:19:19 1999<br>
+++ acpi/linux/MAINTAINERS	Mon Sep  6 17:17:58 1999<br>
@@ -93,6 +93,15 @@<br>
 L:	<a href="mailto:linux-net@vger.rutgers.edu">linux-net@vger.rutgers.edu</a><br>
 S:	Maintained<br>
 <br>
+ACPI POWER MANAGEMENT<br>
+P:	Max Berger<br>
+P:	Simon Richter<br>
+M:	<a href="mailto:acpi-project@phobos.fs.tum.de">acpi-project@phobos.fs.tum.de</a><br>
+M:	<a href="mailto:Max.Berger@phobos.fs.tum.de">Max.Berger@phobos.fs.tum.de</a><br>
+M:	<a href="mailto:Simon.Richter@phobos.fs.tum.de">Simon.Richter@phobos.fs.tum.de</a><br>
+L:	<a href="mailto:acpi@phobos.fs.tum.de">acpi@phobos.fs.tum.de</a><br>
+S:	Maintained<br>
+<br>
 AD1816 SOUND DRIVER<br>
 P:	Thorsten Knabe<br>
 M:	Thorsten Knabe &lt;<a href="mailto:tek@rbg.informatik.tu-darmstadt.de">tek@rbg.informatik.tu-darmstadt.de</a>&gt;<br>
Index: acpi/linux/Documentation/Configure.help<br>
diff -u acpi/linux/Documentation/Configure.help:1.1.1.1 acpi/linux/Documentation/Configure.help:1.2<br>
--- acpi/linux/Documentation/Configure.help:1.1.1.1	Sun Sep  5 13:22:50 1999<br>
+++ acpi/linux/Documentation/Configure.help	Mon Sep  6 17:18:32 1999<br>
@@ -9136,6 +9136,30 @@<br>
 <br>
   If unsure, say N.<br>
 <br>
+Advanced Configuration and Power Interface<br>
+CONFIG_ACPI<br>
+  ACPI is a new specification designed as a replacement for APM. It<br>
+  allows a much finer grained power management that APM did, plus it<br>
+  provides temperature management control (when to turn on fans, that<br>
+  is) and configuration management (docking/undocking devices, ...).<br>
+  It can not only make coffee but the entire breakfast.<br>
+<br>
+  ACPI is available on some Pentium and almost all PentiumII and<br>
+  PentiumIII motherboards. The best thing is to look into your<br>
+  mainboard documentation. 386 and 486 owners should say N here.<br>
+<br>
+Free ACPI tables on boot<br>
+CONFIG_ACPI_NOTATALL<br>
+  If you choose not to enable ACPI but your system has ACPI support,<br>
+  your BIOS will mark some areas as being "reserved for ACPI". If you<br>
+  enable this, these areas will be freed. On systems without ACPI<br>
+  support, this option has no effect.<br>
+<br>
+  Say Y only if you know that you will not need ACPI. If you enable<br>
+  this, you will not be able to build the initializer module unless<br>
+  you boot with a new kernel without this option. On the other hand,<br>
+  this will free some more memory if you don't want ACPI.<br>
+<br>
 Advanced Power Management<br>
 CONFIG_APM<br>
   APM is a BIOS specification for saving power using several different<br>
Index: acpi/linux/arch/i386/config.in<br>
diff -u acpi/linux/arch/i386/config.in:1.1.1.1 acpi/linux/arch/i386/config.in:1.3<br>
--- acpi/linux/arch/i386/config.in:1.1.1.1	Sun Sep  5 13:22:09 1999<br>
+++ acpi/linux/arch/i386/config.in	Mon Sep  6 18:52:59 1999<br>
@@ -92,17 +92,29 @@<br>
 <br>
 source drivers/parport/Config.in<br>
 <br>
-tristate 'Advanced Power Management BIOS support' CONFIG_APM<br>
-if [ "$CONFIG_APM" != "n" ]; then<br>
-  bool '   Ignore USER SUSPEND' CONFIG_APM_IGNORE_USER_SUSPEND<br>
-  bool '   Enable PM at boot time' CONFIG_APM_DO_ENABLE<br>
-  bool '   Make CPU Idle calls when idle' CONFIG_APM_CPU_IDLE<br>
-  bool '   Enable console blanking using APM' CONFIG_APM_DISPLAY_BLANK<br>
-  bool '   Power off on shutdown' CONFIG_APM_POWER_OFF<br>
-  bool '   Ignore multiple suspend' CONFIG_APM_IGNORE_MULTIPLE_SUSPEND<br>
-  bool '   Ignore multiple suspend/resume cycles' CONFIG_APM_IGNORE_SUSPEND_BOUNCE<br>
-  bool '   RTC stores time in GMT' CONFIG_APM_RTC_IS_GMT<br>
-  bool '   Allow interrupts during APM BIOS calls' CONFIG_APM_ALLOW_INTS<br>
+if [ "$CONFIG_EXPERIMENTAL" = "y" ]; then<br>
+  bool 'Advanced Configuration and Power Interface support (EXPERIMENTAL)' CONFIG_ACPI<br>
+else<br>
+  define_bool CONFIG_ACPI n<br>
+fi<br>
+<br>
+if [ "$CONFIG_ACPI" = "n" ]; then<br>
+  if [ "$CONFIG_EXPERIMENTAL" = "y" ]; then<br>
+    bool '   Free ACPI tables on boot (EXPERIMENTAL)' CONFIG_ACPI_NOTATALL<br>
+  fi<br>
+<br>
+  tristate 'Advanced Power Management BIOS support' CONFIG_APM<br>
+  if [ "$CONFIG_APM" != "n" ]; then<br>
+    bool '   Ignore USER SUSPEND' CONFIG_APM_IGNORE_USER_SUSPEND<br>
+    bool '   Enable PM at boot time' CONFIG_APM_DO_ENABLE<br>
+    bool '   Make CPU Idle calls when idle' CONFIG_APM_CPU_IDLE<br>
+    bool '   Enable console blanking using APM' CONFIG_APM_DISPLAY_BLANK<br>
+    bool '   Power off on shutdown' CONFIG_APM_POWER_OFF<br>
+    bool '   Ignore multiple suspend' CONFIG_APM_IGNORE_MULTIPLE_SUSPEND<br>
+    bool '   Ignore multiple suspend/resume cycles' CONFIG_APM_IGNORE_SUSPEND_BOUNCE<br>
+    bool '   RTC stores time in GMT' CONFIG_APM_RTC_IS_GMT<br>
+    bool '   Allow interrupts during APM BIOS calls' CONFIG_APM_ALLOW_INTS<br>
+  fi<br>
 fi<br>
 <br>
 endmenu<br>
Index: acpi/linux/arch/i386/mm/init.c<br>
diff -u acpi/linux/arch/i386/mm/init.c:1.1.1.1 acpi/linux/arch/i386/mm/init.c:1.2<br>
--- acpi/linux/arch/i386/mm/init.c:1.1.1.1	Sun Sep  5 13:22:10 1999<br>
+++ acpi/linux/arch/i386/mm/init.c	Mon Sep  6 17:20:00 1999<br>
@@ -413,11 +413,34 @@<br>
 	/* walk the whitelist, unreserving good memory<br>
 	 */<br>
 	for (avail = i = 0; i &lt; e820.nr_map; i++) {<br>
-		if (e820.map[i].type != 1)	/* not usable memory */<br>
-			continue;<br>
-		printk("memory region: %luk @ %08lx\n",<br>
+		printk("memory region: %luk @ %08lx ",<br>
 				    ((long)(e820.map[i].size)) / 1024,<br>
 				    (long)(e820.map[i].addr) );<br>
+		switch(e820.map[i].type) {<br>
+		case 1:<br>
+			printk("(system memory)");<br>
+			break;<br>
+		case 2:<br>
+			printk("(reserved)");<br>
+			break;<br>
+		case 3:<br>
+#ifdef CONFIG_ACPI_NOTATALL<br>
+			printk("(system memory [ACPI reclaim])");<br>
+			e820.map[i].type = 1;<br>
+#else<br>
+			printk("(ACPI reclaim memory)");<br>
+#endif<br>
+			break;<br>
+		case 4:<br>
+			printk("(ACPI NVS memory)");<br>
+			break;<br>
+		default:<br>
+			printk("(unknown memory type, unusable)");<br>
+		}<br>
+		printk("\n");<br>
+<br>
+		if (e820.map[i].type != 1)	/* not usable memory */<br>
+			continue;<br>
 		for (addr=PAGE_ALIGN(((long)(e820.map[i].addr)))+PAGE_OFFSET,<br>
 								     tmp = 0;<br>
 				     tmp &lt; (unsigned long)(e820.map[i].size);<br>
<p>
Is the patch acceptable this way?<br>
<p>
   Simon<br>
<p>
PGP public key available from <a href="ftp://phobos.fs.tum.de/pub/pgp/geier.asc">ftp://phobos.fs.tum.de/pub/pgp/geier.asc</a><br>
 Fingerprint: 10 62 F6 F5 C0 5D 9E D8  47 05 1B 8A 22 E5 4E C1<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0276.html">Jamie Lokier: "Re: iput: Aieee, semaphore in use inode 00:00/XXX, count=2"</a>
<li> <b>Previous message:</b> <a href="0274.html">Benjamin C.R. LaHaise: "Re: Problem allocating DMA memory"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
