<!-- received="Tue Sep  7 19:07:30 1999 EET DST" -->
<!-- sent="Tue, 07 Sep 1999 11:54:25 +0200" -->
<!-- name="Martin Schenk" -->
<!-- email="schenkm@eunet.at" -->
<!-- subject="testpatch for faster fsync on larger files (2.2.12)" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-36,: testpatch for faster fsync on larger files (2.2.12)</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>testpatch for faster fsync on larger files (2.2.12)</h1>
<b>Martin Schenk</b> (<a href="mailto:schenkm@eunet.at"><i>schenkm@eunet.at</i></a>)<br>
<i>Tue, 07 Sep 1999 11:54:25 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#371">[ date ]</a><a href="index.html#371">[ thread ]</a><a href="subject.html#371">[ subject ]</a><a href="author.html#371">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0372.html">Alexander S A Kjeldaas: "Re: loop.c transfer module api"</a>
<li> <b>Previous message:</b> <a href="0370.html">Keith Owens: "Re: Oops in 2.2.12"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
This is a multi-part message in MIME format.<br>
--------------8255755D04C3BF741A7CC351<br>
Content-Type: text/plain; charset=us-ascii<br>
Content-Transfer-Encoding: 7bit<br>
<p>
Here is a patch which tests my faster implementation of fsync while<br>
still using the original (slow) implementation.<br>
This new implementation uses the way fsync for ext2 scans through<br>
the hierarchy of indirect blocks used in ext2 in order to prune most<br>
of the scans.<br>
If TEST_FASTFSYNC is defined, my patch goes through the entire<br>
hierarchy like the old implementation did but checks all writes<br>
whether they would have occured in the new version, too.<br>
<p>
Using this patch with TEST_FASTSYNC, you can check whether the<br>
new fsync code works for you without any risk and without noticable<br>
extra processing cost.<br>
<p>
When you are comfortable with it, you might want to use<br>
CONFIG_FASTSYNC to actually get the speed increases.<br>
<p>
If you use this patch, please contact me (especially if you get<br>
error messages, but also if it seems to work).<br>
<p>
PS: I just looked into 2.3.16 to see how I might implement something<br>
like this, but it will have to be done very differently.<br>
<pre>
-- 
Martin Schenk &lt;<a href="mailto:schenkm@eunet.at">schenkm@eunet.at</a>&gt;
Richard-Wagnergasse 46, A-8010 Graz, Austria
--------------8255755D04C3BF741A7CC351
Content-Type: text/plain; charset=us-ascii; name="fsyncpatch"
Content-Transfer-Encoding: 7bit
Content-Disposition: inline; filename="fsyncpatch"
<p>
diff -urN linuxelf-2.2.orig/fs/ext2/fsync.c linuxelf-2.2/fs/ext2/fsync.c
--- linuxelf-2.2.orig/fs/ext2/fsync.c	Wed May 20 22:09:12 1998
+++ linuxelf-2.2/fs/ext2/fsync.c	Tue Sep  7 11:21:32 1999
@@ -35,10 +35,21 @@
 #define blocksize (EXT2_BLOCK_SIZE(inode-&gt;i_sb))
 #define addr_per_block (EXT2_ADDR_PER_BLOCK(inode-&gt;i_sb))
 
+#ifdef TEST_FASTSYNC
+static int pruned=0;	/* pruned=1 -&gt; this part would not be scanned by FASTSYNC */
+static int fastsyncerr=0;	/* number of errors ! */
+static int blocks_written=0;	/* number of written blocks */
+static int blocks_scanned=0;	/* number of scanned blocks */
+static int blocks_pruned=0;	/* number of blocks that FASTSYNC would not scan */
+#endif
+
 static int sync_block (struct inode * inode, u32 * block, int wait)
 {
 	struct buffer_head * bh;
-	
+#ifdef TEST_FASTSYNC
+	blocks_scanned++;
+	if (pruned) blocks_pruned++;
+#endif	
 	if (!*block)
 		return 0;
 	bh = get_hash_table (inode-&gt;i_dev, *block, blocksize);
@@ -52,6 +63,10 @@
 		brelse (bh);
 		return 0;
 	}
+#ifdef TEST_FASTSYNC
+	if (pruned) fastsyncerr++;	/* we would not write this block :-( */
+	blocks_written++;
+#endif
 	ll_rw_block (WRITE, 1, &amp;bh);
 	bh-&gt;b_count--;
 	return 0;
@@ -142,10 +157,23 @@
 	int i;
 	struct buffer_head * ind_bh;
 	int rc, err = 0;
+#ifdef TEST_FASTSYNC
+	int i_pruned=0;
+#endif
 
 	rc = sync_iblock (inode, iblock, &amp;ind_bh, wait);
 	if (rc || !ind_bh)
 		return rc;
+
+#ifdef CONFIG_FASTSYNC
+	if (!ind_bh-&gt;sync_depend) 
+	{	brelse(ind_bh); return 0; } /* no changes to dependents */
+#endif
+#ifdef TEST_FASTSYNC
+	if (!ind_bh-&gt;sync_depend &amp;&amp; !pruned)
+	{	pruned=1; i_pruned=1;
+	}
+#endif
 	
 	for (i = 0; i &lt; addr_per_block; i++) {
 		rc = sync_block_swab32 (inode, 
@@ -154,6 +182,14 @@
 		if (rc)
 			err = rc;
 	}
+
+#ifdef CONFIG_FASTSYNC
+	if (wait) ind_bh-&gt;sync_depend=0;
+#endif
+#ifdef TEST_FASTSYNC
+	if (wait) ind_bh-&gt;sync_depend=0;
+	if (i_pruned) pruned=0;
+#endif
 	brelse (ind_bh);
 	return err;
 }
@@ -164,10 +200,23 @@
 	int i;
 	struct buffer_head * ind_bh;
 	int rc, err = 0;
+#ifdef TEST_FASTSYNC
+	int i_pruned=0;
+#endif
 
 	rc = sync_iblock_swab32 (inode, iblock, &amp;ind_bh, wait);
 	if (rc || !ind_bh)
 		return rc;
+
+#ifdef CONFIG_FASTSYNC
+	if (!ind_bh-&gt;sync_depend) 
+	{	brelse(ind_bh); return 0; } /* no changes to dependents */
+#endif
+#ifdef TEST_FASTSYNC
+	if (!ind_bh-&gt;sync_depend &amp;&amp; !pruned)
+	{	pruned=1; i_pruned=1;
+	}
+#endif
 	
 	for (i = 0; i &lt; addr_per_block; i++) {
 		rc = sync_block_swab32 (inode, 
@@ -176,6 +225,14 @@
 		if (rc)
 			err = rc;
 	}
+
+#ifdef CONFIG_FASTSYNC
+	if (wait) ind_bh-&gt;sync_depend=0;
+#endif
+#ifdef TEST_FASTSYNC
+	if (wait) ind_bh-&gt;sync_depend=0;
+	if (i_pruned) pruned=0;
+#endif
 	brelse (ind_bh);
 	return err;
 }
@@ -188,10 +245,23 @@
 	int i;
 	struct buffer_head * dind_bh;
 	int rc, err = 0;
+#ifdef TEST_FASTSYNC
+	int i_pruned=0;
+#endif
 
 	rc = sync_iblock (inode, diblock, &amp;dind_bh, wait);
 	if (rc || !dind_bh)
 		return rc;
+
+#ifdef CONFIG_FASTSYNC
+	if (!dind_bh-&gt;sync_depend) 
+	{	brelse(dind_bh); return 0; } /* no changes to dependents */
+#endif
+#ifdef TEST_FASTSYNC
+	if (!dind_bh-&gt;sync_depend &amp;&amp; !pruned)
+	{	pruned=1; i_pruned=1;
+	}
+#endif
 	
 	for (i = 0; i &lt; addr_per_block; i++) {
 		rc = sync_indirect_swab32 (inode,
@@ -200,6 +270,15 @@
 		if (rc)
 			err = rc;
 	}
+
+#ifdef CONFIG_FASTSYNC
+	if (wait) dind_bh-&gt;sync_depend=0;
+#endif
+#ifdef TEST_FASTSYNC
+	if (wait) dind_bh-&gt;sync_depend=0;
+	if (i_pruned) pruned=0;
+#endif
+
 	brelse (dind_bh);
 	return err;
 }
@@ -210,10 +289,23 @@
 	int i;
 	struct buffer_head * dind_bh;
 	int rc, err = 0;
+#ifdef TEST_FASTSYNC
+	int i_pruned=0;
+#endif
 
 	rc = sync_iblock_swab32 (inode, diblock, &amp;dind_bh, wait);
 	if (rc || !dind_bh)
 		return rc;
+
+#ifdef CONFIG_FASTSYNC
+	if (!dind_bh-&gt;sync_depend) 
+	{	brelse(dind_bh); return 0; } /* no changes to dependents */
+#endif
+#ifdef TEST_FASTSYNC
+	if (!dind_bh-&gt;sync_depend &amp;&amp; !pruned)
+	{	pruned=1; i_pruned=1;
+	}
+#endif
 	
 	for (i = 0; i &lt; addr_per_block; i++) {
 		rc = sync_indirect_swab32 (inode,
@@ -222,6 +314,14 @@
 		if (rc)
 			err = rc;
 	}
+
+#ifdef CONFIG_FASTSYNC
+	if (wait) dind_bh-&gt;sync_depend=0;
+#endif
+#ifdef TEST_FASTSYNC
+	if (wait) dind_bh-&gt;sync_depend=0;
+	if (i_pruned) pruned=0;
+#endif
 	brelse (dind_bh);
 	return err;
 }
@@ -234,10 +334,24 @@
 	int i;
 	struct buffer_head * tind_bh;
 	int rc, err = 0;
+#ifdef TEST_FASTSYNC
+	int i_pruned=0;
+#endif
 
 	rc = sync_iblock (inode, tiblock, &amp;tind_bh, wait);
 	if (rc || !tind_bh)
 		return rc;
+
+#ifdef CONFIG_FASTSYNC
+	if (!tind_bh-&gt;sync_depend) /* no changes to dependents */
+	{	brelse(tind_bh); return 0; 
+	}
+#endif
+#ifdef TEST_FASTSYNC
+	if (!tind_bh-&gt;sync_depend &amp;&amp; !pruned)
+	{	pruned=1; i_pruned=1;
+	}
+#endif
 	
 	for (i = 0; i &lt; addr_per_block; i++) {
 		rc = sync_dindirect_swab32 (inode,
@@ -246,6 +360,14 @@
 		if (rc)
 			err = rc;
 	}
+
+#ifdef CONFIG_FASTSYNC
+	if (wait) tind_bh-&gt;sync_depend=0;
+#endif
+#ifdef TEST_FASTSYNC
+	if (wait) tind_bh-&gt;sync_depend=0;
+	if (i_pruned) pruned=0;
+#endif
 	brelse (tind_bh);
 	return err;
 }
@@ -266,6 +388,10 @@
 		 */
 		goto skip;
 
+#ifdef TEST_FASTSYNC
+	pruned=0; blocks_pruned=0; blocks_scanned=0;
+	blocks_written=0; fastsyncerr=0;
+#endif
 	for (wait=0; wait&lt;=1; wait++)
 	{
 		err |= sync_direct (inode, wait);
@@ -279,6 +405,22 @@
 				       inode-&gt;u.ext2_i.i_data+EXT2_TIND_BLOCK, 
 				       wait);
 	}
+#ifdef TEST_FASTSYNC
+	if (fastsyncerr)
+	{
+		printk("error in FASTSYNC-algorithm: %d blocks would not have been synced\n", 
+			fastsyncerr);
+		printk("%d blocks were written, %d scanned, %d pruned\n", 
+			blocks_written, blocks_scanned, blocks_pruned);
+	}
+#ifdef FASTSYNC_STAT
+	if (blocks_pruned/(blocks_scanned-blocks_pruned) &gt; 10)	/* tell us if we pruned &gt; 90% of scanns */
+	{	printk("FASTSYNC (good news): %d blocks pruned, %d scanned\n",
+			blocks_pruned, blocks_scanned);
+	}
+#endif
+#endif
+
 skip:
 	err |= ext2_sync_inode (inode);
 	return err ? -EIO : 0;
diff -urN linuxelf-2.2.orig/fs/ext2/inode.c linuxelf-2.2/fs/ext2/inode.c
--- linuxelf-2.2.orig/fs/ext2/inode.c	Mon Aug  9 21:04:57 1999
+++ linuxelf-2.2/fs/ext2/inode.c	Tue Sep  7 10:58:10 1999
@@ -283,6 +283,12 @@
 			return NULL;
 		}
 	}
+#ifdef CONFIG_FASTSYNC
+	if (create) bh-&gt;sync_depend=1;	/* changes to dependents possible */
+#endif
+#ifdef TEST_FASTSYNC
+	if (create) bh-&gt;sync_depend=1;	/* changes to dependents possible */
+#endif
 	p = (u32 *) bh-&gt;b_data + nr;
 repeat:
 	tmp = le32_to_cpu(*p);
diff -urN linuxelf-2.2.orig/include/linux/fs.h linuxelf-2.2/include/linux/fs.h
--- linuxelf-2.2.orig/include/linux/fs.h	Thu Aug 26 02:29:52 1999
+++ linuxelf-2.2/include/linux/fs.h	Tue Sep  7 10:58:49 1999
@@ -226,6 +226,17 @@
 	 */
 	void (*b_end_io)(struct buffer_head *bh, int uptodate);
 	void *b_dev_id;
+
+#ifdef CONFIG_FASTSYNC			/* faster fsync for large files on EXT2 */
+	int	sync_depend:1;		/* (Double/Triple)Indirect-Buffer:
+					   true -&gt; points to a possibly changed buffer,
+					   false -&gt;no changes done, sync does not need to
+						   check dependents
+					*/ 
+#endif
+#ifdef TEST_FASTSYNC
+	int	sync_depend:1;
+#endif
 };
 
 typedef void (bh_end_io_t)(struct buffer_head *bh, int uptodate);
<p>
--------------8255755D04C3BF741A7CC351--
<p>
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0372.html">Alexander S A Kjeldaas: "Re: loop.c transfer module api"</a>
<li> <b>Previous message:</b> <a href="0370.html">Keith Owens: "Re: Oops in 2.2.12"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
