<!-- received="Tue Sep  7 19:25:23 1999 EET DST" -->
<!-- sent="Tue, 7 Sep 1999 18:28:51 +0200 (CEST)" -->
<!-- name="Marek Zelem" -->
<!-- email="marek@fornax.elf.stuba.sk" -->
<!-- subject="[PATCH] 2.2.x bugfix (signal handling)" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-36,: [PATCH] 2.2.x bugfix (signal handling)</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] 2.2.x bugfix (signal handling)</h1>
<b>Marek Zelem</b> (<a href="mailto:marek@fornax.elf.stuba.sk"><i>marek@fornax.elf.stuba.sk</i></a>)<br>
<i>Tue, 7 Sep 1999 18:28:51 +0200 (CEST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#375">[ date ]</a><a href="index.html#375">[ thread ]</a><a href="subject.html#375">[ subject ]</a><a href="author.html#375">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0376.html">Enrique Vidal: "RTC Alarm IRQ-8"</a>
<li> <b>Previous message:</b> <a href="0374.html">Lorenzo Allegrucci: "clone() and CLONE_PID"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0378.html">Davide Libenzi: "Re: [PATCH] 2.2.x bugfix (signal handling)"</a>
<li> <b>Reply:</b> <a href="0378.html">Davide Libenzi: "Re: [PATCH] 2.2.x bugfix (signal handling)"</a>
<li> <b>Reply:</b> <a href="0386.html">Camm Maguire: "2.2.11: unkillable, perpetually-sleeping rpciod"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hi,<br>
<p>
I've found a bug in kernel/signal.c, which causes unkillable processes,<br>
increasing load by 1 for each instance of such process.<br>
<p>
When process is exiting, it's state is changed to TASK_ZOMBIE in<br>
do_exit(). After this, signals are sent to the parent process and<br>
to the actual process group. We made some changes to the signal<br>
delivering code, which contained re-scheduling. After return into<br>
do_exit(), current process had TASK_RUNNING set, because of queued<br>
signals. This caused infinite loop. I understand that this is my fault<br>
(due to rescheduling), but I noticed such tasks on server running original<br>
kernel (2.2.9, 2.2.10) sometimes - it's heavy loaded server and many users<br>
are doing many things there, which may cause re-scheduling after<br>
state-change at places, where author assumed that state of process will<br>
remain unchanged.<br>
<p>
This have to be true for the zombies, so I propose following patch<br>
to the kernel/signal.c:<br>
<p>
--- signal.c.orig	Tue Sep  7 17:23:50 1999<br>
+++ signal.c	Tue Sep  7 17:25:22 1999<br>
@@ -260,6 +260,10 @@<br>
 	ret = -EINVAL;<br>
 	if (sig &lt; 0 || sig &gt; _NSIG)<br>
 		goto out_nolock;<br>
+	/* Zombie task cannot be killed! &lt;<a href="mailto:marek@fornax.elf.stuba.sk">marek@fornax.elf.stuba.sk</a>&gt; */<br>
+	ret = -ESRCH;<br>
+	if ( t-&gt;state == TASK_ZOMBIE )<br>
+		goto out_nolock;<br>
 	/* The somewhat baroque permissions check... */<br>
 	ret = -EPERM;<br>
 	if ((!info || ((unsigned long)info != 1 &amp;&amp; SI_FROMUSER(info)))<br>
<p>
Let me know, if I got it wrong.<br>
<p>
Thanks,<br>
		Marek Zelem<br>
<p>
<pre>
--
  e-mail: <a href="mailto:marek@fornax.elf.stuba.sk">marek@fornax.elf.stuba.sk</a>
          <a href="mailto:marek.zelem@pobox.sk">marek.zelem@pobox.sk</a>
  web: <a href="http://fornax.elf.stuba.sk/~marek/">http://fornax.elf.stuba.sk/~marek/</a>
  pgp key: <a href="http://fornax.elf.stuba.sk/~marek/pgp.txt">http://fornax.elf.stuba.sk/~marek/pgp.txt</a>
<p>
<p>
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0376.html">Enrique Vidal: "RTC Alarm IRQ-8"</a>
<li> <b>Previous message:</b> <a href="0374.html">Lorenzo Allegrucci: "clone() and CLONE_PID"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0378.html">Davide Libenzi: "Re: [PATCH] 2.2.x bugfix (signal handling)"</a>
<li> <b>Reply:</b> <a href="0378.html">Davide Libenzi: "Re: [PATCH] 2.2.x bugfix (signal handling)"</a>
<li> <b>Reply:</b> <a href="0386.html">Camm Maguire: "2.2.11: unkillable, perpetually-sleeping rpciod"</a>
<!-- reply="end" -->
</ul>
</font></body>
