<!-- received="Tue Sep  7 22:50:55 1999 EET DST" -->
<!-- sent="7 Sep 1999 12:38:00 -0700" -->
<!-- name="david parsons" -->
<!-- email="o.r.c@p.e.l.l.p.o.r.t.l.a.n.d.o.r.u.s" -->
<!-- subject="[PATCH] 2.3.17 -- shut up binfmt_aout, and put back old flocking" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-36,: [PATCH] 2.3.17 -- shut up binfmt_aout, and put back old flocking</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] 2.3.17 -- shut up binfmt_aout, and put back old flocking</h1>
<b>david parsons</b> (<a href="mailto:o.r.c@p.e.l.l.p.o.r.t.l.a.n.d.o.r.u.s"><i>o.r.c@p.e.l.l.p.o.r.t.l.a.n.d.o.r.u.s</i></a>)<br>
<i>7 Sep 1999 12:38:00 -0700</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#405">[ date ]</a><a href="index.html#405">[ thread ]</a><a href="subject.html#405">[ subject ]</a><a href="author.html#405">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0406.html">Guest section DW: "Re: Would anyone miss devices.tex?"</a>
<li> <b>Previous message:</b> <a href="0404.html">Alan Cox: "Re: RH6.0 C compiler doesn't recognize "\""</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
This little patch does two things.  <br>
<p>
1) It makes binfmt_aout shut up about non-pagealigned libraries and<br>
   executables  (an a.out library (libc 4.8.0) built last month with gcc<br>
   2.7.2.3 and binutils 2.9.1 makes binfmt_aout scream) and gives me<br>
   back about 10k of syslog when the system boots up.<br>
<p>
2) It puts back the old mappings of F_SHLCK -&gt; F_RDLCK and F_EXLCK -&gt; F_WRLCK<br>
   so that old binaries (statically linked a.out and dynamically linked<br>
   a.out against libraries older than libc 4.8.0) won't fail when they<br>
   try to make rdlocks and wrlocks.<br>
<p>
The first part has a negative space impact, and the second has a small<br>
positive space impact, but that's compensated for by keeping an binary<br>
interface compatable.<br>
<p>
This patch goes cleanly into 2.3.13, 2.3.14, 2.3.15, 2.3.16, and 2.3.17pre1,<br>
so ignore the 2.3.13 behind the curtain.<br>
<p>
Is there any chance they could go into 2.3.18, and cut down my carnival<br>
of patches that I need to apply to the development kernels so I can use<br>
them on Mastodon?<br>
<p>
                  ____<br>
    david parsons \bi/ &lt;Insert blatant grovelling here&gt;<br>
                   \/<br>
<p>
<p>
diff -Naur linux-2.3.13-orig/fs/binfmt_aout.c linux-2.3.13/fs/binfmt_aout.c<br>
--- linux-2.3.13-orig/fs/binfmt_aout.c	Tue Aug  3 10:18:39 1999<br>
+++ linux-2.3.13/fs/binfmt_aout.c	Sun Aug 15 00:50:50 1999<br>
@@ -355,21 +355,25 @@<br>
 		flush_icache_range((unsigned long) 0,<br>
 				   (unsigned long) ex.a_text+ex.a_data);<br>
 	} else {<br>
+#if 0<br>
 		if ((ex.a_text &amp; 0xfff || ex.a_data &amp; 0xfff) &amp;&amp;<br>
 		    (N_MAGIC(ex) != NMAGIC))<br>
 			printk(KERN_NOTICE "executable not page aligned\n");<br>
+#endif<br>
 <br>
 		fd = open_dentry(bprm-&gt;dentry, O_RDONLY);<br>
 		if (fd &lt; 0)<br>
 			return fd;<br>
 		file = fget(fd);<br>
 <br>
+#if 0<br>
 		if ((fd_offset &amp; ~PAGE_MASK) != 0) {<br>
 			printk(KERN_WARNING <br>
 			       "fd_offset is not page aligned. Please convert program: %s\n",<br>
 			       file-&gt;f_dentry-&gt;d_name.name<br>
 			       );<br>
 		}<br>
+#endif<br>
 <br>
 		if (!file-&gt;f_op || !file-&gt;f_op-&gt;mmap || ((fd_offset &amp; ~PAGE_MASK) != 0)) {<br>
 			fput(file);<br>
@@ -499,10 +503,12 @@<br>
 	start_addr =  ex.a_entry &amp; 0xfffff000;<br>
 <br>
 	if ((N_TXTOFF(ex) &amp; ~PAGE_MASK) != 0) {<br>
+#if 0<br>
 		printk(KERN_WARNING <br>
 		       "N_TXTOFF is not page aligned. Please convert library: %s\n",<br>
 		       file-&gt;f_dentry-&gt;d_name.name<br>
 		       );<br>
+#endif<br>
 		<br>
 		do_mmap(NULL, start_addr &amp; PAGE_MASK, ex.a_text + ex.a_data + ex.a_bss,<br>
 			PROT_READ | PROT_WRITE | PROT_EXEC,<br>
diff -Naur linux-2.3.13-orig/fs/locks.c linux-2.3.13/fs/locks.c<br>
--- linux-2.3.13-orig/fs/locks.c	Mon Jul  5 20:11:07 1999<br>
+++ linux-2.3.13/fs/locks.c	Sun Aug 15 00:50:50 1999<br>
@@ -448,10 +448,10 @@<br>
 		       current-&gt;pid, current-&gt;comm);<br>
 	}<br>
 }<br>
+#endif<br>
 		if (!(filp-&gt;f_mode &amp; 3))<br>
 			goto out_putf;<br>
 		break;<br>
-#endif<br>
 	default:<br>
 		error = -EINVAL;<br>
 		goto out_putf;<br>
@@ -648,11 +648,20 @@<br>
 	init_waitqueue_head(&amp;fl-&gt;fl_wait);<br>
 	fl-&gt;fl_flags = FL_POSIX;<br>
 <br>
+	/*<br>
+	 * remap old-style locks into the locking method de jour<br>
+	 */<br>
 	switch (l-&gt;l_type) {<br>
 	case F_RDLCK:<br>
 	case F_WRLCK:<br>
 	case F_UNLCK:<br>
 		fl-&gt;fl_type = l-&gt;l_type;<br>
+		break;<br>
+	case F_SHLCK :<br>
+		fl-&gt;fl_type = F_RDLCK;<br>
+		break;<br>
+	case F_EXLCK :<br>
+		fl-&gt;fl_type = F_WRLCK;<br>
 		break;<br>
 	default:<br>
 		return (0);<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0406.html">Guest section DW: "Re: Would anyone miss devices.tex?"</a>
<li> <b>Previous message:</b> <a href="0404.html">Alan Cox: "Re: RH6.0 C compiler doesn't recognize "\""</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
